/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.security.impl;

import com.aelitis.azureus.core.security.CryptoECCUtils;
import com.aelitis.azureus.core.security.CryptoHandler;
import com.aelitis.azureus.core.security.CryptoManagerException;
import com.aelitis.azureus.core.security.CryptoManagerPasswordException;
import com.aelitis.azureus.core.security.CryptoSTSEngine;
import com.aelitis.azureus.core.security.impl.CryptoManagerImpl;
import com.aelitis.azureus.core.security.impl.CryptoSTSEngineImpl;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.util.Base32;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.RandomUtils;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.bouncycastle.jce.provider.JCEIESCipher;
import org.gudy.bouncycastle.jce.spec.IEKeySpec;
import org.gudy.bouncycastle.jce.spec.IESParameterSpec;

public class CryptoHandlerECC
implements CryptoHandler {
    private static final String DEFAULT_PASSWORD = "";
    private static final Long DEFAULT_TIMEOUT = Long.MAX_VALUE;
    private static final int TIMEOUT_DEFAULT_SECS = 3600;
    final CryptoManagerImpl manager;
    private String CONFIG_PREFIX = "core.crypto.ecc.";
    private PrivateKey use_method_private_key;
    private PublicKey use_method_public_key;
    private long last_unlock_time;

    protected CryptoHandlerECC(CryptoManagerImpl _manager, int _instance_id) {
        this.manager = _manager;
        this.CONFIG_PREFIX = this.CONFIG_PREFIX + _instance_id + ".";
        if (this.getDefaultPasswordHandlerType() != 1) {
            COConfigurationManager.setParameter(this.CONFIG_PREFIX + "default_pwtype", 1);
        }
        if (this.getCurrentPasswordType() == 2 || COConfigurationManager.getByteParameter(this.CONFIG_PREFIX + "publickey", null) == null) {
            try {
                this.createAndStoreKeys(this.manager.setPassword(1, 1, DEFAULT_PASSWORD.toCharArray(), DEFAULT_TIMEOUT));
                Debug.outNoStack("Successfully migrated key management");
            }
            catch (Throwable e) {
                Debug.out("Failed to migrate key management", e);
            }
        }
    }

    @Override
    public int getType() {
        return 1;
    }

    @Override
    public void unlock() throws CryptoManagerException {
        this.getMyPrivateKey("unlock");
    }

    @Override
    public synchronized boolean isUnlocked() {
        return this.use_method_private_key != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void lock() {
        boolean changed = false;
        CryptoHandlerECC cryptoHandlerECC = this;
        synchronized (cryptoHandlerECC) {
            changed = this.use_method_private_key != null;
            this.use_method_private_key = null;
        }
        if (changed) {
            this.manager.lockChanged(this);
        }
    }

    @Override
    public int getUnlockTimeoutSeconds() {
        return COConfigurationManager.getIntParameter(this.CONFIG_PREFIX + "timeout", 3600);
    }

    @Override
    public void setUnlockTimeoutSeconds(int secs) {
        COConfigurationManager.setParameter(this.CONFIG_PREFIX + "timeout", secs);
    }

    @Override
    public byte[] sign(byte[] data, String reason) throws CryptoManagerException {
        PrivateKey priv = this.getMyPrivateKey(reason);
        Signature sig = CryptoECCUtils.getSignature(priv);
        try {
            sig.update(data);
            return sig.sign();
        }
        catch (Throwable e) {
            throw new CryptoManagerException("Signature failed", e);
        }
    }

    @Override
    public boolean verify(byte[] public_key, byte[] data, byte[] signature) throws CryptoManagerException {
        PublicKey pub = CryptoECCUtils.rawdataToPubkey(public_key);
        Signature sig = CryptoECCUtils.getSignature(pub);
        try {
            sig.update(data);
            return sig.verify(signature);
        }
        catch (Throwable e) {
            throw new CryptoManagerException("Signature failed", e);
        }
    }

    @Override
    public byte[] encrypt(byte[] other_public_key, byte[] data, String reason) throws CryptoManagerException {
        try {
            IEKeySpec key_spec = new IEKeySpec(this.getMyPrivateKey(reason), CryptoECCUtils.rawdataToPubkey(other_public_key));
            byte[] d = new byte[16];
            byte[] e = new byte[16];
            RandomUtils.nextSecureBytes(d);
            RandomUtils.nextSecureBytes(e);
            IESParameterSpec param = new IESParameterSpec(d, e, 128);
            InternalECIES cipher = new InternalECIES();
            cipher.internalEngineInit(1, key_spec, param, null);
            byte[] encrypted = cipher.internalEngineDoFinal(data, 0, data.length);
            byte[] result = new byte[32 + encrypted.length];
            System.arraycopy(d, 0, result, 0, 16);
            System.arraycopy(e, 0, result, 16, 16);
            System.arraycopy(encrypted, 0, result, 32, encrypted.length);
            return result;
        }
        catch (CryptoManagerException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new CryptoManagerException("Encrypt failed", e);
        }
    }

    @Override
    public byte[] decrypt(byte[] other_public_key, byte[] data, String reason) throws CryptoManagerException {
        try {
            IEKeySpec key_spec = new IEKeySpec(this.getMyPrivateKey(reason), CryptoECCUtils.rawdataToPubkey(other_public_key));
            byte[] d = new byte[16];
            byte[] e = new byte[16];
            System.arraycopy(data, 0, d, 0, 16);
            System.arraycopy(data, 16, e, 0, 16);
            IESParameterSpec param = new IESParameterSpec(d, e, 128);
            InternalECIES cipher = new InternalECIES();
            cipher.internalEngineInit(2, key_spec, param, null);
            return cipher.internalEngineDoFinal(data, 32, data.length - 32);
        }
        catch (CryptoManagerException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new CryptoManagerException("Decrypt failed", e);
        }
    }

    @Override
    public CryptoSTSEngine getSTSEngine(String reason) throws CryptoManagerException {
        return new CryptoSTSEngineImpl(this.getMyPublicKey(reason, true), this.getMyPrivateKey(reason));
    }

    @Override
    public CryptoSTSEngine getSTSEngine(PublicKey public_key, PrivateKey private_key) throws CryptoManagerException {
        return new CryptoSTSEngineImpl(public_key, private_key);
    }

    @Override
    public byte[] peekPublicKey() {
        try {
            return CryptoECCUtils.keyToRawdata(this.getMyPublicKey("peek", false));
        }
        catch (Throwable e) {
            return null;
        }
    }

    @Override
    public byte[] getPublicKey(String reason) throws CryptoManagerException {
        return CryptoECCUtils.keyToRawdata(this.getMyPublicKey(reason, true));
    }

    @Override
    public byte[] getEncryptedPrivateKey(String reason) throws CryptoManagerException {
        this.getMyPrivateKey(reason);
        byte[] pk = COConfigurationManager.getByteParameter(this.CONFIG_PREFIX + "privatekey", null);
        if (pk == null) {
            throw new CryptoManagerException("Private key unavailable");
        }
        int pw_type = this.getCurrentPasswordType();
        byte[] res = new byte[pk.length + 1];
        res[0] = (byte)pw_type;
        System.arraycopy(pk, 0, res, 1, pk.length);
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void recoverKeys(byte[] public_key, byte[] encrypted_private_key_and_type) throws CryptoManagerException {
        boolean lock_changed = false;
        CryptoHandlerECC cryptoHandlerECC = this;
        synchronized (cryptoHandlerECC) {
            lock_changed = this.use_method_private_key != null;
            this.use_method_private_key = null;
            this.use_method_public_key = null;
            this.manager.clearPassword(1, 3);
            COConfigurationManager.setParameter(this.CONFIG_PREFIX + "publickey", public_key);
            int type = encrypted_private_key_and_type[0] & 0xFF;
            COConfigurationManager.setParameter(this.CONFIG_PREFIX + "pwtype", type);
            byte[] encrypted_private_key = new byte[encrypted_private_key_and_type.length - 1];
            System.arraycopy(encrypted_private_key_and_type, 1, encrypted_private_key, 0, encrypted_private_key.length);
            COConfigurationManager.setParameter(this.CONFIG_PREFIX + "privatekey", encrypted_private_key);
            COConfigurationManager.save();
        }
        this.manager.keyChanged(this);
        if (lock_changed) {
            this.manager.lockChanged(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resetKeys(String reason) throws CryptoManagerException {
        boolean lock_changed = false;
        CryptoHandlerECC cryptoHandlerECC = this;
        synchronized (cryptoHandlerECC) {
            lock_changed = this.use_method_private_key != null;
            this.use_method_private_key = null;
            this.use_method_public_key = null;
            this.manager.clearPassword(1, 3);
            COConfigurationManager.removeParameter(this.CONFIG_PREFIX + "publickey");
            COConfigurationManager.removeParameter(this.CONFIG_PREFIX + "privatekey");
            COConfigurationManager.save();
        }
        if (lock_changed) {
            this.manager.lockChanged(this);
        }
        try {
            this.createAndStoreKeys("resetting keys");
        }
        catch (CryptoManagerException e) {
            this.manager.keyChanged(this);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected PrivateKey getMyPrivateKey(String reason) throws CryptoManagerException {
        boolean lock_change = false;
        try {
            CryptoHandlerECC cryptoHandlerECC = this;
            synchronized (cryptoHandlerECC) {
                int timeout_secs2;
                if (this.use_method_private_key != null && (timeout_secs2 = this.getUnlockTimeoutSeconds()) > 0 && SystemTime.getCurrentTime() - this.last_unlock_time >= (long)(timeout_secs2 * 1000)) {
                    lock_change = true;
                    this.use_method_private_key = null;
                }
                if (this.use_method_private_key != null) {
                    PrivateKey timeout_secs2 = this.use_method_private_key;
                    return timeout_secs2;
                }
            }
            final byte[] encoded = COConfigurationManager.getByteParameter(this.CONFIG_PREFIX + "privatekey", null);
            if (encoded == null) {
                PrivateKey timeout_secs2 = (PrivateKey)this.createAndStoreKeys(reason)[1];
                return timeout_secs2;
            }
            CryptoManagerImpl.passwordDetails password_details = this.manager.getPassword(1, 2, reason, new CryptoManagerImpl.passwordTester(){

                @Override
                public boolean testPassword(char[] password) {
                    try {
                        CryptoHandlerECC.this.manager.decryptWithPBE(encoded, password);
                        return true;
                    }
                    catch (Throwable e) {
                        return false;
                    }
                }
            }, this.getCurrentPasswordType());
            CryptoHandlerECC cryptoHandlerECC2 = this;
            synchronized (cryptoHandlerECC2) {
                boolean ok = false;
                try {
                    this.use_method_private_key = CryptoECCUtils.rawdataToPrivkey(this.manager.decryptWithPBE(encoded, password_details.getPassword()));
                    lock_change = true;
                    this.last_unlock_time = SystemTime.getCurrentTime();
                    if (!this.checkKeysOK(reason)) {
                        throw new CryptoManagerPasswordException(true, "Password incorrect");
                    }
                    ok = true;
                }
                catch (CryptoManagerException e) {
                    throw e;
                }
                catch (Throwable e) {
                    throw new CryptoManagerException("Password incorrect", e);
                }
                finally {
                    if (!ok) {
                        this.manager.clearPassword(1, 3);
                        lock_change = true;
                        this.use_method_private_key = null;
                    }
                }
                if (this.use_method_private_key == null) {
                    throw new CryptoManagerException("Failed to get private key");
                }
                PrivateKey privateKey = this.use_method_private_key;
                return privateKey;
            }
        }
        finally {
            if (lock_change) {
                this.manager.lockChanged(this);
            }
        }
    }

    protected boolean checkKeysOK(String reason) throws CryptoManagerException {
        byte[] test_data = "test".getBytes();
        return this.verify(CryptoECCUtils.keyToRawdata(this.getMyPublicKey(reason, true)), test_data, this.sign(test_data, reason));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected PublicKey getMyPublicKey(String reason, boolean create_if_needed) throws CryptoManagerException {
        boolean create_new = false;
        CryptoHandlerECC cryptoHandlerECC = this;
        synchronized (cryptoHandlerECC) {
            if (this.use_method_public_key == null) {
                byte[] key_bytes = COConfigurationManager.getByteParameter(this.CONFIG_PREFIX + "publickey", null);
                if (key_bytes == null) {
                    if (!create_if_needed) return null;
                    create_new = true;
                } else {
                    this.use_method_public_key = CryptoECCUtils.rawdataToPubkey(key_bytes);
                }
            }
            if (create_new) return (PublicKey)this.createAndStoreKeys(reason)[0];
            if (this.use_method_public_key != null) return this.use_method_public_key;
            throw new CryptoManagerException("Failed to get public key");
        }
    }

    @Override
    public int getDefaultPasswordHandlerType() {
        return COConfigurationManager.getIntParameter(this.CONFIG_PREFIX + "default_pwtype", 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDefaultPasswordHandlerType(int new_type) throws CryptoManagerException {
        boolean have_existing_keys;
        String reason = "Changing password handler";
        boolean bl = have_existing_keys = COConfigurationManager.getByteParameter(this.CONFIG_PREFIX + "privatekey", null) != null;
        if (have_existing_keys) {
            if (new_type == this.getCurrentPasswordType()) {
                return;
            }
            this.getMyPrivateKey(reason);
            CryptoManagerImpl.passwordDetails password_details = this.manager.getPassword(1, 1, reason, null, new_type);
            CryptoHandlerECC cryptoHandlerECC = this;
            synchronized (cryptoHandlerECC) {
                if (this.use_method_private_key == null) {
                    throw new CryptoManagerException("Private key not available");
                }
                byte[] priv_raw = CryptoECCUtils.keyToRawdata(this.use_method_private_key);
                byte[] priv_enc = this.manager.encryptWithPBE(priv_raw, password_details.getPassword());
                COConfigurationManager.setParameter(this.CONFIG_PREFIX + "privatekey", priv_enc);
                COConfigurationManager.setParameter(this.CONFIG_PREFIX + "pwtype", password_details.getHandlerType());
                COConfigurationManager.setParameter(this.CONFIG_PREFIX + "default_pwtype", password_details.getHandlerType());
                COConfigurationManager.save();
            }
        }
        CryptoHandlerECC cryptoHandlerECC = this;
        synchronized (cryptoHandlerECC) {
            if (COConfigurationManager.getByteParameter(this.CONFIG_PREFIX + "privatekey", null) == null) {
                COConfigurationManager.setParameter(this.CONFIG_PREFIX + "default_pwtype", new_type);
                COConfigurationManager.save();
            }
        }
    }

    protected Key[] createAndStoreKeys(String reason) throws CryptoManagerException {
        CryptoManagerImpl.passwordDetails password_details = this.manager.getPassword(1, 1, reason, null, this.getDefaultPasswordHandlerType());
        return this.createAndStoreKeys(password_details);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Key[] createAndStoreKeys(CryptoManagerImpl.passwordDetails password_details) throws CryptoManagerException {
        try {
            CryptoHandlerECC cryptoHandlerECC = this;
            synchronized (cryptoHandlerECC) {
                if (this.use_method_public_key == null || this.use_method_private_key == null) {
                    KeyPair keys = CryptoECCUtils.createKeys();
                    this.use_method_public_key = keys.getPublic();
                    this.use_method_private_key = keys.getPrivate();
                    this.last_unlock_time = SystemTime.getCurrentTime();
                    COConfigurationManager.setParameter(this.CONFIG_PREFIX + "publickey", CryptoECCUtils.keyToRawdata(this.use_method_public_key));
                    byte[] priv_raw = CryptoECCUtils.keyToRawdata(this.use_method_private_key);
                    byte[] priv_enc = this.manager.encryptWithPBE(priv_raw, password_details.getPassword());
                    COConfigurationManager.setParameter(this.CONFIG_PREFIX + "privatekey", priv_enc);
                    COConfigurationManager.setParameter(this.CONFIG_PREFIX + "pwtype", password_details.getHandlerType());
                    COConfigurationManager.save();
                }
                Key[] keyArray = new Key[]{this.use_method_public_key, this.use_method_private_key};
                return keyArray;
            }
        }
        finally {
            this.manager.keyChanged(this);
            this.manager.lockChanged(this);
        }
    }

    @Override
    public boolean verifyPublicKey(byte[] encoded) {
        try {
            CryptoECCUtils.rawdataToPubkey(encoded);
            return true;
        }
        catch (Throwable e) {
            return false;
        }
    }

    @Override
    public String exportKeys() throws CryptoManagerException {
        return "id:      " + Base32.encode(this.manager.getSecureID()) + "\r\n" + "public:  " + Base32.encode(this.getPublicKey("Key export")) + "\r\n" + "private: " + Base32.encode(this.getEncryptedPrivateKey("Key export"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean importKeys(String str) throws CryptoManagerException {
        String reason = "Key import";
        byte[] existing_id = this.manager.getSecureID();
        byte[] existing_public_key = this.peekPublicKey();
        byte[] existing_private_key = existing_public_key == null ? null : this.getEncryptedPrivateKey(reason);
        byte[] recovered_id = null;
        byte[] recovered_public_key = null;
        byte[] recovered_private_key = null;
        String[] bits = str.split("\n");
        for (int i = 0; i < bits.length; ++i) {
            String[] x;
            String bit = bits[i].trim();
            if (bit.length() == 0 || (x = bit.split(":")).length != 2) continue;
            String lhs = x[0].trim();
            String rhs = x[1].trim();
            byte[] rhs_val = Base32.decode(rhs);
            if (lhs.equals("id")) {
                recovered_id = rhs_val;
                continue;
            }
            if (lhs.equals("public")) {
                recovered_public_key = rhs_val;
                continue;
            }
            if (!lhs.equals("private")) continue;
            recovered_private_key = rhs_val;
        }
        if (recovered_id == null || recovered_public_key == null || recovered_private_key == null) {
            throw new CryptoManagerException("Invalid input file");
        }
        boolean ok = false;
        boolean result = false;
        try {
            boolean bl = result = !Arrays.equals(existing_id, recovered_id);
            if (result) {
                this.manager.setSecureID(recovered_id);
            }
            this.recoverKeys(recovered_public_key, recovered_private_key);
            if (!this.checkKeysOK(reason)) {
                throw new CryptoManagerException("Invalid key pair");
            }
            ok = true;
        }
        finally {
            if (!ok) {
                result = false;
                this.manager.setSecureID(existing_id);
                if (existing_public_key != null) {
                    this.recoverKeys(existing_public_key, existing_private_key);
                }
            }
        }
        return result;
    }

    protected int getCurrentPasswordType() {
        return COConfigurationManager.getIntParameter(this.CONFIG_PREFIX + "pwtype", 1);
    }

    static class InternalECIES
    extends JCEIESCipher.ECIES {
        InternalECIES() {
        }

        public void internalEngineInit(int opmode, Key key, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
            this.engineInit(opmode, key, params, random);
        }

        protected byte[] internalEngineDoFinal(byte[] input, int inputOffset, int inputLen) throws IllegalBlockSizeException, BadPaddingException {
            return this.engineDoFinal(input, inputOffset, inputLen);
        }
    }
}

