/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.proxy.impl;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.AzureusCoreRunningListener;
import com.aelitis.azureus.core.proxy.AEProxyFactory;
import com.aelitis.azureus.core.proxy.AEProxySelector;
import com.aelitis.azureus.core.util.CopyOnWriteMap;
import com.aelitis.azureus.core.util.DNSUtils;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.gudy.azureus2.core3.config.COConfigurationListener;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.util.AddressUtils;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.HostNameToIPResolver;
import org.gudy.azureus2.core3.util.SystemTime;

public class AEProxySelectorImpl
extends ProxySelector
implements AEProxySelector {
    private static final boolean LOG = false;
    private static final String NL = "\r\n";
    private static final AEProxySelectorImpl singleton = new AEProxySelectorImpl();
    private static final List<Proxy> no_proxy_list = Arrays.asList(Proxy.NO_PROXY);
    private static final ThreadLocal<Integer> tls = new ThreadLocal<Integer>(){

        @Override
        public Integer initialValue() {
            return 0;
        }
    };
    private final ProxySelector existing_selector;
    private volatile ActiveProxy active_proxy;
    private volatile List<String> alt_dns_servers = new ArrayList<String>();
    private final CopyOnWriteMap<String, List<Proxy>> explicit_proxy_map = new CopyOnWriteMap();

    public static AEProxySelector getSingleton() {
        return singleton;
    }

    private AEProxySelectorImpl() {
        COConfigurationManager.addAndFireListener(new COConfigurationListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void configurationSaved() {
                boolean enable_proxy = COConfigurationManager.getBooleanParameter("Enable.Proxy");
                boolean enable_socks = COConfigurationManager.getBooleanParameter("Enable.SOCKS");
                String proxy_host = null;
                int proxy_port = -1;
                if (enable_proxy && enable_socks) {
                    proxy_host = COConfigurationManager.getStringParameter("Proxy.Host").trim();
                    try {
                        proxy_port = Integer.parseInt(COConfigurationManager.getStringParameter("Proxy.Port").trim());
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    if (proxy_host.length() == 0) {
                        proxy_host = null;
                    }
                    if (proxy_port <= 0 || proxy_port > 65535) {
                        proxy_host = null;
                    }
                }
                ArrayList<String> new_servers = new ArrayList<String>();
                if (COConfigurationManager.getBooleanParameter("DNS Alt Servers SOCKS Enable")) {
                    String[] servers;
                    String alt_servers = COConfigurationManager.getStringParameter("DNS Alt Servers");
                    alt_servers = alt_servers.replace(',', ';');
                    for (String s : servers = alt_servers.split(";")) {
                        if ((s = s.trim()).length() <= 0) continue;
                        new_servers.add(s);
                    }
                }
                AEProxySelectorImpl aEProxySelectorImpl = AEProxySelectorImpl.this;
                synchronized (aEProxySelectorImpl) {
                    boolean servers_changed = false;
                    if (AEProxySelectorImpl.this.alt_dns_servers.size() != new_servers.size()) {
                        servers_changed = true;
                    } else {
                        for (String s : new_servers) {
                            if (AEProxySelectorImpl.this.alt_dns_servers.contains(s)) continue;
                            servers_changed = true;
                            break;
                        }
                    }
                    if (servers_changed) {
                        AEProxySelectorImpl.this.alt_dns_servers = new_servers;
                    }
                    if (proxy_host == null) {
                        if (AEProxySelectorImpl.this.active_proxy != null) {
                            AEProxySelectorImpl.this.active_proxy = null;
                        }
                    } else if (AEProxySelectorImpl.this.active_proxy == null || !AEProxySelectorImpl.this.active_proxy.sameAddress(proxy_host, proxy_port)) {
                        AEProxySelectorImpl.this.active_proxy = new ActiveProxy(proxy_host, proxy_port, new_servers);
                    } else if (servers_changed) {
                        AEProxySelectorImpl.this.active_proxy.updateServers(new_servers);
                    }
                }
            }
        });
        this.existing_selector = ProxySelector.getDefault();
        try {
            ProxySelector.setDefault(this);
        }
        catch (Throwable e) {
            Debug.out(e);
        }
        AzureusCoreFactory.addCoreRunningListener(new AzureusCoreRunningListener(){

            @Override
            public void azureusCoreRunning(AzureusCore core) {
                try {
                    Class.forName("com.aelitis.azureus.core.proxy.impl.swt.AEProxySelectorSWTImpl").getConstructor(AzureusCore.class, AEProxySelectorImpl.class).newInstance(core, AEProxySelectorImpl.this);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        });
    }

    @Override
    public void startNoProxy() {
        tls.set(tls.get() + 1);
    }

    @Override
    public void endNoProxy() {
        tls.set(tls.get() - 1);
    }

    @Override
    public Proxy setProxy(InetSocketAddress address, Proxy proxy) {
        ArrayList<Proxy> p = new ArrayList<Proxy>();
        p.add(proxy);
        String address_str = AddressUtils.getHostNameNoResolve(address) + ":" + address.getPort();
        List old = this.explicit_proxy_map.put(address_str, Collections.unmodifiableList(p));
        if (old != null) {
            return (Proxy)old.get(0);
        }
        return null;
    }

    @Override
    public Proxy removeProxy(InetSocketAddress address) {
        String address_str = AddressUtils.getHostNameNoResolve(address) + ":" + address.getPort();
        List<Proxy> old = this.explicit_proxy_map.remove(address_str);
        if (old != null) {
            return old.get(0);
        }
        return null;
    }

    @Override
    public List<Proxy> select(URI uri) {
        List<Proxy> result;
        String host;
        if (this.explicit_proxy_map.size() > 0) {
            try {
                host = uri.getHost();
                if (host != null) {
                    List<Proxy> p;
                    String scheme;
                    int port = uri.getPort();
                    if (port == -1 && (scheme = uri.getScheme()) != null) {
                        if ((scheme = scheme.toLowerCase(Locale.US)).equals("http")) {
                            port = 80;
                        } else if (scheme.equals("https")) {
                            port = 443;
                        }
                    }
                    if (port != -1 && (p = this.explicit_proxy_map.get(host + ":" + port)) != null) {
                        return p;
                    }
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        if (tls.get() > 0) {
            result = no_proxy_list;
        } else {
            result = this.selectSupport(uri);
            host = uri.getHost();
            if (host != null && (host.endsWith(".i2p") || host.endsWith(".onion"))) {
                ArrayList<Proxy> trimmed = new ArrayList<Proxy>(result.size());
                for (Proxy p : result) {
                    if (p.type() == Proxy.Type.DIRECT) continue;
                    trimmed.add(p);
                }
                if (trimmed.size() == 0) {
                    throw new AEProxyFactory.UnknownHostException(host);
                }
            }
        }
        return result;
    }

    private List<Proxy> selectSupport(URI uri) {
        ActiveProxy active = this.active_proxy;
        if (active == null) {
            if (this.existing_selector == null) {
                return no_proxy_list;
            }
            List<Proxy> proxies = this.existing_selector.select(uri);
            Iterator<Proxy> it = proxies.iterator();
            while (it.hasNext()) {
                Proxy p = it.next();
                if (p.type() != Proxy.Type.SOCKS) continue;
                it.remove();
            }
            if (proxies.size() > 0) {
                return proxies;
            }
            return no_proxy_list;
        }
        if (this.alt_dns_servers.contains(uri.getHost())) {
            return no_proxy_list;
        }
        if (this.existing_selector != null) {
            List<Proxy> proxies = this.existing_selector.select(uri);
            boolean apply = false;
            for (Proxy p : proxies) {
                if (p.type() != Proxy.Type.SOCKS) continue;
                apply = true;
                break;
            }
            if (!apply) {
                return no_proxy_list;
            }
        }
        return Arrays.asList(active.select());
    }

    private void connectFailed(SocketAddress sa, Throwable error) {
        ActiveProxy active = this.active_proxy;
        if (active == null || !(sa instanceof InetSocketAddress)) {
            return;
        }
        active.connectFailed((InetSocketAddress)sa, error);
    }

    @Override
    public void connectFailed(URI uri, SocketAddress sa, IOException ioe) {
        this.connectFailed(sa, (Throwable)ioe);
        if (this.existing_selector != null) {
            this.existing_selector.connectFailed(uri, sa, ioe);
        }
    }

    @Override
    public Proxy getSOCKSProxy(String host, int port, InetSocketAddress target) {
        InetSocketAddress isa = new InetSocketAddress(host, port);
        return this.getSOCKSProxy(isa, target);
    }

    @Override
    public Proxy getSOCKSProxy(InetSocketAddress isa, InetSocketAddress target) {
        ActiveProxy active;
        Proxy result = tls.get() > 0 ? Proxy.NO_PROXY : ((active = this.active_proxy) == null || !active.getAddress().equals(isa) ? new Proxy(Proxy.Type.SOCKS, isa) : active.select());
        return result;
    }

    @Override
    public Proxy getActiveProxy() {
        String proxy = System.getProperty("socksProxyHost", "");
        if (proxy.trim().length() == 0) {
            return null;
        }
        ActiveProxy active = this.active_proxy;
        if (active == null) {
            return null;
        }
        return new Proxy(Proxy.Type.SOCKS, active.getAddress());
    }

    @Override
    public void connectFailed(Proxy proxy, Throwable error) {
        this.connectFailed(proxy.address(), error);
    }

    @Override
    public long getLastConnectionTime() {
        ActiveProxy active = this.active_proxy;
        if (active == null) {
            return -1L;
        }
        return active.getLastConnectionTime();
    }

    @Override
    public long getLastFailTime() {
        ActiveProxy active = this.active_proxy;
        if (active == null) {
            return -1L;
        }
        return active.getLastFailTime();
    }

    @Override
    public int getConnectionCount() {
        ActiveProxy active = this.active_proxy;
        if (active == null) {
            return 0;
        }
        return active.getConnectionCount();
    }

    @Override
    public int getFailCount() {
        ActiveProxy active = this.active_proxy;
        if (active == null) {
            return 0;
        }
        return active.getFailCount();
    }

    @Override
    public String getInfo() {
        ActiveProxy active = this.active_proxy;
        if (active == null || this.getActiveProxy() == null) {
            return "No proxy active";
        }
        return active.getInfo();
    }

    private static class ActiveProxy {
        private static final int DNS_RETRY_MILLIS = 900000;
        private final String proxy_host;
        private final int proxy_port;
        private final InetSocketAddress address;
        private volatile List<MyProxy> proxy_list_cow = new ArrayList<MyProxy>();
        private Boolean alt_dns_enable;
        private List<String> alt_dns_to_try;
        private final Map<String, Long> alt_dns_tried = new HashMap<String, Long>();
        private long default_dns_tried_time = -1L;
        private volatile long last_connection_time = -1L;
        private volatile int connection_count = 0;
        private volatile long last_fail_time = -1L;
        private volatile int fail_count = 0;

        private ActiveProxy(String _proxy_host, int _proxy_port, List<String> _servers) {
            this.proxy_host = _proxy_host;
            this.proxy_port = _proxy_port;
            this.alt_dns_to_try = _servers;
            this.address = new InetSocketAddress(this.proxy_host, this.proxy_port);
            this.proxy_list_cow.add(new MyProxy(this.address));
        }

        public String getInfo() {
            StringBuilder sb = new StringBuilder(2048);
            long now = SystemTime.getCurrentTime();
            long mono_now = SystemTime.getMonotonousTime();
            sb.append("Proxy: ").append(this.address).append(AEProxySelectorImpl.NL);
            sb.append("Last connection attempt: ").append(this.last_connection_time == -1L ? "Never" : new Date(now - (mono_now - this.last_connection_time))).append(AEProxySelectorImpl.NL);
            sb.append("Last failure: ").append(this.last_fail_time == -1L ? "Never" : new Date(now - (mono_now - this.last_fail_time))).append(AEProxySelectorImpl.NL);
            sb.append("Total connections: ").append(this.connection_count).append(AEProxySelectorImpl.NL);
            sb.append("Total failures: ").append(this.fail_count).append(AEProxySelectorImpl.NL);
            ArrayList<MyProxy> proxies = new ArrayList<MyProxy>(this.proxy_list_cow);
            sb.append(AEProxySelectorImpl.NL);
            for (MyProxy p : proxies) {
                sb.append(p.getInfo(now, mono_now)).append(AEProxySelectorImpl.NL);
            }
            return sb.toString();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateServers(List<String> servers) {
            ActiveProxy activeProxy = this;
            synchronized (activeProxy) {
                this.alt_dns_to_try = servers;
                this.alt_dns_tried.clear();
            }
        }

        private boolean sameAddress(String host, int port) {
            return host.equals(this.proxy_host) && port == this.proxy_port;
        }

        private InetSocketAddress getAddress() {
            return this.address;
        }

        public long getLastConnectionTime() {
            return this.last_connection_time;
        }

        public int getConnectionCount() {
            return this.connection_count;
        }

        public long getLastFailTime() {
            return this.last_fail_time;
        }

        public int getFailCount() {
            return this.fail_count;
        }

        private MyProxy select() {
            MyProxy proxy = this.proxy_list_cow.get(0);
            proxy.handedOut();
            this.last_connection_time = SystemTime.getMonotonousTime();
            ++this.connection_count;
            return proxy;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void connectFailed(InetSocketAddress failed_isa, Throwable error) {
            String msg = Debug.getNestedExceptionMessage(error).toLowerCase();
            if (msg.contains("unreachable") || msg.contains("operation on nonsocket")) {
                return;
            }
            long now_mono = SystemTime.getMonotonousTime();
            ActiveProxy activeProxy = this;
            synchronized (activeProxy) {
                InetAddress failed_ia = failed_isa.getAddress();
                String failed_hostname = failed_ia == null ? failed_isa.getHostName() : null;
                MyProxy matching_proxy = null;
                ArrayList<MyProxy> new_list = new ArrayList<MyProxy>();
                HashSet<InetAddress> existing_addresses = new HashSet<InetAddress>();
                boolean all_failed = true;
                for (MyProxy p : this.proxy_list_cow) {
                    String p_hostname;
                    InetSocketAddress p_isa = (InetSocketAddress)p.address();
                    InetAddress p_ia = p_isa.getAddress();
                    String string = p_hostname = p_ia == null ? p_isa.getHostName() : null;
                    if (p_ia != null) {
                        existing_addresses.add(p_ia);
                    }
                    if (failed_ia != null && failed_ia.equals(p_ia) || failed_hostname != null && failed_hostname.equals(p_hostname)) {
                        matching_proxy = p;
                        matching_proxy.setFailed();
                    } else {
                        new_list.add(p);
                    }
                    if (p.getFailCount() != 0) continue;
                    all_failed = false;
                }
                if (matching_proxy != null) {
                    this.last_fail_time = now_mono;
                    ++this.fail_count;
                    new_list.add(matching_proxy);
                }
                DNSUtils.DNSUtilsIntf dns_utils = DNSUtils.getSingleton();
                if (dns_utils != null && all_failed) {
                    DNSUtils.DNSDirContext dns_to_try = null;
                    if (this.alt_dns_enable == null) {
                        this.alt_dns_enable = HostNameToIPResolver.hostAddressToBytes(this.proxy_host) == null;
                    }
                    if (this.alt_dns_enable.booleanValue()) {
                        if (this.default_dns_tried_time == -1L || now_mono - this.default_dns_tried_time >= 900000L) {
                            this.default_dns_tried_time = now_mono;
                            if (failed_ia != null) {
                                try {
                                    dns_to_try = dns_utils.getInitialDirContext();
                                }
                                catch (Throwable e) {
                                    Debug.out(e);
                                }
                            }
                        }
                        if (dns_to_try == null) {
                            if (this.alt_dns_to_try.size() == 0) {
                                Iterator<Map.Entry<String, Long>> it = this.alt_dns_tried.entrySet().iterator();
                                while (it.hasNext()) {
                                    Map.Entry<String, Long> entry = it.next();
                                    if (now_mono - entry.getValue() < 900000L) continue;
                                    it.remove();
                                    this.alt_dns_to_try.add(entry.getKey());
                                }
                            }
                            if (this.alt_dns_to_try.size() > 0) {
                                String try_dns = this.alt_dns_to_try.remove(0);
                                this.alt_dns_tried.put(try_dns, now_mono);
                                try {
                                    dns_to_try = dns_utils.getDirContextForServer(try_dns);
                                }
                                catch (Throwable e) {
                                    Debug.out(e);
                                }
                            }
                        }
                        if (dns_to_try != null) {
                            try {
                                List<InetAddress> addresses = dns_utils.getAllByName(dns_to_try, this.proxy_host);
                                Collections.shuffle(addresses);
                                for (InetAddress a : addresses) {
                                    if (existing_addresses.contains(a)) continue;
                                    new_list.add(0, new MyProxy(new InetSocketAddress(a, this.proxy_port)));
                                }
                            }
                            catch (Throwable e) {
                                Debug.out(e);
                            }
                        }
                    }
                }
                this.proxy_list_cow = new_list;
            }
        }
    }

    private static class MyProxy
    extends Proxy {
        private int use_count = 0;
        private int fail_count = 0;
        private long last_use;
        private long last_fail;

        private MyProxy(InetSocketAddress address) {
            super(Proxy.Type.SOCKS, address);
        }

        private void handedOut() {
            ++this.use_count;
            this.last_use = SystemTime.getMonotonousTime();
        }

        private void setFailed() {
            ++this.fail_count;
            this.last_fail = SystemTime.getMonotonousTime();
        }

        private int getFailCount() {
            return this.fail_count;
        }

        private String getInfo(long now, long mono_now) {
            String str;
            InetSocketAddress address = (InetSocketAddress)this.address();
            InetAddress ia = address.getAddress();
            String string = str = ia == null ? address.getHostName() : ia.getHostAddress();
            if (this.last_use > 0L) {
                str = str + "\r\n\tcons=" + this.use_count + ", last=" + new Date(now - (mono_now - this.last_use));
            }
            if (this.last_fail > 0L) {
                str = str + "\r\n\tfails=" + this.fail_count + ", last=" + new Date(now - (mono_now - this.last_fail));
            }
            return str;
        }
    }
}

