/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.peermanager.utils;

import com.aelitis.azureus.core.networkmanager.OutgoingMessageQueue;
import com.aelitis.azureus.core.peermanager.messaging.Message;
import com.aelitis.azureus.core.peermanager.messaging.azureus.AZHave;
import com.aelitis.azureus.core.peermanager.messaging.bittorrent.BTHave;
import java.util.ArrayList;
import org.gudy.azureus2.core3.util.AEMonitor;

public class OutgoingBTHaveMessageAggregator {
    private final ArrayList pending_haves = new ArrayList();
    private final AEMonitor pending_haves_mon = new AEMonitor("OutgoingBTHaveMessageAggregator:PH");
    private byte bt_have_version;
    private byte az_have_version;
    private boolean destroyed = false;
    private final OutgoingMessageQueue outgoing_message_q;
    private final OutgoingMessageQueue.MessageQueueListener added_message_listener = new OutgoingMessageQueue.MessageQueueListener(){

        @Override
        public boolean messageAdded(Message message) {
            return true;
        }

        @Override
        public void messageQueued(Message message) {
            String message_id = message.getID();
            if (!message_id.equals("BT_HAVE") && !message_id.equals("AZ_HAVE")) {
                OutgoingBTHaveMessageAggregator.this.sendPendingHaves();
            }
        }

        @Override
        public void messageRemoved(Message message) {
        }

        @Override
        public void messageSent(Message message) {
        }

        @Override
        public void protocolBytesSent(int byte_count) {
        }

        @Override
        public void dataBytesSent(int byte_count) {
        }

        @Override
        public void flush() {
        }
    };

    public OutgoingBTHaveMessageAggregator(OutgoingMessageQueue outgoing_message_q, byte _bt_have_version, byte _az_have_version) {
        this.outgoing_message_q = outgoing_message_q;
        this.bt_have_version = _bt_have_version;
        this.az_have_version = _az_have_version;
        outgoing_message_q.registerQueueListener(this.added_message_listener);
    }

    public void setHaveVersion(byte bt_version, byte az_version) {
        this.bt_have_version = bt_version;
        this.az_have_version = az_version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queueHaveMessage(int piece_number, boolean force) {
        if (this.destroyed) {
            return;
        }
        try {
            this.pending_haves_mon.enter();
            this.pending_haves.add(new Integer(piece_number));
            if (force) {
                this.sendPendingHaves();
            } else {
                int pending_bytes = this.pending_haves.size() * 9;
                if (pending_bytes >= this.outgoing_message_q.getMssSize()) {
                    this.sendPendingHaves();
                }
            }
        }
        finally {
            this.pending_haves_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        try {
            this.pending_haves_mon.enter();
            this.pending_haves.clear();
            this.destroyed = true;
        }
        finally {
            this.pending_haves_mon.exit();
        }
    }

    public void forceSendOfPending() {
        this.sendPendingHaves();
    }

    public boolean hasPending() {
        return !this.pending_haves.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendPendingHaves() {
        if (this.destroyed) {
            return;
        }
        try {
            this.pending_haves_mon.enter();
            int num_haves = this.pending_haves.size();
            if (num_haves == 0) {
                return;
            }
            if (num_haves == 1 || this.az_have_version < 2) {
                for (int i = 0; i < num_haves; ++i) {
                    Integer piece_num = (Integer)this.pending_haves.get(i);
                    this.outgoing_message_q.addMessage(new BTHave(piece_num, this.bt_have_version), true);
                }
            } else {
                int[] piece_numbers = new int[num_haves];
                for (int i = 0; i < num_haves; ++i) {
                    piece_numbers[i] = (Integer)this.pending_haves.get(i);
                }
                this.outgoing_message_q.addMessage(new AZHave(piece_numbers, this.az_have_version), true);
            }
            this.outgoing_message_q.doListenerNotifications();
            this.pending_haves.clear();
        }
        finally {
            this.pending_haves_mon.exit();
        }
    }
}

