/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.peermanager.messaging.bittorrent;

import com.aelitis.azureus.core.networkmanager.RawMessage;
import com.aelitis.azureus.core.networkmanager.impl.RawMessageImpl;
import com.aelitis.azureus.core.peermanager.messaging.Message;
import com.aelitis.azureus.core.peermanager.messaging.MessageException;
import com.aelitis.azureus.core.peermanager.messaging.MessageManager;
import com.aelitis.azureus.core.peermanager.messaging.bittorrent.BTAllowedFast;
import com.aelitis.azureus.core.peermanager.messaging.bittorrent.BTBitfield;
import com.aelitis.azureus.core.peermanager.messaging.bittorrent.BTCancel;
import com.aelitis.azureus.core.peermanager.messaging.bittorrent.BTChoke;
import com.aelitis.azureus.core.peermanager.messaging.bittorrent.BTDHTPort;
import com.aelitis.azureus.core.peermanager.messaging.bittorrent.BTHandshake;
import com.aelitis.azureus.core.peermanager.messaging.bittorrent.BTHave;
import com.aelitis.azureus.core.peermanager.messaging.bittorrent.BTHaveAll;
import com.aelitis.azureus.core.peermanager.messaging.bittorrent.BTHaveNone;
import com.aelitis.azureus.core.peermanager.messaging.bittorrent.BTInterested;
import com.aelitis.azureus.core.peermanager.messaging.bittorrent.BTKeepAlive;
import com.aelitis.azureus.core.peermanager.messaging.bittorrent.BTLTMessage;
import com.aelitis.azureus.core.peermanager.messaging.bittorrent.BTMessage;
import com.aelitis.azureus.core.peermanager.messaging.bittorrent.BTPiece;
import com.aelitis.azureus.core.peermanager.messaging.bittorrent.BTRejectRequest;
import com.aelitis.azureus.core.peermanager.messaging.bittorrent.BTRequest;
import com.aelitis.azureus.core.peermanager.messaging.bittorrent.BTSuggestPiece;
import com.aelitis.azureus.core.peermanager.messaging.bittorrent.BTUnchoke;
import com.aelitis.azureus.core.peermanager.messaging.bittorrent.BTUninterested;
import java.util.HashMap;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DirectByteBuffer;
import org.gudy.azureus2.core3.util.DirectByteBufferPool;

public class BTMessageFactory {
    public static final byte MESSAGE_VERSION_INITIAL = 1;
    public static final byte MESSAGE_VERSION_SUPPORTS_PADDING = 2;
    private static final LogIDs LOGID = LogIDs.PEER;
    private static final String[] id_to_name = new String[21];
    private static final HashMap legacy_data = new HashMap();

    public static void init() {
        try {
            MessageManager.getSingleton().registerMessageType(new BTBitfield(null, 2));
            MessageManager.getSingleton().registerMessageType(new BTCancel(-1, -1, -1, 2));
            MessageManager.getSingleton().registerMessageType(new BTChoke(2));
            MessageManager.getSingleton().registerMessageType(new BTHandshake(new byte[0], new byte[0], 2, 1));
            MessageManager.getSingleton().registerMessageType(new BTHave(-1, 2));
            MessageManager.getSingleton().registerMessageType(new BTInterested(2));
            MessageManager.getSingleton().registerMessageType(new BTKeepAlive(2));
            MessageManager.getSingleton().registerMessageType(new BTPiece(-1, -1, null, 2));
            MessageManager.getSingleton().registerMessageType(new BTRequest(-1, -1, -1, 2));
            MessageManager.getSingleton().registerMessageType(new BTUnchoke(2));
            MessageManager.getSingleton().registerMessageType(new BTUninterested(2));
            MessageManager.getSingleton().registerMessageType(new BTSuggestPiece(-1, 2));
            MessageManager.getSingleton().registerMessageType(new BTHaveAll(2));
            MessageManager.getSingleton().registerMessageType(new BTHaveNone(2));
            MessageManager.getSingleton().registerMessageType(new BTRejectRequest(-1, -1, -1, 2));
            MessageManager.getSingleton().registerMessageType(new BTAllowedFast(-1, 2));
            MessageManager.getSingleton().registerMessageType(new BTLTMessage(null, 2));
            MessageManager.getSingleton().registerMessageType(new BTDHTPort(-1));
        }
        catch (MessageException me) {
            me.printStackTrace();
        }
    }

    public static Message createBTMessage(DirectByteBuffer stream_payload) throws MessageException {
        byte id = stream_payload.get((byte)11);
        switch (id) {
            case 0: {
                return MessageManager.getSingleton().createMessage(BTMessage.ID_BT_CHOKE_BYTES, stream_payload, (byte)1);
            }
            case 1: {
                return MessageManager.getSingleton().createMessage(BTMessage.ID_BT_UNCHOKE_BYTES, stream_payload, (byte)1);
            }
            case 2: {
                return MessageManager.getSingleton().createMessage(BTMessage.ID_BT_INTERESTED_BYTES, stream_payload, (byte)1);
            }
            case 3: {
                return MessageManager.getSingleton().createMessage(BTMessage.ID_BT_UNINTERESTED_BYTES, stream_payload, (byte)1);
            }
            case 4: {
                return MessageManager.getSingleton().createMessage(BTMessage.ID_BT_HAVE_BYTES, stream_payload, (byte)1);
            }
            case 5: {
                return MessageManager.getSingleton().createMessage(BTMessage.ID_BT_BITFIELD_BYTES, stream_payload, (byte)1);
            }
            case 6: {
                return MessageManager.getSingleton().createMessage(BTMessage.ID_BT_REQUEST_BYTES, stream_payload, (byte)1);
            }
            case 7: {
                return MessageManager.getSingleton().createMessage(BTMessage.ID_BT_PIECE_BYTES, stream_payload, (byte)1);
            }
            case 8: {
                return MessageManager.getSingleton().createMessage(BTMessage.ID_BT_CANCEL_BYTES, stream_payload, (byte)1);
            }
            case 9: {
                return MessageManager.getSingleton().createMessage(BTMessage.ID_BT_DHT_PORT_BYTES, stream_payload, (byte)1);
            }
            case 13: {
                return MessageManager.getSingleton().createMessage(BTMessage.ID_BT_SUGGEST_PIECE_BYTES, stream_payload, (byte)1);
            }
            case 14: {
                return MessageManager.getSingleton().createMessage(BTMessage.ID_BT_HAVE_ALL_BYTES, stream_payload, (byte)1);
            }
            case 15: {
                return MessageManager.getSingleton().createMessage(BTMessage.ID_BT_HAVE_NONE_BYTES, stream_payload, (byte)1);
            }
            case 16: {
                return MessageManager.getSingleton().createMessage(BTMessage.ID_BT_REJECT_REQUEST_BYTES, stream_payload, (byte)1);
            }
            case 17: {
                return MessageManager.getSingleton().createMessage(BTMessage.ID_BT_ALLOWED_FAST_BYTES, stream_payload, (byte)1);
            }
            case 20: {
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(LOGID, 1, "Old extended messaging hello received (or malformed LT extension message), ignoring and faking as keep-alive."));
                }
                return MessageManager.getSingleton().createMessage(BTMessage.ID_BT_KEEP_ALIVE_BYTES, null, (byte)1);
            }
        }
        System.out.println("Unknown BT message id [" + id + "]");
        throw new MessageException("Unknown BT message id [" + id + "]");
    }

    public static int getMessageType(DirectByteBuffer stream_payload) {
        Message message;
        String name;
        byte id = stream_payload.get((byte)11, 0);
        if (id == 84) {
            return 0;
        }
        if (id >= 0 && id < id_to_name.length && (name = id_to_name[id]) != null && (message = MessageManager.getSingleton().lookupMessage(name)) != null) {
            return message.getType();
        }
        return 0;
    }

    public static RawMessage createBTRawMessage(Message base_message) {
        if (base_message instanceof RawMessage) {
            return (RawMessage)base_message;
        }
        LegacyData ld = (LegacyData)legacy_data.get(base_message.getID());
        if (ld == null) {
            Debug.out("legacy message type id not found for [" + base_message.getID() + "]");
            return null;
        }
        DirectByteBuffer[] payload = base_message.getData();
        int payload_size = 0;
        for (int i = 0; i < payload.length; ++i) {
            payload_size += payload[i].remaining((byte)11);
        }
        DirectByteBuffer header = DirectByteBufferPool.getBuffer((byte)21, 5);
        header.putInt((byte)11, 1 + payload_size);
        header.put((byte)11, ld.bt_id);
        header.flip((byte)11);
        DirectByteBuffer[] raw_buffs = new DirectByteBuffer[payload.length + 1];
        raw_buffs[0] = header;
        System.arraycopy(payload, 0, raw_buffs, 1, payload.length);
        return new RawMessageImpl(base_message, raw_buffs, ld.priority, ld.is_no_delay, ld.to_remove);
    }

    static {
        legacy_data.put("BT_CHOKE", new LegacyData(2, true, new Message[]{new BTUnchoke(0), new BTPiece(-1, -1, null, 0)}, 0));
        BTMessageFactory.id_to_name[0] = "BT_CHOKE";
        legacy_data.put("BT_UNCHOKE", new LegacyData(1, true, new Message[]{new BTChoke(0)}, 1));
        BTMessageFactory.id_to_name[1] = "BT_UNCHOKE";
        legacy_data.put("BT_INTERESTED", new LegacyData(2, true, new Message[]{new BTUninterested(0)}, 2));
        BTMessageFactory.id_to_name[2] = "BT_INTERESTED";
        legacy_data.put("BT_UNINTERESTED", new LegacyData(1, false, new Message[]{new BTInterested(0)}, 3));
        BTMessageFactory.id_to_name[3] = "BT_UNINTERESTED";
        legacy_data.put("BT_HAVE", new LegacyData(0, false, null, 4));
        BTMessageFactory.id_to_name[4] = "BT_HAVE";
        legacy_data.put("BT_BITFIELD", new LegacyData(2, true, null, 5));
        BTMessageFactory.id_to_name[5] = "BT_BITFIELD";
        legacy_data.put("BT_REQUEST", new LegacyData(1, true, null, 6));
        BTMessageFactory.id_to_name[6] = "BT_REQUEST";
        legacy_data.put("BT_PIECE", new LegacyData(0, false, null, 7));
        BTMessageFactory.id_to_name[7] = "BT_PIECE";
        legacy_data.put("BT_CANCEL", new LegacyData(2, true, null, 8));
        BTMessageFactory.id_to_name[8] = "BT_CANCEL";
        legacy_data.put("BT_DHT_PORT", new LegacyData(0, true, null, 9));
        BTMessageFactory.id_to_name[9] = "BT_DHT_PORT";
        legacy_data.put("BT_SUGGEST_PIECE", new LegacyData(1, true, null, 13));
        BTMessageFactory.id_to_name[13] = "BT_SUGGEST_PIECE";
        legacy_data.put("BT_HAVE_ALL", new LegacyData(2, true, null, 14));
        BTMessageFactory.id_to_name[14] = "BT_HAVE_ALL";
        legacy_data.put("BT_HAVE_NONE", new LegacyData(2, true, null, 15));
        BTMessageFactory.id_to_name[15] = "BT_HAVE_NONE";
        legacy_data.put("BT_REJECT_REQUEST", new LegacyData(1, true, null, 16));
        BTMessageFactory.id_to_name[16] = "BT_REJECT_REQUEST";
        legacy_data.put("BT_ALLOWED_FAST", new LegacyData(0, false, null, 17));
        BTMessageFactory.id_to_name[17] = "BT_ALLOWED_FAST";
        legacy_data.put("BT_LT_EXT_MESSAGE", new LegacyData(2, true, null, 20));
        BTMessageFactory.id_to_name[20] = "BT_LT_EXT_MESSAGE";
    }

    protected static class LegacyData {
        protected final int priority;
        protected final boolean is_no_delay;
        protected final Message[] to_remove;
        protected final byte bt_id;

        protected LegacyData(int prio, boolean no_delay, Message[] remove, byte btid) {
            this.priority = prio;
            this.is_no_delay = no_delay;
            this.to_remove = remove;
            this.bt_id = btid;
        }
    }
}

