/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.peermanager.messaging.bittorrent;

import com.aelitis.azureus.core.peermanager.messaging.Message;
import com.aelitis.azureus.core.peermanager.messaging.MessageException;
import com.aelitis.azureus.core.peermanager.messaging.bittorrent.BTMessage;
import org.gudy.azureus2.core3.util.DirectByteBuffer;
import org.gudy.azureus2.core3.util.DirectByteBufferPool;

public class BTDHTPort
implements BTMessage {
    private final int port;
    private DirectByteBuffer buffer;

    public BTDHTPort(int port) {
        this.port = port;
    }

    @Override
    public Message deserialize(DirectByteBuffer data, byte version) throws MessageException {
        if (data == null) {
            throw new MessageException("[" + this.getID() + "] decode error: data == null");
        }
        if (data.remaining((byte)11) != 2) {
            throw new MessageException("[" + this.getID() + "] decode error: payload.remaining[" + data.remaining((byte)11) + "] != 2");
        }
        short s_port = data.getShort((byte)11);
        data.returnToPool();
        return new BTDHTPort(0xFFFF & s_port);
    }

    @Override
    public DirectByteBuffer[] getData() {
        if (this.buffer == null) {
            this.buffer = DirectByteBufferPool.getBuffer((byte)30, 2);
            short s_port = (short)this.port;
            this.buffer.put((byte)11, (byte)(s_port >> 8));
            this.buffer.put((byte)11, (byte)(s_port & 0xFF));
            this.buffer.flip((byte)11);
        }
        return new DirectByteBuffer[]{this.buffer};
    }

    @Override
    public String getDescription() {
        return this.getID() + " (port " + this.port + ")";
    }

    @Override
    public void destroy() {
        if (this.buffer != null) {
            this.buffer.returnToPool();
        }
    }

    @Override
    public String getFeatureID() {
        return "BT1";
    }

    @Override
    public int getFeatureSubID() {
        return 9;
    }

    @Override
    public String getID() {
        return "BT_DHT_PORT";
    }

    @Override
    public byte[] getIDBytes() {
        return BTMessage.ID_BT_DHT_PORT_BYTES;
    }

    @Override
    public int getType() {
        return 0;
    }

    @Override
    public byte getVersion() {
        return 1;
    }

    public int getDHTPort() {
        return this.port;
    }
}

