/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.peermanager.messaging.azureus;

import com.aelitis.azureus.core.peermanager.messaging.Message;
import com.aelitis.azureus.core.peermanager.messaging.MessageException;
import com.aelitis.azureus.core.peermanager.messaging.MessagingUtil;
import com.aelitis.azureus.core.peermanager.messaging.azureus.AZMessage;
import java.util.HashMap;
import java.util.Map;
import org.gudy.azureus2.core3.util.DirectByteBuffer;

public class AZStatReply
implements AZMessage {
    private final byte version;
    private DirectByteBuffer buffer = null;
    private final Map reply;

    public AZStatReply(Map _reply, byte _version) {
        this.reply = _reply;
        this.version = _version;
    }

    @Override
    public String getID() {
        return "AZ_STAT_REP";
    }

    @Override
    public byte[] getIDBytes() {
        return AZMessage.ID_AZ_STAT_REPLY_BYTES;
    }

    @Override
    public String getFeatureID() {
        return "AZ1";
    }

    @Override
    public int getFeatureSubID() {
        return 7;
    }

    @Override
    public int getType() {
        return 0;
    }

    @Override
    public byte getVersion() {
        return this.version;
    }

    @Override
    public String getDescription() {
        return this.getID() + ": " + this.reply;
    }

    public Map getReply() {
        return this.reply;
    }

    @Override
    public DirectByteBuffer[] getData() {
        if (this.buffer == null) {
            HashMap<String, Map> map = new HashMap<String, Map>();
            map.put("reply", this.reply);
            this.buffer = MessagingUtil.convertPayloadToBencodedByteStream(map, (byte)12);
        }
        return new DirectByteBuffer[]{this.buffer};
    }

    @Override
    public Message deserialize(DirectByteBuffer data, byte version) throws MessageException {
        Map payload = MessagingUtil.convertBencodedByteStreamToPayload(data, 1, this.getID());
        Map reply = (Map)payload.get("reply");
        return new AZStatReply(reply, version);
    }

    @Override
    public void destroy() {
        if (this.buffer != null) {
            this.buffer.returnToPool();
        }
    }
}

