/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.peermanager.messaging.azureus;

import com.aelitis.azureus.core.peermanager.messaging.Message;
import com.aelitis.azureus.core.peermanager.messaging.MessageException;
import com.aelitis.azureus.core.peermanager.messaging.MessagingUtil;
import com.aelitis.azureus.core.peermanager.messaging.azureus.AZMessage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.util.DirectByteBuffer;

public class AZHave
implements AZMessage {
    private final byte version;
    private DirectByteBuffer buffer = null;
    private final int[] piece_numbers;

    public AZHave(int[] _piece_numbers, byte _version) {
        this.piece_numbers = _piece_numbers;
        this.version = _version;
    }

    @Override
    public String getID() {
        return "AZ_HAVE";
    }

    @Override
    public byte[] getIDBytes() {
        return AZMessage.ID_AZ_HAVE_BYTES;
    }

    @Override
    public String getFeatureID() {
        return "AZ1";
    }

    @Override
    public int getFeatureSubID() {
        return 4;
    }

    @Override
    public int getType() {
        return 0;
    }

    @Override
    public byte getVersion() {
        return this.version;
    }

    @Override
    public String getDescription() {
        StringBuilder str = new StringBuilder(this.piece_numbers.length * 10);
        for (int i = 0; i < this.piece_numbers.length; ++i) {
            if (i > 0) {
                str.append(",");
            }
            str.append(this.piece_numbers[i]);
        }
        return this.getID() + " " + str;
    }

    public int[] getPieceNumbers() {
        return this.piece_numbers;
    }

    @Override
    public DirectByteBuffer[] getData() {
        if (this.buffer == null) {
            HashMap map = new HashMap();
            ArrayList<Long> l = new ArrayList<Long>(this.piece_numbers.length);
            for (int i = 0; i < this.piece_numbers.length; ++i) {
                l.add(new Long(this.piece_numbers[i]));
            }
            map.put("pieces", l);
            this.buffer = MessagingUtil.convertPayloadToBencodedByteStream(map, (byte)12);
        }
        return new DirectByteBuffer[]{this.buffer};
    }

    @Override
    public Message deserialize(DirectByteBuffer data, byte version) throws MessageException {
        Map payload = MessagingUtil.convertBencodedByteStreamToPayload(data, 1, this.getID());
        List l = (List)payload.get("pieces");
        int[] pieces = new int[l.size()];
        for (int i = 0; i < pieces.length; ++i) {
            pieces[i] = ((Long)l.get(i)).intValue();
        }
        AZHave message = new AZHave(pieces, version);
        return message;
    }

    @Override
    public void destroy() {
        if (this.buffer != null) {
            this.buffer.returnToPool();
        }
    }
}

