/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.pairing.impl;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.dht.DHT;
import com.aelitis.azureus.core.dht.nat.DHTNATPuncher;
import com.aelitis.azureus.core.dht.nat.DHTNATPuncherListener;
import com.aelitis.azureus.core.dht.transport.DHTTransportContact;
import com.aelitis.azureus.core.nat.NATTraversalHandler;
import com.aelitis.azureus.core.pairing.PairedServiceRequestHandler;
import com.aelitis.azureus.core.pairing.impl.PairManagerTunnel;
import com.aelitis.azureus.core.pairing.impl.PairingManagerImpl;
import com.aelitis.azureus.core.security.CryptoManager;
import com.aelitis.azureus.core.security.CryptoManagerFactory;
import com.aelitis.azureus.plugins.dht.DHTPlugin;
import com.aelitis.azureus.util.JSONUtils;
import java.io.IOException;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URL;
import java.security.AlgorithmParameters;
import java.security.Key;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.Base32;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.IndentWriter;
import org.gudy.azureus2.core3.util.LightHashMap;
import org.gudy.azureus2.core3.util.RandomUtils;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.core3.util.UrlUtils;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.tracker.web.TrackerWebPageRequest;
import org.gudy.azureus2.plugins.tracker.web.TrackerWebPageResponse;
import org.gudy.bouncycastle.crypto.agreement.srp.SRP6Server;
import org.gudy.bouncycastle.crypto.agreement.srp.SRP6VerifierGenerator;
import org.gudy.bouncycastle.crypto.digests.SHA256Digest;
import org.json.simple.JSONObject;

public class PairingManagerTunnelHandler {
    private static final String DEFAULT_IDENTITY = "vuze";
    private BigInteger N_3072;
    private BigInteger G_3072;
    private byte[] SRP_SALT;
    private BigInteger SRP_VERIFIER;
    final PairingManagerImpl manager;
    private final AzureusCore core;
    private boolean started = false;
    private boolean active = false;
    private final List<DHTNATPuncher> nat_punchers_ipv4 = new ArrayList<DHTNATPuncher>();
    private final List<DHTNATPuncher> nat_punchers_ipv6 = new ArrayList<DHTNATPuncher>();
    private int last_punchers_registered = 0;
    private TimerEvent update_event;
    private final Map<String, Object[]> local_server_map = new LinkedHashMap<String, Object[]>(10, 0.75f, true){

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, Object[]> eldest) {
            return this.size() > 10;
        }
    };
    private long last_server_create_time;
    private long last_server_agree_time;
    private int total_servers;
    private long last_local_server_create_time;
    private long last_local_server_agree_time;
    private int total_local_servers;
    private static final int MAX_TUNNELS = 10;
    final Map<String, PairManagerTunnel> tunnels = new HashMap<String, PairManagerTunnel>();
    private String init_fail;

    protected PairingManagerTunnelHandler(PairingManagerImpl _manager, AzureusCore _core) {
        this.manager = _manager;
        this.core = _core;
        CryptoManager.SRPParameters params = CryptoManagerFactory.getSingleton().getSRPParameters();
        if (params != null) {
            this.SRP_SALT = params.getSalt();
            this.SRP_VERIFIER = params.getVerifier();
        }
    }

    public void setSRPPassword(char[] password) {
        if (password == null || password.length == 0) {
            this.SRP_SALT = null;
            this.SRP_VERIFIER = null;
            CryptoManagerFactory.getSingleton().setSRPParameters(null, null);
        } else {
            this.start();
            try {
                byte[] I = DEFAULT_IDENTITY.getBytes("UTF-8");
                byte[] P = new String(password).getBytes("UTF-8");
                byte[] salt = new byte[16];
                RandomUtils.nextSecureBytes(salt);
                SRP6VerifierGenerator gen = new SRP6VerifierGenerator();
                gen.init(this.N_3072, this.G_3072, new SHA256Digest());
                BigInteger verifier = gen.generateVerifier(salt, I, P);
                CryptoManagerFactory.getSingleton().setSRPParameters(salt, verifier);
                this.SRP_SALT = salt;
                this.SRP_VERIFIER = verifier;
            }
            catch (Throwable e) {
                Debug.out(e);
            }
        }
        this.updateActive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void start() {
        PairingManagerTunnelHandler pairingManagerTunnelHandler = this;
        synchronized (pairingManagerTunnelHandler) {
            if (this.started) {
                return;
            }
            this.started = true;
        }
        this.N_3072 = this.fromHex("FFFFFFFF FFFFFFFF C90FDAA2 2168C234 C4C6628B 80DC1CD1 29024E088A67CC74 020BBEA6 3B139B22 514A0879 8E3404DD EF9519B3 CD3A431B302B0A6D F25F1437 4FE1356D 6D51C245 E485B576 625E7EC6 F44C42E9A637ED6B 0BFF5CB6 F406B7ED EE386BFB 5A899FA5 AE9F2411 7C4B1FE649286651 ECE45B3D C2007CB8 A163BF05 98DA4836 1C55D39A 69163FA8FD24CF5F 83655D23 DCA3AD96 1C62F356 208552BB 9ED52907 7096966D670C354E 4ABC9804 F1746C08 CA18217C 32905E46 2E36CE3B E39E772C180E8603 9B2783A2 EC07A28F B5C55DF0 6F4C52C9 DE2BCBF6 955817183995497C EA956AE5 15D22618 98FA0510 15728E5A 8AAAC42D AD33170D04507A33 A85521AB DF1CBA64 ECFB8504 58DBEF0A 8AEA7157 5D060C7DB3970F85 A6E1E4C7 ABF5AE8C DB0933D7 1E8C94E0 4A25619D CEE3D2261AD2EE6B F12FFA06 D98A0864 D8760273 3EC86A64 521F2B18 177B200CBBE11757 7A615D6C 770988C0 BAD946E2 08E24FA0 74E5AB31 43DB5BFCE0FD108E 4B82D120 A93AD2CA FFFFFFFF FFFFFFFF");
        this.G_3072 = BigInteger.valueOf(5L);
        try {
            PluginInterface dht_pi = this.core.getPluginManager().getPluginInterfaceByClass(DHTPlugin.class);
            if (dht_pi == null) {
                throw new Exception("DHT Plugin not found");
            }
            DHTPlugin dht_plugin = (DHTPlugin)dht_pi.getPlugin();
            if (!dht_plugin.isEnabled()) {
                throw new Exception("DHT Plugin is disabled");
            }
            DHT[] dhts = dht_plugin.getDHTs();
            ArrayList<DHTNATPuncher> punchers = new ArrayList<DHTNATPuncher>();
            for (DHT dht : dhts) {
                int net = dht.getTransport().getNetwork();
                if (net == 0) {
                    DHTNATPuncher primary_puncher = dht.getNATPuncher();
                    if (primary_puncher == null) continue;
                    punchers.add(primary_puncher);
                    this.nat_punchers_ipv4.add(primary_puncher);
                    for (int i = 1; i <= 2; ++i) {
                        DHTNATPuncher puncher = primary_puncher.getSecondaryPuncher();
                        punchers.add(puncher);
                        this.nat_punchers_ipv4.add(puncher);
                    }
                    continue;
                }
                if (net != 3) continue;
            }
            if (punchers.size() == 0) {
                throw new Exception("No suitable DHT instances available");
            }
            for (DHTNATPuncher p : punchers) {
                p.forceActive(true);
                p.addListener(new DHTNATPuncherListener(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void rendezvousChanged(DHTTransportContact rendezvous) {
                        System.out.println("active: " + rendezvous.getString());
                        PairingManagerTunnelHandler pairingManagerTunnelHandler = PairingManagerTunnelHandler.this;
                        synchronized (pairingManagerTunnelHandler) {
                            if (PairingManagerTunnelHandler.this.update_event == null) {
                                PairingManagerTunnelHandler.this.update_event = SimpleTimer.addEvent("PMT:defer", SystemTime.getOffsetTime(15000L), new TimerEventPerformer(){

                                    /*
                                     * WARNING - Removed try catching itself - possible behaviour change.
                                     */
                                    @Override
                                    public void perform(TimerEvent event2) {
                                        PairingManagerTunnelHandler pairingManagerTunnelHandler = PairingManagerTunnelHandler.this;
                                        synchronized (pairingManagerTunnelHandler) {
                                            PairingManagerTunnelHandler.this.update_event = null;
                                        }
                                        System.out.println("    updating");
                                        PairingManagerTunnelHandler.this.manager.updateNeeded();
                                    }
                                });
                            }
                        }
                    }
                });
            }
            this.core.getNATTraverser().registerHandler(new NATTraversalHandler(){
                private final Map<Long, Object[]> server_map = new LinkedHashMap<Long, Object[]>(10, 0.75f, true){

                    @Override
                    protected boolean removeEldestEntry(Map.Entry<Long, Object[]> eldest) {
                        return this.size() > 10;
                    }
                };

                @Override
                public int getType() {
                    return 3;
                }

                @Override
                public String getName() {
                    return "Pairing Tunnel";
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Map process(InetSocketAddress originator, Map data) {
                    if (PairingManagerTunnelHandler.this.SRP_VERIFIER == null || !PairingManagerTunnelHandler.this.active) {
                        return null;
                    }
                    boolean good_request = false;
                    try {
                        BigInteger B;
                        SRP6Server server;
                        long sleep;
                        long diff;
                        InetAddress tunnel_originator;
                        HashMap<String, Object> result = new HashMap<String, Object>();
                        Long session = (Long)data.get("sid");
                        if (session == null) {
                            Map map = null;
                            return map;
                        }
                        try {
                            tunnel_originator = InetAddress.getByAddress((byte[])data.get("origin"));
                        }
                        catch (Throwable e) {
                            Debug.out("originator decode failed: " + data);
                            Map map = null;
                            if (!good_request) {
                                PairingManagerTunnelHandler.this.manager.recordRequest("SRP", originator.getAddress().getHostAddress(), false);
                            }
                            return map;
                        }
                        System.out.println("PairManagerTunnelHander: incoming message - session=" + session + ", payload=" + data + " from " + tunnel_originator + " via " + originator);
                        Map<Long, Object[]> map = this.server_map;
                        synchronized (map) {
                            Object[] entry = this.server_map.get(session);
                            if (entry == null) {
                                diff = SystemTime.getMonotonousTime() - PairingManagerTunnelHandler.this.last_server_create_time;
                                if (diff < 5000L) {
                                    try {
                                        sleep = 5000L - diff;
                                        System.out.println("Sleeping for " + sleep + " before starting srp");
                                        Thread.sleep(sleep);
                                    }
                                    catch (Throwable e) {
                                        // empty catch block
                                    }
                                }
                                server = new SRP6Server();
                                server.init(PairingManagerTunnelHandler.this.N_3072, PairingManagerTunnelHandler.this.G_3072, PairingManagerTunnelHandler.this.SRP_VERIFIER, new SHA256Digest(), RandomUtils.SECURE_RANDOM);
                                B = server.generateServerCredentials();
                                this.server_map.put(session, new Object[]{server, B});
                                PairingManagerTunnelHandler.this.last_server_create_time = SystemTime.getMonotonousTime();
                                PairingManagerTunnelHandler.this.total_servers++;
                            } else {
                                server = (SRP6Server)entry[0];
                                B = (BigInteger)entry[1];
                            }
                        }
                        Long op = (Long)data.get("op");
                        if (op == 1L) {
                            result.put("op", 2);
                            result.put("s", PairingManagerTunnelHandler.this.SRP_SALT);
                            result.put("b", B.toByteArray());
                            good_request = true;
                            if (data.containsKey("test")) {
                                PairingManagerTunnelHandler.this.manager.recordRequest("SRP Test", originator.getAddress().getHostAddress(), true);
                            }
                        } else if (op == 3L) {
                            boolean log_error = true;
                            try {
                                diff = SystemTime.getMonotonousTime() - PairingManagerTunnelHandler.this.last_server_agree_time;
                                if (diff < 5000L) {
                                    try {
                                        sleep = 5000L - diff;
                                        System.out.println("Sleeping for " + sleep + " before completing srp");
                                        Thread.sleep(sleep);
                                    }
                                    catch (Throwable e) {
                                        // empty catch block
                                    }
                                }
                                BigInteger A = new BigInteger((byte[])data.get("a"));
                                BigInteger serverS = server.calculateSecret(A);
                                byte[] shared_secret = serverS.toByteArray();
                                Cipher decipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
                                byte[] key = new byte[16];
                                System.arraycopy(shared_secret, 0, key, 0, 16);
                                SecretKeySpec secret = new SecretKeySpec(key, "AES");
                                decipher.init(2, (Key)secret, new IvParameterSpec((byte[])data.get("enc_iv")));
                                byte[] dec = decipher.doFinal((byte[])data.get("enc_data"));
                                String json_str = new String(dec, "UTF-8");
                                if (!json_str.startsWith("{")) {
                                    log_error = false;
                                    throw new Exception("decode failed");
                                }
                                JSONObject dec_json = (JSONObject)JSONUtils.decodeJSON(json_str);
                                String tunnel_url = (String)dec_json.get("url");
                                String service_id = new String((byte[])data.get("service"), "UTF-8");
                                String endpoint_url = (String)dec_json.get("endpoint");
                                boolean ok = PairingManagerTunnelHandler.this.createTunnel(tunnel_originator, session, service_id, secret, tunnel_url, endpoint_url);
                                result.put("op", 4);
                                result.put("status", ok ? "ok" : "failed");
                                good_request = true;
                            }
                            catch (Throwable e) {
                                result.put("op", 4);
                                result.put("status", "failed");
                                if (e instanceof BadPaddingException || e instanceof IllegalBlockSizeException) {
                                    log_error = false;
                                }
                                if (log_error) {
                                    e.printStackTrace();
                                }
                            }
                            finally {
                                PairingManagerTunnelHandler.this.last_server_agree_time = SystemTime.getMonotonousTime();
                            }
                        }
                        HashMap<String, Object> hashMap = result;
                        return hashMap;
                    }
                    finally {
                        if (!good_request) {
                            PairingManagerTunnelHandler.this.manager.recordRequest("SRP", originator.getAddress().getHostAddress(), false);
                        }
                    }
                }
            });
            SimpleTimer.addPeriodicEvent("pm:tunnel:stats", 30000L, new TimerEventPerformer(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void perform(TimerEvent event2) {
                    Map<String, PairManagerTunnel> map = PairingManagerTunnelHandler.this.tunnels;
                    synchronized (map) {
                        if (PairingManagerTunnelHandler.this.tunnels.size() > 0) {
                            System.out.println("PairTunnels: " + PairingManagerTunnelHandler.this.tunnels.size());
                            for (PairManagerTunnel t : PairingManagerTunnelHandler.this.tunnels.values()) {
                                System.out.println("\t" + t.getString());
                            }
                        }
                    }
                }
            });
        }
        catch (Throwable e) {
            Debug.out(e);
            this.init_fail = Debug.getNestedExceptionMessage(e);
            this.manager.updateSRPState();
        }
    }

    protected String getStatus() {
        if (this.init_fail != null) {
            return MessageText.getString("MyTorrentsView.menu.setSpeed.disabled") + ": " + this.init_fail;
        }
        if (!this.active) {
            return MessageText.getString("pairing.status.initialising") + "...";
        }
        if (this.SRP_SALT == null) {
            return MessageText.getString("pairing.srp.pw.req");
        }
        if (this.last_punchers_registered == 0) {
            return MessageText.getString("pairing.srp.registering");
        }
        return MessageText.getString("tps.status.available");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setActive(boolean a) {
        PairingManagerTunnelHandler pairingManagerTunnelHandler = this;
        synchronized (pairingManagerTunnelHandler) {
            if (this.active == a) {
                return;
            }
            this.active = a;
        }
        this.updateActive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateActive() {
        this.manager.updateSRPState();
        if (this.active && this.SRP_VERIFIER != null) {
            this.start();
        } else {
            Map<String, PairManagerTunnel> map = this.tunnels;
            synchronized (map) {
                for (PairManagerTunnel t : new ArrayList<PairManagerTunnel>(this.tunnels.values())) {
                    t.destroy();
                }
            }
            map = this.local_server_map;
            synchronized (map) {
                this.local_server_map.clear();
            }
        }
        ArrayList<DHTNATPuncher> punchers = new ArrayList<DHTNATPuncher>();
        punchers.addAll(this.nat_punchers_ipv4);
        punchers.addAll(this.nat_punchers_ipv6);
        for (DHTNATPuncher p : punchers) {
            p.forceActive(this.active);
        }
    }

    protected void updateRegistrationData(Map<String, Object> payload) {
        InetSocketAddress rend_address;
        DHTTransportContact lc;
        DHTTransportContact rend;
        int puncher_num = 0;
        int num_registered = 0;
        for (DHTNATPuncher nat_ipv4 : this.nat_punchers_ipv4) {
            rend = nat_ipv4.getRendezvous();
            lc = nat_ipv4.getLocalContact();
            if (rend == null || lc == null) continue;
            rend_address = rend.getTransportAddress();
            ++num_registered;
            payload.put("rc_v4-" + ++puncher_num, rend_address.getAddress().getHostAddress() + ":" + rend_address.getPort());
            if (puncher_num != 1) continue;
            payload.put("rl_v4", lc.getExternalAddress().getAddress().getHostAddress() + ":" + lc.getAddress().getPort());
        }
        puncher_num = 0;
        for (DHTNATPuncher nat_ipv6 : this.nat_punchers_ipv6) {
            rend = nat_ipv6.getRendezvous();
            lc = nat_ipv6.getLocalContact();
            if (rend == null || lc == null) continue;
            rend_address = rend.getTransportAddress();
            ++num_registered;
            payload.put("rc_v6-" + ++puncher_num, rend_address.getAddress().getHostAddress() + ":" + rend_address.getPort());
            if (puncher_num != 1) continue;
            payload.put("rl_v6", lc.getExternalAddress().getAddress().getHostAddress() + ":" + lc.getAddress().getPort());
        }
        if (num_registered != this.last_punchers_registered) {
            this.last_punchers_registered = num_registered;
            this.manager.updateSRPState();
        }
    }

    private BigInteger fromHex(String hex) {
        return new BigInteger(1, ByteFormatter.decodeString(hex.replaceAll(" ", "")));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean handleLocalTunnel(TrackerWebPageRequest request2, TrackerWebPageResponse response) throws IOException {
        this.start();
        if (this.SRP_VERIFIER == null) throw new IOException("Secure pairing is not enabled");
        if (!this.active) {
            throw new IOException("Secure pairing is not enabled");
        }
        boolean good_request = false;
        try {
            Object[] entry;
            Map<String, Object> result;
            Object ps;
            String url = request2.getURL().substring(16);
            int q_pos = url.indexOf(63);
            HashMap<String, String> args = new HashMap<String, String>();
            if (q_pos != -1) {
                String[] bits;
                String args_str = url.substring(q_pos + 1);
                for (String arg : bits = args_str.split("&")) {
                    String[] x = arg.split("=");
                    if (x.length != 2) continue;
                    args.put(x[0].toLowerCase(), x[1]);
                }
                url = url.substring(0, q_pos);
            }
            if (url.startsWith("create")) {
                String ac = (String)args.get("ac");
                String sid = (String)args.get("sid");
                if (ac == null) throw new IOException("Access code or service id missing");
                if (sid == null) {
                    throw new IOException("Access code or service id missing");
                }
                if (!ac.equals(this.manager.peekAccessCode())) {
                    throw new IOException("Invalid access code");
                }
                ps = this.manager.getService(sid);
                if (ps == null) {
                    good_request = true;
                    throw new IOException("Service '" + sid + "' not registered");
                }
                PairedServiceRequestHandler handler = ((PairingManagerImpl.PairedServiceImpl)ps).getHandler();
                if (handler == null) {
                    good_request = true;
                    throw new IOException("Service '" + sid + "' has no handler registered");
                }
                JSONObject json = new JSONObject();
                result = new JSONObject();
                json.put("result", result);
                byte[] ss = new byte[]{this.SRP_SALT[0], this.SRP_SALT[1], this.SRP_SALT[2], this.SRP_SALT[3]};
                long tunnel_id = RandomUtils.nextSecureAbsoluteLong();
                String tunnel_name = Base32.encode(ss) + "_" + tunnel_id;
                Map<String, Object[]> map = this.local_server_map;
                synchronized (map) {
                    long diff = SystemTime.getMonotonousTime() - this.last_local_server_create_time;
                    if (diff < 5000L) {
                        try {
                            long sleep = 5000L - diff;
                            System.out.println("Sleeping for " + sleep + " before starting srp");
                            Thread.sleep(sleep);
                        }
                        catch (Throwable e) {
                            // empty catch block
                        }
                    }
                    SRP6Server server = new SRP6Server();
                    server.init(this.N_3072, this.G_3072, this.SRP_VERIFIER, new SHA256Digest(), RandomUtils.SECURE_RANDOM);
                    BigInteger B = server.generateServerCredentials();
                    this.local_server_map.put(tunnel_name, new Object[]{server, handler, null, null});
                    this.last_local_server_create_time = SystemTime.getMonotonousTime();
                    ++this.total_local_servers;
                    ((LightHashMap)result).put("srp_salt", Base32.encode(this.SRP_SALT));
                    ((LightHashMap)result).put("srp_b", Base32.encode(B.toByteArray()));
                    Map headers = request2.getHeaders();
                    String host = (String)headers.get("host");
                    int pos = host.lastIndexOf("]");
                    if (pos != -1) {
                        host = host.substring(0, pos + 1);
                    } else {
                        pos = host.indexOf(58);
                        if (pos != -1) {
                            host = host.substring(0, pos);
                        }
                    }
                    String abs_url = request2.getAbsoluteURL().toString();
                    abs_url = UrlUtils.setHost(new URL(abs_url), host).toExternalForm();
                    pos = abs_url.indexOf("/create");
                    String tunnel_url = abs_url.substring(0, pos) + "/id/" + tunnel_name;
                    ((LightHashMap)result).put("url", tunnel_url);
                }
                response.getOutputStream().write(JSONUtils.encodeToJSON(json).getBytes("UTF-8"));
                response.setContentType("application/json; charset=UTF-8");
                response.setGZIP(true);
                good_request = true;
                boolean bl = true;
                return bl;
            }
            if (!url.startsWith("id/")) throw new IOException("Unknown tunnel operation");
            String tunnel_name = url.substring(3);
            ps = this.local_server_map;
            synchronized (ps) {
                entry = this.local_server_map.get(tunnel_name);
                if (entry == null) {
                    good_request = true;
                    throw new IOException("Unknown tunnel id");
                }
            }
            String srp_a = (String)args.get("srp_a");
            String enc_data = (String)args.get("enc_data");
            String enc_iv = (String)args.get("enc_iv");
            if (srp_a != null && enc_data != null && enc_iv != null) {
                try {
                    result = this.local_server_map;
                    synchronized (result) {
                        long diff = SystemTime.getMonotonousTime() - this.last_local_server_agree_time;
                        if (diff < 5000L) {
                            try {
                                long sleep = 5000L - diff;
                                System.out.println("Sleeping for " + sleep + " before completing srp");
                                Thread.sleep(sleep);
                            }
                            catch (Throwable e) {
                                // empty catch block
                            }
                        }
                    }
                    JSONObject json = new JSONObject();
                    JSONObject result2 = new JSONObject();
                    json.put("result", result2);
                    SRP6Server server = (SRP6Server)entry[0];
                    BigInteger A = new BigInteger(Base32.decode(srp_a));
                    BigInteger serverS = server.calculateSecret(A);
                    byte[] shared_secret = serverS.toByteArray();
                    Cipher decipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
                    byte[] key = new byte[16];
                    System.arraycopy(shared_secret, 0, key, 0, 16);
                    SecretKeySpec secret = new SecretKeySpec(key, "AES");
                    decipher.init(2, (Key)secret, new IvParameterSpec(Base32.decode(enc_iv)));
                    byte[] dec = decipher.doFinal(Base32.decode(enc_data));
                    JSONObject dec_json = (JSONObject)JSONUtils.decodeJSON(new String(dec, "UTF-8"));
                    String tunnel_url = (String)dec_json.get("url");
                    if (!tunnel_url.contains(tunnel_name)) {
                        throw new IOException("Invalid tunnel url");
                    }
                    String endpoint_url = (String)dec_json.get("endpoint");
                    entry[2] = secret;
                    entry[3] = endpoint_url;
                    result2.put("state", "activated");
                    response.getOutputStream().write(JSONUtils.encodeToJSON(json).getBytes("UTF-8"));
                    response.setContentType("application/json; charset=UTF-8");
                    response.setGZIP(true);
                    good_request = true;
                    boolean bl = true;
                    return bl;
                }
                catch (Throwable e22) {
                    throw new IOException(Debug.getNestedExceptionMessage(e22));
                }
                finally {
                    this.last_local_server_agree_time = SystemTime.getMonotonousTime();
                }
            }
            if (args.containsKey("close")) {
                Map<String, Object[]> e22 = this.local_server_map;
                synchronized (e22) {
                    this.local_server_map.remove(tunnel_name);
                }
                good_request = true;
                boolean e22 = true;
                return e22;
            }
            PairedServiceRequestHandler request_handler = (PairedServiceRequestHandler)entry[1];
            SecretKeySpec secret = (SecretKeySpec)entry[2];
            String endpoint_url = (String)entry[3];
            if (secret == null) {
                throw new IOException("auth not completed");
            }
            byte[] request_data = FileUtil.readInputStreamAsByteArray(request2.getInputStream());
            try {
                byte[] IV = new byte[16];
                System.arraycopy(request_data, 0, IV, 0, IV.length);
                Cipher decipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
                decipher.init(2, (Key)secret, new IvParameterSpec(IV));
                byte[] decrypted = decipher.doFinal(request_data, 16, request_data.length - 16);
                byte[] reply_bytes = request_handler.handleRequest(request2.getClientAddress2().getAddress(), endpoint_url, decrypted);
                Cipher encipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
                encipher.init(1, secret);
                AlgorithmParameters params = encipher.getParameters();
                byte[] IV2 = params.getParameterSpec(IvParameterSpec.class).getIV();
                byte[] enc = encipher.doFinal(reply_bytes);
                byte[] rep_bytes = new byte[IV2.length + enc.length];
                System.arraycopy(IV2, 0, rep_bytes, 0, IV2.length);
                System.arraycopy(enc, 0, rep_bytes, IV2.length, enc.length);
                response.getOutputStream().write(rep_bytes);
                response.setContentType("application/octet-stream");
                good_request = true;
                boolean bl = true;
                return bl;
            }
            catch (Throwable e) {
                throw new IOException(Debug.getNestedExceptionMessage(e));
            }
        }
        finally {
            if (!good_request) {
                this.manager.recordRequest("SRP", request2.getClientAddress2().getAddress().getHostAddress(), false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean createTunnel(InetAddress originator, long session, String sid, SecretKeySpec secret, String tunnel_url, String endpoint_url) {
        PairingManagerImpl.PairedServiceImpl ps = this.manager.getService(sid);
        if (ps == null) {
            Debug.out("Service '" + sid + "' not registered");
            return false;
        }
        PairedServiceRequestHandler handler = ps.getHandler();
        if (handler == null) {
            Debug.out("Service '" + sid + "' has no handler registered");
            return false;
        }
        String key = originator.getHostAddress() + ":" + session + ":" + sid;
        Map<String, PairManagerTunnel> map = this.tunnels;
        synchronized (map) {
            PairManagerTunnel existing = this.tunnels.get(key);
            if (existing != null) {
                return true;
            }
            if (this.tunnels.size() > 10) {
                long oldest_active = Long.MAX_VALUE;
                PairManagerTunnel oldest_tunnel = null;
                for (PairManagerTunnel t : this.tunnels.values()) {
                    long at = t.getLastActive();
                    if (at >= oldest_active) continue;
                    oldest_active = at;
                    oldest_tunnel = t;
                }
                oldest_tunnel.destroy();
                this.tunnels.remove(oldest_tunnel.getKey());
            }
            PairManagerTunnel tunnel = new PairManagerTunnel(this, key, originator, sid, handler, secret, tunnel_url, endpoint_url);
            this.tunnels.put(key, tunnel);
            System.out.println("Created pair manager tunnel: " + tunnel.getString());
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeTunnel(PairManagerTunnel tunnel) {
        System.out.println("Destroyed pair manager tunnel: " + tunnel.getString());
        Map<String, PairManagerTunnel> map = this.tunnels;
        synchronized (map) {
            this.tunnels.remove(tunnel.getKey());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void generateEvidence(IndentWriter writer) {
        writer.println("Tunnel Handler");
        writer.indent();
        writer.println("started=" + this.started + ", active=" + this.active);
        if (this.init_fail != null) {
            writer.println("Init fail: " + this.init_fail);
        }
        long now = SystemTime.getMonotonousTime();
        writer.println("total local=" + this.total_local_servers);
        writer.println("last local create=" + (this.last_local_server_create_time == 0L ? "<never>" : String.valueOf(now - this.last_local_server_create_time)));
        writer.println("last local agree=" + (this.last_local_server_agree_time == 0L ? "<never>" : String.valueOf(now - this.last_local_server_agree_time)));
        writer.println("total remote=" + this.total_servers);
        writer.println("last remote create=" + (this.last_server_create_time == 0L ? "<never>" : String.valueOf(now - this.last_server_create_time)));
        writer.println("last remote agree=" + (this.last_server_agree_time == 0L ? "<never>" : String.valueOf(now - this.last_server_agree_time)));
        Map<String, PairManagerTunnel> map = this.tunnels;
        synchronized (map) {
            writer.println("tunnels=" + this.tunnels.size());
            for (PairManagerTunnel tunnel : this.tunnels.values()) {
                writer.println("    " + tunnel.getString());
            }
        }
        try {
            writer.println("IPv4 punchers: " + this.nat_punchers_ipv4.size());
            for (DHTNATPuncher p : this.nat_punchers_ipv4) {
                writer.println("    " + p.getStats());
            }
            writer.println("IPv6 punchers: " + this.nat_punchers_ipv6.size());
            for (DHTNATPuncher p : this.nat_punchers_ipv6) {
                writer.println("    " + p.getStats());
            }
        }
        finally {
            writer.exdent();
        }
    }
}

