/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.neuronal;

import com.aelitis.azureus.core.neuronal.LogisticActivationFunction;
import com.aelitis.azureus.core.neuronal.NeuralNetwork;

public class NeuralSpeedLimiter {
    long maxDlSpeed;
    long maxUlSpeed;
    long ulSpeed;
    long dlSpeed;
    long minLatency;
    long maxLatency;
    long latency;
    final NeuralNetwork neuralNetwork;
    private boolean dirty;
    private double currentULTarget = 0.6;
    final double[][] trainingSet = new double[][]{{0.0, 0.0, 0.0, 0.9, 0.9, 0.9, 0.9}, {0.0, 1.0, 0.0, 0.9, 0.9, 0.9, 0.9}, {1.0, 0.0, 0.0, 0.9, 0.9, 0.9, 0.9}, {1.0, 1.0, 0.0, 0.9, 0.9, 0.9, 0.9}, {0.0, 1.0, 1.0, 0.9, 0.9, 0.1, 0.1}, {0.0, 1.0, 0.3, 0.9, 0.9, 0.1, 0.1}, {0.0, 1.0, 0.1, 0.9, 0.9, 0.1, 0.8}, {0.0, 1.0, 0.2, 0.9, 0.9, 0.1, 0.6}, {1.0, 0.0, 1.0, 0.1, 0.5, 0.9, 0.9}, {1.0, 0.0, 0.3, 0.1, 0.6, 0.9, 0.9}, {1.0, 0.0, 0.1, 0.1, 0.9, 0.9, 0.9}, {1.0, 0.0, 0.2, 0.1, 0.8, 0.9, 0.9}};

    public NeuralSpeedLimiter() {
        this.neuralNetwork = new NeuralNetwork(3, 4, 4);
        this.neuralNetwork.setLearningRate(0.05);
        this.neuralNetwork.setMomentum(true, 0.9);
        this.neuralNetwork.setActivationFunction(new LogisticActivationFunction());
        this.train();
        this.dirty = false;
    }

    private void train() {
        double error = 1.0;
        for (int c = 0; error > 0.002 && c < 200000; error /= (double)this.trainingSet.length, ++c) {
            error = 0.0;
            for (int i = 0; i < this.trainingSet.length; ++i) {
                this.neuralNetwork.setInput(0, this.trainingSet[i][0]);
                this.neuralNetwork.setInput(1, this.trainingSet[i][1]);
                this.neuralNetwork.setInput(2, this.trainingSet[i][2]);
                this.neuralNetwork.setDesiredOutput(0, this.trainingSet[i][3]);
                this.neuralNetwork.setDesiredOutput(1, this.trainingSet[i][4]);
                this.neuralNetwork.setDesiredOutput(2, this.trainingSet[i][5]);
                this.neuralNetwork.setDesiredOutput(3, this.trainingSet[i][6]);
                this.neuralNetwork.feedForward();
                error += this.neuralNetwork.calculateError();
                this.neuralNetwork.backPropagate();
            }
        }
    }

    private void resetInput() {
        try {
            if (this.ulSpeed > this.maxUlSpeed) {
                this.maxUlSpeed = this.ulSpeed;
            }
            if (this.dlSpeed > this.maxDlSpeed) {
                this.maxDlSpeed = this.dlSpeed;
            }
            if (this.latency > this.maxLatency) {
                this.maxLatency = this.latency;
            }
            if (this.latency < this.minLatency) {
                this.minLatency = this.latency;
            }
            double downloadFactor = (double)this.dlSpeed / (double)this.maxDlSpeed;
            double uploadFactor = (double)this.ulSpeed / (double)this.maxUlSpeed;
            double latencyFactor = ((double)this.latency - (double)this.minLatency) / (double)this.maxLatency;
            this.neuralNetwork.setInput(0, downloadFactor);
            this.neuralNetwork.setInput(1, uploadFactor);
            this.neuralNetwork.setInput(2, latencyFactor);
            this.dirty = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void retrain(double ulTarget) {
        this.resetInput();
        this.neuralNetwork.feedForward();
        double shouldLimitDownload = this.neuralNetwork.getOutput(0);
        double downloadLimit = this.neuralNetwork.getOutput(1);
        double downloadFactor = (double)this.dlSpeed / (double)this.maxDlSpeed;
        double uploadFactor = (double)this.ulSpeed / (double)this.maxUlSpeed;
        double latencyFactor = ((double)this.latency - (double)this.minLatency) / (double)this.maxLatency;
        double error = 1.0;
        for (int c = 0; error > 0.002 && c < 400; ++c) {
            this.neuralNetwork.setInput(0, downloadFactor);
            this.neuralNetwork.setInput(1, uploadFactor);
            this.neuralNetwork.setInput(2, latencyFactor);
            this.neuralNetwork.setDesiredOutput(0, shouldLimitDownload);
            this.neuralNetwork.setDesiredOutput(1, downloadLimit);
            this.neuralNetwork.setDesiredOutput(2, 0.9);
            this.neuralNetwork.setDesiredOutput(3, ulTarget);
            this.neuralNetwork.feedForward();
            error = this.neuralNetwork.calculateError();
            this.neuralNetwork.backPropagate();
        }
    }

    private void feedForward() {
        this.neuralNetwork.feedForward();
        this.dirty = false;
        double latencyFactor = ((double)this.latency - (double)this.minLatency) / (double)this.maxLatency;
        if (latencyFactor >= 0.15) {
            this.currentULTarget *= 0.97;
            this.retrain(this.currentULTarget);
        } else if (latencyFactor < 0.05) {
            this.currentULTarget *= 1.02;
            this.retrain(this.currentULTarget);
        }
    }

    public void setMaxDlSpeed(long maxDlSpeed) {
        if (maxDlSpeed > 0L) {
            this.maxDlSpeed = maxDlSpeed;
        }
        this.resetInput();
    }

    public void setMaxUlSpeed(long maxUlSpeed) {
        if (maxUlSpeed > 0L) {
            this.maxUlSpeed = maxUlSpeed;
        }
        this.resetInput();
    }

    public void setMinLatency(long minLatency) {
        if (minLatency >= 0L) {
            this.minLatency = minLatency;
        }
        this.resetInput();
    }

    public void setUlSpeed(long ulSpeed) {
        if (ulSpeed >= 0L) {
            this.ulSpeed = ulSpeed;
        }
        this.resetInput();
    }

    public void setDlSpeed(long dlSpeed) {
        if (dlSpeed >= 0L) {
            this.dlSpeed = dlSpeed;
        }
        this.resetInput();
    }

    public void setLatency(long latency) {
        if (latency >= 0L) {
            this.latency = latency;
        }
        this.resetInput();
    }

    public void setMaxLatency(long maxLatency) {
        if (maxLatency > 0L) {
            this.maxLatency = maxLatency;
        }
        this.resetInput();
    }

    public boolean shouldLimitDownload() {
        if (this.dirty) {
            this.feedForward();
        }
        return this.neuralNetwork.getOutput(0) < 0.5;
    }

    public long getDownloadLimit() {
        if (this.dirty) {
            this.feedForward();
        }
        return (long)(1.2 * (double)this.maxDlSpeed * this.neuralNetwork.getOutput(1));
    }

    public boolean shouldLimitUpload() {
        if (this.dirty) {
            this.feedForward();
        }
        return this.neuralNetwork.getOutput(2) < 0.5;
    }

    public long getUploadLimit() {
        if (this.dirty) {
            this.feedForward();
        }
        return (long)(1.2 * (double)this.maxUlSpeed * this.neuralNetwork.getOutput(3));
    }

    public static void main(String[] args) {
        new NeuralSpeedLimiter();
    }
}

