/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager.impl.tcp;

import com.aelitis.azureus.core.networkmanager.VirtualChannelSelector;
import com.aelitis.azureus.core.networkmanager.impl.tcp.SelectorGuard;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.AbstractSelectableChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.gudy.azureus2.core3.logging.LogAlert;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.AEDiagnostics;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;

public class VirtualChannelSelectorImpl {
    private static final LogIDs LOGID = LogIDs.NWMAN;
    private static final boolean MAYBE_BROKEN_SELECT;
    private static final int SELECTOR_TIMEOUT = 15000;
    static final AESemaphore get_selector_allowed;
    private boolean select_is_broken;
    private int select_looks_broken_count;
    private boolean logged_broken_select;
    protected Selector selector;
    private final SelectorGuard selector_guard;
    private int consec_select_fails;
    private long consec_select_fails_start;
    private final LinkedList<Object> register_cancel_list = new LinkedList();
    private final AEMonitor register_cancel_list_mon = new AEMonitor("VirtualChannelSelector:RCL");
    private final HashMap<AbstractSelectableChannel, Boolean> paused_states = new HashMap();
    private final int INTEREST_OP;
    private final boolean pause_after_select;
    protected final VirtualChannelSelector parent;
    private volatile boolean destroyed;
    private boolean randomise_keys;
    private int next_select_loop_pos = 0;
    private static final int WRITE_SELECTOR_DEBUG_CHECK_PERIOD = 10000;
    private static final int WRITE_SELECTOR_DEBUG_MAX_TIME = 20000;
    private long last_write_select_debug;
    private long last_select_debug;
    private long last_reopen_attempt = SystemTime.getMonotonousTime();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Selector getSelector() throws IOException {
        if (!get_selector_allowed.reserve(15000L)) {
            Debug.out("Selector timeout (existing incomplete)");
            throw new SelectorTimeoutException();
        }
        final Object[] result = new Object[]{null};
        final AESemaphore sem = new AESemaphore("getSelector");
        Class<VirtualChannelSelectorImpl> clazz = VirtualChannelSelectorImpl.class;
        synchronized (VirtualChannelSelectorImpl.class) {
            try {
                final TimerEvent event2 = SimpleTimer.addEvent("getSelector", SystemTime.getOffsetTime(15000L), new TimerEventPerformer(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void perform(TimerEvent event2) {
                        Class<VirtualChannelSelectorImpl> clazz = VirtualChannelSelectorImpl.class;
                        synchronized (VirtualChannelSelectorImpl.class) {
                            if (result[0] == null) {
                                Debug.out("Selector timeout");
                                result[0] = new SelectorTimeoutException();
                                sem.release();
                            }
                            // ** MonitorExit[var2_2] (shouldn't be in output)
                            return;
                        }
                    }
                });
                new AEThread2("getSelector"){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    @Override
                    public void run() {
                        Class<VirtualChannelSelectorImpl> clazz;
                        try {
                            Selector sel = Selector.open();
                            clazz = VirtualChannelSelectorImpl.class;
                            synchronized (VirtualChannelSelectorImpl.class) {
                                block14: {
                                    if (result[0] != null) break block14;
                                    result[0] = sel;
                                    // ** MonitorExit[var2_3] (shouldn't be in output)
                                    return;
                                }
                                // ** MonitorExit[var2_3] (shouldn't be in output)
                                sel.close();
                                return;
                            }
                        }
                        catch (Throwable e) {
                            clazz = VirtualChannelSelectorImpl.class;
                            synchronized (VirtualChannelSelectorImpl.class) {
                                if (result[0] != null) return;
                                result[0] = e instanceof IOException ? e : new IOException(Debug.getNestedExceptionMessage(e));
                                // ** MonitorExit[var2_3] (shouldn't be in output)
                                return;
                            }
                        }
                        finally {
                            get_selector_allowed.release();
                            sem.release();
                            event2.cancel();
                        }
                    }
                }.start();
            }
            catch (Throwable e) {
                get_selector_allowed.release();
                throw new IOException(Debug.getNestedExceptionMessage(e));
            }
            sem.reserve();
            if (result[0] instanceof IOException) {
                throw (IOException)result[0];
            }
            return (Selector)result[0];
        }
    }

    public VirtualChannelSelectorImpl(VirtualChannelSelector _parent, int _interest_op, boolean _pause_after_select, boolean _randomise_keys) {
        String type;
        this.parent = _parent;
        this.INTEREST_OP = _interest_op;
        this.pause_after_select = _pause_after_select;
        this.randomise_keys = _randomise_keys;
        switch (this.INTEREST_OP) {
            case 8: {
                type = "OP_CONNECT";
                break;
            }
            case 1: {
                type = "OP_READ";
                break;
            }
            default: {
                type = "OP_WRITE";
            }
        }
        this.selector_guard = new SelectorGuard(type, new SelectorGuard.GuardListener(){

            @Override
            public boolean safeModeSelectEnabled() {
                return VirtualChannelSelectorImpl.this.parent.isSafeSelectionModeEnabled();
            }

            @Override
            public void spinDetected() {
                VirtualChannelSelectorImpl.this.closeExistingSelector();
                try {
                    Thread.sleep(1000L);
                }
                catch (Throwable x) {
                    x.printStackTrace();
                }
                VirtualChannelSelectorImpl.this.parent.enableSafeSelectionMode();
            }

            @Override
            public void failureDetected() {
                try {
                    Thread.sleep(10000L);
                }
                catch (Throwable x) {
                    x.printStackTrace();
                }
                VirtualChannelSelectorImpl.this.closeExistingSelector();
                try {
                    Thread.sleep(1000L);
                }
                catch (Throwable x) {
                    x.printStackTrace();
                }
                VirtualChannelSelectorImpl.this.selector = VirtualChannelSelectorImpl.this.openNewSelector();
            }
        });
        this.selector = this.openNewSelector();
    }

    protected Selector openNewSelector() {
        Selector sel = null;
        int MAX_TRIES = 10;
        try {
            sel = VirtualChannelSelectorImpl.getSelector();
            AEDiagnostics.logWithStack("seltrace", "Selector created for '" + this.parent.getName() + "'," + this.selector_guard.getType());
        }
        catch (Throwable t) {
            int fail_count;
            Debug.out("ERROR: caught exception on Selector.open()", t);
            try {
                Thread.sleep(3000L);
            }
            catch (Throwable x) {
                x.printStackTrace();
            }
            int n = fail_count = t instanceof SelectorTimeoutException ? 1000 : 1;
            while (fail_count < 10) {
                try {
                    sel = VirtualChannelSelectorImpl.getSelector();
                    AEDiagnostics.logWithStack("seltrace", "Selector created for '" + this.parent.getName() + "'," + this.selector_guard.getType());
                    break;
                }
                catch (Throwable f) {
                    Debug.out(f);
                    fail_count = f instanceof SelectorTimeoutException ? 1000 : ++fail_count;
                    if (fail_count >= 10) break;
                    try {
                        Thread.sleep(3000L);
                    }
                    catch (Throwable x) {
                        x.printStackTrace();
                    }
                }
            }
            if (fail_count < 10) {
                Debug.out("NOTICE: socket Selector successfully opened after " + fail_count + " failures.");
            }
            Logger.log(new LogAlert(true, 3, "ERROR: socket Selector.open() failed " + (fail_count == 1000 ? "due to timeout" : "10 times in a row") + ", aborting." + "\nAzureus / Java is likely being firewalled!"));
        }
        return sel;
    }

    public void setRandomiseKeys(boolean r) {
        this.randomise_keys = r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pauseSelects(AbstractSelectableChannel channel2) {
        if (channel2 == null) {
            return;
        }
        SelectionKey key = channel2.keyFor(this.selector);
        if (key != null && key.isValid()) {
            key.interestOps(key.interestOps() & ~this.INTEREST_OP);
        } else if (channel2.isOpen()) {
            try {
                this.register_cancel_list_mon.enter();
                this.paused_states.put(channel2, Boolean.TRUE);
            }
            finally {
                this.register_cancel_list_mon.exit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resumeSelects(AbstractSelectableChannel channel2) {
        if (channel2 == null) {
            Debug.printStackTrace(new Exception("resumeSelects():: channel == null"));
            return;
        }
        SelectionKey key = channel2.keyFor(this.selector);
        if (key != null && key.isValid()) {
            if ((key.interestOps() & this.INTEREST_OP) == 0) {
                RegistrationData data = (RegistrationData)key.attachment();
                data.last_select_success_time = SystemTime.getCurrentTime();
                data.non_progress_count = 0;
            }
            key.interestOps(key.interestOps() | this.INTEREST_OP);
        } else {
            try {
                this.register_cancel_list_mon.enter();
                this.paused_states.remove(channel2);
            }
            finally {
                this.register_cancel_list_mon.exit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel(AbstractSelectableChannel channel2) {
        if (this.destroyed) {
            // empty if block
        }
        if (channel2 == null) {
            Debug.out("Attempt to cancel selects for null channel");
            return;
        }
        try {
            this.register_cancel_list_mon.enter();
            Iterator it = this.register_cancel_list.iterator();
            while (it.hasNext()) {
                Object obj = it.next();
                if (channel2 != obj && (!(obj instanceof RegistrationData) || ((RegistrationData)obj).channel != channel2)) continue;
                it.remove();
                break;
            }
            this.pauseSelects(channel2);
            this.register_cancel_list.add(channel2);
        }
        finally {
            this.register_cancel_list_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(AbstractSelectableChannel channel2, VirtualChannelSelector.VirtualAbstractSelectorListener listener, Object attachment) {
        if (this.destroyed) {
            Debug.out("register called after selector destroyed");
        }
        if (channel2 == null) {
            Debug.out("Attempt to register selects for null channel");
            return;
        }
        try {
            this.register_cancel_list_mon.enter();
            Iterator it = this.register_cancel_list.iterator();
            while (it.hasNext()) {
                Object obj = it.next();
                if (channel2 != obj && (!(obj instanceof RegistrationData) || ((RegistrationData)obj).channel != channel2)) continue;
                it.remove();
                break;
            }
            this.paused_states.remove(channel2);
            this.register_cancel_list.add(new RegistrationData(channel2, listener, attachment));
        }
        finally {
            this.register_cancel_list_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int select(long timeout) {
        long time_diff;
        RegistrationData data;
        boolean randy;
        List<Object> ready_keys;
        long select_start_time = SystemTime.getCurrentTime();
        if (this.selector == null) {
            long mono_now = SystemTime.getMonotonousTime();
            if (mono_now - this.last_reopen_attempt > 60000L && !this.destroyed) {
                this.last_reopen_attempt = mono_now;
                this.selector = this.openNewSelector();
            }
            if (this.selector == null) {
                Debug.out("VirtualChannelSelector.select() op called with null selector");
                try {
                    Thread.sleep(3000L);
                }
                catch (Throwable x) {
                    x.printStackTrace();
                }
                return 0;
            }
        }
        if (!this.selector.isOpen()) {
            Debug.out("VirtualChannelSelector.select() op called with closed selector");
            try {
                Thread.sleep(3000L);
            }
            catch (Throwable x) {
                x.printStackTrace();
            }
            return 0;
        }
        RegistrationData select_fail_data = null;
        Throwable select_fail_excep = null;
        try {
            this.register_cancel_list_mon.enter();
            while (this.register_cancel_list.size() > 0) {
                SelectionKey key;
                Object obj = this.register_cancel_list.remove(0);
                if (obj instanceof AbstractSelectableChannel) {
                    AbstractSelectableChannel canceled_channel = (AbstractSelectableChannel)obj;
                    try {
                        key = canceled_channel.keyFor(this.selector);
                        if (key == null) continue;
                        key.cancel();
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                    }
                    continue;
                }
                RegistrationData data2 = (RegistrationData)obj;
                try {
                    if (data2 == null) {
                        throw new Exception("data == null");
                    }
                    if (data2.channel == null) {
                        throw new Exception("data.channel == null");
                    }
                    if (data2.channel.isOpen()) {
                        Boolean paused;
                        key = data2.channel.keyFor(this.selector);
                        if (key != null && key.isValid()) {
                            key.attach(data2);
                            key.interestOps(key.interestOps() | this.INTEREST_OP);
                        } else {
                            data2.channel.register(this.selector, this.INTEREST_OP, data2);
                        }
                        if ((paused = this.paused_states.get(data2.channel)) == null) continue;
                        this.pauseSelects(data2.channel);
                        continue;
                    }
                    select_fail_data = data2;
                    select_fail_excep = new Throwable("select registration: channel is closed");
                }
                catch (Throwable t) {
                    Debug.printStackTrace(t);
                    select_fail_data = data2;
                    select_fail_excep = t;
                }
            }
            this.paused_states.clear();
        }
        finally {
            this.register_cancel_list_mon.exit();
        }
        if (select_fail_data != null) {
            try {
                this.parent.selectFailure(select_fail_data.listener, select_fail_data.channel, select_fail_data.attachment, select_fail_excep);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
        int count = 0;
        this.selector_guard.markPreSelectTime();
        try {
            count = this.selector.select(timeout);
            this.consec_select_fails = 0;
        }
        catch (Throwable t) {
            long now = SystemTime.getMonotonousTime();
            ++this.consec_select_fails;
            if (this.consec_select_fails == 1) {
                this.consec_select_fails_start = now;
            }
            if (this.consec_select_fails > 20 && this.consec_select_fails_start - now > 16000L) {
                this.consec_select_fails = 0;
                Debug.out("Consecutive fail exceeded (" + this.consec_select_fails + ") - recreating selector");
                this.closeExistingSelector();
                try {
                    Thread.sleep(1000L);
                }
                catch (Throwable x) {
                    x.printStackTrace();
                }
                this.selector = this.openNewSelector();
                return 0;
            }
            if (now - this.last_select_debug > 5000L) {
                this.last_select_debug = now;
                String msg = t.getMessage();
                if (msg == null || !msg.equalsIgnoreCase("bad file descriptor")) {
                    Debug.out("Caught exception on selector.select() op: " + msg, t);
                }
            }
            try {
                Thread.sleep(timeout);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        if (this.destroyed) {
            this.closeExistingSelector();
            return 0;
        }
        if (MAYBE_BROKEN_SELECT && !this.select_is_broken && (this.INTEREST_OP == 1 || this.INTEREST_OP == 4)) {
            if (this.selector.selectedKeys().size() == 0) {
                Set<SelectionKey> keys = this.selector.keys();
                for (SelectionKey key : keys) {
                    if ((key.readyOps() & this.INTEREST_OP) == 0) continue;
                    ++this.select_looks_broken_count;
                    break;
                }
                if (this.select_looks_broken_count >= 5) {
                    this.select_is_broken = true;
                    if (!this.logged_broken_select) {
                        this.logged_broken_select = true;
                    }
                }
            } else {
                this.select_looks_broken_count = 0;
            }
        }
        this.selector_guard.verifySelectorIntegrity(count, 12L);
        if (!this.selector.isOpen()) {
            return count;
        }
        int progress_made_key_count = 0;
        int total_key_count = 0;
        long now = SystemTime.getCurrentTime();
        HashSet<SelectionKey> non_selected_keys = null;
        if (this.INTEREST_OP == 4 && (now < this.last_write_select_debug || now - this.last_write_select_debug > 10000L)) {
            this.last_write_select_debug = now;
            non_selected_keys = new HashSet<SelectionKey>(this.selector.keys());
        }
        if (MAYBE_BROKEN_SELECT && this.select_is_broken) {
            Set<SelectionKey> all_keys = this.selector.keys();
            ready_keys = new ArrayList();
            for (SelectionKey key : all_keys) {
                if ((key.readyOps() & this.INTEREST_OP) == 0) continue;
                ready_keys.add(key);
            }
        } else {
            Set<SelectionKey> selected = this.selector.selectedKeys();
            ready_keys = selected.size() == 0 ? Collections.emptyList() : new ArrayList<SelectionKey>(selected);
        }
        if (randy = this.randomise_keys) {
            Collections.shuffle(ready_keys);
        }
        Set<SelectionKey> selected_keys = this.selector.selectedKeys();
        int ready_key_size = ready_keys.size();
        int start_pos = this.next_select_loop_pos++;
        int end_pos = start_pos + ready_key_size;
        for (int i = start_pos; i < end_pos; ++i) {
            SelectionKey key = (SelectionKey)ready_keys.get(i % ready_key_size);
            ++total_key_count;
            selected_keys.remove(key);
            data = (RegistrationData)key.attachment();
            if (non_selected_keys != null) {
                non_selected_keys.remove(key);
            }
            data.last_select_success_time = now;
            if (key.isValid()) {
                SocketChannel sc;
                Socket socket;
                InetAddress address;
                boolean progress_indicator;
                if ((key.interestOps() & this.INTEREST_OP) == 0) continue;
                if (this.pause_after_select) {
                    try {
                        key.interestOps(key.interestOps() & ~this.INTEREST_OP);
                    }
                    catch (CancelledKeyException e) {
                        // empty catch block
                    }
                }
                if (progress_indicator = this.parent.selectSuccess(data.listener, data.channel, data.attachment)) {
                    ++progress_made_key_count;
                    data.non_progress_count = 0;
                    continue;
                }
                ++data.non_progress_count;
                boolean loopback_connection = false;
                if (this.INTEREST_OP != 16 && (address = (socket = (sc = (SocketChannel)data.channel).socket()).getInetAddress()) != null) {
                    loopback_connection = address.isLoopbackAddress();
                }
                if (loopback_connection) {
                    if (data.non_progress_count != 10000) continue;
                    Debug.out("No progress for " + data.non_progress_count + ", closing connection");
                    try {
                        data.channel.close();
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                if (data.non_progress_count != 10 && (data.non_progress_count % 100 != 0 || data.non_progress_count <= 0)) continue;
                boolean do_log = true;
                if (data.non_progress_count == 10 && this.INTEREST_OP == 4) {
                    do_log = false;
                }
                if (do_log) {
                    Debug.out("VirtualChannelSelector: No progress for op " + this.INTEREST_OP + ": listener = " + data.listener.getClass() + ", count = " + data.non_progress_count + ", socket: open = " + data.channel.isOpen() + (this.INTEREST_OP == 16 ? "" : ", connected = " + ((SocketChannel)data.channel).isConnected()));
                }
                if (data.non_progress_count != 1000) continue;
                Debug.out("No progress for " + data.non_progress_count + ", closing connection");
                try {
                    data.channel.close();
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
                continue;
            }
            key.cancel();
            this.parent.selectFailure(data.listener, data.channel, data.attachment, new Throwable("key is invalid"));
        }
        if (non_selected_keys != null) {
            for (SelectionKey key : non_selected_keys) {
                data = (RegistrationData)key.attachment();
                try {
                    if ((key.interestOps() & this.INTEREST_OP) == 0) {
                    }
                }
                catch (CancelledKeyException e) {}
                continue;
                long stall_time = now - data.last_select_success_time;
                if (stall_time < 0L) {
                    data.last_select_success_time = now;
                    continue;
                }
                if (stall_time <= 20000L) continue;
                Logger.log(new LogEvent(LOGID, 1, "Write select for " + key.channel() + " stalled for " + stall_time));
                if (key.isValid()) {
                    if (this.pause_after_select) {
                        key.interestOps(key.interestOps() & ~this.INTEREST_OP);
                    }
                    if (!this.parent.selectSuccess(data.listener, data.channel, data.attachment)) continue;
                    data.non_progress_count = 0;
                    continue;
                }
                key.cancel();
                this.parent.selectFailure(data.listener, data.channel, data.attachment, new Throwable("key is invalid"));
            }
        }
        if ((total_key_count == 0 || progress_made_key_count != total_key_count) && (time_diff = SystemTime.getCurrentTime() - select_start_time) < timeout && time_diff >= 0L) {
            try {
                Thread.sleep(timeout - time_diff);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        return count;
    }

    public void destroy() {
        this.destroyed = true;
    }

    protected void closeExistingSelector() {
        for (SelectionKey key : this.selector.keys()) {
            RegistrationData data = (RegistrationData)key.attachment();
            this.parent.selectFailure(data.listener, data.channel, data.attachment, new Throwable("selector destroyed"));
        }
        try {
            this.selector.close();
            AEDiagnostics.log("seltrace", "Selector destroyed for '" + this.parent.getName() + "'," + this.selector_guard.getType());
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    static {
        String jvm_name = System.getProperty("java.vm.name", "");
        boolean is_diablo = jvm_name.startsWith("Diablo");
        boolean is_freebsd_7_or_higher = false;
        try {
            String os_type;
            if ((Constants.isFreeBSD || Constants.isLinux) && (os_type = System.getenv("OSTYPE")) != null && os_type.equals("FreeBSD")) {
                char c;
                String os_version = System.getProperty("os.version", "");
                String digits = "";
                for (int i = 0; i < os_version.length() && Character.isDigit(c = os_version.charAt(i)); ++i) {
                    digits = digits + c;
                }
                if (digits.length() > 0) {
                    is_freebsd_7_or_higher = Integer.parseInt(digits) >= 7;
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        boolean bl = MAYBE_BROKEN_SELECT = is_freebsd_7_or_higher || is_diablo || Constants.isOSX_10_6_OrHigher;
        if (MAYBE_BROKEN_SELECT) {
            System.out.println("Enabling broken select detection: diablo=" + is_diablo + ", freebsd 7+=" + is_freebsd_7_or_higher + ", osx 10.6+=" + Constants.isOSX_10_6_OrHigher);
        }
        get_selector_allowed = new AESemaphore("getSelectorAllowed", 1);
    }

    private static class RegistrationData {
        protected final AbstractSelectableChannel channel;
        protected final VirtualChannelSelector.VirtualAbstractSelectorListener listener;
        protected final Object attachment;
        protected int non_progress_count;
        protected long last_select_success_time;

        private RegistrationData(AbstractSelectableChannel _channel, VirtualChannelSelector.VirtualAbstractSelectorListener _listener, Object _attachment) {
            this.channel = _channel;
            this.listener = _listener;
            this.attachment = _attachment;
            this.last_select_success_time = SystemTime.getCurrentTime();
        }
    }

    private static class SelectorTimeoutException
    extends IOException {
        private SelectorTimeoutException() {
            super("Selector allocation timeout");
        }
    }
}

