/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager.impl.tcp;

import com.aelitis.azureus.core.networkmanager.VirtualServerChannelSelector;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import org.gudy.azureus2.core3.logging.LogAlert;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SystemTime;

public class VirtualBlockingServerChannelSelector
implements VirtualServerChannelSelector {
    private static final LogIDs LOGID = LogIDs.NWMAN;
    private ServerSocketChannel server_channel = null;
    private final InetSocketAddress bind_address;
    private final int receive_buffer_size;
    private final VirtualServerChannelSelector.SelectListener listener;
    protected final AEMonitor this_mon = new AEMonitor("VirtualServerChannelSelector");
    private long last_accept_time;

    public VirtualBlockingServerChannelSelector(InetSocketAddress _bind_address, int so_rcvbuf_size, VirtualServerChannelSelector.SelectListener listener) {
        this.bind_address = _bind_address;
        this.receive_buffer_size = so_rcvbuf_size;
        this.listener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        block7: {
            try {
                this.this_mon.enter();
                if (this.isRunning()) break block7;
                try {
                    this.server_channel = ServerSocketChannel.open();
                    this.server_channel.socket().setReuseAddress(true);
                    if (this.receive_buffer_size > 0) {
                        this.server_channel.socket().setReceiveBufferSize(this.receive_buffer_size);
                    }
                    this.server_channel.socket().bind(this.bind_address, 1024);
                    if (Logger.isEnabled()) {
                        Logger.log(new LogEvent(LOGID, "TCP incoming server socket " + this.bind_address));
                    }
                    AEThread accept_thread = new AEThread("VServerSelector:port" + this.bind_address.getPort()){

                        @Override
                        public void runSupport() {
                            VirtualBlockingServerChannelSelector.this.accept_loop();
                        }
                    };
                    accept_thread.setDaemon(true);
                    accept_thread.start();
                }
                catch (Throwable t) {
                    Debug.out(t);
                    Logger.log(new LogAlert(false, "ERROR, unable to bind TCP incoming server socket to " + this.bind_address.getPort(), t));
                }
                this.last_accept_time = SystemTime.getCurrentTime();
            }
            finally {
                this.this_mon.exit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        try {
            this.this_mon.enter();
            if (this.server_channel != null) {
                try {
                    this.server_channel.close();
                    this.server_channel = null;
                }
                catch (Throwable t) {
                    Debug.out(t);
                }
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    protected void accept_loop() {
        while (this.isRunning()) {
            try {
                SocketChannel client_channel = this.server_channel.accept();
                this.last_accept_time = SystemTime.getCurrentTime();
                try {
                    client_channel.configureBlocking(false);
                }
                catch (IOException e) {
                    client_channel.close();
                    throw e;
                }
                this.listener.newConnectionAccepted(this.server_channel, client_channel);
            }
            catch (AsynchronousCloseException e) {
            }
            catch (Throwable t) {
                Debug.out(t);
                try {
                    Thread.sleep(500L);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @Override
    public boolean isRunning() {
        return this.server_channel != null && this.server_channel.isOpen();
    }

    @Override
    public InetAddress getBoundToAddress() {
        if (this.server_channel != null) {
            return this.server_channel.socket().getInetAddress();
        }
        return null;
    }

    @Override
    public int getPort() {
        if (this.server_channel != null) {
            return this.server_channel.socket().getLocalPort();
        }
        return -1;
    }

    @Override
    public long getTimeOfLastAccept() {
        return this.last_accept_time;
    }
}

