/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager.impl.tcp;

import com.aelitis.azureus.core.networkmanager.EventWaiter;
import com.aelitis.azureus.core.networkmanager.NetworkConnection;
import com.aelitis.azureus.core.networkmanager.ProtocolEndpoint;
import com.aelitis.azureus.core.networkmanager.Transport;
import com.aelitis.azureus.core.networkmanager.TransportEndpoint;
import com.aelitis.azureus.core.networkmanager.TransportStartpoint;
import com.aelitis.azureus.core.networkmanager.impl.TransportHelperFilter;
import com.aelitis.azureus.core.networkmanager.impl.tcp.TCPNetworkManager;
import com.aelitis.azureus.core.networkmanager.impl.tcp.TCPTransportHelper;
import com.aelitis.azureus.core.networkmanager.impl.tcp.TransportEndpointTCP;
import com.aelitis.azureus.core.networkmanager.impl.tcp.TransportStartpointTCP;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;

public class LightweightTCPTransport
implements Transport {
    private final TransportStartpointTCP transport_startpoint;
    private final TransportEndpointTCP transport_endpoint;
    private final TransportHelperFilter filter;

    public LightweightTCPTransport(ProtocolEndpoint pe, TransportHelperFilter filter2) {
        SocketChannel channel2 = ((TCPTransportHelper)filter2.getHelper()).getSocketChannel();
        this.transport_endpoint = new TransportEndpointTCP(pe, channel2);
        this.transport_startpoint = new TransportStartpointTCP(this.transport_endpoint);
        this.filter = filter2;
    }

    @Override
    public TransportEndpoint getTransportEndpoint() {
        return this.transport_endpoint;
    }

    @Override
    public TransportStartpoint getTransportStartpoint() {
        return this.transport_startpoint;
    }

    @Override
    public long write(ByteBuffer[] buffers, int array_offset, int length) throws IOException {
        return this.filter.write(buffers, array_offset, length);
    }

    @Override
    public long read(ByteBuffer[] buffers, int array_offset, int length) throws IOException {
        return this.filter.read(buffers, array_offset, length);
    }

    public SocketChannel getSocketChannel() {
        return ((TCPTransportHelper)this.filter.getHelper()).getSocketChannel();
    }

    public InetSocketAddress getRemoteAddress() {
        return new InetSocketAddress(this.getSocketChannel().socket().getInetAddress(), this.getSocketChannel().socket().getPort());
    }

    @Override
    public String getDescription() {
        return this.getSocketChannel().socket().getInetAddress().getHostAddress() + ": " + this.getSocketChannel().socket().getPort();
    }

    @Override
    public void close(String reason) {
        try {
            this.getSocketChannel().close();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    @Override
    public int getMssSize() {
        return TCPNetworkManager.getTcpMssSize();
    }

    @Override
    public void setAlreadyRead(ByteBuffer bytes_already_read) {
        throw new RuntimeException("not implemented");
    }

    @Override
    public boolean isReadyForWrite(EventWaiter waiter) {
        throw new RuntimeException("not implemented");
    }

    @Override
    public long isReadyForRead(EventWaiter waiter) {
        throw new RuntimeException("not implemented");
    }

    @Override
    public void setReadyForRead() {
        throw new RuntimeException("not implemented");
    }

    @Override
    public void connectOutbound(ByteBuffer initial_data, Transport.ConnectListener listener, int priority) {
        throw new RuntimeException("not implemented");
    }

    @Override
    public void connectedInbound() {
        throw new RuntimeException("not implemented");
    }

    @Override
    public void setTransportMode(int mode) {
        throw new RuntimeException("not implemented");
    }

    @Override
    public int getTransportMode() {
        throw new RuntimeException("not implemented");
    }

    @Override
    public void setTrace(boolean on) {
    }

    @Override
    public String getEncryption(boolean verbose) {
        return this.filter.getName(verbose);
    }

    @Override
    public boolean isEncrypted() {
        return this.filter.isEncrypted();
    }

    @Override
    public boolean isTCP() {
        return true;
    }

    @Override
    public boolean isSOCKS() {
        return false;
    }

    @Override
    public String getProtocol() {
        return "TCP";
    }

    @Override
    public void bindConnection(NetworkConnection connection) {
    }

    @Override
    public void unbindConnection(NetworkConnection connection) {
    }
}

