/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager.impl.tcp;

import com.aelitis.azureus.core.networkmanager.ConnectionEndpoint;
import com.aelitis.azureus.core.networkmanager.ProtocolEndpointFactory;
import com.aelitis.azureus.core.networkmanager.VirtualServerChannelSelector;
import com.aelitis.azureus.core.networkmanager.VirtualServerChannelSelectorFactory;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdmin;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdminPropertyChangeListener;
import com.aelitis.azureus.core.networkmanager.impl.IncomingConnectionManager;
import com.aelitis.azureus.core.networkmanager.impl.ProtocolDecoder;
import com.aelitis.azureus.core.networkmanager.impl.TransportCryptoManager;
import com.aelitis.azureus.core.networkmanager.impl.TransportHelperFilter;
import com.aelitis.azureus.core.networkmanager.impl.tcp.ProtocolEndpointTCP;
import com.aelitis.azureus.core.networkmanager.impl.tcp.TCPTransportHelper;
import com.aelitis.azureus.core.networkmanager.impl.tcp.TCPTransportImpl;
import com.aelitis.azureus.core.proxy.AEProxyAddressMapper;
import com.aelitis.azureus.core.proxy.AEProxyFactory;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Map;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.logging.LogAlert;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.RandomUtils;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;

public class IncomingSocketChannelManager {
    private static final LogIDs LOGID = LogIDs.NWMAN;
    private final String port_config_key;
    private final String port_enable_config_key;
    private int tcp_listen_port;
    private int so_rcvbuf_size = COConfigurationManager.getIntParameter("network.tcp.socket.SO_RCVBUF");
    private InetAddress[] default_bind_addresses = NetworkAdmin.getSingleton().getMultiHomedServiceBindAddresses(true);
    private InetAddress explicit_bind_address;
    private boolean explicit_bind_address_set;
    private VirtualServerChannelSelector[] serverSelectors = new VirtualServerChannelSelector[0];
    private int[] listenFailCounts = new int[0];
    final IncomingConnectionManager incoming_manager = IncomingConnectionManager.getSingleton();
    protected final AEMonitor this_mon = new AEMonitor("IncomingSocketChannelManager");
    private long last_non_local_connection_time;
    private final AEProxyAddressMapper proxy_address_mapper = AEProxyFactory.getAddressMapper();
    private final VirtualServerChannelSelector.SelectListener selectListener = new TcpSelectListener();

    public IncomingSocketChannelManager(String _port_config_key, String _port_enable_config_key) {
        this.port_config_key = _port_config_key;
        this.port_enable_config_key = _port_enable_config_key;
        this.tcp_listen_port = COConfigurationManager.getIntParameter(this.port_config_key);
        COConfigurationManager.addParameterListener(this.port_config_key, new ParameterListener(){

            @Override
            public void parameterChanged(String parameterName) {
                int port = COConfigurationManager.getIntParameter(IncomingSocketChannelManager.this.port_config_key);
                if (port != IncomingSocketChannelManager.this.tcp_listen_port) {
                    IncomingSocketChannelManager.this.tcp_listen_port = port;
                    IncomingSocketChannelManager.this.restart();
                }
            }
        });
        COConfigurationManager.addParameterListener(this.port_enable_config_key, new ParameterListener(){

            @Override
            public void parameterChanged(String parameterName) {
                IncomingSocketChannelManager.this.restart();
            }
        });
        COConfigurationManager.addParameterListener("network.tcp.socket.SO_RCVBUF", new ParameterListener(){

            @Override
            public void parameterChanged(String parameterName) {
                int size = COConfigurationManager.getIntParameter("network.tcp.socket.SO_RCVBUF");
                if (size != IncomingSocketChannelManager.this.so_rcvbuf_size) {
                    IncomingSocketChannelManager.this.so_rcvbuf_size = size;
                    IncomingSocketChannelManager.this.restart();
                }
            }
        });
        NetworkAdmin.getSingleton().addPropertyChangeListener(new NetworkAdminPropertyChangeListener(){

            @Override
            public void propertyChanged(String property) {
                Object[] addresses;
                if (property == "Default Bind IP" && !Arrays.equals(addresses = NetworkAdmin.getSingleton().getMultiHomedServiceBindAddresses(true), IncomingSocketChannelManager.this.default_bind_addresses)) {
                    IncomingSocketChannelManager.access$402(IncomingSocketChannelManager.this, (InetAddress[])addresses);
                    IncomingSocketChannelManager.this.restart();
                }
            }
        });
        this.start();
        SimpleTimer.addPeriodicEvent("IncomingSocketChannelManager:concheck", 60000L, new TimerEventPerformer(){

            @Override
            public void perform(TimerEvent ev) {
                COConfigurationManager.setParameter("network.tcp.port." + IncomingSocketChannelManager.this.tcp_listen_port + ".last.nonlocal.incoming", IncomingSocketChannelManager.this.last_non_local_connection_time);
                for (int i = 0; i < IncomingSocketChannelManager.this.serverSelectors.length; ++i) {
                    VirtualServerChannelSelector server_selector = IncomingSocketChannelManager.this.serverSelectors[i];
                    if (server_selector == null || !server_selector.isRunning()) continue;
                    long accept_idle = SystemTime.getCurrentTime() - server_selector.getTimeOfLastAccept();
                    if (accept_idle > 600000L) {
                        InetAddress inet_address = server_selector.getBoundToAddress();
                        try {
                            if (inet_address == null) {
                                inet_address = InetAddress.getByName("127.0.0.1");
                            }
                            Socket sock = new Socket(inet_address, IncomingSocketChannelManager.this.tcp_listen_port, inet_address, 0);
                            sock.close();
                            ((IncomingSocketChannelManager)IncomingSocketChannelManager.this).listenFailCounts[i] = 0;
                        }
                        catch (Throwable t) {
                            try {
                                Socket sock = new Socket(InetAddress.getByName("127.0.0.1"), IncomingSocketChannelManager.this.tcp_listen_port);
                                sock.close();
                                ((IncomingSocketChannelManager)IncomingSocketChannelManager.this).listenFailCounts[i] = 0;
                            }
                            catch (Throwable x) {
                                int[] nArray = IncomingSocketChannelManager.this.listenFailCounts;
                                int n = i;
                                nArray[n] = nArray[n] + 1;
                                Debug.out(new Date() + ": listen port on [" + inet_address + ": " + IncomingSocketChannelManager.this.tcp_listen_port + "] seems CLOSED [" + IncomingSocketChannelManager.this.listenFailCounts[i] + "x]");
                                if (IncomingSocketChannelManager.this.listenFailCounts[i] <= 4) continue;
                                String error = t.getMessage() == null ? "<null>" : t.getMessage();
                                String msg = "Listen server socket on [" + inet_address + ": " + IncomingSocketChannelManager.this.tcp_listen_port + "] does not appear to be accepting inbound connections.\n[" + error + "]\nAuto-repairing listen service....\n";
                                Logger.log(new LogAlert(false, 1, msg));
                                IncomingSocketChannelManager.this.restart();
                                ((IncomingSocketChannelManager)IncomingSocketChannelManager.this).listenFailCounts[i] = 0;
                            }
                        }
                        continue;
                    }
                    ((IncomingSocketChannelManager)IncomingSocketChannelManager.this).listenFailCounts[i] = 0;
                }
            }
        });
    }

    public boolean isEnabled() {
        return COConfigurationManager.getBooleanParameter(this.port_enable_config_key);
    }

    public int getTCPListeningPortNumber() {
        return this.tcp_listen_port;
    }

    public void setExplicitBindAddress(InetAddress address) {
        this.explicit_bind_address = address;
        this.explicit_bind_address_set = true;
        this.restart();
    }

    public void clearExplicitBindAddress() {
        this.explicit_bind_address = null;
        this.explicit_bind_address_set = false;
        this.restart();
    }

    protected InetAddress[] getEffectiveBindAddresses() {
        if (this.explicit_bind_address_set) {
            return new InetAddress[]{this.explicit_bind_address};
        }
        return this.default_bind_addresses;
    }

    public boolean isEffectiveBindAddress(InetAddress address) {
        InetAddress[] effective = this.getEffectiveBindAddresses();
        return Arrays.asList(effective).contains(address);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void start() {
        try {
            this.this_mon.enter();
            if (this.tcp_listen_port < 0 || this.tcp_listen_port > 65535 || this.tcp_listen_port == Constants.INSTANCE_PORT) {
                String msg = "Invalid incoming TCP listen port configured, " + this.tcp_listen_port + ". Port reset to default. Please check your config!";
                Debug.out(msg);
                Logger.log(new LogAlert(false, 3, msg));
                this.tcp_listen_port = RandomUtils.generateRandomNetworkListenPort();
                COConfigurationManager.setParameter(this.port_config_key, this.tcp_listen_port);
            }
            if (COConfigurationManager.getBooleanParameter(this.port_enable_config_key)) {
                this.last_non_local_connection_time = COConfigurationManager.getLongParameter("network.tcp.port." + this.tcp_listen_port + ".last.nonlocal.incoming", 0L);
                if (this.last_non_local_connection_time > SystemTime.getCurrentTime()) {
                    this.last_non_local_connection_time = SystemTime.getCurrentTime();
                }
                if (this.serverSelectors.length == 0) {
                    InetAddress[] bindAddresses = this.getEffectiveBindAddresses();
                    ArrayList<VirtualServerChannelSelector> tempSelectors = new ArrayList<VirtualServerChannelSelector>(bindAddresses.length);
                    this.listenFailCounts = new int[bindAddresses.length];
                    for (int i = 0; i < bindAddresses.length; ++i) {
                        InetAddress bindAddress = bindAddresses[i];
                        if (!NetworkAdmin.getSingleton().hasIPV6Potential(true) && bindAddress instanceof Inet6Address) continue;
                        InetSocketAddress address = bindAddress != null ? new InetSocketAddress(bindAddress, this.tcp_listen_port) : new InetSocketAddress(this.tcp_listen_port);
                        VirtualServerChannelSelector serverSelector = bindAddresses.length == 1 ? VirtualServerChannelSelectorFactory.createBlocking(address, this.so_rcvbuf_size, this.selectListener) : VirtualServerChannelSelectorFactory.createNonBlocking(address, this.so_rcvbuf_size, this.selectListener);
                        serverSelector.start();
                        tempSelectors.add(serverSelector);
                    }
                    if (tempSelectors.size() == 0) {
                        Logger.log(new LogAlert(true, 1, MessageText.getString("network.bindError")));
                    }
                    this.serverSelectors = tempSelectors.toArray(new VirtualServerChannelSelector[tempSelectors.size()]);
                }
            } else {
                Logger.log(new LogEvent(LOGID, "Not starting TCP listener on port " + this.tcp_listen_port + " as protocol disabled"));
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    protected void process(int local_port, TransportHelperFilter filter2) {
        SocketChannel channel2 = ((TCPTransportHelper)filter2.getHelper()).getSocketChannel();
        Socket socket = channel2.socket();
        try {
            String ip_tos;
            int so_sndbuf_size = COConfigurationManager.getIntParameter("network.tcp.socket.SO_SNDBUF");
            if (so_sndbuf_size > 0) {
                socket.setSendBufferSize(so_sndbuf_size);
            }
            if ((ip_tos = COConfigurationManager.getStringParameter("network.tcp.socket.IPDiffServ")).length() > 0) {
                socket.setTrafficClass(Integer.decode(ip_tos));
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        AEProxyAddressMapper.AppliedPortMapping applied_mapping = this.proxy_address_mapper.applyPortMapping(socket.getInetAddress(), socket.getPort());
        InetSocketAddress tcp_address = applied_mapping.getAddress();
        ConnectionEndpoint co_ep = new ConnectionEndpoint(tcp_address);
        Map<String, Object> properties = applied_mapping.getProperties();
        if (properties != null) {
            co_ep.addProperties(properties);
        }
        ProtocolEndpointTCP pe_tcp = (ProtocolEndpointTCP)ProtocolEndpointFactory.createEndpoint(1, co_ep, tcp_address);
        TCPTransportImpl transport = new TCPTransportImpl(pe_tcp, filter2);
        this.incoming_manager.addConnection(local_port, filter2, transport);
    }

    protected long getLastNonLocalConnectionTime() {
        return this.last_non_local_connection_time;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restart() {
        try {
            this.this_mon.enter();
            for (int i = 0; i < this.serverSelectors.length; ++i) {
                this.serverSelectors[i].stop();
            }
            this.serverSelectors = new VirtualServerChannelSelector[0];
        }
        finally {
            this.this_mon.exit();
        }
        try {
            Thread.sleep(1000L);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        this.start();
    }

    static /* synthetic */ InetAddress[] access$402(IncomingSocketChannelManager x0, InetAddress[] x1) {
        x0.default_bind_addresses = x1;
        return x1;
    }

    private final class TcpSelectListener
    implements VirtualServerChannelSelector.SelectListener {
        private TcpSelectListener() {
        }

        @Override
        public void newConnectionAccepted(final ServerSocketChannel server, SocketChannel channel2) {
            InetAddress remote_ia = channel2.socket().getInetAddress();
            if (!(remote_ia.isLoopbackAddress() || remote_ia.isLinkLocalAddress() || remote_ia.isSiteLocalAddress())) {
                IncomingSocketChannelManager.this.last_non_local_connection_time = SystemTime.getCurrentTime();
            }
            final TCPTransportHelper helper = new TCPTransportHelper(channel2);
            TransportCryptoManager.getSingleton().manageCrypto(helper, null, true, null, new TransportCryptoManager.HandshakeListener(){

                @Override
                public void handshakeSuccess(ProtocolDecoder decoder, ByteBuffer remaining_initial_data) {
                    IncomingSocketChannelManager.this.process(server.socket().getLocalPort(), decoder.getFilter());
                }

                @Override
                public void handshakeFailure(Throwable failure_msg) {
                    if (Logger.isEnabled()) {
                        Logger.log(new LogEvent(LOGID, "incoming crypto handshake failure: " + Debug.getNestedExceptionMessage(failure_msg)));
                    }
                    helper.close("Handshake failure: " + Debug.getNestedExceptionMessage(failure_msg));
                }

                @Override
                public void gotSecret(byte[] session_secret) {
                }

                @Override
                public int getMaximumPlainHeaderLength() {
                    return IncomingSocketChannelManager.this.incoming_manager.getMaxMinMatchBufferSize();
                }

                @Override
                public int matchPlainHeader(ByteBuffer buffer) {
                    Object[] match_data = IncomingSocketChannelManager.this.incoming_manager.checkForMatch(helper, server.socket().getLocalPort(), buffer, true);
                    if (match_data == null) {
                        return 1;
                    }
                    IncomingConnectionManager.MatchListener match = (IncomingConnectionManager.MatchListener)match_data[0];
                    if (match.autoCryptoFallback()) {
                        return 3;
                    }
                    return 2;
                }
            });
        }
    }
}

