/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager.impl;

import com.aelitis.azureus.core.networkmanager.EventWaiter;
import com.aelitis.azureus.core.networkmanager.NetworkConnection;
import com.aelitis.azureus.core.networkmanager.Transport;
import com.aelitis.azureus.core.networkmanager.TransportStartpoint;
import com.aelitis.azureus.core.networkmanager.impl.TransportHelper;
import com.aelitis.azureus.core.networkmanager.impl.TransportHelperFilter;
import com.aelitis.azureus.core.networkmanager.impl.TransportStats;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimeFormatter;

public abstract class TransportImpl
implements Transport {
    private TransportHelperFilter filter;
    private static final TransportStats stats = null;
    private ByteBuffer data_already_read = null;
    private volatile EventWaiter read_waiter;
    private volatile EventWaiter write_waiter;
    private volatile boolean is_ready_for_write = false;
    private volatile boolean is_ready_for_read = false;
    private Throwable write_select_failure = null;
    private Throwable read_select_failure = null;
    private long last_ready_for_read = SystemTime.getSteppedMonotonousTime();
    private boolean trace;

    protected TransportImpl() {
    }

    @Override
    public TransportStartpoint getTransportStartpoint() {
        return null;
    }

    public void setFilter(TransportHelperFilter _filter) {
        this.filter = _filter;
        if (this.trace && _filter != null) {
            _filter.setTrace(true);
        }
    }

    public TransportHelperFilter getFilter() {
        return this.filter;
    }

    @Override
    public void setAlreadyRead(ByteBuffer bytes_already_read) {
        if (bytes_already_read != null && bytes_already_read.hasRemaining()) {
            if (this.data_already_read != null) {
                ByteBuffer new_bb = ByteBuffer.allocate(this.data_already_read.remaining() + bytes_already_read.remaining());
                new_bb.put(bytes_already_read);
                new_bb.put(this.data_already_read);
                new_bb.position(0);
                this.data_already_read = new_bb;
            } else {
                this.data_already_read = bytes_already_read;
            }
            this.is_ready_for_read = true;
        }
    }

    @Override
    public String getEncryption(boolean verbose) {
        return this.filter == null ? "" : this.filter.getName(verbose);
    }

    @Override
    public String getProtocol() {
        String s = this.getEncryption(false);
        int pos = s.indexOf(40);
        if (pos != -1 && (pos = (s = s.substring(pos + 1)).indexOf(41)) > 0) {
            return s.substring(0, pos);
        }
        return "";
    }

    @Override
    public boolean isEncrypted() {
        return this.filter == null ? false : this.filter.isEncrypted();
    }

    @Override
    public boolean isSOCKS() {
        return false;
    }

    @Override
    public boolean isReadyForWrite(EventWaiter waiter) {
        if (waiter != null) {
            this.write_waiter = waiter;
        }
        return this.is_ready_for_write;
    }

    protected boolean readyForWrite(boolean ready) {
        if (this.trace) {
            TimeFormatter.milliTrace("trans: readyForWrite -> " + ready);
        }
        if (ready) {
            boolean progress = !this.is_ready_for_write;
            this.is_ready_for_write = true;
            EventWaiter ww = this.write_waiter;
            if (ww != null) {
                ww.eventOccurred();
            }
            return progress;
        }
        this.is_ready_for_write = false;
        return false;
    }

    protected void writeFailed(Throwable msg) {
        msg.fillInStackTrace();
        this.write_select_failure = msg;
        this.is_ready_for_write = true;
    }

    @Override
    public long isReadyForRead(EventWaiter waiter) {
        if (waiter != null) {
            this.read_waiter = waiter;
        }
        boolean ready = this.is_ready_for_read || this.data_already_read != null || this.filter != null && this.filter.hasBufferedRead();
        long now = SystemTime.getSteppedMonotonousTime();
        if (ready) {
            this.last_ready_for_read = now;
            return 0L;
        }
        long diff = now - this.last_ready_for_read + 1L;
        return diff;
    }

    protected boolean readyForRead(boolean ready) {
        if (ready) {
            boolean progress = !this.is_ready_for_read;
            this.is_ready_for_read = true;
            EventWaiter rw = this.read_waiter;
            if (rw != null) {
                rw.eventOccurred();
            }
            return progress;
        }
        this.is_ready_for_read = false;
        return false;
    }

    @Override
    public void setReadyForRead() {
        this.readyForRead(true);
    }

    protected void readFailed(Throwable msg) {
        msg.fillInStackTrace();
        this.read_select_failure = msg;
        this.is_ready_for_read = true;
    }

    @Override
    public long write(ByteBuffer[] buffers, int array_offset, int length) throws IOException {
        if (this.write_select_failure != null) {
            throw new IOException("write_select_failure: " + this.write_select_failure.getMessage());
        }
        if (this.filter == null) {
            return 0L;
        }
        long written = this.filter.write(buffers, array_offset, length);
        if (stats != null) {
            stats.bytesWritten((int)written);
        }
        if (written < 1L) {
            this.requestWriteSelect();
        }
        return written;
    }

    @Override
    public long read(ByteBuffer[] buffers, int array_offset, int length) throws IOException {
        if (this.read_select_failure != null) {
            throw new IOException("read_select_failure: " + this.read_select_failure.getMessage());
        }
        if (this.data_already_read != null) {
            int inserted = 0;
            for (int i = array_offset; i < array_offset + length; ++i) {
                ByteBuffer bb = buffers[i];
                int orig_limit = this.data_already_read.limit();
                if (this.data_already_read.remaining() > bb.remaining()) {
                    this.data_already_read.limit(this.data_already_read.position() + bb.remaining());
                }
                inserted += this.data_already_read.remaining();
                bb.put(this.data_already_read);
                this.data_already_read.limit(orig_limit);
                if (this.data_already_read.hasRemaining()) continue;
                this.data_already_read = null;
                break;
            }
            if (!buffers[array_offset + length - 1].hasRemaining()) {
                return inserted;
            }
        }
        if (this.filter == null) {
            throw new IOException("Transport not ready");
        }
        long bytes_read = this.filter.read(buffers, array_offset, length);
        if (stats != null) {
            stats.bytesRead((int)bytes_read);
        }
        if (bytes_read == 0L) {
            this.requestReadSelect();
        }
        return bytes_read;
    }

    private void requestWriteSelect() {
        this.is_ready_for_write = false;
        if (this.filter != null) {
            this.filter.getHelper().resumeWriteSelects();
        }
    }

    private void requestReadSelect() {
        this.is_ready_for_read = false;
        if (this.filter != null) {
            this.filter.getHelper().resumeReadSelects();
        }
    }

    @Override
    public void connectedInbound() {
        this.registerSelectHandling();
    }

    public void connectedOutbound() {
        this.registerSelectHandling();
    }

    @Override
    public void bindConnection(NetworkConnection connection) {
    }

    @Override
    public void unbindConnection(NetworkConnection connection) {
    }

    private void registerSelectHandling() {
        TransportHelperFilter filter2 = this.getFilter();
        if (filter2 == null) {
            Debug.out("ERROR: registerSelectHandling():: filter == null");
            return;
        }
        TransportHelper helper = filter2.getHelper();
        helper.registerForReadSelects(new TransportHelper.selectListener(){

            @Override
            public boolean selectSuccess(TransportHelper helper, Object attachment) {
                return TransportImpl.this.readyForRead(true);
            }

            @Override
            public void selectFailure(TransportHelper helper, Object attachment, Throwable msg) {
                TransportImpl.this.readFailed(msg);
            }
        }, null);
        helper.registerForWriteSelects(new TransportHelper.selectListener(){

            @Override
            public boolean selectSuccess(TransportHelper helper, Object attachment) {
                return TransportImpl.this.readyForWrite(true);
            }

            @Override
            public void selectFailure(TransportHelper helper, Object attachment, Throwable msg) {
                TransportImpl.this.writeFailed(msg);
            }
        }, null);
    }

    @Override
    public void setTrace(boolean on) {
        this.trace = on;
        TransportHelperFilter filter2 = this.getFilter();
        if (filter2 != null) {
            filter2.setTrace(on);
        }
    }
}

