/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager.impl;

import com.aelitis.azureus.core.networkmanager.EventWaiter;
import com.aelitis.azureus.core.networkmanager.NetworkConnectionBase;
import com.aelitis.azureus.core.networkmanager.RateHandler;
import com.aelitis.azureus.core.networkmanager.impl.RateControlledEntity;
import com.aelitis.azureus.core.peermanager.messaging.Message;
import java.io.IOException;
import org.gudy.azureus2.core3.util.Debug;

public class SinglePeerUploader
implements RateControlledEntity {
    private final NetworkConnectionBase connection;
    private final RateHandler rate_handler;

    public SinglePeerUploader(NetworkConnectionBase connection, RateHandler rate_handler) {
        this.connection = connection;
        this.rate_handler = rate_handler;
    }

    @Override
    public RateHandler getRateHandler() {
        return this.rate_handler;
    }

    @Override
    public boolean canProcess(EventWaiter waiter) {
        if (!this.connection.getTransportBase().isReadyForWrite(waiter)) {
            return false;
        }
        if (this.connection.getOutgoingMessageQueue().getTotalSize() < 1) {
            return false;
        }
        int[] allowed = this.rate_handler.getCurrentNumBytesAllowed();
        if (allowed[0] < 1) {
            boolean protocol_is_free;
            boolean bl = protocol_is_free = allowed[1] > 0;
            if (protocol_is_free) {
                Message first = this.connection.getOutgoingMessageQueue().peekFirstMessage();
                return first != null && first.getType() == 0;
            }
            return false;
        }
        return true;
    }

    @Override
    public int doProcessing(EventWaiter waiter, int max_bytes) {
        int[] written2;
        int num_bytes_available;
        boolean protocol_is_free;
        if (!this.connection.getTransportBase().isReadyForWrite(waiter)) {
            return 0;
        }
        int[] allowed = this.rate_handler.getCurrentNumBytesAllowed();
        int num_bytes_allowed = allowed[0];
        boolean bl = protocol_is_free = allowed[1] > 0;
        if (num_bytes_allowed < 1) {
            if (protocol_is_free) {
                num_bytes_allowed = 0;
            } else {
                return 0;
            }
        }
        if (max_bytes > 0 && max_bytes < num_bytes_allowed) {
            num_bytes_allowed = max_bytes;
        }
        if ((num_bytes_available = this.connection.getOutgoingMessageQueue().getTotalSize()) < 1) {
            if (!this.connection.getOutgoingMessageQueue().isDestroyed()) {
                // empty if block
            }
            return 0;
        }
        int num_bytes_to_write = num_bytes_allowed > num_bytes_available ? num_bytes_available : num_bytes_allowed;
        try {
            written2 = this.connection.getOutgoingMessageQueue().deliverToTransport(num_bytes_to_write, protocol_is_free, false);
        }
        catch (Throwable e) {
            int[] written2 = new int[2];
            if (!(e instanceof IOException)) {
                Debug.printStackTrace(e);
            }
            this.connection.notifyOfException(e);
            return 0;
        }
        int data_bytes_written = written2[0];
        int protocol_bytes_written = written2[1];
        int total_written = data_bytes_written + protocol_bytes_written;
        if (total_written < 1) {
            return 0;
        }
        this.rate_handler.bytesProcessed(data_bytes_written, protocol_bytes_written);
        return total_written;
    }

    @Override
    public int getPriority() {
        return 0;
    }

    @Override
    public boolean getPriorityBoost() {
        return this.connection.getOutgoingMessageQueue().getPriorityBoost();
    }

    @Override
    public long getBytesReadyToWrite() {
        return this.connection.getOutgoingMessageQueue().getTotalSize();
    }

    @Override
    public int getConnectionCount(EventWaiter waiter) {
        return 1;
    }

    @Override
    public int getReadyConnectionCount(EventWaiter waiter) {
        if (this.connection.getTransportBase().isReadyForWrite(waiter)) {
            return 1;
        }
        return 0;
    }

    @Override
    public String getString() {
        return "SPU: bytes_allowed=" + this.rate_handler.getCurrentNumBytesAllowed() + " " + this.connection.getString();
    }
}

