/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager.impl;

import com.aelitis.azureus.core.networkmanager.ConnectionAttempt;
import com.aelitis.azureus.core.networkmanager.ConnectionEndpoint;
import com.aelitis.azureus.core.networkmanager.EventWaiter;
import com.aelitis.azureus.core.networkmanager.IncomingMessageQueue;
import com.aelitis.azureus.core.networkmanager.NetworkConnection;
import com.aelitis.azureus.core.networkmanager.NetworkConnectionHelper;
import com.aelitis.azureus.core.networkmanager.NetworkManager;
import com.aelitis.azureus.core.networkmanager.OutgoingMessageQueue;
import com.aelitis.azureus.core.networkmanager.Transport;
import com.aelitis.azureus.core.networkmanager.TransportBase;
import com.aelitis.azureus.core.networkmanager.TransportEndpoint;
import com.aelitis.azureus.core.networkmanager.TransportStartpoint;
import com.aelitis.azureus.core.networkmanager.impl.IncomingMessageQueueImpl;
import com.aelitis.azureus.core.networkmanager.impl.OutgoingMessageQueueImpl;
import com.aelitis.azureus.core.peermanager.messaging.MessageStreamDecoder;
import com.aelitis.azureus.core.peermanager.messaging.MessageStreamEncoder;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Map;
import org.gudy.azureus2.core3.util.AddressUtils;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.LightHashMap;

public class NetworkConnectionImpl
extends NetworkConnectionHelper
implements NetworkConnection {
    private final ConnectionEndpoint connection_endpoint;
    private final boolean is_incoming;
    private boolean connect_with_crypto;
    private boolean allow_fallback;
    private byte[][] shared_secrets;
    private NetworkConnection.ConnectionListener connection_listener;
    private boolean is_connected;
    private byte is_lan_local = 0;
    private final OutgoingMessageQueueImpl outgoing_message_queue;
    private final IncomingMessageQueueImpl incoming_message_queue;
    private Transport transport;
    private volatile ConnectionAttempt connection_attempt;
    private volatile boolean closed;
    private Map<Object, Object> user_data;

    public NetworkConnectionImpl(ConnectionEndpoint _target, MessageStreamEncoder encoder, MessageStreamDecoder decoder, boolean _connect_with_crypto, boolean _allow_fallback, byte[][] _shared_secrets) {
        this.connection_endpoint = _target;
        this.is_incoming = false;
        this.connect_with_crypto = _connect_with_crypto;
        this.allow_fallback = _allow_fallback;
        this.shared_secrets = _shared_secrets;
        this.is_connected = false;
        this.outgoing_message_queue = new OutgoingMessageQueueImpl(encoder);
        this.incoming_message_queue = new IncomingMessageQueueImpl(decoder, this);
    }

    public NetworkConnectionImpl(Transport _transport, MessageStreamEncoder encoder, MessageStreamDecoder decoder) {
        this.transport = _transport;
        this.connection_endpoint = this.transport.getTransportEndpoint().getProtocolEndpoint().getConnectionEndpoint();
        this.is_incoming = true;
        this.is_connected = true;
        this.outgoing_message_queue = new OutgoingMessageQueueImpl(encoder);
        this.outgoing_message_queue.setTransport(this.transport);
        this.incoming_message_queue = new IncomingMessageQueueImpl(decoder, this);
        this.transport.bindConnection(this);
    }

    @Override
    public ConnectionEndpoint getEndpoint() {
        return this.connection_endpoint;
    }

    @Override
    public boolean isIncoming() {
        return this.is_incoming;
    }

    @Override
    public void connect(int priority, NetworkConnection.ConnectionListener listener) {
        this.connect(null, priority, listener);
    }

    @Override
    public void connect(ByteBuffer initial_outbound_data, int priority, NetworkConnection.ConnectionListener listener) {
        ConnectionAttempt ca;
        this.connection_listener = listener;
        if (this.is_connected) {
            this.connection_listener.connectStarted(-1);
            this.connection_listener.connectSuccess(initial_outbound_data);
            return;
        }
        if (this.connection_attempt != null) {
            Debug.out("Connection attempt already active");
            listener.connectFailure(new Throwable("Connection attempt already active"));
            return;
        }
        this.connection_attempt = this.connection_endpoint.connectOutbound(this.connect_with_crypto, this.allow_fallback, this.shared_secrets, initial_outbound_data, priority, new Transport.ConnectListener(){

            @Override
            public int connectAttemptStarted(int default_connect_timeout) {
                return NetworkConnectionImpl.this.connection_listener.connectStarted(default_connect_timeout);
            }

            @Override
            public void connectSuccess(Transport _transport, ByteBuffer remaining_initial_data) {
                NetworkConnectionImpl.this.is_connected = true;
                NetworkConnectionImpl.this.transport = _transport;
                NetworkConnectionImpl.this.outgoing_message_queue.setTransport(NetworkConnectionImpl.this.transport);
                NetworkConnectionImpl.this.transport.bindConnection(NetworkConnectionImpl.this);
                NetworkConnectionImpl.this.connection_listener.connectSuccess(remaining_initial_data);
                NetworkConnectionImpl.this.connection_attempt = null;
            }

            @Override
            public void connectFailure(Throwable failure_msg) {
                NetworkConnectionImpl.this.is_connected = false;
                NetworkConnectionImpl.this.connection_listener.connectFailure(failure_msg);
            }

            @Override
            public Object getConnectionProperty(String property_name) {
                return NetworkConnectionImpl.this.connection_listener.getConnectionProperty(property_name);
            }
        });
        if (this.closed && (ca = this.connection_attempt) != null) {
            ca.abandon();
        }
    }

    @Override
    public Transport detachTransport() {
        Transport t = this.transport;
        if (t != null) {
            t.unbindConnection(this);
        }
        this.transport = new bogusTransport(this.transport);
        this.close("detached transport");
        return t;
    }

    @Override
    public void close(String reason) {
        NetworkManager.getSingleton().stopTransferProcessing(this);
        this.closed = true;
        if (this.connection_attempt != null) {
            this.connection_attempt.abandon();
        }
        if (this.transport != null) {
            this.transport.close("Tidy close" + (reason == null || reason.length() == 0 ? "" : ": " + reason));
        }
        this.incoming_message_queue.destroy();
        this.outgoing_message_queue.destroy();
        this.is_connected = false;
    }

    @Override
    public void notifyOfException(Throwable error) {
        if (this.connection_listener != null) {
            this.connection_listener.exceptionThrown(error);
        } else {
            Debug.out("notifyOfException():: connection_listener == null for exception: " + error.getMessage());
        }
    }

    @Override
    public OutgoingMessageQueue getOutgoingMessageQueue() {
        return this.outgoing_message_queue;
    }

    @Override
    public IncomingMessageQueue getIncomingMessageQueue() {
        return this.incoming_message_queue;
    }

    @Override
    public void startMessageProcessing() {
        NetworkManager.getSingleton().startTransferProcessing(this);
    }

    @Override
    public void enableEnhancedMessageProcessing(boolean enable, int partition_id) {
        if (enable) {
            NetworkManager.getSingleton().upgradeTransferProcessing(this, partition_id);
        } else {
            NetworkManager.getSingleton().downgradeTransferProcessing(this);
        }
    }

    @Override
    public Transport getTransport() {
        return this.transport;
    }

    @Override
    public TransportBase getTransportBase() {
        return this.transport;
    }

    @Override
    public int getMssSize() {
        if (this.transport == null) {
            return NetworkManager.getMinMssSize();
        }
        return this.transport.getMssSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object setUserData(Object key, Object value) {
        NetworkConnectionImpl networkConnectionImpl = this;
        synchronized (networkConnectionImpl) {
            if (this.user_data == null) {
                this.user_data = new LightHashMap<Object, Object>();
            }
            return this.user_data.put(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getUserData(Object key) {
        NetworkConnectionImpl networkConnectionImpl = this;
        synchronized (networkConnectionImpl) {
            if (this.user_data == null) {
                return null;
            }
            return this.user_data.get(key);
        }
    }

    public String toString() {
        return this.transport == null ? this.connection_endpoint.getDescription() : this.transport.getDescription();
    }

    @Override
    public boolean isConnected() {
        return this.is_connected;
    }

    @Override
    public boolean isLANLocal() {
        if (this.is_lan_local == 0) {
            this.is_lan_local = AddressUtils.isLANLocalAddress(this.connection_endpoint.getNotionalAddress());
        }
        return this.is_lan_local == 1;
    }

    @Override
    public String getString() {
        return "tran=" + (this.transport == null ? "null" : this.transport.getDescription() + ",w_ready=" + this.transport.isReadyForWrite(null) + ",r_ready=" + this.transport.isReadyForRead(null)) + ",in=" + this.incoming_message_queue.getPercentDoneOfCurrentMessage() + ",out=" + (this.outgoing_message_queue == null ? 0 : this.outgoing_message_queue.getTotalSize()) + ",owner=" + (this.connection_listener == null ? "null" : this.connection_listener.getDescription());
    }

    protected static class bogusTransport
    implements Transport {
        private final Transport transport;

        protected bogusTransport(Transport _transport) {
            this.transport = _transport;
        }

        @Override
        public boolean isReadyForWrite(EventWaiter waiter) {
            return false;
        }

        @Override
        public long isReadyForRead(EventWaiter waiter) {
            return Long.MAX_VALUE;
        }

        @Override
        public boolean isTCP() {
            return this.transport.isTCP();
        }

        @Override
        public boolean isSOCKS() {
            return this.transport.isSOCKS();
        }

        @Override
        public String getDescription() {
            return this.transport.getDescription();
        }

        @Override
        public int getMssSize() {
            return this.transport.getMssSize();
        }

        @Override
        public void setAlreadyRead(ByteBuffer bytes_already_read) {
            Debug.out("Bogus Transport Operation");
        }

        @Override
        public TransportEndpoint getTransportEndpoint() {
            return this.transport.getTransportEndpoint();
        }

        @Override
        public TransportStartpoint getTransportStartpoint() {
            return this.transport.getTransportStartpoint();
        }

        @Override
        public boolean isEncrypted() {
            return this.transport.isEncrypted();
        }

        @Override
        public String getEncryption(boolean verbose) {
            return this.transport.getEncryption(verbose);
        }

        @Override
        public String getProtocol() {
            return this.transport.getProtocol();
        }

        @Override
        public void setReadyForRead() {
            Debug.out("Bogus Transport Operation");
        }

        @Override
        public long write(ByteBuffer[] buffers, int array_offset, int length) throws IOException {
            Debug.out("Bogus Transport Operation");
            throw new IOException("Bogus transport!");
        }

        @Override
        public long read(ByteBuffer[] buffers, int array_offset, int length) throws IOException {
            Debug.out("Bogus Transport Operation");
            throw new IOException("Bogus transport!");
        }

        @Override
        public void setTransportMode(int mode) {
            Debug.out("Bogus Transport Operation");
        }

        @Override
        public int getTransportMode() {
            return this.transport.getTransportMode();
        }

        @Override
        public void connectOutbound(ByteBuffer initial_data, Transport.ConnectListener listener, int priority) {
            Debug.out("Bogus Transport Operation");
            listener.connectFailure(new Throwable("Bogus Transport"));
        }

        @Override
        public void connectedInbound() {
            Debug.out("Bogus Transport Operation");
        }

        @Override
        public void close(String reason) {
        }

        @Override
        public void bindConnection(NetworkConnection connection) {
        }

        @Override
        public void unbindConnection(NetworkConnection connection) {
        }

        @Override
        public void setTrace(boolean on) {
        }
    }
}

