/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager.impl;

import com.aelitis.azureus.core.networkmanager.EventWaiter;
import com.aelitis.azureus.core.networkmanager.NetworkConnectionBase;
import com.aelitis.azureus.core.networkmanager.OutgoingMessageQueue;
import com.aelitis.azureus.core.networkmanager.RateHandler;
import com.aelitis.azureus.core.networkmanager.impl.RateControlledEntity;
import com.aelitis.azureus.core.peermanager.messaging.Message;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SystemTime;

public class MultiPeerUploader
implements RateControlledEntity {
    private static final int FLUSH_CHECK_LOOP_TIME = 500;
    private static final int FLUSH_WAIT_TIME = 3000;
    private long last_flush_check_time = 0L;
    private final RateHandler rate_handler;
    private boolean destroyed = false;
    private final HashMap waiting_connections = new HashMap();
    private final LinkedList ready_connections = new LinkedList();
    private final AEMonitor lists_lock = new AEMonitor("PacketFillingMultiPeerUploader:lists_lock");
    private volatile EventWaiter waiter;

    public MultiPeerUploader(RateHandler rate_handler) {
        this.rate_handler = rate_handler;
    }

    @Override
    public RateHandler getRateHandler() {
        return this.rate_handler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushCheck() {
        long diff = SystemTime.getCurrentTime() - this.last_flush_check_time;
        if (!(this.destroyed || diff <= 500L && diff >= 0L)) {
            try {
                this.lists_lock.enter();
                long current_time = SystemTime.getCurrentTime();
                Iterator i = this.waiting_connections.entrySet().iterator();
                while (i.hasNext()) {
                    Map.Entry entry = i.next();
                    PeerData peer_data = (PeerData)entry.getValue();
                    long wait_time = current_time - peer_data.last_message_added_time;
                    if (wait_time <= 3000L && wait_time >= 0L) continue;
                    NetworkConnectionBase conn = (NetworkConnectionBase)entry.getKey();
                    if (conn.getOutgoingMessageQueue().getTotalSize() > 0) {
                        conn.getOutgoingMessageQueue().cancelQueueListener(peer_data.queue_listener);
                        i.remove();
                        this.addToReadyList(conn);
                        continue;
                    }
                    peer_data.last_message_added_time = current_time;
                }
            }
            finally {
                this.lists_lock.exit();
            }
            this.last_flush_check_time = SystemTime.getCurrentTime();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        this.destroyed = true;
        try {
            this.lists_lock.enter();
            for (Map.Entry entry : this.waiting_connections.entrySet()) {
                NetworkConnectionBase conn = (NetworkConnectionBase)entry.getKey();
                PeerData data = (PeerData)entry.getValue();
                conn.getOutgoingMessageQueue().cancelQueueListener(data.queue_listener);
            }
            this.waiting_connections.clear();
            this.ready_connections.clear();
        }
        finally {
            this.lists_lock.exit();
        }
    }

    public void addPeerConnection(NetworkConnectionBase peer_connection) {
        int mss_size = peer_connection.getMssSize();
        boolean has_urgent_data = peer_connection.getOutgoingMessageQueue().hasUrgentMessage();
        int num_bytes_ready = peer_connection.getOutgoingMessageQueue().getTotalSize();
        if (num_bytes_ready >= mss_size || has_urgent_data) {
            this.addToReadyList(peer_connection);
        } else {
            this.addToWaitingList(peer_connection);
        }
        EventWaiter waiter_to_kick = this.waiter;
        if (waiter_to_kick != null) {
            this.waiter = null;
            waiter_to_kick.eventOccurred();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removePeerConnection(NetworkConnectionBase peer_connection) {
        try {
            this.lists_lock.enter();
            PeerData peer_data = (PeerData)this.waiting_connections.remove(peer_connection);
            if (peer_data != null) {
                peer_connection.getOutgoingMessageQueue().cancelQueueListener(peer_data.queue_listener);
                boolean bl = true;
                return bl;
            }
            if (this.ready_connections.remove(peer_connection)) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.lists_lock.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToWaitingList(final NetworkConnectionBase conn) {
        final PeerData peer_data = new PeerData();
        OutgoingMessageQueue.MessageQueueListener listener = new OutgoingMessageQueue.MessageQueueListener(){

            @Override
            public boolean messageAdded(Message message) {
                return true;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void messageQueued(Message message) {
                try {
                    MultiPeerUploader.this.lists_lock.enter();
                    if (MultiPeerUploader.this.waiting_connections.get(conn) == null) {
                        return;
                    }
                    int mss_size = conn.getMssSize();
                    boolean has_urgent_data = conn.getOutgoingMessageQueue().hasUrgentMessage();
                    int num_bytes_ready = conn.getOutgoingMessageQueue().getTotalSize();
                    if (num_bytes_ready >= mss_size || has_urgent_data) {
                        MultiPeerUploader.this.waiting_connections.remove(conn);
                        conn.getOutgoingMessageQueue().cancelQueueListener(this);
                        MultiPeerUploader.this.addToReadyList(conn);
                    } else if (!peer_data.bumped) {
                        peer_data.bumped = true;
                        peer_data.last_message_added_time = SystemTime.getCurrentTime();
                    }
                }
                finally {
                    MultiPeerUploader.this.lists_lock.exit();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void flush() {
                try {
                    MultiPeerUploader.this.lists_lock.enter();
                    if (MultiPeerUploader.this.waiting_connections.remove(conn) != null) {
                        conn.getOutgoingMessageQueue().cancelQueueListener(this);
                        MultiPeerUploader.this.addToReadyList(conn);
                    }
                }
                finally {
                    MultiPeerUploader.this.lists_lock.exit();
                }
            }

            @Override
            public void messageRemoved(Message message) {
            }

            @Override
            public void messageSent(Message message) {
            }

            @Override
            public void protocolBytesSent(int byte_count) {
            }

            @Override
            public void dataBytesSent(int byte_count) {
            }
        };
        peer_data.queue_listener = listener;
        peer_data.last_message_added_time = SystemTime.getCurrentTime();
        peer_data.bumped = false;
        try {
            this.lists_lock.enter();
            this.waiting_connections.put(conn, peer_data);
            conn.getOutgoingMessageQueue().registerQueueListener(listener);
        }
        finally {
            this.lists_lock.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToReadyList(NetworkConnectionBase conn) {
        try {
            this.lists_lock.enter();
            this.ready_connections.addLast(conn);
        }
        finally {
            this.lists_lock.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int write(EventWaiter waiter, int num_bytes_to_write, boolean protocol_is_free) {
        NetworkConnectionBase conn;
        if (num_bytes_to_write < 1) {
            if (!protocol_is_free) {
                Debug.out("num_bytes_to_write < 1");
            }
            return 0;
        }
        HashMap<NetworkConnectionBase, Throwable> connections_to_notify_of_exception = new HashMap<NetworkConnectionBase, Throwable>();
        ArrayList<NetworkConnectionBase> manual_notifications = new ArrayList<NetworkConnectionBase>();
        int num_bytes_remaining = num_bytes_to_write;
        int data_bytes_written = 0;
        int protocol_bytes_written = 0;
        try {
            this.lists_lock.enter();
            int num_unusable_connections = 0;
            while (num_bytes_remaining > 0 && num_unusable_connections < this.ready_connections.size()) {
                int num_bytes_available;
                conn = (NetworkConnectionBase)this.ready_connections.removeFirst();
                if (!conn.getTransportBase().isReadyForWrite(waiter)) {
                    this.ready_connections.addLast(conn);
                    ++num_unusable_connections;
                    continue;
                }
                int total_size = conn.getOutgoingMessageQueue().getTotalSize();
                if (total_size < 1) {
                    this.addToWaitingList(conn);
                    continue;
                }
                int mss_size = conn.getMssSize();
                int num_bytes_allowed = num_bytes_remaining > mss_size ? mss_size : num_bytes_remaining;
                int n = num_bytes_available = total_size > mss_size ? mss_size : total_size;
                if (num_bytes_allowed >= num_bytes_available) {
                    int written = 0;
                    try {
                        int[] _written = conn.getOutgoingMessageQueue().deliverToTransport(num_bytes_available, protocol_is_free, true);
                        data_bytes_written += _written[0];
                        protocol_bytes_written += _written[1];
                        written = _written[0] + _written[1];
                        if (written > 0) {
                            manual_notifications.add(conn);
                        }
                        boolean has_urgent_data = conn.getOutgoingMessageQueue().hasUrgentMessage();
                        int remaining = conn.getOutgoingMessageQueue().getTotalSize();
                        if (remaining >= mss_size || has_urgent_data) {
                            this.ready_connections.addLast(conn);
                            num_unusable_connections = 0;
                        } else {
                            this.addToWaitingList(conn);
                        }
                    }
                    catch (Throwable e) {
                        if (!(e instanceof IOException)) {
                            Debug.printStackTrace(e);
                        }
                        connections_to_notify_of_exception.put(conn, e);
                        this.addToWaitingList(conn);
                    }
                    num_bytes_remaining -= written;
                    continue;
                }
                this.ready_connections.addLast(conn);
                ++num_unusable_connections;
            }
        }
        finally {
            this.lists_lock.exit();
        }
        for (int i = 0; i < manual_notifications.size(); ++i) {
            conn = (NetworkConnectionBase)manual_notifications.get(i);
            conn.getOutgoingMessageQueue().doListenerNotifications();
        }
        for (Map.Entry entry : connections_to_notify_of_exception.entrySet()) {
            NetworkConnectionBase conn2 = (NetworkConnectionBase)entry.getKey();
            Throwable exception = (Throwable)entry.getValue();
            conn2.notifyOfException(exception);
        }
        int num_bytes_written = num_bytes_to_write - num_bytes_remaining;
        if (num_bytes_written > 0) {
            this.rate_handler.bytesProcessed(data_bytes_written, protocol_bytes_written);
        }
        return num_bytes_written;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getBytesReadyToWrite() {
        long total = 0L;
        try {
            this.lists_lock.enter();
            for (NetworkConnectionBase conn : this.waiting_connections.keySet()) {
                total += (long)conn.getOutgoingMessageQueue().getTotalSize();
            }
            for (NetworkConnectionBase conn : this.ready_connections) {
                total += (long)conn.getOutgoingMessageQueue().getTotalSize();
            }
        }
        finally {
            this.lists_lock.exit();
        }
        return total;
    }

    @Override
    public int getConnectionCount(EventWaiter _waiter) {
        int res = this.waiting_connections.size() + this.ready_connections.size();
        if (res == 0) {
            this.waiter = _waiter;
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getReadyConnectionCount(EventWaiter waiter) {
        int total = 0;
        try {
            this.lists_lock.enter();
            for (NetworkConnectionBase conn : this.waiting_connections.keySet()) {
                if (!conn.getTransportBase().isReadyForWrite(waiter)) continue;
                ++total;
            }
            for (NetworkConnectionBase conn : this.ready_connections) {
                if (!conn.getTransportBase().isReadyForWrite(waiter)) continue;
                ++total;
            }
        }
        finally {
            this.lists_lock.exit();
        }
        return total;
    }

    @Override
    public boolean canProcess(EventWaiter waiter) {
        this.flushCheck();
        if (this.ready_connections.isEmpty()) {
            return false;
        }
        int[] allowed = this.rate_handler.getCurrentNumBytesAllowed();
        return allowed[0] >= 1 || allowed[1] != 0;
    }

    @Override
    public int doProcessing(EventWaiter waiter, int max_bytes) {
        boolean protocol_is_free;
        int[] allowed = this.rate_handler.getCurrentNumBytesAllowed();
        int num_bytes_allowed = allowed[0];
        boolean bl = protocol_is_free = allowed[1] > 0;
        if (num_bytes_allowed < 1) {
            return 0;
        }
        if (max_bytes > 0 && max_bytes < num_bytes_allowed) {
            num_bytes_allowed = max_bytes;
        }
        return this.write(waiter, num_bytes_allowed, protocol_is_free);
    }

    @Override
    public int getPriority() {
        return 1;
    }

    @Override
    public boolean getPriorityBoost() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getString() {
        StringBuilder str = new StringBuilder();
        str.append("MPU (").append(this.waiting_connections.size()).append("/").append(this.ready_connections.size()).append("): ");
        str.append("can_process=").append(this.canProcess(null)).append(",bytes_allowed=").append(this.rate_handler.getCurrentNumBytesAllowed()).append(", waiting=");
        try {
            this.lists_lock.enter();
            int num = 0;
            for (NetworkConnectionBase conn : this.waiting_connections.keySet()) {
                if (num++ > 0) {
                    str.append(",");
                }
                str.append(conn.getString());
            }
            str.append(": ready=");
            num = 0;
            for (NetworkConnectionBase conn : this.ready_connections) {
                if (num++ > 0) {
                    str.append(",");
                }
                str.append(conn.getString());
            }
        }
        finally {
            this.lists_lock.exit();
        }
        return str.toString();
    }

    private static class PeerData {
        private OutgoingMessageQueue.MessageQueueListener queue_listener;
        private long last_message_added_time;
        private boolean bumped;

        private PeerData() {
        }
    }
}

