/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager.impl;

import com.aelitis.azureus.core.networkmanager.IncomingMessageQueue;
import com.aelitis.azureus.core.networkmanager.NetworkConnection;
import com.aelitis.azureus.core.peermanager.messaging.Message;
import com.aelitis.azureus.core.peermanager.messaging.MessageStreamDecoder;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DirectByteBuffer;

public class IncomingMessageQueueImpl
implements IncomingMessageQueue {
    private volatile ArrayList<IncomingMessageQueue.MessageQueueListener> listeners = new ArrayList();
    private final AEMonitor listeners_mon = new AEMonitor("IncomingMessageQueue:listeners");
    private MessageStreamDecoder stream_decoder;
    private final NetworkConnection connection;

    public IncomingMessageQueueImpl(MessageStreamDecoder stream_decoder, NetworkConnection connection) {
        if (stream_decoder == null) {
            throw new NullPointerException("stream_decoder is null");
        }
        this.connection = connection;
        this.stream_decoder = stream_decoder;
    }

    @Override
    public void setDecoder(MessageStreamDecoder new_stream_decoder) {
        ByteBuffer already_read = this.stream_decoder.destroy();
        this.connection.getTransport().setAlreadyRead(already_read);
        this.stream_decoder = new_stream_decoder;
        this.stream_decoder.resumeDecoding();
    }

    @Override
    public MessageStreamDecoder getDecoder() {
        return this.stream_decoder;
    }

    @Override
    public int getPercentDoneOfCurrentMessage() {
        return this.stream_decoder.getPercentDoneOfCurrentMessage();
    }

    @Override
    public int[] receiveFromTransport(int max_bytes, boolean protocol_is_free) throws IOException {
        int data_read;
        int protocol_read;
        int bytes_read;
        if (max_bytes < 1) {
            if (!protocol_is_free) {
                Debug.out("max_bytes < 1: " + max_bytes);
            }
            return new int[2];
        }
        if (this.listeners.isEmpty()) {
            Debug.out("no queue listeners registered!");
            throw new IOException("no queue listeners registered!");
        }
        try {
            bytes_read = this.stream_decoder.performStreamDecode(this.connection.getTransport(), max_bytes);
        }
        catch (RuntimeException e) {
            Debug.out("Stream decode for " + this.connection.getString() + " failed: " + Debug.getNestedExceptionMessageAndStack(e));
            throw e;
        }
        Message[] messages = this.stream_decoder.removeDecodedMessages();
        if (messages != null) {
            for (int i = 0; i < messages.length; ++i) {
                Message msg = messages[i];
                if (msg == null) {
                    System.out.println("received msg == null [messages.length=" + messages.length + ", #" + i + "]: " + this.connection.getTransport().getDescription());
                    continue;
                }
                ArrayList<IncomingMessageQueue.MessageQueueListener> listeners_ref = this.listeners;
                boolean handled = false;
                for (int x = 0; x < listeners_ref.size(); ++x) {
                    IncomingMessageQueue.MessageQueueListener mql = listeners_ref.get(x);
                    if (!mql.messageReceived(msg)) continue;
                    handled = true;
                }
                if (handled) continue;
                if (listeners_ref.size() > 0) {
                    System.out.println("no registered listeners [out of " + listeners_ref.size() + "] handled decoded message [" + msg.getDescription() + "]");
                }
                DirectByteBuffer[] buffs = msg.getData();
                for (int x = 0; x < buffs.length; ++x) {
                    buffs[x].returnToPool();
                }
            }
        }
        if ((protocol_read = this.stream_decoder.getProtocolBytesDecoded()) > 0) {
            ArrayList<IncomingMessageQueue.MessageQueueListener> listeners_ref = this.listeners;
            for (int i = 0; i < listeners_ref.size(); ++i) {
                IncomingMessageQueue.MessageQueueListener mql = listeners_ref.get(i);
                mql.protocolBytesReceived(protocol_read);
            }
        }
        if ((data_read = this.stream_decoder.getDataBytesDecoded()) > 0) {
            ArrayList<IncomingMessageQueue.MessageQueueListener> listeners_ref = this.listeners;
            for (int i = 0; i < listeners_ref.size(); ++i) {
                IncomingMessageQueue.MessageQueueListener mql = listeners_ref.get(i);
                mql.dataBytesReceived(data_read);
            }
        }
        if ((data_read = bytes_read - protocol_read) < 0) {
            protocol_read = bytes_read;
            data_read = 0;
        }
        return new int[]{data_read, protocol_read};
    }

    @Override
    public void notifyOfExternallyReceivedMessage(Message message) throws IOException {
        ArrayList<IncomingMessageQueue.MessageQueueListener> listeners_ref = this.listeners;
        boolean handled = false;
        DirectByteBuffer[] dbbs = message.getData();
        int size = 0;
        for (int i = 0; i < dbbs.length; ++i) {
            size += dbbs[i].remaining((byte)5);
        }
        for (int x = 0; x < listeners_ref.size(); ++x) {
            IncomingMessageQueue.MessageQueueListener mql = listeners_ref.get(x);
            if (mql.messageReceived(message)) {
                handled = true;
            }
            if (message.getType() == 1) {
                mql.dataBytesReceived(size);
                continue;
            }
            mql.protocolBytesReceived(size);
        }
        if (!handled) {
            if (listeners_ref.size() > 0) {
                System.out.println("no registered listeners [out of " + listeners_ref.size() + "] handled decoded message [" + message.getDescription() + "]");
            }
            DirectByteBuffer[] buffs = message.getData();
            for (int x = 0; x < buffs.length; ++x) {
                buffs[x].returnToPool();
            }
        }
    }

    @Override
    public void resumeQueueProcessing() {
        this.stream_decoder.resumeDecoding();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerQueueListener(IncomingMessageQueue.MessageQueueListener listener) {
        try {
            this.listeners_mon.enter();
            ArrayList<IncomingMessageQueue.MessageQueueListener> new_list = new ArrayList<IncomingMessageQueue.MessageQueueListener>(this.listeners.size() + 1);
            if (listener.isPriority()) {
                boolean added = false;
                for (int i = 0; i < this.listeners.size(); ++i) {
                    IncomingMessageQueue.MessageQueueListener existing = this.listeners.get(i);
                    if (!added && !existing.isPriority()) {
                        new_list.add(listener);
                        added = true;
                    }
                    new_list.add(existing);
                }
                if (!added) {
                    new_list.add(listener);
                }
            } else {
                new_list.addAll(this.listeners);
                new_list.add(listener);
            }
            this.listeners = new_list;
        }
        finally {
            this.listeners_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancelQueueListener(IncomingMessageQueue.MessageQueueListener listener) {
        try {
            this.listeners_mon.enter();
            ArrayList<IncomingMessageQueue.MessageQueueListener> new_list = new ArrayList<IncomingMessageQueue.MessageQueueListener>(this.listeners);
            new_list.remove(listener);
            this.listeners = new_list;
        }
        finally {
            this.listeners_mon.exit();
        }
    }

    @Override
    public void destroy() {
        this.stream_decoder.destroy();
    }
}

