/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager.impl;

import com.aelitis.azureus.core.networkmanager.NetworkManager;
import com.aelitis.azureus.core.networkmanager.impl.ByteBucket;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SystemTime;

public class ByteBucketMT
implements ByteBucket {
    private int rate;
    private int burst_rate;
    private volatile long avail_bytes;
    private volatile long prev_update_time;
    private volatile boolean frozen;

    public ByteBucketMT(int rate_bytes_per_sec) {
        this(rate_bytes_per_sec, rate_bytes_per_sec + rate_bytes_per_sec / 5);
    }

    private ByteBucketMT(int rate_bytes_per_sec, int burst_rate) {
        this.rate = rate_bytes_per_sec;
        this.burst_rate = burst_rate;
        this.avail_bytes = 0L;
        this.prev_update_time = SystemTime.getMonotonousTime();
        this.ensureByteBucketMinBurstRate();
    }

    @Override
    public int getAvailableByteCount() {
        int res;
        if (this.avail_bytes < 0x6400000L) {
            this.update_avail_byte_count();
        }
        if ((res = (int)this.avail_bytes) < 0) {
            res = 0;
        }
        return res;
    }

    @Override
    public void setBytesUsed(int bytes_used) {
        if (this.avail_bytes >= 0x6400000L) {
            return;
        }
        this.avail_bytes -= (long)bytes_used;
    }

    @Override
    public int getRate() {
        return this.rate;
    }

    public int getBurstRate() {
        return this.burst_rate;
    }

    @Override
    public void setRate(int rate_bytes_per_sec) {
        this.setRate(rate_bytes_per_sec, rate_bytes_per_sec + rate_bytes_per_sec / 5);
    }

    @Override
    public void setFrozen(boolean f) {
        this.frozen = f;
    }

    public void setRate(int rate_bytes_per_sec, int burst_rate) {
        if (rate_bytes_per_sec < 0) {
            Debug.out("rate_bytes_per_sec [" + rate_bytes_per_sec + "] < 0");
            rate_bytes_per_sec = 0;
        }
        if (burst_rate < rate_bytes_per_sec) {
            Debug.out("burst_rate [" + burst_rate + "] < rate_bytes_per_sec [" + rate_bytes_per_sec + "]");
            burst_rate = rate_bytes_per_sec;
        }
        this.rate = rate_bytes_per_sec;
        this.burst_rate = burst_rate;
        if (this.avail_bytes > (long)burst_rate) {
            this.avail_bytes = burst_rate;
        }
        this.ensureByteBucketMinBurstRate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void update_avail_byte_count() {
        if (this.frozen) {
            return;
        }
        ByteBucketMT byteBucketMT = this;
        synchronized (byteBucketMT) {
            long now = SystemTime.getMonotonousTime();
            if (this.prev_update_time < now) {
                this.avail_bytes += (now - this.prev_update_time) * (long)this.rate / 1000L;
                this.prev_update_time = now;
                if (this.avail_bytes > (long)this.burst_rate) {
                    this.avail_bytes = this.burst_rate;
                } else if (this.avail_bytes < 0L) {
                    // empty if block
                }
            }
        }
    }

    private void ensureByteBucketMinBurstRate() {
        int mss = NetworkManager.getMinMssSize();
        if (this.burst_rate < mss) {
            this.burst_rate = mss;
        }
    }
}

