/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager;

import com.aelitis.azureus.core.networkmanager.ConnectionEndpoint;
import com.aelitis.azureus.core.networkmanager.ProtocolEndpoint;
import com.aelitis.azureus.core.networkmanager.ProtocolEndpointHandler;
import com.aelitis.azureus.core.networkmanager.impl.tcp.ProtocolEndpointTCP;
import com.aelitis.azureus.core.networkmanager.impl.udp.ProtocolEndpointUDP;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.Map;

public class ProtocolEndpointFactory {
    private static ProtocolEndpointHandler tcp_handler = null;
    private static ProtocolEndpointHandler udp_handler = null;
    private static final Map<Integer, ProtocolEndpointHandler> other_handlers = new HashMap<Integer, ProtocolEndpointHandler>();

    public static void registerHandler(ProtocolEndpointHandler handler) {
        int type = handler.getType();
        if (type == 1) {
            tcp_handler = handler;
        } else if (type == 2) {
            udp_handler = handler;
        } else {
            other_handlers.put(type, handler);
        }
    }

    public static boolean isHandlerRegistered(int type) {
        if (type == 1 || type == 2) {
            return true;
        }
        return other_handlers.containsKey(type);
    }

    public static ProtocolEndpoint createEndpoint(int type, InetSocketAddress target) {
        switch (type) {
            case 1: {
                return tcp_handler.create(target);
            }
            case 2: {
                return udp_handler.create(target);
            }
        }
        ProtocolEndpointHandler handler = other_handlers.get(type);
        if (handler != null) {
            return handler.create(target);
        }
        return null;
    }

    public static ProtocolEndpoint createEndpoint(int type, ConnectionEndpoint connection_endpoint, InetSocketAddress target) {
        switch (type) {
            case 1: {
                return tcp_handler.create(connection_endpoint, target);
            }
            case 2: {
                return udp_handler.create(connection_endpoint, target);
            }
        }
        ProtocolEndpointHandler handler = other_handlers.get(type);
        if (handler != null) {
            return handler.create(connection_endpoint, target);
        }
        return null;
    }

    static {
        ProtocolEndpointTCP.register();
        ProtocolEndpointUDP.register();
    }
}

