/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.metasearch.impl.web.json;

import com.aelitis.azureus.core.metasearch.Engine;
import com.aelitis.azureus.core.metasearch.Result;
import com.aelitis.azureus.core.metasearch.ResultListener;
import com.aelitis.azureus.core.metasearch.SearchException;
import com.aelitis.azureus.core.metasearch.SearchParameter;
import com.aelitis.azureus.core.metasearch.impl.EngineImpl;
import com.aelitis.azureus.core.metasearch.impl.MetaSearchImpl;
import com.aelitis.azureus.core.metasearch.impl.web.FieldMapping;
import com.aelitis.azureus.core.metasearch.impl.web.WebEngine;
import com.aelitis.azureus.core.metasearch.impl.web.WebResult;
import com.aelitis.azureus.util.ImportExportUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.UrlUtils;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;

public class JSONEngine
extends WebEngine {
    private static final String variablePattern = "\\$\\{[^}]+\\}";
    private static final Pattern patternVariable = Pattern.compile("\\$\\{[^}]+\\}");
    private static final boolean DEBUG_MAPPINGS = false;
    private String resultsEntryPath;
    private String rankDivisorPath;
    private float rankDivisor = 1.0f;

    public static EngineImpl importFromBEncodedMap(MetaSearchImpl meta_search, Map map) throws IOException {
        return new JSONEngine(meta_search, map);
    }

    public static Engine importFromJSONString(MetaSearchImpl meta_search, long id, long last_updated, float rank_bias, String name, JSONObject map) throws IOException {
        return new JSONEngine(meta_search, id, last_updated, rank_bias, name, map);
    }

    public JSONEngine(MetaSearchImpl meta_search, long id, long last_updated, float rank_bias, String name, String searchURLFormat, String timeZone, boolean automaticDateFormat, String userDateFormat, String resultsEntryPath, FieldMapping[] mappings, boolean needs_auth, String auth_method, String login_url, String[] required_cookies) {
        super(meta_search, 2, id, last_updated, rank_bias, name, searchURLFormat, timeZone, automaticDateFormat, userDateFormat, mappings, needs_auth, auth_method, login_url, required_cookies);
        this.resultsEntryPath = resultsEntryPath;
        this.setSource(2);
        this.setSelectionState(2);
    }

    protected JSONEngine(MetaSearchImpl meta_search, Map map) throws IOException {
        super(meta_search, map);
        this.resultsEntryPath = ImportExportUtils.importString(map, "json.path");
        this.rankDivisorPath = ImportExportUtils.importString(map, "rank.divisor.path");
    }

    protected JSONEngine(MetaSearchImpl meta_search, long id, long last_updated, float rank_bias, String name, JSONObject map) throws IOException {
        super(meta_search, 2, id, last_updated, rank_bias, name, map);
        this.resultsEntryPath = ImportExportUtils.importString(map, "json_result_key");
        this.resultsEntryPath = UrlUtils.decode(this.resultsEntryPath);
        this.rankDivisorPath = ImportExportUtils.importString(map, "rank_divisor_key");
    }

    public Map exportToBencodedMap() throws IOException {
        return this.exportToBencodedMap(false);
    }

    public Map exportToBencodedMap(boolean generic) throws IOException {
        HashMap res = new HashMap();
        ImportExportUtils.exportString(res, "json.path", this.resultsEntryPath);
        ImportExportUtils.exportString(res, "rank.divisor.path", this.rankDivisorPath);
        super.exportToBencodedMap(res, generic);
        return res;
    }

    @Override
    protected void exportToJSONObject(JSONObject res) throws IOException {
        res.put("json_result_key", this.resultsEntryPath);
        res.put("rank_divisor_key", this.rankDivisorPath);
        super.exportToJSONObject(res);
    }

    @Override
    protected Result[] searchSupport(SearchParameter[] searchParameters, Map searchContext, int desired_max_matches, int absolute_max_matches, String headers, ResultListener listener) throws SearchException {
        this.debugStart();
        WebEngine.pageDetails page_details = super.getWebPageContent(searchParameters, searchContext, headers, false);
        String page = page_details.getContent();
        if (listener != null) {
            listener.contentReceived(this, page);
        }
        String searchQuery = null;
        for (int i = 0; i < searchParameters.length; ++i) {
            if (!searchParameters[i].getMatchPattern().equals("s")) continue;
            searchQuery = searchParameters[i].getValue();
        }
        FieldMapping[] mappings = this.getMappings();
        try {
            Object jsonObject;
            try {
                jsonObject = JSONValue.parse(page);
            }
            catch (Throwable e) {
                String temp_page = page.replaceAll("\\\\\",", "\",");
                try {
                    jsonObject = JSONValue.parse(temp_page);
                }
                catch (Throwable f) {
                    throw e;
                }
            }
            if (this.rankDivisorPath != null) {
                String[] split = this.rankDivisorPath.split("\\.");
                try {
                    if (split.length > 0) {
                        Object jsonRankDivisor = jsonObject;
                        for (int i = 0; i < split.length - 1; ++i) {
                            String key = split[i];
                            if (!(jsonRankDivisor instanceof JSONObject)) break;
                            jsonRankDivisor = ((JSONObject)jsonRankDivisor).get(key);
                        }
                        if (jsonRankDivisor instanceof Map) {
                            jsonRankDivisor = ((Map)jsonRankDivisor).get(split[split.length - 1]);
                        }
                        if (jsonRankDivisor instanceof Number) {
                            this.rankDivisor = ((Number)jsonRankDivisor).floatValue();
                        }
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            JSONArray resultArray = null;
            if (this.resultsEntryPath != null && this.resultsEntryPath.length() > 0) {
                JSONArray array;
                String[] split = this.resultsEntryPath.split("\\.");
                if (jsonObject instanceof JSONArray && split.length > 0 && !split[0].startsWith("[") && (array = (JSONArray)jsonObject).size() == 1) {
                    jsonObject = array.get(0);
                }
                for (String pathEntry : split) {
                    if (jsonObject == null) {
                        throw new SearchException("Invalid entry path : " + this.resultsEntryPath);
                    }
                    try {
                        if (pathEntry.startsWith("[") && pathEntry.endsWith("]")) {
                            int idx = Integer.parseInt(pathEntry.substring(1, pathEntry.length() - 1));
                            jsonObject = ((JSONArray)jsonObject).get(idx);
                            continue;
                        }
                        jsonObject = ((JSONObject)jsonObject).get(pathEntry);
                    }
                    catch (Throwable t) {
                        throw new SearchException("Invalid entry path : " + this.resultsEntryPath, t);
                    }
                }
            }
            try {
                resultArray = (JSONArray)jsonObject;
            }
            catch (Throwable t) {
                throw new SearchException("Object is not a result array. Check the JSON service and/or the entry path");
            }
            if (resultArray != null) {
                ArrayList<WebResult> results = new ArrayList<WebResult>();
                Throwable decode_failure = null;
                for (int i = 0; i < resultArray.size(); ++i) {
                    Object obj = resultArray.get(i);
                    if (!(obj instanceof JSONObject)) continue;
                    JSONObject jsonEntry = (JSONObject)obj;
                    if (absolute_max_matches >= 0 && --absolute_max_matches < 0) break;
                    if (listener != null) {
                        Iterator<Map.Entry<String, Object>> it = new TreeMap<String, Object>(jsonEntry).entrySet().iterator();
                        String[] groups = new String[jsonEntry.size()];
                        int pos = 0;
                        while (it.hasNext()) {
                            Map.Entry<String, Object> entry = it.next();
                            String key = entry.getKey();
                            Object value = entry.getValue();
                            if (key != null && value != null) {
                                groups[pos++] = key.toString() + "=" + UrlUtils.encode(value.toString());
                                continue;
                            }
                            groups[pos++] = "";
                        }
                        listener.matchFound(this, groups);
                    }
                    WebResult result = new WebResult(this, this.getRootPage(), this.getBasePage(), this.getDateParser(), searchQuery);
                    try {
                        String downloadLink;
                        String possibleMagnet;
                        byte[] hash;
                        block43: for (int j = 0; j < mappings.length; ++j) {
                            String fieldFrom = mappings[j].getName();
                            if (fieldFrom == null) continue;
                            int fieldTo = mappings[j].getField();
                            String fieldContent = null;
                            Matcher matcher = patternVariable.matcher(fieldFrom);
                            if (matcher.find()) {
                                fieldContent = fieldFrom;
                                do {
                                    String key = matcher.group();
                                    key = key.substring(2, key.length() - 1);
                                    String[] keys = key.split(",", -1);
                                    try {
                                        String replaceWith;
                                        Object replaceWithObject = jsonEntry.get(keys[0]);
                                        String string = replaceWith = replaceWithObject == null ? "" : replaceWithObject.toString();
                                        if (keys.length > 1) {
                                            String[] commands = keys[1].split("\\+");
                                            int keyPos = 2;
                                            for (String command : commands) {
                                                try {
                                                    if (command.equals("replace")) {
                                                        if (keyPos + 2 > keys.length) break;
                                                        String simpleReplace = keys[keyPos];
                                                        String simpleReplacement = keys[++keyPos];
                                                        ++keyPos;
                                                        replaceWith = replaceWith.replaceAll(simpleReplace, simpleReplacement);
                                                        continue;
                                                    }
                                                    if (command.equals("ucase")) {
                                                        replaceWith = replaceWith.toUpperCase();
                                                        continue;
                                                    }
                                                    if (command.equals("lcase")) {
                                                        replaceWith = replaceWith.toLowerCase();
                                                        continue;
                                                    }
                                                    if (!command.equals("urldecode")) continue;
                                                    replaceWith = UrlUtils.decode(replaceWith);
                                                }
                                                catch (Exception e) {
                                                    // empty catch block
                                                }
                                            }
                                        }
                                        fieldContent = fieldContent.replaceFirst(variablePattern, replaceWith);
                                    }
                                    catch (Exception e) {
                                        // empty catch block
                                    }
                                } while (matcher.find());
                            } else {
                                Object fieldContentObj = jsonEntry.get(fieldFrom);
                                String string = fieldContent = fieldContentObj == null ? "" : fieldContentObj.toString();
                            }
                            if (fieldContent == null) continue;
                            switch (fieldTo) {
                                case 1: {
                                    result.setNameFromHTML(fieldContent);
                                    continue block43;
                                }
                                case 3: {
                                    result.setSizeFromHTML(fieldContent);
                                    continue block43;
                                }
                                case 4: {
                                    result.setNbPeersFromHTML(fieldContent);
                                    continue block43;
                                }
                                case 5: {
                                    result.setNbSeedsFromHTML(fieldContent);
                                    continue block43;
                                }
                                case 6: {
                                    result.setCategoryFromHTML(fieldContent);
                                    continue block43;
                                }
                                case 2: {
                                    result.setPublishedDateFromHTML(fieldContent);
                                    continue block43;
                                }
                                case 7: {
                                    result.setCommentsFromHTML(fieldContent);
                                    continue block43;
                                }
                                case 103: {
                                    result.setCDPLink(fieldContent);
                                    continue block43;
                                }
                                case 102: {
                                    result.setTorrentLink(fieldContent);
                                    continue block43;
                                }
                                case 104: {
                                    result.setPlayLink(fieldContent);
                                    continue block43;
                                }
                                case 105: {
                                    result.setDownloadButtonLink(fieldContent);
                                    continue block43;
                                }
                                case 10: {
                                    result.setVotesFromHTML(fieldContent);
                                    continue block43;
                                }
                                case 11: {
                                    result.setNbSuperSeedsFromHTML(fieldContent);
                                    continue block43;
                                }
                                case 12: {
                                    result.setPrivateFromHTML(fieldContent);
                                    continue block43;
                                }
                                case 13: {
                                    result.setDrmKey(fieldContent);
                                    continue block43;
                                }
                                case 14: {
                                    result.setVotesDownFromHTML(fieldContent);
                                    continue block43;
                                }
                                case 200: {
                                    if (fieldContent.startsWith("magnet:")) {
                                        byte[] hash2 = UrlUtils.getHashFromMagnetURI(fieldContent);
                                        fieldContent = hash2 != null ? ByteFormatter.encodeString(hash2) : null;
                                    }
                                    if (fieldContent == null) continue block43;
                                    result.setHash(fieldContent);
                                    continue block43;
                                }
                                case 201: {
                                    result.setRankFromHTML(fieldContent, this.rankDivisor);
                                    continue block43;
                                }
                            }
                        }
                        if (result.getHash() == null && (hash = UrlUtils.getHashFromMagnetURI(possibleMagnet = UrlUtils.parseTextForMagnets(downloadLink = result.getDownloadLink()))) != null) {
                            result.setHash(ByteFormatter.nicePrint(hash, true));
                        }
                        results.add(result);
                        continue;
                    }
                    catch (Throwable e) {
                        decode_failure = e;
                    }
                }
                if (results.size() == 0 && decode_failure != null) {
                    throw decode_failure;
                }
                Result[] res = results.toArray(new Result[results.size()]);
                this.debugLog("success: found " + res.length + " results");
                return res;
            }
            this.debugLog("success: no result array found so no results");
            return new Result[0];
        }
        catch (Throwable e) {
            this.debugLog("failed: " + Debug.getNestedExceptionMessageAndStack(e));
            if (e instanceof SearchException) {
                throw (SearchException)e;
            }
            String content_str = page;
            if (content_str.length() > 256) {
                content_str = content_str.substring(0, 256) + "...";
            }
            throw new SearchException("JSON matching failed for " + this.getName() + ", content=" + content_str, e);
        }
    }
}

