/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.metasearch.impl;

import com.aelitis.azureus.core.custom.Customization;
import com.aelitis.azureus.core.custom.CustomizationManager;
import com.aelitis.azureus.core.custom.CustomizationManagerFactory;
import com.aelitis.azureus.core.messenger.config.PlatformMetaSearchMessenger;
import com.aelitis.azureus.core.metasearch.Engine;
import com.aelitis.azureus.core.metasearch.MetaSearch;
import com.aelitis.azureus.core.metasearch.MetaSearchException;
import com.aelitis.azureus.core.metasearch.MetaSearchManager;
import com.aelitis.azureus.core.metasearch.MetaSearchManagerListener;
import com.aelitis.azureus.core.metasearch.Result;
import com.aelitis.azureus.core.metasearch.ResultListener;
import com.aelitis.azureus.core.metasearch.SearchParameter;
import com.aelitis.azureus.core.metasearch.impl.EngineImpl;
import com.aelitis.azureus.core.metasearch.impl.MetaSearchImpl;
import com.aelitis.azureus.core.metasearch.impl.plugin.PluginEngine;
import com.aelitis.azureus.core.subs.Subscription;
import com.aelitis.azureus.core.subs.SubscriptionManager;
import com.aelitis.azureus.core.subs.SubscriptionManagerFactory;
import com.aelitis.azureus.core.vuzefile.VuzeFile;
import com.aelitis.azureus.core.vuzefile.VuzeFileComponent;
import com.aelitis.azureus.core.vuzefile.VuzeFileHandler;
import com.aelitis.azureus.core.vuzefile.VuzeFileProcessor;
import com.aelitis.azureus.util.ConstantsVuze;
import com.aelitis.azureus.util.ImportExportUtils;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.util.AEDiagnostics;
import org.gudy.azureus2.core3.util.AEDiagnosticsEvidenceGenerator;
import org.gudy.azureus2.core3.util.AEDiagnosticsLogger;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AsyncDispatcher;
import org.gudy.azureus2.core3.util.Base32;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.IndentWriter;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.core3.util.TorrentUtils;
import org.gudy.azureus2.core3.xml.util.XUXmlWriter;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.PluginListener;
import org.gudy.azureus2.plugins.ui.UIManager;
import org.gudy.azureus2.plugins.utils.FeatureManager;
import org.gudy.azureus2.plugins.utils.StaticUtilities;
import org.gudy.azureus2.plugins.utils.search.Search;
import org.gudy.azureus2.plugins.utils.search.SearchException;
import org.gudy.azureus2.plugins.utils.search.SearchInstance;
import org.gudy.azureus2.plugins.utils.search.SearchListener;
import org.gudy.azureus2.plugins.utils.search.SearchObserver;
import org.gudy.azureus2.plugins.utils.search.SearchProvider;
import org.gudy.azureus2.plugins.utils.search.SearchProviderResults;
import org.gudy.azureus2.plugins.utils.search.SearchResult;
import org.gudy.azureus2.pluginsimpl.local.PluginInitializer;
import org.gudy.azureus2.pluginsimpl.local.utils.UtilitiesImpl;

public class MetaSearchManagerImpl
implements MetaSearchManager,
UtilitiesImpl.searchManager,
AEDiagnosticsEvidenceGenerator {
    private static final boolean AUTO_MODE_DEFAULT = true;
    private static final String LOGGER_NAME = "MetaSearch";
    private static final int REFRESH_MILLIS = 82800000;
    private static MetaSearchManagerImpl singleton;
    private MetaSearchImpl meta_search;
    private AsyncDispatcher dispatcher = new AsyncDispatcher(10000);
    private AESemaphore initial_refresh_sem = new AESemaphore("MetaSearch:initrefresh");
    private AESemaphore refresh_sem = new AESemaphore("MetaSearch:refresh", 1);
    private boolean checked_customization;
    private AsyncDispatcher op_dispatcher = new AsyncDispatcher(5000);
    private List<MetaSearchManagerListener> listeners = new ArrayList<MetaSearchManagerListener>();
    private List<Map> operations = new ArrayList<Map>();
    private String extension_key;
    private Map<String, EngineImpl> potential_associations = new LinkedHashMap<String, EngineImpl>(32, 0.75f, true){

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, EngineImpl> eldest) {
            return this.size() > 32;
        }
    };
    private boolean proxy_requests_enabled;
    private static Object import_lock;

    public static void preInitialise() {
        VuzeFileHandler.getSingleton().addProcessor(new VuzeFileProcessor(){

            @Override
            public void process(VuzeFile[] files, int expected_types) {
                for (int i = 0; i < files.length; ++i) {
                    VuzeFile vf = files[i];
                    VuzeFileComponent[] comps = vf.getComponents();
                    for (int j = 0; j < comps.length; ++j) {
                        VuzeFileComponent comp2 = comps[j];
                        int comp_type = comp2.getType();
                        if (comp_type == 1) {
                            try {
                                Engine e = MetaSearchManagerImpl.getSingleton().importEngine(comp2.getContent(), (expected_types & 1) == 0);
                                comp2.setProcessed();
                                if (e == null) continue;
                                comp2.setData(Engine.VUZE_FILE_COMPONENT_ENGINE_KEY, e);
                            }
                            catch (Throwable e) {
                                Debug.printStackTrace(e);
                            }
                            continue;
                        }
                        if (comp_type != 256) continue;
                        MetaSearchManagerImpl.getSingleton().addOperation(comp2.getContent());
                        comp2.setProcessed();
                    }
                }
            }
        });
        TorrentUtils.addTorrentAttributeListener(new TorrentUtils.torrentAttributeListener(){

            @Override
            public void attributeSet(TOTorrent torrent, String attribute, Object value) {
                if (attribute == "obtained_from" && !TorrentUtils.isReallyPrivate(torrent)) {
                    try {
                        MetaSearchManagerImpl.getSingleton().checkPotentialAssociations(torrent.getHash(), (String)value);
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                    }
                }
            }
        });
    }

    public static synchronized MetaSearchManagerImpl getSingleton() {
        if (singleton == null) {
            singleton = new MetaSearchManagerImpl();
        }
        return singleton;
    }

    protected MetaSearchManagerImpl() {
        COConfigurationManager.addAndFireParameterListener("metasearch.config.proxy.enable", new ParameterListener(){

            @Override
            public void parameterChanged(String parameterName) {
                MetaSearchManagerImpl.this.proxy_requests_enabled = COConfigurationManager.getBooleanParameter("metasearch.config.proxy.enable", false);
            }
        });
        this.meta_search = new MetaSearchImpl(this);
        AEDiagnostics.addEvidenceGenerator(this);
        this.extension_key = COConfigurationManager.getStringParameter("metasearch.extkey.latest", "");
        if (this.extension_key.length() == 0) {
            this.extension_key = null;
        }
        this.setupExtensions();
        SimpleTimer.addPeriodicEvent("MetaSearchRefresh", 82800000L, new TimerEventPerformer(){

            @Override
            public void perform(TimerEvent event2) {
                MetaSearchManagerImpl.this.refresh();
            }
        });
        this.refresh();
        UtilitiesImpl.addSearchManager(this);
    }

    @Override
    public void addProvider(PluginInterface pi, SearchProvider provider2) {
        String id = pi.getPluginID() + "." + provider2.getProperty(1);
        try {
            this.meta_search.importFromPlugin(id, provider2);
        }
        catch (Throwable e) {
            Debug.out("Failed to add search provider '" + id + "' (" + provider2 + ")", e);
        }
    }

    @Override
    public void removeProvider(PluginInterface pi, SearchProvider provider2) {
        String id = pi.getPluginID() + "." + provider2.getProperty(1);
        try {
            Engine[] engines;
            for (Engine engine : engines = this.meta_search.getEngines(false, false)) {
                PluginEngine pe;
                if (!(engine instanceof PluginEngine) || (pe = (PluginEngine)engine).getProvider() != provider2) continue;
                engine.delete();
            }
        }
        catch (Throwable e) {
            Debug.out("Failed to remove search provider '" + id + "' (" + provider2 + ")", e);
        }
    }

    @Override
    public SearchProvider[] getProviders() {
        Engine[] engines = this.meta_search.getEngines(true, false);
        SearchProvider[] result = new SearchProvider[engines.length];
        for (int i = 0; i < engines.length; ++i) {
            result[i] = new engineInfo(engines[i]);
        }
        return result;
    }

    @Override
    public Engine getEngine(SearchProvider sp) {
        Engine[] engines;
        for (Engine engine : engines = this.meta_search.getEngines(false, false)) {
            PluginEngine pe;
            if (!(engine instanceof PluginEngine) || (pe = (PluginEngine)engine).getProvider() != sp) continue;
            return pe;
        }
        return null;
    }

    @Override
    public Search createSearch(String provider_ids, String properties_str) throws SearchException {
        String[] bits = XUXmlWriter.splitWithEscape(provider_ids, ',');
        long[] pids = new long[bits.length];
        for (int i = 0; i < bits.length; ++i) {
            pids[i] = Long.parseLong(bits[i]);
        }
        HashMap<String, String> properties = new HashMap<String, String>();
        bits = XUXmlWriter.splitWithEscape(properties_str, ',');
        for (int i = 0; i < bits.length; ++i) {
            String[] x = XUXmlWriter.splitWithEscape(bits[i], '=');
            properties.put(x[0].trim(), x[1].trim());
        }
        return this.createSearch(pids, properties, null);
    }

    @Override
    public Search createSearch(SearchProvider[] providers, Map<String, String> properties, SearchListener listener) throws SearchException {
        long[] pids;
        if (providers == null) {
            pids = new long[]{};
        } else {
            pids = new long[providers.length];
            for (int i = 0; i < pids.length; ++i) {
                Long id = (Long)providers[i].getProperty(0);
                if (id == null) {
                    throw new SearchException("Unknown provider - no id available");
                }
                pids[i] = id;
            }
        }
        return this.createSearch(pids, properties, listener);
    }

    protected Search createSearch(long[] provider_ids, Map<String, String> properties, SearchListener listener) throws SearchException {
        Engine[] used_engines;
        ArrayList<SearchParameter> sps = new ArrayList<SearchParameter>();
        String search_term = properties.get("search_term");
        if (search_term == null) {
            throw new SearchException("Search term is mandatory");
        }
        sps.add(new SearchParameter("s", search_term));
        String mature = properties.get("mature");
        if (mature != null) {
            sps.add(new SearchParameter("m", mature.toString()));
        }
        SearchParameter[] parameters = sps.toArray(new SearchParameter[sps.size()]);
        HashMap<String, String> context2 = new HashMap<String, String>();
        context2.put("force_full", "true");
        String headers = null;
        int max_per_engine = 256;
        SearchObject search = new SearchObject(listener);
        if (provider_ids.length == 0) {
            used_engines = this.getMetaSearch().search(search, parameters, headers, context2, max_per_engine);
        } else {
            ArrayList<Engine> selected_engines = new ArrayList<Engine>();
            for (long id : provider_ids) {
                Engine engine = this.meta_search.getEngine(id);
                if (engine == null) {
                    throw new SearchException("Unknown engine id - " + id);
                }
                selected_engines.add(engine);
            }
            Engine[] engines = selected_engines.toArray(new Engine[selected_engines.size()]);
            used_engines = this.getMetaSearch().search(engines, search, parameters, headers, context2, max_per_engine);
        }
        search.setEnginesUsed(used_engines);
        return search;
    }

    protected void refresh() {
        this.dispatcher.dispatch(new AERunnable(){

            @Override
            public void runSupport() {
                if (MetaSearchManagerImpl.this.dispatcher.getQueueSize() == 0) {
                    try {
                        MetaSearchManagerImpl.this.syncRefresh();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
        });
    }

    protected void ensureEnginesUpToDate() {
        long timeout;
        long l = timeout = this.meta_search.getEngineCount() == 0 ? 30000L : 10000L;
        if (!this.initial_refresh_sem.reserve(timeout)) {
            this.log("Timeout waiting for initial refresh to complete, continuing");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void syncRefresh() throws MetaSearchException {
        boolean refresh_completed = false;
        boolean first_run = false;
        try {
            this.refresh_sem.reserve();
            first_run = COConfigurationManager.getBooleanParameter("metasearch.refresh.first_run", true);
            if (!this.checked_customization) {
                this.checked_customization = true;
                CustomizationManager cust_man = CustomizationManagerFactory.getSingleton();
                Customization cust = cust_man.getActiveCustomization();
                if (cust != null) {
                    boolean new_version;
                    String cust_name = COConfigurationManager.getStringParameter("metasearch.custom.name", "");
                    String cust_version = COConfigurationManager.getStringParameter("metasearch.custom.version", "0");
                    boolean new_name = !cust_name.equals(cust.getName());
                    boolean bl = new_version = Constants.compareVersions(cust_version, cust.getVersion()) < 0;
                    if (new_name || new_version) {
                        this.log("Customization: checking templates for " + cust.getName() + "/" + cust.getVersion());
                        try {
                            InputStream[] streams = cust.getResources("metasearch");
                            if (streams.length > 0 && new_name) {
                                this.log("    setting auto-mode to false");
                                this.setAutoMode(false);
                            }
                            for (int i = 0; i < streams.length; ++i) {
                                InputStream is = streams[i];
                                try {
                                    VuzeFile vf = VuzeFileHandler.getSingleton().loadVuzeFile(is);
                                    if (vf == null) continue;
                                    VuzeFileComponent[] comps = vf.getComponents();
                                    for (int j = 0; j < comps.length; ++j) {
                                        VuzeFileComponent comp2 = comps[j];
                                        if (comp2.getType() != 1) continue;
                                        try {
                                            Engine e = MetaSearchManagerImpl.getSingleton().importEngine(comp2.getContent(), false);
                                            this.log("    updated " + e.getName());
                                            e.setSelectionState(2);
                                            continue;
                                        }
                                        catch (Throwable e) {
                                            Debug.printStackTrace(e);
                                        }
                                    }
                                    continue;
                                }
                                finally {
                                    try {
                                        is.close();
                                    }
                                    catch (Throwable e) {}
                                }
                            }
                        }
                        finally {
                            COConfigurationManager.setParameter("metasearch.custom.name", cust.getName());
                            COConfigurationManager.setParameter("metasearch.custom.version", cust.getVersion());
                        }
                    }
                }
            }
            this.log("Refreshing engines");
            HashMap<Long, PlatformMetaSearchMessenger.templateInfo> vuze_selected_ids = new HashMap<Long, PlatformMetaSearchMessenger.templateInfo>();
            HashMap<Long, PlatformMetaSearchMessenger.templateInfo> vuze_preload_ids = new HashMap<Long, PlatformMetaSearchMessenger.templateInfo>();
            HashSet<Long> featured_ids = new HashSet<Long>();
            HashSet<Long> popular_ids = new HashSet<Long>();
            HashSet<Long> manual_vuze_ids = new HashSet<Long>();
            boolean auto_mode = this.isAutoMode();
            Engine[] engines = this.meta_search.getEngines(false, false);
            String fud = this.meta_search.getFUD();
            try {
                int i;
                PlatformMetaSearchMessenger.templateInfo[] featured = PlatformMetaSearchMessenger.listFeaturedTemplates(this.extension_key, fud);
                String featured_str = "";
                for (int i2 = 0; i2 < featured.length; ++i2) {
                    PlatformMetaSearchMessenger.templateInfo template = featured[i2];
                    if (!template.isVisible()) continue;
                    Long key = new Long(template.getId());
                    vuze_selected_ids.put(key, template);
                    featured_ids.add(key);
                    featured_str = featured_str + (featured_str.length() == 0 ? "" : ",") + key;
                }
                this.log("Featured templates: " + featured_str);
                if (auto_mode || first_run) {
                    PlatformMetaSearchMessenger.templateInfo[] popular = PlatformMetaSearchMessenger.listTopPopularTemplates(this.extension_key, fud);
                    String popular_str = "";
                    String preload_str = "";
                    for (int i3 = 0; i3 < popular.length; ++i3) {
                        PlatformMetaSearchMessenger.templateInfo template = popular[i3];
                        if (!template.isVisible()) continue;
                        Long key = new Long(template.getId());
                        if (auto_mode) {
                            if (vuze_selected_ids.containsKey(key)) continue;
                            vuze_selected_ids.put(key, template);
                            popular_ids.add(key);
                            popular_str = popular_str + (popular_str.length() == 0 ? "" : ",") + key;
                            continue;
                        }
                        if (vuze_preload_ids.containsKey(key)) continue;
                        vuze_preload_ids.put(key, template);
                        preload_str = preload_str + (preload_str.length() == 0 ? "" : ",") + key;
                    }
                    this.log("Popular templates: " + popular_str);
                    if (preload_str.length() > 0) {
                        this.log("Pre-load templates: " + popular_str);
                    }
                }
                String manual_str = "";
                for (int i4 = 0; i4 < engines.length; ++i4) {
                    Engine engine = engines[i4];
                    Long key = new Long(engine.getId());
                    if (engine.getSource() != 1 || engine.getSelectionState() != 2 || vuze_selected_ids.containsKey(key)) continue;
                    manual_vuze_ids.add(key);
                }
                if (manual_vuze_ids.size() > 0) {
                    long[] manual_ids = new long[manual_vuze_ids.size()];
                    Iterator it = manual_vuze_ids.iterator();
                    int pos = 0;
                    while (it.hasNext()) {
                        manual_ids[pos++] = (Long)it.next();
                    }
                    PlatformMetaSearchMessenger.templateInfo[] manual = PlatformMetaSearchMessenger.getTemplateDetails(this.extension_key, manual_ids);
                    for (int i5 = 0; i5 < manual.length; ++i5) {
                        PlatformMetaSearchMessenger.templateInfo template = manual[i5];
                        if (!template.isVisible()) continue;
                        Long key = new Long(template.getId());
                        vuze_selected_ids.put(key, template);
                        manual_str = manual_str + (manual_str.length() == 0 ? "" : ",") + key;
                    }
                }
                this.log("Manual templates: " + manual_str);
                HashMap<Long, Engine> existing_engine_map = new HashMap<Long, Engine>();
                String existing_str = "";
                for (int i6 = 0; i6 < engines.length; ++i6) {
                    Engine engine = engines[i6];
                    Long key = new Long(engine.getId());
                    existing_engine_map.put(key, engine);
                    existing_str = existing_str + (existing_str.length() == 0 ? "" : ",") + key + "[source=" + Engine.ENGINE_SOURCE_STRS[engine.getSource()] + ",type=" + engine.getType() + ",selected=" + Engine.SEL_STATE_STRINGS[engine.getSelectionState()] + "]";
                }
                this.log("Existing templates: " + existing_str);
                for (Map.Entry entry : vuze_selected_ids.entrySet()) {
                    boolean update;
                    vuze_preload_ids.remove(entry.getKey());
                    long id = (Long)entry.getKey();
                    PlatformMetaSearchMessenger.templateInfo template = (PlatformMetaSearchMessenger.templateInfo)entry.getValue();
                    long modified = template.getModifiedDate();
                    Engine this_engine = (Engine)existing_engine_map.get(new Long(id));
                    boolean bl = update = this_engine == null || this_engine.getLastUpdated() < modified;
                    if (update) {
                        PlatformMetaSearchMessenger.templateDetails details = PlatformMetaSearchMessenger.getTemplate(this.extension_key, id);
                        this.log("Downloading definition of template " + id);
                        this.log(details.getValue());
                        if (details.isVisible()) {
                            try {
                                this_engine = this.meta_search.importFromJSONString(details.getType() == 1 ? 2 : 1, details.getId(), details.getModifiedDate(), details.getRankBias(), details.getName(), details.getValue());
                                this_engine.setSource(1);
                                this.meta_search.addEngine(this_engine);
                            }
                            catch (Throwable e) {
                                this.log("Failed to import engine '" + details.getValue() + "'", e);
                            }
                        }
                    } else if (this_engine.getRankBias() != template.getRankBias()) {
                        this_engine.setRankBias(template.getRankBias());
                        this.log("Updating rank bias for " + this_engine.getString() + " to " + template.getRankBias());
                    } else {
                        this.log("Not updating " + this_engine.getString() + " as unchanged");
                    }
                    if (this_engine == null) continue;
                    int sel_state = this_engine.getSelectionState();
                    if (sel_state == 0) {
                        this.log("Auto-selecting " + this_engine.getString());
                        this_engine.setSelectionState(1);
                        continue;
                    }
                    if (!auto_mode || sel_state != 2) continue;
                    this.log("Switching Manual to Auto select for " + this_engine.getString());
                    this_engine.setSelectionState(1);
                }
                for (Map.Entry entry : vuze_preload_ids.entrySet()) {
                    long id = (Long)entry.getKey();
                    Engine this_engine = (Engine)existing_engine_map.get(new Long(id));
                    if (this_engine != null) continue;
                    PlatformMetaSearchMessenger.templateDetails details = PlatformMetaSearchMessenger.getTemplate(this.extension_key, id);
                    this.log("Downloading pre-load definition of template " + id);
                    this.log(details.getValue());
                    if (!details.isVisible()) continue;
                    try {
                        this_engine = this.meta_search.importFromJSONString(details.getType() == 1 ? 2 : 1, details.getId(), details.getModifiedDate(), details.getRankBias(), details.getName(), details.getValue());
                        this_engine.setSource(1);
                        this_engine.setSelectionState(0);
                        this.meta_search.addEngine(this_engine);
                    }
                    catch (Throwable e) {
                        this.log("Failed to import engine '" + details.getValue() + "'", e);
                    }
                }
                for (i = 0; i < engines.length; ++i) {
                    Engine engine = engines[i];
                    if (engine.getSource() != 1 || engine.getSelectionState() != 1 || vuze_selected_ids.containsKey(new Long(engine.getId()))) continue;
                    this.log("Deselecting " + engine.getString() + " as no longer visible on Vuze");
                    engine.setSelectionState(0);
                }
                for (i = 0; i < engines.length; ++i) {
                    Engine engine = engines[i];
                    if (engine.getSource() == 1 && engine.getSelectionState() == 2) {
                        engine.recordSelectionState();
                        continue;
                    }
                    engine.checkSelectionStateRecorded();
                }
                refresh_completed = true;
            }
            catch (Throwable e) {
                this.log("Refresh failed", e);
                throw new MetaSearchException("Refresh failed", e);
            }
        }
        finally {
            if (first_run && refresh_completed) {
                COConfigurationManager.setParameter("metasearch.refresh.first_run", false);
            }
            this.refresh_sem.release();
            this.initial_refresh_sem.releaseForever();
        }
    }

    @Override
    public MetaSearch getMetaSearch() {
        return this.meta_search;
    }

    @Override
    public boolean isAutoMode() {
        return COConfigurationManager.getBooleanParameter("metasearch.auto.mode", true);
    }

    protected void setAutoMode(boolean auto) {
        COConfigurationManager.setParameter("metasearch.auto.mode", auto);
    }

    @Override
    public void setSelectedEngines(long[] ids, boolean auto) throws MetaSearchException {
        try {
            Engine existing;
            long id;
            int i;
            String s = "";
            for (int i2 = 0; i2 < ids.length; ++i2) {
                s = s + (i2 == 0 ? "" : ",") + ids[i2];
            }
            this.log("setSelectedIds: " + s + ", auto=" + auto);
            COConfigurationManager.setParameter("metasearch.auto.mode", auto);
            Engine[] engines = this.meta_search.getEngines(false, false);
            HashMap<Long, Engine> engine_map = new HashMap<Long, Engine>();
            for (int i3 = 0; i3 < engines.length; ++i3) {
                engine_map.put(new Long(engines[i3].getId()), engines[i3]);
            }
            HashSet<Engine> selected_engine_set = new HashSet<Engine>();
            for (i = 0; i < ids.length; ++i) {
                id = ids[i];
                existing = (Engine)engine_map.get(new Long(id));
                if (existing == null) continue;
                existing.setSelectionState(2);
                selected_engine_set.add(existing);
            }
            this.syncRefresh();
            engines = this.meta_search.getEngines(false, false);
            for (i = 0; i < ids.length; ++i) {
                id = ids[i];
                existing = (Engine)engine_map.get(new Long(id));
                if (existing != null) continue;
                PlatformMetaSearchMessenger.templateDetails details = PlatformMetaSearchMessenger.getTemplate(this.extension_key, id);
                this.log("Downloading definition of template " + id);
                this.log(details.getValue());
                Engine new_engine = this.meta_search.importFromJSONString(details.getType() == 1 ? 2 : 1, details.getId(), details.getModifiedDate(), details.getRankBias(), details.getName(), details.getValue());
                new_engine.setSelectionState(2);
                new_engine.setSource(1);
                this.meta_search.addEngine(new_engine);
                selected_engine_set.add(new_engine);
            }
            for (i = 0; i < engines.length; ++i) {
                Engine e = engines[i];
                if (e.getSelectionState() != 2 || selected_engine_set.contains(e)) continue;
                e.setSelectionState(0);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            if (e instanceof MetaSearchException) {
                throw (MetaSearchException)e;
            }
            throw new MetaSearchException("Failed to set selected engines", e);
        }
    }

    @Override
    public Engine addEngine(long id, int type, String name, String json_value) throws MetaSearchException {
        if (id == -1L) {
            id = this.getLocalTemplateID();
        }
        try {
            Engine engine = this.meta_search.importFromJSONString(type, id, SystemTime.getCurrentTime(), 1.0f, name, json_value);
            engine.setSource(2);
            engine.setSelectionState(2);
            this.meta_search.addEngine(engine);
            return engine;
        }
        catch (Throwable e) {
            throw new MetaSearchException("Failed to add engine", e);
        }
    }

    @Override
    public boolean isImportable(VuzeFile vf) {
        VuzeFileComponent[] comps = vf.getComponents();
        for (int j = 0; j < comps.length; ++j) {
            VuzeFileComponent comp2 = comps[j];
            int comp_type = comp2.getType();
            if (comp_type != 1) continue;
            try {
                EngineImpl engine = (EngineImpl)this.meta_search.importFromBEncodedMap(comp2.getContent());
                long id = engine.getId();
                Engine existing = this.meta_search.getEngine(id);
                if (existing != null) {
                    int state = existing.getSelectionState();
                    if (state != 0 && state != 3 && existing.sameLogicAs(engine)) continue;
                    return true;
                }
                try {
                    Engine[] engines = this.meta_search.getEngines(false, false);
                    boolean is_new = true;
                    for (Engine e : engines) {
                        int state = e.getSelectionState();
                        if (state == 0 || state == 3 || !e.sameLogicAs(engine)) continue;
                        is_new = false;
                        break;
                    }
                    if (!is_new) continue;
                    return true;
                }
                catch (Throwable e) {}
                continue;
            }
            catch (Throwable e) {
                // empty catch block
            }
        }
        return false;
    }

    @Override
    public Engine importEngine(Map map, boolean warn_user) throws MetaSearchException {
        Object object = import_lock;
        synchronized (object) {
            try {
                String details;
                UIManager ui_manager;
                EngineImpl engine = (EngineImpl)this.meta_search.importFromBEncodedMap(map);
                long id = engine.getId();
                Engine existing = this.meta_search.getEngine(id);
                if (existing != null) {
                    if (existing.sameLogicAs(engine)) {
                        if (warn_user) {
                            UIManager ui_manager2 = StaticUtilities.getUIManager(120000L);
                            String details2 = MessageText.getString("metasearch.addtemplate.dup.desc", new String[]{engine.getName()});
                            ui_manager2.showMessageBox("metasearch.addtemplate.dup.title", "!" + details2 + "!", 1L);
                        }
                        return existing;
                    }
                } else {
                    try {
                        Engine[] engines;
                        for (Engine e : engines = this.meta_search.getEngines(false, false)) {
                            if (!e.sameLogicAs(engine)) continue;
                            return e;
                        }
                    }
                    catch (Throwable e) {
                        // empty catch block
                    }
                }
                if (warn_user) {
                    ui_manager = StaticUtilities.getUIManager(120000L);
                    details = MessageText.getString("metasearch.addtemplate.desc", new String[]{engine.getName()});
                    long res = ui_manager.showMessageBox("metasearch.addtemplate.title", "!" + details + "!", 12L);
                    if (res != 4L) {
                        throw new MetaSearchException("User declined the template");
                    }
                }
                if (id >= 0L && id < Integer.MAX_VALUE) {
                    id = this.getLocalTemplateID();
                    engine.setId(id);
                }
                engine.setSource(2);
                engine.setSelectionState(2);
                this.meta_search.addEngine(engine);
                if (warn_user) {
                    ui_manager = StaticUtilities.getUIManager(120000L);
                    details = MessageText.getString("metasearch.addtemplate.done.desc", new String[]{engine.getName()});
                    ui_manager.showMessageBox("metasearch.addtemplate.done.title", "!" + details + "!", 1L);
                }
                return engine;
            }
            catch (Throwable e) {
                if (warn_user) {
                    UIManager ui_manager = StaticUtilities.getUIManager(120000L);
                    String details = MessageText.getString("metasearch.addtemplate.failed.desc", new String[]{Debug.getNestedExceptionMessage(e)});
                    ui_manager.showMessageBox("metasearch.addtemplate.failed.title", "!" + details + "!", 1L);
                }
                throw new MetaSearchException("Failed to add engine", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addPotentialAssociation(EngineImpl engine, String key) {
        if (engine.isShareable() && !engine.isAuthenticated()) {
            Map<String, EngineImpl> map = this.potential_associations;
            synchronized (map) {
                this.potential_associations.put(key, engine);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkPotentialAssociations(byte[] hash, String key) {
        EngineImpl engine;
        Map<String, EngineImpl> map = this.potential_associations;
        synchronized (map) {
            engine = this.potential_associations.remove(key);
        }
        if (engine != null) {
            try {
                VuzeFile vf = engine.exportToVuzeFile(true);
                byte[] bytes = vf.exportToBytes();
                String url_str = "vuze://?body=" + new String(bytes, "ISO-8859-1");
                SubscriptionManager sub_man = SubscriptionManagerFactory.getSingleton();
                Subscription subs = sub_man.createSingletonRSS(vf.getName() + ": " + engine.getName() + " (v" + engine.getVersion() + ")", new URL(url_str), Integer.MAX_VALUE);
                subs.setSubscribed(true);
                subs.addAssociation(hash);
            }
            catch (Throwable e) {
                Debug.out(e);
            }
        }
    }

    public Engine[] loadFromVuzeFile(File file) {
        VuzeFile vf = VuzeFileHandler.getSingleton().loadVuzeFile(file.getAbsolutePath());
        if (vf != null) {
            return this.loadFromVuzeFile(vf);
        }
        return new Engine[0];
    }

    public Engine[] loadFromVuzeFile(VuzeFile vf) {
        ArrayList<Engine> result = new ArrayList<Engine>();
        VuzeFileComponent[] comps = vf.getComponents();
        for (int j = 0; j < comps.length; ++j) {
            VuzeFileComponent comp2 = comps[j];
            if (comp2.getType() != 1) continue;
            try {
                result.add(this.importEngine(comp2.getContent(), false));
                continue;
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
        return result.toArray(new Engine[result.size()]);
    }

    public long getLocalTemplateID() {
        MetaSearchManagerImpl metaSearchManagerImpl = this;
        synchronized (metaSearchManagerImpl) {
            long id;
            Random random = new Random();
            while (this.meta_search.getEngine(id = Integer.MAX_VALUE + (long)random.nextInt(Integer.MAX_VALUE)) != null) {
            }
            return id;
        }
    }

    @Override
    public boolean getProxyRequestsEnabled() {
        return this.proxy_requests_enabled;
    }

    @Override
    public void setProxyRequestsEnabled(boolean enabled) {
        COConfigurationManager.setParameter("metasearch.config.proxy.enable", enabled);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(MetaSearchManagerListener listener) {
        List<MetaSearchManagerListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(listener);
        }
        this.dispatchOps();
    }

    @Override
    public void removeListener(MetaSearchManagerListener listener) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addOperation(Map map) {
        List<MetaSearchManagerListener> list = this.listeners;
        synchronized (list) {
            this.operations.add(map);
        }
        this.dispatchOps();
    }

    private void dispatchOps() {
        this.op_dispatcher.dispatch(new AERunnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void runSupport() {
                ArrayList o;
                ArrayList l;
                List list = MetaSearchManagerImpl.this.listeners;
                synchronized (list) {
                    if (MetaSearchManagerImpl.this.listeners.size() == 0 || MetaSearchManagerImpl.this.operations.size() == 0) {
                        return;
                    }
                    l = new ArrayList(MetaSearchManagerImpl.this.listeners);
                    o = new ArrayList(MetaSearchManagerImpl.this.operations);
                    MetaSearchManagerImpl.this.operations.clear();
                }
                for (MetaSearchManagerListener listener : l) {
                    for (Map operation : o) {
                        try {
                            int type = ImportExportUtils.importInt(operation, "type", -1);
                            if (type == 1) {
                                String term = ImportExportUtils.importString(operation, "term", null);
                                if (term == null) {
                                    Debug.out("search term missing");
                                    continue;
                                }
                                listener.searchRequest(term);
                                continue;
                            }
                            Debug.out("unknown operation type " + type);
                        }
                        catch (Throwable e) {
                            Debug.out(e);
                        }
                    }
                }
            }
        });
    }

    private void setupExtensions() {
        PluginInterface pi = PluginInitializer.getDefaultInterface();
        final FeatureManager fm = pi.getUtilities().getFeatureManager();
        fm.addListener(new FeatureManager.FeatureManagerListener(){

            @Override
            public void licenceAdded(FeatureManager.Licence licence) {
                MetaSearchManagerImpl.this.getExtensions(fm, false);
            }

            @Override
            public void licenceChanged(FeatureManager.Licence licence) {
                MetaSearchManagerImpl.this.getExtensions(fm, false);
            }

            @Override
            public void licenceRemoved(FeatureManager.Licence licence) {
                MetaSearchManagerImpl.this.getExtensions(fm, false);
            }
        });
        if (pi.getPluginState().isInitialisationComplete()) {
            this.getExtensions(fm, true);
        } else {
            pi.addListener(new PluginListener(){

                @Override
                public void initializationComplete() {
                    MetaSearchManagerImpl.this.getExtensions(fm, false);
                }

                @Override
                public void closedownInitiated() {
                }

                @Override
                public void closedownComplete() {
                }
            });
        }
    }

    private void getExtensions(FeatureManager fm, boolean init) {
        FeatureManager.FeatureDetails[] fds;
        String existing_ext = this.extension_key;
        String latest_ext = null;
        for (FeatureManager.FeatureDetails fd : fds = fm.getFeatureDetails("core")) {
            String finger_print;
            if (fd.hasExpired() || (finger_print = (String)fd.getProperty("Fingerprint")) == null) continue;
            latest_ext = fd.getLicence().getShortID() + "-" + finger_print;
            break;
        }
        if (!(existing_ext == latest_ext || existing_ext != null && latest_ext != null && existing_ext.equals(latest_ext))) {
            this.extension_key = latest_ext;
            COConfigurationManager.setParameter("metasearch.extkey.latest", latest_ext == null ? "" : latest_ext);
            if (!init) {
                this.refresh();
            }
        }
    }

    protected String getExtensionKey() {
        return this.extension_key;
    }

    public void log(String s, Throwable e) {
        AEDiagnosticsLogger diag_logger = AEDiagnostics.getLogger(LOGGER_NAME);
        diag_logger.log(s);
        diag_logger.log(e);
        if (ConstantsVuze.DIAG_TO_STDOUT) {
            System.out.println(Thread.currentThread().getName() + "|" + System.currentTimeMillis() + "] " + s + ": " + Debug.getNestedExceptionMessage(e));
        }
    }

    @Override
    public void log(String s) {
        AEDiagnosticsLogger diag_logger = AEDiagnostics.getLogger(LOGGER_NAME);
        diag_logger.log(s);
        if (ConstantsVuze.DIAG_TO_STDOUT) {
            System.out.println(Thread.currentThread().getName() + "|" + System.currentTimeMillis() + "] " + s);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void generate(IndentWriter writer) {
        writer.println("Metasearch: auto=" + this.isAutoMode());
        try {
            writer.indent();
            this.meta_search.generate(writer);
        }
        finally {
            writer.exdent();
        }
    }

    public static void main(String[] args) {
        try {
            VuzeFile vf = VuzeFileHandler.getSingleton().create();
            HashMap<String, Object> contents = new HashMap<String, Object>();
            contents.put("type", new Long(1L));
            contents.put("term", "donkey");
            vf.addComponent(256, contents);
            vf.write(new File("C:\\temp\\search.vuze"));
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    static {
        import_lock = new Object();
    }

    protected static class SearchObject
    implements Search,
    ResultListener {
        private SearchListener listener;
        private Map<Long, engineInfo> engine_map = new HashMap<Long, engineInfo>();
        private boolean engines_set;
        private List<SearchProviderResults> pending_results = new ArrayList<SearchProviderResults>();
        private boolean is_complete;

        protected SearchObject(SearchListener _listener) {
            this.listener = _listener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void setEnginesUsed(Engine[] engines) {
            boolean report_complete;
            Map<Long, engineInfo> map = this.engine_map;
            synchronized (map) {
                for (Engine e : engines) {
                    this.getInfo(e);
                }
                this.engines_set = true;
                report_complete = this.reportOverallComplete();
            }
            if (this.listener != null && report_complete) {
                this.listener.completed();
            }
        }

        private boolean reportOverallComplete() {
            if (this.is_complete || !this.engines_set) {
                return false;
            }
            for (engineInfo info : this.engine_map.values()) {
                if (info.isComplete()) continue;
                return false;
            }
            this.is_complete = true;
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected engineInfo getInfo(Engine engine) {
            Map<Long, engineInfo> map = this.engine_map;
            synchronized (map) {
                engineInfo res = this.engine_map.get(engine.getId());
                if (res == null) {
                    res = new engineInfo(engine);
                    this.engine_map.put(engine.getId(), res);
                }
                return res;
            }
        }

        @Override
        public void contentReceived(Engine engine, String content) {
        }

        @Override
        public void matchFound(Engine engine, String[] fields) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void resultsReceived(Engine engine, final Result[] results) {
            SearchProviderResults result;
            Map<Long, engineInfo> map = this.engine_map;
            synchronized (map) {
                final engineInfo info = this.getInfo(engine);
                result = new SearchProviderResults(){

                    @Override
                    public SearchProvider getProvider() {
                        return info;
                    }

                    @Override
                    public SearchResult[] getResults() {
                        return SearchObject.this.wrapResults(results);
                    }

                    @Override
                    public boolean isComplete() {
                        return false;
                    }

                    @Override
                    public SearchException getError() {
                        return null;
                    }
                };
                this.pending_results.add(result);
            }
            if (this.listener != null) {
                this.listener.receivedResults(new SearchProviderResults[]{result});
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void resultsComplete(Engine engine) {
            SearchProviderResults result;
            boolean report_complete;
            Map<Long, engineInfo> map = this.engine_map;
            synchronized (map) {
                final engineInfo info = this.getInfo(engine);
                info.setComplete();
                report_complete = this.reportOverallComplete();
                result = new SearchProviderResults(){

                    @Override
                    public SearchProvider getProvider() {
                        return info;
                    }

                    @Override
                    public SearchResult[] getResults() {
                        return new SearchResult[0];
                    }

                    @Override
                    public boolean isComplete() {
                        return true;
                    }

                    @Override
                    public SearchException getError() {
                        return null;
                    }
                };
                this.pending_results.add(result);
            }
            if (this.listener != null) {
                this.listener.receivedResults(new SearchProviderResults[]{result});
                if (report_complete) {
                    this.listener.completed();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void failed(Engine engine, final SearchException error) {
            SearchProviderResults result;
            boolean report_complete;
            Map<Long, engineInfo> map = this.engine_map;
            synchronized (map) {
                final engineInfo info = this.getInfo(engine);
                info.setComplete();
                report_complete = this.reportOverallComplete();
                result = new SearchProviderResults(){

                    @Override
                    public SearchProvider getProvider() {
                        return info;
                    }

                    @Override
                    public SearchResult[] getResults() {
                        return new SearchResult[0];
                    }

                    @Override
                    public boolean isComplete() {
                        return false;
                    }

                    @Override
                    public SearchException getError() {
                        return error;
                    }
                };
                this.pending_results.add(result);
            }
            if (this.listener != null) {
                this.listener.receivedResults(new SearchProviderResults[]{result});
                if (report_complete) {
                    this.listener.completed();
                }
            }
        }

        @Override
        public void engineFailed(Engine engine, Throwable cause) {
            this.failed(engine, new SearchException("Search failed", cause));
        }

        @Override
        public void engineRequiresLogin(Engine engine, Throwable cause) {
            this.failed(engine, new SearchException("Authentication required", cause));
        }

        protected SearchResult[] wrapResults(Result[] res) {
            SearchResult[] x = new SearchResult[res.length];
            for (int i = 0; i < x.length; ++i) {
                x[i] = new resultWrapper(res[i]);
            }
            return x;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SearchProviderResults[] getResults() {
            Map<Long, engineInfo> map = this.engine_map;
            synchronized (map) {
                SearchProviderResults[] result = this.pending_results.toArray(new SearchProviderResults[this.pending_results.size()]);
                this.pending_results.clear();
                return result;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isComplete() {
            Map<Long, engineInfo> map = this.engine_map;
            synchronized (map) {
                if (!this.is_complete) {
                    return false;
                }
                return this.pending_results.size() <= 0;
                {
                }
            }
        }

        protected static class resultWrapper
        implements SearchResult {
            private Result result;

            protected resultWrapper(Result _result) {
                this.result = _result;
            }

            @Override
            public Object getProperty(int property_name) {
                switch (property_name) {
                    case 22: {
                        return -1L;
                    }
                    case 1: {
                        return this.result.getName();
                    }
                    case 2: {
                        return this.result.getPublishedDate();
                    }
                    case 3: {
                        return this.result.getSize();
                    }
                    case 4: {
                        return new Long(this.result.getNbPeers());
                    }
                    case 5: {
                        return new Long(this.result.getNbSeeds());
                    }
                    case 6: {
                        return new Long(this.result.getNbSuperSeeds());
                    }
                    case 7: {
                        return this.result.getCategory();
                    }
                    case 8: {
                        return new Long(this.result.getComments());
                    }
                    case 9: {
                        return new Long(this.result.getVotes());
                    }
                    case 10: {
                        return this.result.getContentType();
                    }
                    case 11: {
                        return this.result.getCDPLink();
                    }
                    case 12: {
                        return this.result.getDownloadLink();
                    }
                    case 23: {
                        return this.result.getTorrentLink();
                    }
                    case 13: {
                        return this.result.getPlayLink();
                    }
                    case 14: {
                        return this.result.isPrivate();
                    }
                    case 15: {
                        return this.result.getDRMKey();
                    }
                    case 16: {
                        return this.result.getDownloadButtonLink();
                    }
                    case 17: {
                        float rank = this.result.getRank();
                        return new Long(rank == -1.0f ? -1L : (long)(rank * 100.0f));
                    }
                    case 18: {
                        float accuracy = this.result.getAccuracy();
                        return new Long(accuracy == -1.0f ? -1L : (long)(accuracy * 100.0f));
                    }
                    case 19: {
                        return new Long(this.result.getVotesDown());
                    }
                    case 20: {
                        return this.result.getUID();
                    }
                    case 21: {
                        String base32_hash = this.result.getHash();
                        if (base32_hash != null) {
                            return Base32.decode(base32_hash);
                        }
                        return null;
                    }
                }
                Debug.out("Unknown property type " + property_name);
                return null;
            }
        }
    }

    protected static class engineInfo
    implements SearchProvider {
        private Engine engine;
        private boolean complete;

        protected engineInfo(Engine _engine) {
            this.engine = _engine;
        }

        protected void setComplete() {
            this.complete = true;
        }

        protected boolean isComplete() {
            return this.complete;
        }

        @Override
        public SearchInstance search(Map<String, Object> search_parameters, SearchObserver observer) throws SearchException {
            throw new SearchException("Not supported");
        }

        @Override
        public Object getProperty(int property) {
            if (property == 0) {
                return this.engine.getId();
            }
            if (property == 1) {
                return this.engine.getName();
            }
            return null;
        }

        @Override
        public void setProperty(int property, Object value) {
            Debug.out("Not supported");
        }
    }
}

