/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.lws;

import com.aelitis.azureus.core.lws.LightWeightSeed;
import com.aelitis.azureus.core.peermanager.PeerManagerRegistration;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Map;
import org.gudy.azureus2.core3.disk.DiskManagerReadRequest;
import org.gudy.azureus2.core3.disk.DiskManagerReadRequestListener;
import org.gudy.azureus2.core3.logging.LogRelation;
import org.gudy.azureus2.core3.peer.PEPeer;
import org.gudy.azureus2.core3.peer.PEPeerManagerAdapter;
import org.gudy.azureus2.core3.peer.PEPiece;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.tracker.client.TRTrackerScraperResponse;
import org.gudy.azureus2.core3.util.AENetworkClassifier;
import org.gudy.azureus2.core3.util.BEncoder;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.pluginsimpl.local.PluginCoreUtils;

public class LWSPeerManagerAdapter
extends LogRelation
implements PEPeerManagerAdapter {
    private final LightWeightSeed lws;
    private final PeerManagerRegistration peer_manager_registration;
    private final String[] enabled_networks;
    private int md_info_dict_size;
    private WeakReference<byte[]> md_info_dict_ref = new WeakReference<Object>(null);

    public LWSPeerManagerAdapter(LightWeightSeed _lws, PeerManagerRegistration _peer_manager_registration) {
        this.lws = _lws;
        String main_net = this.lws.getNetwork();
        this.enabled_networks = main_net.equals("Public") ? AENetworkClassifier.AT_NETWORKS : AENetworkClassifier.AT_NON_PUBLIC;
        this.peer_manager_registration = _peer_manager_registration;
    }

    @Override
    public String getDisplayName() {
        return this.lws.getName();
    }

    @Override
    public PeerManagerRegistration getPeerManagerRegistration() {
        return this.peer_manager_registration;
    }

    @Override
    public int getUploadRateLimitBytesPerSecond() {
        return 0;
    }

    @Override
    public int getDownloadRateLimitBytesPerSecond() {
        return 0;
    }

    @Override
    public int getPermittedBytesToReceive() {
        return Integer.MAX_VALUE;
    }

    @Override
    public void permittedReceiveBytesUsed(int bytes) {
    }

    @Override
    public int getPermittedBytesToSend() {
        return Integer.MAX_VALUE;
    }

    @Override
    public void permittedSendBytesUsed(int bytes) {
    }

    @Override
    public int getUploadPriority() {
        return 0;
    }

    @Override
    public int getMaxUploads() {
        return 4;
    }

    @Override
    public int[] getMaxConnections() {
        return new int[]{0, 0};
    }

    @Override
    public int[] getMaxSeedConnections() {
        return new int[]{0, 0};
    }

    @Override
    public int getExtendedMessagingMode() {
        return 2;
    }

    @Override
    public boolean isPeerExchangeEnabled() {
        return true;
    }

    @Override
    public boolean isNetworkEnabled(String network) {
        for (String net : this.enabled_networks) {
            if (net != network) continue;
            return true;
        }
        return false;
    }

    @Override
    public String[] getEnabledNetworks() {
        return this.enabled_networks;
    }

    @Override
    public int getCryptoLevel() {
        return 0;
    }

    @Override
    public long getRandomSeed() {
        return 0L;
    }

    @Override
    public boolean isPeriodicRescanEnabled() {
        return false;
    }

    @Override
    public void setStateFinishing() {
    }

    @Override
    public void setStateSeeding(boolean never_downloaded) {
    }

    @Override
    public void restartDownload(boolean recheck) {
        Debug.out("restartDownload called for " + this.getDisplayName());
    }

    @Override
    public TRTrackerScraperResponse getTrackerScrapeResponse() {
        return null;
    }

    @Override
    public String getTrackerClientExtensions() {
        return null;
    }

    @Override
    public void setTrackerRefreshDelayOverrides(int percent) {
    }

    @Override
    public boolean isMetadataDownload() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getTorrentInfoDictSize() {
        LWSPeerManagerAdapter lWSPeerManagerAdapter = this;
        synchronized (lWSPeerManagerAdapter) {
            if (this.md_info_dict_size == 0) {
                byte[] data = this.getTorrentInfoDict(null);
                this.md_info_dict_size = data == null ? -1 : data.length;
            }
            return this.md_info_dict_size;
        }
    }

    @Override
    public byte[] getTorrentInfoDict(PEPeer peer) {
        try {
            byte[] data = (byte[])this.md_info_dict_ref.get();
            if (data == null) {
                TOTorrent torrent = PluginCoreUtils.unwrap(this.lws.getTorrent());
                data = BEncoder.encode((Map)torrent.serialiseToMap().get("info"));
                this.md_info_dict_ref = new WeakReference<byte[]>(data);
            }
            return data;
        }
        catch (Throwable e) {
            return null;
        }
    }

    @Override
    public boolean isNATHealthy() {
        return true;
    }

    @Override
    public void addPeer(PEPeer peer) {
    }

    @Override
    public void removePeer(PEPeer peer) {
    }

    @Override
    public void addPiece(PEPiece piece) {
    }

    @Override
    public void removePiece(PEPiece piece) {
    }

    @Override
    public void discarded(PEPeer peer, int bytes) {
    }

    @Override
    public void protocolBytesReceived(PEPeer peer, int bytes) {
    }

    @Override
    public void dataBytesReceived(PEPeer peer, int bytes) {
    }

    @Override
    public void protocolBytesSent(PEPeer peer, int bytes) {
    }

    @Override
    public void dataBytesSent(PEPeer peer, int bytes) {
    }

    @Override
    public void statsRequest(PEPeer originator, Map request2, Map reply) {
    }

    @Override
    public void addHTTPSeed(String address, int port) {
    }

    @Override
    public byte[][] getSecrets(int crypto_level) {
        return this.lws.getSecrets();
    }

    @Override
    public void enqueueReadRequest(PEPeer peer, DiskManagerReadRequest request2, DiskManagerReadRequestListener listener) {
        this.lws.enqueueReadRequest(peer, request2, listener);
    }

    @Override
    public int getPosition() {
        return Integer.MAX_VALUE;
    }

    @Override
    public boolean isPeerSourceEnabled(String peer_source) {
        return true;
    }

    @Override
    public boolean hasPriorityConnection() {
        return false;
    }

    @Override
    public void priorityConnectionChanged(boolean added) {
    }

    @Override
    public LogRelation getLogRelation() {
        return this;
    }

    @Override
    public String getRelationText() {
        return this.lws.getRelationText();
    }

    @Override
    public Object[] getQueryableInterfaces() {
        ArrayList<Object> interfaces = new ArrayList<Object>();
        Object[] intf = this.lws.getQueryableInterfaces();
        for (int i = 0; i < intf.length; ++i) {
            if (intf[i] == null) continue;
            interfaces.add(intf[i]);
        }
        interfaces.add(this.lws.getRelation());
        return interfaces.toArray();
    }
}

