/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.lws;

import com.aelitis.azureus.core.diskmanager.access.DiskAccessController;
import com.aelitis.azureus.core.diskmanager.cache.CacheFile;
import com.aelitis.azureus.core.lws.LWSDiskManagerState;
import com.aelitis.azureus.core.lws.LightWeightSeed;
import java.io.File;
import org.gudy.azureus2.core3.disk.DiskManager;
import org.gudy.azureus2.core3.disk.DiskManagerCheckRequest;
import org.gudy.azureus2.core3.disk.DiskManagerCheckRequestListener;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfo;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfoSet;
import org.gudy.azureus2.core3.disk.DiskManagerListener;
import org.gudy.azureus2.core3.disk.DiskManagerPiece;
import org.gudy.azureus2.core3.disk.DiskManagerReadRequest;
import org.gudy.azureus2.core3.disk.DiskManagerReadRequestListener;
import org.gudy.azureus2.core3.disk.DiskManagerWriteRequest;
import org.gudy.azureus2.core3.disk.DiskManagerWriteRequestListener;
import org.gudy.azureus2.core3.disk.impl.DiskManagerFileInfoImpl;
import org.gudy.azureus2.core3.disk.impl.DiskManagerHelper;
import org.gudy.azureus2.core3.disk.impl.DiskManagerImpl;
import org.gudy.azureus2.core3.disk.impl.DiskManagerPieceImpl;
import org.gudy.azureus2.core3.disk.impl.DiskManagerRecheckScheduler;
import org.gudy.azureus2.core3.disk.impl.DiskManagerUtil;
import org.gudy.azureus2.core3.disk.impl.access.DMAccessFactory;
import org.gudy.azureus2.core3.disk.impl.access.DMChecker;
import org.gudy.azureus2.core3.disk.impl.access.DMReader;
import org.gudy.azureus2.core3.disk.impl.piecemapper.DMPieceList;
import org.gudy.azureus2.core3.disk.impl.piecemapper.DMPieceMap;
import org.gudy.azureus2.core3.disk.impl.piecemapper.DMPieceMapper;
import org.gudy.azureus2.core3.disk.impl.piecemapper.DMPieceMapperFactory;
import org.gudy.azureus2.core3.disk.impl.piecemapper.DMPieceMapperFile;
import org.gudy.azureus2.core3.download.DownloadManagerState;
import org.gudy.azureus2.core3.internat.LocaleTorrentUtil;
import org.gudy.azureus2.core3.internat.LocaleUtilDecoder;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentException;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DirectByteBuffer;
import org.gudy.azureus2.core3.util.IndentWriter;

public class LWSDiskManager
implements DiskManagerHelper {
    private static final sePiece piece = new sePiece();
    private final LightWeightSeed lws;
    private final DiskAccessController disk_access_controller;
    private final File save_file;
    private DMReader reader;
    private DMChecker checker_use_accessor;
    private DMPieceMapper piece_mapper;
    private DMPieceMap piece_map_use_accessor;
    private final sePiece[] pieces;
    private DiskManagerFileInfoImpl[] files;
    private String internal_name;
    private final DownloadManagerState download_state;
    private boolean started;
    private int state = 1;
    private String error_message = "";
    private int error_type = 0;

    protected LWSDiskManager(LightWeightSeed _lws, File _save_file) {
        this.lws = _lws;
        this.save_file = _save_file;
        this.disk_access_controller = DiskManagerImpl.getDefaultDiskAccessController();
        this.download_state = new LWSDiskManagerState();
        TOTorrent torrent = this.lws.getTOTorrent(false);
        this.pieces = new sePiece[torrent.getNumberOfPieces()];
        for (int i = 0; i < this.pieces.length; ++i) {
            this.pieces[i] = piece;
        }
    }

    public String getName() {
        return this.lws.getName();
    }

    @Override
    public int getCacheMode() {
        return 1;
    }

    @Override
    public long[] getReadStats() {
        if (this.reader == null) {
            return new long[]{0L, 0L};
        }
        return this.reader.getStats();
    }

    @Override
    public void start() {
        try {
            TOTorrent torrent = this.lws.getTOTorrent(false);
            this.internal_name = ByteFormatter.nicePrint(torrent.getHash(), true);
            LocaleUtilDecoder locale_decoder = LocaleTorrentUtil.getTorrentEncoding(torrent);
            this.piece_mapper = DMPieceMapperFactory.create(torrent);
            this.piece_mapper.construct(locale_decoder, this.save_file.getName());
            this.files = this.getFileInfo(this.piece_mapper.getFiles(), this.save_file);
            this.reader = DMAccessFactory.createReader(this);
            this.reader.start();
            if (this.state != 10) {
                this.started = true;
                this.state = 4;
            }
        }
        catch (Throwable e) {
            this.setFailed("start failed - " + Debug.getNestedExceptionMessage(e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DiskManagerFileInfoImpl[] getFileInfo(DMPieceMapperFile[] pm_files, File save_location) {
        boolean ok = false;
        DiskManagerFileInfoImpl[] local_files = new DiskManagerFileInfoImpl[pm_files.length];
        try {
            TOTorrent torrent = this.lws.getTOTorrent(false);
            if (torrent.isSimpleTorrent()) {
                save_location = save_location.getParentFile();
            }
            for (int i = 0; i < pm_files.length; ++i) {
                DiskManagerFileInfoImpl file_info;
                DMPieceMapperFile pm_info = pm_files[i];
                File relative_file = pm_info.getDataFile();
                long target_length = pm_info.getLength();
                local_files[i] = file_info = new DiskManagerFileInfoImpl(this, save_location.toString(), relative_file, i, pm_info.getTorrentFile(), 1);
                CacheFile cache_file = file_info.getCacheFile();
                File data_file = file_info.getFile(true);
                if (!cache_file.exists()) {
                    throw new Exception("File '" + data_file + "' doesn't exist");
                }
                if (cache_file.getLength() != target_length) {
                    throw new Exception("File '" + data_file + "' doesn't exist");
                }
                pm_info.setFileInfo(file_info);
            }
            ok = true;
            DiskManagerFileInfoImpl[] diskManagerFileInfoImplArray = local_files;
            return diskManagerFileInfoImplArray;
        }
        catch (Throwable e) {
            this.setFailed("getFiles failed - " + Debug.getNestedExceptionMessage(e));
            DiskManagerFileInfoImpl[] diskManagerFileInfoImplArray = null;
            return diskManagerFileInfoImplArray;
        }
        finally {
            if (!ok) {
                for (int i = 0; i < local_files.length; ++i) {
                    if (local_files[i] == null) continue;
                    local_files[i].close();
                }
            }
        }
    }

    @Override
    public void setPieceDone(DiskManagerPieceImpl dmPiece, boolean done) {
    }

    @Override
    public boolean stop(boolean closing) {
        this.started = false;
        if (this.reader != null) {
            this.reader.stop();
            this.reader = null;
        }
        if (this.files != null) {
            for (int i = 0; i < this.files.length; ++i) {
                try {
                    this.files[i].getCacheFile().close();
                    continue;
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        }
        return false;
    }

    @Override
    public boolean isStopped() {
        return !this.started;
    }

    @Override
    public boolean filesExist() {
        throw new RuntimeException("filesExist not implemented");
    }

    @Override
    public DiskManagerWriteRequest createWriteRequest(int pieceNumber, int offset, DirectByteBuffer data, Object user_data) {
        throw new RuntimeException("createWriteRequest not implemented");
    }

    @Override
    public void enqueueWriteRequest(DiskManagerWriteRequest request2, DiskManagerWriteRequestListener listener) {
        throw new RuntimeException("enqueueWriteRequest not implemented");
    }

    @Override
    public boolean hasOutstandingWriteRequestForPiece(int piece_number) {
        throw new RuntimeException("hasOutstandingWriteRequestForPiece not implemented");
    }

    @Override
    public boolean hasOutstandingReadRequestForPiece(int piece_number) {
        throw new RuntimeException("hasOutstandingReadRequestForPiece not implemented");
    }

    @Override
    public boolean hasOutstandingCheckRequestForPiece(int piece_number) {
        throw new RuntimeException("hasOutstandingCheckRequestForPiece not implemented");
    }

    @Override
    public DirectByteBuffer readBlock(int pieceNumber, int offset, int length) {
        return this.reader.readBlock(pieceNumber, offset, length);
    }

    @Override
    public DiskManagerReadRequest createReadRequest(int pieceNumber, int offset, int length) {
        return this.reader.createReadRequest(pieceNumber, offset, length);
    }

    @Override
    public void enqueueReadRequest(DiskManagerReadRequest request2, DiskManagerReadRequestListener listener) {
        this.reader.readBlock(request2, listener);
    }

    @Override
    public DiskManagerCheckRequest createCheckRequest(int pieceNumber, Object user_data) {
        DMChecker checker = this.getChecker();
        return checker.createCheckRequest(pieceNumber, user_data);
    }

    @Override
    public void enqueueCheckRequest(DiskManagerCheckRequest request2, DiskManagerCheckRequestListener listener) {
        DMChecker checker = this.getChecker();
        checker.enqueueCheckRequest(request2, listener);
    }

    @Override
    public void enqueueCompleteRecheckRequest(DiskManagerCheckRequest request2, DiskManagerCheckRequestListener listener) {
        throw new RuntimeException("enqueueCompleteRecheckRequest not implemented");
    }

    @Override
    public void setPieceCheckingEnabled(boolean enabled) {
    }

    @Override
    public void saveResumeData(boolean interim_save) {
    }

    @Override
    public DiskManagerPiece[] getPieces() {
        return this.pieces;
    }

    @Override
    public DiskManagerPiece getPiece(int index) {
        return this.pieces[index];
    }

    @Override
    public boolean isInteresting(int piece_num) {
        return false;
    }

    @Override
    public boolean isDone(int piece_num) {
        return false;
    }

    @Override
    public int getNbPieces() {
        return this.pieces.length;
    }

    @Override
    public DiskManagerFileInfo[] getFiles() {
        return this.files;
    }

    @Override
    public DiskManagerFileInfoSet getFileSet() {
        throw new RuntimeException("getFileSet not implemented");
    }

    @Override
    public int getState() {
        return this.state;
    }

    @Override
    public long getTotalLength() {
        return this.piece_mapper.getTotalLength();
    }

    @Override
    public int getPieceLength() {
        return this.piece_mapper.getPieceLength();
    }

    @Override
    public int getPieceLength(int piece_number) {
        if (piece_number == this.pieces.length - 1) {
            return this.piece_mapper.getLastPieceLength();
        }
        return this.piece_mapper.getPieceLength();
    }

    public int getLastPieceLength() {
        return this.piece_mapper.getLastPieceLength();
    }

    @Override
    public long getRemaining() {
        return 0L;
    }

    @Override
    public long getRemainingExcludingDND() {
        return 0L;
    }

    @Override
    public int getPercentDone() {
        return 100;
    }

    @Override
    public int getPercentDoneExcludingDND() {
        return 1000;
    }

    @Override
    public long getSizeExcludingDND() {
        return this.getTotalLength();
    }

    @Override
    public String getErrorMessage() {
        return this.error_message;
    }

    @Override
    public int getErrorType() {
        return this.error_type;
    }

    @Override
    public void downloadEnded(DiskManager.OperationStatus op_status) {
    }

    @Override
    public void moveDataFiles(File new_parent_dir, String new_name, DiskManager.OperationStatus op_status) {
        throw new RuntimeException("moveDataFiles not implemented");
    }

    @Override
    public int getCompleteRecheckStatus() {
        return -1;
    }

    @Override
    public int getMoveProgress() {
        return -1;
    }

    @Override
    public boolean checkBlockConsistencyForWrite(String originator, int pieceNumber, int offset, DirectByteBuffer data) {
        long pos = (long)pieceNumber * (long)this.piece_mapper.getPieceLength() + (long)offset + (long)data.remaining((byte)1);
        return pos <= this.piece_mapper.getTotalLength();
    }

    @Override
    public boolean checkBlockConsistencyForRead(String originator, boolean peer_request, int pieceNumber, int offset, int length) {
        return DiskManagerUtil.checkBlockConsistencyForRead(this, originator, peer_request, pieceNumber, offset, length);
    }

    @Override
    public boolean checkBlockConsistencyForHint(String originator, int pieceNumber, int offset, int length) {
        return DiskManagerUtil.checkBlockConsistencyForHint(this, originator, pieceNumber, offset, length);
    }

    @Override
    public void addListener(DiskManagerListener l) {
    }

    @Override
    public void removeListener(DiskManagerListener l) {
    }

    @Override
    public boolean hasListener(DiskManagerListener l) {
        return false;
    }

    @Override
    public void saveState() {
    }

    @Override
    public DiskAccessController getDiskAccessController() {
        return this.disk_access_controller;
    }

    @Override
    public DMPieceMap getPieceMap() {
        DMPieceMap map = this.piece_map_use_accessor;
        if (map == null) {
            this.piece_map_use_accessor = map = this.piece_mapper.getPieceMap();
        }
        return map;
    }

    @Override
    public DMPieceList getPieceList(int piece_number) {
        DMPieceMap map = this.getPieceMap();
        return map.getPieceList(piece_number);
    }

    protected DMChecker getChecker() {
        DMChecker checker = this.checker_use_accessor;
        if (checker == null) {
            checker = this.checker_use_accessor = DMAccessFactory.createChecker(this);
        }
        return checker;
    }

    @Override
    public byte[] getPieceHash(int piece_number) throws TOTorrentException {
        return this.lws.getTorrent().getPieces()[piece_number];
    }

    @Override
    public DiskManagerRecheckScheduler getRecheckScheduler() {
        throw new RuntimeException("getPieceHash not implemented");
    }

    @Override
    public void downloadRemoved() {
    }

    @Override
    public void setFailed(String reason) {
        this.started = false;
        this.state = 10;
        this.error_message = reason;
        this.error_type = 1;
    }

    @Override
    public void setFailed(DiskManagerFileInfo file, String reason) {
        this.started = false;
        this.state = 10;
        this.error_message = reason;
        this.error_type = 1;
    }

    @Override
    public long getAllocated() {
        return 0L;
    }

    @Override
    public void setAllocated(long num) {
    }

    @Override
    public void setPercentDone(int num) {
    }

    @Override
    public TOTorrent getTorrent() {
        return this.lws.getTOTorrent(false);
    }

    @Override
    public String[] getStorageTypes() {
        throw new RuntimeException("getStorageTypes not implemented");
    }

    @Override
    public String getStorageType(int fileIndex) {
        throw new RuntimeException("getStorageType not implemented");
    }

    @Override
    public void accessModeChanged(DiskManagerFileInfoImpl file, int old_mode, int new_mode) {
    }

    @Override
    public void skippedFileSetChanged(DiskManagerFileInfo file) {
    }

    @Override
    public void priorityChanged(DiskManagerFileInfo file) {
    }

    @Override
    public File getSaveLocation() {
        return this.save_file;
    }

    @Override
    public String getInternalName() {
        return this.internal_name;
    }

    @Override
    public DownloadManagerState getDownloadState() {
        return this.download_state;
    }

    @Override
    public long getPriorityChangeMarker() {
        return 0L;
    }

    @Override
    public void generateEvidence(IndentWriter writer) {
    }

    protected static class sePiece
    implements DiskManagerPiece {
        protected sePiece() {
        }

        public void clearChecking() {
            throw new RuntimeException("clearChecking not implemented");
        }

        @Override
        public boolean isNeedsCheck() {
            throw new RuntimeException("isNeedsCheck not implemented");
        }

        @Override
        public boolean spansFiles() {
            throw new RuntimeException("spansfiles not implemented");
        }

        @Override
        public int getLength() {
            throw new RuntimeException("getLength not implemented");
        }

        @Override
        public int getNbBlocks() {
            throw new RuntimeException("getNbBlocks not implemented");
        }

        @Override
        public int getPieceNumber() {
            throw new RuntimeException("getPieceNumber not implemented");
        }

        @Override
        public int getBlockSize(int b) {
            throw new RuntimeException("getBlockSize not implemented");
        }

        @Override
        public boolean isWritten() {
            throw new RuntimeException("isWritten not implemented");
        }

        @Override
        public int getNbWritten() {
            throw new RuntimeException("getNbWritten not implemented");
        }

        @Override
        public boolean[] getWritten() {
            throw new RuntimeException("getWritten not implemented");
        }

        @Override
        public void reDownloadBlock(int blockNumber) {
            throw new RuntimeException("reDownloadBlock not implemented");
        }

        @Override
        public void reset() {
            throw new RuntimeException("reset not implemented");
        }

        @Override
        public boolean isDownloadable() {
            return false;
        }

        @Override
        public void setDownloadable() {
            throw new RuntimeException("setRequestable not implemented");
        }

        @Override
        public DiskManager getManager() {
            throw new RuntimeException("getManager not implemented");
        }

        @Override
        public boolean calcNeeded() {
            throw new RuntimeException("calcNeeded not implemented");
        }

        @Override
        public void clearNeeded() {
            throw new RuntimeException("clearNeeded not implemented");
        }

        @Override
        public boolean isNeeded() {
            throw new RuntimeException("isNeeded not implemented");
        }

        @Override
        public void setNeeded() {
            throw new RuntimeException("setNeeded not implemented");
        }

        @Override
        public void setNeeded(boolean b) {
            throw new RuntimeException("setNeeded not implemented");
        }

        @Override
        public void setWritten(int b) {
            throw new RuntimeException("setWritten not implemented");
        }

        @Override
        public boolean isWritten(int blockNumber) {
            throw new RuntimeException("isWritten not implemented");
        }

        public boolean calcChecking() {
            throw new RuntimeException("calcChecking not implemented");
        }

        @Override
        public boolean isChecking() {
            return false;
        }

        @Override
        public void setChecking() {
            throw new RuntimeException("setChecking not implemented");
        }

        public void setChecking(boolean b) {
            throw new RuntimeException("setChecking not implemented");
        }

        @Override
        public boolean calcDone() {
            throw new RuntimeException("calcDone not implemented");
        }

        @Override
        public boolean isDone() {
            return true;
        }

        @Override
        public boolean isInteresting() {
            return false;
        }

        @Override
        public boolean isSkipped() {
            return false;
        }

        @Override
        public String getString() {
            return "";
        }

        @Override
        public short getReadCount() {
            return 0;
        }

        @Override
        public void setReadCount(short c) {
        }

        @Override
        public void setDone(boolean b) {
            if (!b) {
                Debug.out("Piece failed recheck");
            }
        }
    }
}

