/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.helpers;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.tag.Tag;
import com.aelitis.azureus.core.tag.TagManager;
import com.aelitis.azureus.core.tag.TagManagerFactory;
import com.aelitis.azureus.core.tag.TagType;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.download.DownloadManagerInitialisationAdapter;
import org.gudy.azureus2.core3.global.GlobalManager;
import org.gudy.azureus2.core3.logging.LogAlert;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TorrentUtils;
import org.gudy.azureus2.plugins.download.DownloadManager;

public class TorrentFolderWatcher {
    private static final LogIDs LOGID = LogIDs.CORE;
    private static final String PARAMID_FOLDER = "Watch Torrent Folder";
    private volatile GlobalManager _global_manager;
    private volatile boolean running = false;
    private final ArrayList<TOTorrent> to_delete = new ArrayList();
    protected final AEMonitor this_mon = new AEMonitor("TorrentFolderWatcher");
    private final FilenameFilter filename_filter = new FilenameFilter(){

        @Override
        public boolean accept(File dir, String name) {
            String lc_name = name.toLowerCase();
            return lc_name.endsWith(".torrent") || lc_name.endsWith(".tor");
        }
    };
    private final ParameterListener param_listener = new ParameterListener(){

        @Override
        public void parameterChanged(String parameterName) {
            if (COConfigurationManager.getBooleanParameter(TorrentFolderWatcher.PARAMID_FOLDER)) {
                if (!TorrentFolderWatcher.this.running) {
                    TorrentFolderWatcher.this.running = true;
                    if (!TorrentFolderWatcher.this.watch_thread.isAlive()) {
                        TorrentFolderWatcher.this.watch_thread.setDaemon(true);
                        TorrentFolderWatcher.this.watch_thread.setPriority(1);
                        TorrentFolderWatcher.this.watch_thread.start();
                    }
                }
            } else {
                TorrentFolderWatcher.this.running = false;
            }
        }
    };
    private final Thread watch_thread = new AEThread("FolderWatcher"){
        private long last_run;
        final AESemaphore wait_sem;
        {
            this.last_run = 0L;
            this.wait_sem = new AESemaphore("fw:wait");
            COConfigurationManager.addParameterListener(new String[]{TorrentFolderWatcher.PARAMID_FOLDER, "Watch Torrent Folder Interval Secs"}, new ParameterListener(){

                @Override
                public void parameterChanged(String name) {
                    wait_sem.release();
                }
            });
        }

        @Override
        public void runSupport() {
            while (true) {
                int sleep_ms;
                long remaining;
                long now = SystemTime.getMonotonousTime();
                int sleep_secs = COConfigurationManager.getIntParameter("Watch Torrent Folder Interval Secs");
                if (sleep_secs < 1) {
                    sleep_secs = 1;
                }
                if ((remaining = this.last_run + (long)(sleep_ms = sleep_secs * 1000) - now) >= 250L && this.last_run != 0L) {
                    if (remaining < 250L) {
                        remaining = 250L;
                    }
                    this.wait_sem.reserve(remaining);
                    continue;
                }
                this.last_run = now;
                try {
                    if (TorrentFolderWatcher.this.running) {
                        TorrentFolderWatcher.this.importAddedFiles();
                        continue;
                    }
                    this.wait_sem.reserve(60000L);
                    continue;
                }
                catch (Throwable e) {
                    Debug.out(e);
                    continue;
                }
                break;
            }
        }
    };

    public TorrentFolderWatcher(GlobalManager global_manager) {
        this._global_manager = global_manager;
    }

    public void start() {
        if (COConfigurationManager.getBooleanParameter(PARAMID_FOLDER)) {
            this.running = true;
            this.watch_thread.setDaemon(true);
            this.watch_thread.setPriority(1);
            this.watch_thread.start();
        }
        COConfigurationManager.addParameterListener(PARAMID_FOLDER, this.param_listener);
    }

    public void destroy() {
        this.running = false;
        this._global_manager = null;
        COConfigurationManager.removeParameterListener(PARAMID_FOLDER, this.param_listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void importAddedFiles() {
        AzureusCore core = AzureusCoreFactory.getSingleton();
        try {
            this.this_mon.enter();
            if (!this.running) {
                return;
            }
            GlobalManager global_manager = this._global_manager;
            if (global_manager == null || !core.isStarted()) {
                return;
            }
            DownloadManager plugin_dm = core.getPluginManager().getDefaultPluginInterface().getDownloadManager();
            boolean save_torrents_default = COConfigurationManager.getBooleanParameter("Save Torrent Files");
            String torrent_save_path = COConfigurationManager.getStringParameter("General_sDefaultTorrent_Directory");
            int start_state = COConfigurationManager.getBooleanParameter("Start Watched Torrents Stopped") ? 70 : 75;
            int num_folders = COConfigurationManager.getIntParameter("Watch Torrent Folder Path Count", 1);
            ArrayList<File> folders = new ArrayList<File>();
            ArrayList<String> tags = new ArrayList<String>();
            for (int i = 0; i < num_folders; ++i) {
                String folder_path = COConfigurationManager.getStringParameter("Watch Torrent Folder Path" + (i == 0 ? "" : " " + i));
                File folder = null;
                if (folder_path != null && folder_path.length() > 0 && !(folder = new File(folder_path)).isDirectory()) {
                    if (!folder.exists()) {
                        FileUtil.mkdirs(folder);
                    }
                    if (!folder.isDirectory()) {
                        if (Logger.isEnabled()) {
                            Logger.log(new LogEvent(LOGID, 3, "[Watch Torrent Folder Path] does not exist or is not a dir"));
                        }
                        folder = null;
                    }
                }
                if (folder == null) continue;
                folders.add(folder);
                String tag = COConfigurationManager.getStringParameter("Watch Torrent Folder Tag" + (i == 0 ? "" : " " + i), null);
                if (tag != null && tag.trim().length() == 0) {
                    tag = null;
                }
                tags.add(tag);
            }
            if (folders.isEmpty()) {
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(LOGID, 3, "[Watch Torrent Folder Path] not configured"));
                }
                return;
            }
            String data_save_path = COConfigurationManager.getStringParameter("Default save path");
            File f = null;
            if (data_save_path != null && data_save_path.length() > 0 && !(f = new File(data_save_path)).isDirectory()) {
                if (!f.exists()) {
                    FileUtil.mkdirs(f);
                }
                if (!f.isDirectory()) {
                    if (Logger.isEnabled()) {
                        Logger.log(new LogEvent(LOGID, 3, "[Default save path] does not exist or is not a dir"));
                    }
                    Logger.log(new LogAlert(false, 3, "[Default save path] does not exist or is not a dir"));
                    return;
                }
            }
            if (f == null) {
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(LOGID, 3, "[Default save path] needs to be set for auto-.torrent-import to work"));
                }
                Logger.log(new LogAlert(false, 3, "[Default save path] needs to be set for auto-.torrent-import to work"));
            }
            for (int i = 0; i < this.to_delete.size(); ++i) {
                TOTorrent torrent = this.to_delete.get(i);
                try {
                    TorrentUtils.delete(torrent);
                    continue;
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            }
            this.to_delete.clear();
            for (int folder_index = 0; folder_index < folders.size(); ++folder_index) {
                String[] currentFileList;
                File folder = (File)folders.get(folder_index);
                final String tag_name = (String)tags.get(folder_index);
                boolean save_torrents = save_torrents_default;
                if (torrent_save_path.length() == 0 || new File(torrent_save_path).getAbsolutePath().equals(folder.getAbsolutePath()) || !new File(torrent_save_path).isDirectory()) {
                    save_torrents = false;
                }
                if ((currentFileList = folder.list(this.filename_filter)) == null) {
                    Logger.log(new LogEvent(LOGID, 3, "There was a problem trying to get a listing of torrents from " + folder));
                    continue;
                }
                for (int i = 0; i < currentFileList.length; ++i) {
                    if (!this.running) {
                        return;
                    }
                    File file = new File(folder, currentFileList[i]);
                    try {
                        TOTorrent torrent = TorrentUtils.readFromFile(file, false);
                        if (global_manager.getDownloadManager(torrent) != null) {
                            if (!Logger.isEnabled()) continue;
                            Logger.log(new LogEvent(LOGID, file.getAbsolutePath() + " is already being downloaded"));
                            continue;
                        }
                        if (plugin_dm.lookupDownloadStub(torrent.getHash()) != null) {
                            if (Logger.isEnabled()) {
                                Logger.log(new LogEvent(LOGID, file.getAbsolutePath() + " is an archived download"));
                            }
                            if (!save_torrents) {
                                File imported = new File(folder, file.getName() + ".imported");
                                TorrentUtils.move(file, imported);
                                continue;
                            }
                            this.to_delete.add(torrent);
                            continue;
                        }
                        DownloadManagerInitialisationAdapter dmia = new DownloadManagerInitialisationAdapter(){

                            @Override
                            public int getActions() {
                                return 1;
                            }

                            @Override
                            public void initialised(org.gudy.azureus2.core3.download.DownloadManager dm, boolean for_seeding) {
                                if (tag_name != null) {
                                    TagManager tm = TagManagerFactory.getTagManager();
                                    TagType tt = tm.getTagType(3);
                                    Tag tag = tt.getTag(tag_name, true);
                                    try {
                                        if (tag == null) {
                                            tag = tt.createTag(tag_name, true);
                                        }
                                        tag.addTaggable(dm);
                                    }
                                    catch (Throwable e) {
                                        Debug.out(e);
                                    }
                                }
                            }
                        };
                        byte[] hash = null;
                        try {
                            hash = torrent.getHash();
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        if (!save_torrents) {
                            File imported = new File(folder, file.getName() + ".imported");
                            TorrentUtils.move(file, imported);
                            global_manager.addDownloadManager(imported.getAbsolutePath(), hash, data_save_path, start_state, true, false, dmia);
                        } else {
                            global_manager.addDownloadManager(file.getAbsolutePath(), hash, data_save_path, start_state, true, false, dmia);
                            this.to_delete.add(torrent);
                        }
                        if (!Logger.isEnabled()) continue;
                        Logger.log(new LogEvent(LOGID, "Auto-imported " + file.getAbsolutePath()));
                        continue;
                    }
                    catch (Throwable e) {
                        Debug.out("Failed to auto-import torrent file '" + file.getAbsolutePath() + "' - " + Debug.getNestedExceptionMessage(e));
                        Debug.printStackTrace(e);
                    }
                }
            }
        }
        finally {
            this.this_mon.exit();
        }
    }
}

