/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.download;

import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.devices.DeviceManager;
import com.aelitis.azureus.core.devices.DeviceManagerFactory;
import com.aelitis.azureus.core.devices.DeviceMediaRenderer;
import com.aelitis.azureus.core.devices.TranscodeAnalysisListener;
import com.aelitis.azureus.core.devices.TranscodeException;
import com.aelitis.azureus.core.devices.TranscodeJob;
import com.aelitis.azureus.core.devices.TranscodeManager;
import com.aelitis.azureus.core.devices.TranscodeProfile;
import com.aelitis.azureus.core.devices.TranscodeProviderAnalysis;
import com.aelitis.azureus.core.devices.TranscodeQueue;
import com.aelitis.azureus.core.download.DownloadManagerEnhancer;
import com.aelitis.azureus.core.download.EnhancedDownloadManager;
import com.aelitis.azureus.core.download.StreamManagerDownload;
import com.aelitis.azureus.core.download.StreamManagerDownloadListener;
import com.aelitis.azureus.ui.UIFunctions;
import com.aelitis.azureus.ui.UIFunctionsManager;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.AsyncDispatcher;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimeFormatter;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.PluginListener;
import org.gudy.azureus2.plugins.PluginManager;
import org.gudy.azureus2.plugins.disk.DiskManagerFileInfo;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.download.DownloadStats;
import org.gudy.azureus2.plugins.torrent.TorrentAttribute;
import org.gudy.azureus2.pluginsimpl.local.PluginCoreUtils;
import org.gudy.azureus2.pluginsimpl.local.PluginInitializer;

public class StreamManager {
    private static final int BUFFER_SECS_DEFAULT = 30;
    private static final int BUFFER_MIN_SECS_DEFAULT = 3;
    private static int config_buffer_secs;
    private static int config_min_buffer_secs;
    private static StreamManager singleton;
    private TorrentAttribute mi_ta;
    private AsyncDispatcher dispatcher = new AsyncDispatcher();
    private List<SMDImpl> streamers = new ArrayList<SMDImpl>();

    public static StreamManager getSingleton() {
        return singleton;
    }

    private StreamManager() {
        PluginInterface default_pi = PluginInitializer.getDefaultInterface();
        this.mi_ta = default_pi.getTorrentManager().getPluginAttribute("sm_metainfo");
        default_pi.addListener(new PluginListener(){

            @Override
            public void initializationComplete() {
            }

            @Override
            public void closedownInitiated() {
                StreamManager.this.dispatcher.dispatch(new AERunnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void runSupport() {
                        ArrayList to_cancel;
                        StreamManager streamManager = StreamManager.this;
                        synchronized (streamManager) {
                            to_cancel = new ArrayList(StreamManager.this.streamers);
                            StreamManager.this.streamers.clear();
                        }
                        for (SMDImpl s : to_cancel) {
                            s.cancel();
                        }
                    }
                });
            }

            @Override
            public void closedownComplete() {
            }
        });
    }

    public int getBufferSecs() {
        return config_buffer_secs;
    }

    public void setBufferSecs(int secs) {
        COConfigurationManager.setParameter("streamman.buffer.secs", secs);
    }

    public int getMinBufferSecs() {
        return config_min_buffer_secs;
    }

    public void setMinBufferSecs(int secs) {
        COConfigurationManager.setParameter("streamman.min.buffer.secs", secs);
    }

    public boolean isStreamingUsable() {
        if (!Constants.isWindows && !Constants.isOSX_10_5_OrHigher) {
            return false;
        }
        try {
            PluginManager plug_man = AzureusCoreFactory.getSingleton().getPluginManager();
            PluginInterface xcode_pi = plug_man.getPluginInterfaceByID("vuzexcode", false);
            if (xcode_pi != null && !xcode_pi.getPluginState().isOperational()) {
                return false;
            }
            PluginInterface emp_pi = plug_man.getPluginInterfaceByID("azemp", false);
            if (emp_pi == null) {
                return true;
            }
            if (!emp_pi.getPluginState().isOperational()) {
                return false;
            }
            Class<?> epwClass = emp_pi.getPlugin().getClass().getClassLoader().loadClass("com.azureus.plugins.azemp.ui.swt.emp.EmbeddedPlayerWindowSWT");
            Method method = epwClass.getMethod("prepareWindow", String.class);
            return method != null;
        }
        catch (Throwable e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StreamManagerDownload stream(DownloadManager dm, int file_index, URL url, boolean preview_mode, StreamManagerDownloadListener listener) {
        SMDImpl result = new SMDImpl(dm, file_index, url, preview_mode, listener);
        StreamManager streamManager = this;
        synchronized (streamManager) {
            this.streamers.add(result);
        }
        return result;
    }

    static {
        COConfigurationManager.addAndFireParameterListeners(new String[]{"streamman.buffer.secs", "streamman.min.buffer.secs"}, new ParameterListener(){

            @Override
            public void parameterChanged(String parameterName) {
                config_buffer_secs = COConfigurationManager.getIntParameter("streamman.buffer.secs", 30);
                config_min_buffer_secs = COConfigurationManager.getIntParameter("streamman.min.buffer.secs", 3);
            }
        });
        singleton = new StreamManager();
    }

    private class SMDImpl
    extends AERunnable
    implements StreamManagerDownload {
        private DownloadManager dm;
        private int file_index;
        private URL url;
        private StreamManagerDownloadListener listener;
        private int existing_dl_limit;
        private boolean preview_mode;
        private long preview_mode_last_change = 0L;
        private AESemaphore active_sem;
        private TranscodeJob active_job;
        private EnhancedDownloadManager active_edm;
        private boolean active_edm_activated;
        private volatile boolean cancelled;

        private SMDImpl(DownloadManager _dm, int _file_index, URL _url, boolean _preview_mode, StreamManagerDownloadListener _listener) {
            this.dm = _dm;
            this.file_index = _file_index;
            this.url = _url;
            this.preview_mode = _preview_mode;
            this.listener = _listener;
            StreamManager.this.dispatcher.dispatch(this);
        }

        @Override
        public DownloadManager getDownload() {
            return this.dm;
        }

        @Override
        public int getFileIndex() {
            return this.file_index;
        }

        @Override
        public URL getURL() {
            return this.url;
        }

        @Override
        public boolean getPreviewMode() {
            return this.preview_mode;
        }

        @Override
        public void setPreviewMode(boolean _preview_mode) {
            long now = SystemTime.getMonotonousTime();
            if (this.preview_mode_last_change == 0L || now - this.preview_mode_last_change > 500L) {
                this.preview_mode_last_change = now;
                this.preview_mode = _preview_mode;
                this.listener.updateActivity("Preview mode changed to " + this.preview_mode);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void runSupport() {
            try {
                long video_height;
                long video_width;
                long duration;
                Method is_active_method;
                Object player;
                DiskManagerFileInfo file;
                Download download;
                long stream_start;
                block39: {
                    Map file_map;
                    StreamManager streamManager = StreamManager.this;
                    synchronized (streamManager) {
                        if (this.cancelled) {
                            throw new Exception("Cancelled");
                        }
                        this.active_edm = DownloadManagerEnhancer.getSingleton().getEnhancedDownload(this.dm);
                    }
                    stream_start = SystemTime.getMonotonousTime();
                    download = PluginCoreUtils.wrap(this.dm);
                    file = download.getDiskManagerFileInfo(this.file_index);
                    PluginInterface emp_pi = this.checkPlugin("azemp", "media player");
                    this.checkPlugin("vuzexcode", "media analyser");
                    Class<?> epwClass = emp_pi.getPlugin().getClass().getClassLoader().loadClass("com.azureus.plugins.azemp.ui.swt.emp.EmbeddedPlayerWindowSWT");
                    Method method = epwClass.getMethod("prepareWindow", String.class);
                    player = method.invoke(null, file.getFile(true).getName());
                    final Method buffering_method = player.getClass().getMethod("bufferingPlayback", Map.class);
                    is_active_method = player.getClass().getMethod("isActive", new Class[0]);
                    final StreamManagerDownloadListener original_listener = this.listener;
                    this.listener = new StreamManagerDownloadListener(){

                        @Override
                        public void updateActivity(String str) {
                            original_listener.updateActivity(str);
                        }

                        @Override
                        public void updateStats(int secs_until_playable, int buffer_secs, long buffer_bytes, int target_buffer_secs) {
                            original_listener.updateStats(secs_until_playable, buffer_secs, buffer_bytes, target_buffer_secs);
                        }

                        @Override
                        public void ready() {
                            original_listener.ready();
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void failed(Throwable error) {
                            try {
                                original_listener.failed(error);
                                HashMap<String, Object> b_map = new HashMap<String, Object>();
                                b_map.put("state", new Integer(3));
                                b_map.put("msg", Debug.getNestedExceptionMessage(error));
                                try {
                                    buffering_method.invoke(player, b_map);
                                }
                                catch (Throwable e) {
                                    Debug.out(e);
                                }
                            }
                            finally {
                                SMDImpl.this.cancel();
                            }
                        }
                    };
                    HashMap<String, HashMap<String, Long>> map = download.getMapAttribute(StreamManager.this.mi_ta);
                    Long l_duration = null;
                    Long l_video_width = null;
                    Long l_video_height = null;
                    if (map != null && (file_map = (Map)map.get(String.valueOf(this.file_index))) != null) {
                        l_duration = (Long)file_map.get("duration");
                        l_video_width = (Long)file_map.get("video_width");
                        l_video_height = (Long)file_map.get("video_height");
                    }
                    if (l_duration == null) {
                        this.active_edm.prepareForProgressiveMode(true);
                        try {
                            TranscodeJob[] jobs;
                            DeviceManager dm = DeviceManagerFactory.getSingleton();
                            TranscodeManager tm = dm.getTranscodeManager();
                            DeviceMediaRenderer dmr = (DeviceMediaRenderer)dm.addVirtualDevice(3, "18a0b53a-a466-6795-1d0f-cf38c830ca0e", "generic", "Media Analyser");
                            dmr.setHidden(true);
                            dmr.setCanRemove(false);
                            TranscodeQueue queue = tm.getQueue();
                            for (TranscodeJob job : jobs = queue.getJobs()) {
                                if (job.getTarget() != dmr) continue;
                                job.removeForce();
                            }
                            TranscodeProfile[] profiles = dmr.getTranscodeProfiles();
                            TranscodeProfile profile = null;
                            for (TranscodeProfile streamManager2 : profiles) {
                                if (!streamManager2.getName().equals("Generic MP4")) continue;
                                profile = streamManager2;
                                break;
                            }
                            if (profile == null) {
                                throw new Exception("Analyser transcode profile not found");
                            }
                            this.listener.updateActivity("Analysing media");
                            final HashMap<String, Object> b_map = new HashMap<String, Object>();
                            b_map.put("state", new Integer(1));
                            b_map.put("msg", MessageText.getString("stream.analysing.media"));
                            buffering_method.invoke(player, b_map);
                            final TranscodeJob tj = queue.add(dmr, profile, file, true);
                            try {
                                final AESemaphore sem = new AESemaphore("analyserWait");
                                StreamManager streamManager3 = StreamManager.this;
                                synchronized (streamManager3) {
                                    if (this.cancelled) {
                                        throw new Exception("Cancelled");
                                    }
                                    this.active_sem = sem;
                                    this.active_job = tj;
                                }
                                final long[] lArray = new long[3];
                                final Throwable[] error = new Throwable[]{null};
                                tj.analyseNow(new TranscodeAnalysisListener(){

                                    /*
                                     * WARNING - Removed try catching itself - possible behaviour change.
                                     */
                                    @Override
                                    public void analysisComplete(TranscodeJob file, TranscodeProviderAnalysis analysis) {
                                        try {
                                            lArray[0] = analysis.getLongProperty(2);
                                            lArray[1] = analysis.getLongProperty(3);
                                            lArray[2] = analysis.getLongProperty(4);
                                            tj.removeForce();
                                        }
                                        finally {
                                            sem.releaseForever();
                                        }
                                    }

                                    /*
                                     * WARNING - Removed try catching itself - possible behaviour change.
                                     */
                                    @Override
                                    public void analysisFailed(TranscodeJob file, TranscodeException e) {
                                        try {
                                            error[0] = e;
                                            tj.removeForce();
                                        }
                                        finally {
                                            sem.releaseForever();
                                        }
                                    }
                                });
                                new AEThread2("SM:anmon"){

                                    @Override
                                    public void run() {
                                        boolean last_preview_mode = SMDImpl.this.preview_mode;
                                        while (!sem.isReleasedForever() && !SMDImpl.this.cancelled) {
                                            if (sem.reserve(250L)) continue;
                                            if (SMDImpl.this.cancelled) {
                                                return;
                                            }
                                            try {
                                                Boolean b = (Boolean)is_active_method.invoke(player, new Object[0]);
                                                if (!b.booleanValue()) {
                                                    SMDImpl.this.cancel();
                                                    break;
                                                }
                                            }
                                            catch (Throwable e) {
                                                // empty catch block
                                            }
                                            if (last_preview_mode != SMDImpl.this.preview_mode) {
                                                last_preview_mode = SMDImpl.this.preview_mode;
                                                b_map.put("msg", MessageText.getString(last_preview_mode ? "stream.analysing.media.preview" : "stream.analysing.media"));
                                            }
                                            DownloadStats stats2 = download.getStats();
                                            b_map.put("dl_rate", stats2.getDownloadAverage());
                                            b_map.put("dl_size", stats2.getDownloaded());
                                            b_map.put("dl_time", SystemTime.getMonotonousTime() - stream_start);
                                            try {
                                                buffering_method.invoke(player, b_map);
                                            }
                                            catch (Throwable throwable) {}
                                        }
                                    }
                                }.start();
                                sem.reserve();
                                StreamManager streamManager4 = StreamManager.this;
                                synchronized (streamManager4) {
                                    if (this.cancelled) {
                                        throw new Exception("Cancelled");
                                    }
                                    this.active_job = null;
                                    this.active_sem = null;
                                }
                                if (error[0] != null) {
                                    throw error[0];
                                }
                                duration = lArray[0];
                                video_width = lArray[1];
                                video_height = lArray[2];
                                if (duration > 0L) {
                                    HashMap<String, Long> file_map2 = (HashMap<String, Long>)(map = map == null ? new HashMap<String, HashMap<String, Long>>() : new HashMap(map)).get(String.valueOf(this.file_index));
                                    if (file_map2 == null) {
                                        file_map2 = new HashMap<String, Long>();
                                        map.put(String.valueOf(this.file_index), file_map2);
                                    }
                                    file_map2.put("duration", duration);
                                    file_map2.put("video_width", video_width);
                                    file_map2.put("video_height", video_height);
                                    download.setMapAttribute(StreamManager.this.mi_ta, map);
                                }
                                break block39;
                            }
                            catch (Throwable e) {
                                tj.removeForce();
                                throw e;
                            }
                        }
                        catch (Throwable e) {
                            throw new Exception("Media analysis failed", e);
                        }
                    }
                    duration = l_duration;
                    video_width = l_video_width == null ? 0L : l_video_width;
                    long l = video_height = l_video_height == null ? 0L : l_video_height;
                }
                if (video_width == 0L || video_height == 0L) {
                    throw new Exception("Media analysis failed - video stream not found");
                }
                if (duration == 0L) {
                    throw new Exception("Media analysis failed - duration unknown");
                }
                this.listener.updateActivity("MetaData read: duration=" + TimeFormatter.formatColon(duration / 1000L) + ", width=" + video_width + ", height=" + video_height);
                Method smd_method = player.getClass().getMethod("setMetaData", Map.class);
                HashMap<String, Long> md_map = new HashMap<String, Long>();
                md_map.put("duration", duration);
                md_map.put("width", video_width);
                md_map.put("height", video_height);
                smd_method.invoke(player, md_map);
                final long bytes_per_sec = file.getLength() / (duration / 1000L);
                long dl_lim_max = (long)COConfigurationManager.getIntParameter("Plugin.azemp.azemp.config.dl_lim_max") * 1024L;
                long dl_lim_extra = (long)COConfigurationManager.getIntParameter("Plugin.azemp.azemp.config.dl_lim_extra") * 1024L;
                this.existing_dl_limit = download.getDownloadRateLimitBytesPerSecond();
                long required_limit = Math.max(dl_lim_max, bytes_per_sec + dl_lim_extra);
                if (required_limit > 0L) {
                    download.setDownloadRateLimitBytesPerSecond((int)required_limit);
                }
                this.listener.updateActivity("Average rate=" + DisplayFormatters.formatByteCountToKiBEtcPerSec(bytes_per_sec) + ", applied dl limit=" + DisplayFormatters.formatByteCountToKiBEtcPerSec(required_limit));
                StreamManager streamManager = StreamManager.this;
                synchronized (streamManager) {
                    if (this.cancelled) {
                        throw new Exception("Cancelled");
                    }
                    this.active_edm.setExplicitProgressive(config_buffer_secs, bytes_per_sec, this.file_index);
                    if (!this.active_edm.setProgressiveMode(true)) {
                        throw new Exception("Failed to set download as progressive");
                    }
                    this.active_edm_activated = true;
                }
                new AEThread2("streamMon"){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        int TIMER_PERIOD = 250;
                        int PLAY_STATS_PERIOD = 5000;
                        int PLAY_STATS_TICKS = 20;
                        int DL_STARTUP_PERIOD = 5000;
                        int DL_STARTUP_TICKS = 20;
                        boolean playback_started = false;
                        boolean playback_paused = false;
                        boolean error_reported = false;
                        try {
                            Method start_method = player.getClass().getMethod("startPlayback", URL.class);
                            Method pause_method = player.getClass().getMethod("pausePlayback", new Class[0]);
                            Method resume_method = player.getClass().getMethod("resumePlayback", new Class[0]);
                            Method buffering_method = player.getClass().getMethod("bufferingPlayback", Map.class);
                            Method play_stats_method = player.getClass().getMethod("playStats", Map.class);
                            int tick_count = 0;
                            while (!SMDImpl.this.cancelled) {
                                boolean playable;
                                int buffer_to_use;
                                boolean complete;
                                ++tick_count;
                                int dm_state = SMDImpl.this.dm.getState();
                                boolean bl = complete = file.getLength() == file.getDownloaded();
                                if (!complete) {
                                    if ((dm_state == 100 || dm_state == 70 || dm_state == 75) && tick_count >= 20) {
                                        throw new Exception("Streaming abandoned, download isn't running");
                                    }
                                    if (!SMDImpl.this.active_edm.getProgressiveMode()) {
                                        boolean bl2 = complete = file.getLength() == file.getDownloaded();
                                        if (!complete) {
                                            throw new Exception("Streaming mode abandoned for download");
                                        }
                                    }
                                }
                                long[] details = SMDImpl.this.updateETA(SMDImpl.this.active_edm);
                                int eta = (int)details[0];
                                int buffer_secs = (int)details[1];
                                long buffer = details[2];
                                SMDImpl.this.listener.updateStats(eta, buffer_secs, buffer, config_buffer_secs);
                                int n = buffer_to_use = playback_started ? config_min_buffer_secs : config_buffer_secs;
                                if (complete) {
                                    playable = true;
                                } else {
                                    playable = buffer_secs > buffer_to_use;
                                    boolean bl3 = playable = playable && (eta <= 0 || playback_started && !playback_paused || SMDImpl.this.preview_mode);
                                }
                                if (playback_started) {
                                    if (playable) {
                                        if (playback_paused) {
                                            SMDImpl.this.listener.updateActivity("Resuming playback");
                                            resume_method.invoke(player, new Object[0]);
                                            playback_paused = false;
                                        }
                                    } else if (!playback_paused) {
                                        SMDImpl.this.listener.updateActivity("Pausing playback to prevent stall");
                                        pause_method.invoke(player, new Object[0]);
                                        playback_paused = true;
                                    }
                                } else if (playable) {
                                    SMDImpl.this.listener.ready();
                                    start_method.invoke(player, SMDImpl.this.url);
                                    playback_started = true;
                                }
                                if (playable) {
                                    if (tick_count % 20 == 0) {
                                        long contiguous_done = SMDImpl.this.active_edm.getContiguousAvailableBytes(SMDImpl.this.file_index >= 0 ? SMDImpl.this.file_index : SMDImpl.this.active_edm.getPrimaryFileIndex(), 0L, 0L);
                                        HashMap<String, Number> map = new HashMap<String, Number>();
                                        map.put("buffer_min", new Long(config_buffer_secs));
                                        map.put("buffer_secs", new Integer(buffer_secs));
                                        map.put("buffer_bytes", new Long(buffer));
                                        map.put("stream_rate", bytes_per_sec);
                                        DownloadStats stats2 = download.getStats();
                                        map.put("dl_rate", stats2.getDownloadAverage());
                                        map.put("dl_size", stats2.getDownloaded());
                                        map.put("dl_time", SystemTime.getMonotonousTime() - stream_start);
                                        map.put("duration", duration);
                                        map.put("file_size", file.getLength());
                                        map.put("cont_done", contiguous_done);
                                        play_stats_method.invoke(player, map);
                                    }
                                } else {
                                    DownloadStats stats3 = download.getStats();
                                    HashMap<String, Number> map = new HashMap<String, Number>();
                                    map.put("state", new Integer(2));
                                    if (SMDImpl.this.preview_mode && !complete) {
                                        int preview_eta;
                                        long rate = stats3.getDownloadAverage();
                                        if (rate <= 0L) {
                                            preview_eta = Integer.MAX_VALUE;
                                        } else {
                                            double secs_per_sec = (double)bytes_per_sec / (double)rate;
                                            preview_eta = (int)((double)(buffer_to_use - buffer_secs) * secs_per_sec);
                                        }
                                        map.put("eta", new Integer(preview_eta));
                                        map.put("preview", 1);
                                    } else {
                                        map.put("eta", new Integer(eta));
                                        map.put("preview", 0);
                                    }
                                    map.put("buffer_min", new Long(config_buffer_secs));
                                    map.put("buffer_secs", new Integer(buffer_secs));
                                    map.put("buffer_bytes", new Long(buffer));
                                    map.put("stream_rate", bytes_per_sec);
                                    map.put("dl_rate", stats3.getDownloadAverage());
                                    map.put("dl_size", stats3.getDownloaded());
                                    map.put("dl_time", SystemTime.getMonotonousTime() - stream_start);
                                    buffering_method.invoke(player, map);
                                }
                                Thread.sleep(250L);
                                try {
                                    Boolean b = (Boolean)is_active_method.invoke(player, new Object[0]);
                                    if (b.booleanValue()) continue;
                                    SMDImpl.this.cancel();
                                    break;
                                }
                                catch (Throwable e) {
                                }
                            }
                        }
                        catch (Throwable e) {
                            error_reported = true;
                            SMDImpl.this.listener.failed(e);
                        }
                        finally {
                            if (!(error_reported || SMDImpl.this.cancelled || playback_started)) {
                                SMDImpl.this.listener.failed(new Exception("Streaming failed, reason unknown"));
                            }
                        }
                    }
                }.start();
            }
            catch (Throwable e) {
                try {
                    this.listener.failed(e);
                }
                finally {
                    this.cancel();
                }
            }
        }

        private long[] updateETA(EnhancedDownloadManager edm) {
            long _eta = edm.getProgressivePlayETA();
            int eta = _eta >= Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)_eta;
            EnhancedDownloadManager.progressiveStats stats2 = edm.getProgressiveStats();
            long provider_pos = stats2.getCurrentProviderPosition(false);
            long buffer = edm.getContiguousAvailableBytes(this.file_index >= 0 ? this.file_index : edm.getPrimaryFileIndex(), provider_pos, 0L);
            long bps = stats2.getStreamBytesPerSecondMin();
            int buffer_secs = bps <= 0L ? Integer.MAX_VALUE : (int)(buffer / bps);
            return new long[]{eta, buffer_secs, buffer};
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void cancel() {
            boolean edm_activated;
            EnhancedDownloadManager edm;
            TranscodeJob job;
            StreamManager streamManager = StreamManager.this;
            synchronized (streamManager) {
                this.cancelled = true;
                job = this.active_job;
                if (this.active_sem != null) {
                    this.active_sem.releaseForever();
                }
                edm = this.active_edm;
                edm_activated = this.active_edm_activated;
                StreamManager.this.streamers.remove(this);
            }
            if (job != null) {
                job.removeForce();
            }
            if (edm != null) {
                if (edm_activated) {
                    edm.setProgressiveMode(false);
                } else {
                    edm.prepareForProgressiveMode(false);
                }
            }
            Download download = PluginCoreUtils.wrap(this.dm);
            download.setDownloadRateLimitBytesPerSecond(this.existing_dl_limit);
        }

        @Override
        public boolean isCancelled() {
            return this.cancelled;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private PluginInterface checkPlugin(String id, String name) throws Throwable {
            PluginManager plug_man = AzureusCoreFactory.getSingleton().getPluginManager();
            PluginInterface pi = plug_man.getPluginInterfaceByID(id, false);
            if (pi == null) {
                UIFunctions uif = UIFunctionsManager.getUIFunctions();
                if (uif == null) {
                    throw new Exception("UIFunctions unavailable - can't install plugin '" + name + "'");
                }
                this.listener.updateActivity("Installing " + name);
                final AESemaphore sem = new AESemaphore("analyserWait");
                StreamManager streamManager = StreamManager.this;
                synchronized (streamManager) {
                    if (this.cancelled) {
                        throw new Exception("Cancelled");
                    }
                    this.active_sem = sem;
                }
                final Throwable[] error = new Throwable[]{null};
                uif.installPlugin(id, "dlg.install." + id, new UIFunctions.actionListener(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void actionComplete(Object result) {
                        try {
                            if (result instanceof Boolean) {
                            } else {
                                error[0] = (Throwable)result;
                            }
                        }
                        finally {
                            sem.release();
                        }
                    }
                });
                sem.reserve();
                StreamManager streamManager2 = StreamManager.this;
                synchronized (streamManager2) {
                    if (this.cancelled) {
                        throw new Exception("Cancelled");
                    }
                    this.active_sem = null;
                }
                if (error[0] != null) {
                    throw error[0];
                }
                long start = SystemTime.getMonotonousTime();
                this.listener.updateActivity("Waiting for plugin initialisation");
                while (true) {
                    if (this.cancelled) {
                        throw new Exception("Cancelled");
                    }
                    if (SystemTime.getMonotonousTime() - start >= 30000L) {
                        throw new Exception("Timeout waiting for " + name + " to initialise");
                    }
                    pi = plug_man.getPluginInterfaceByID(id, false);
                    if (pi != null && pi.getPluginState().isOperational()) {
                        return pi;
                    }
                    Thread.sleep(250L);
                }
            }
            if (!pi.getPluginState().isOperational()) {
                throw new Exception(name + " not operational");
            }
            return pi;
        }
    }
}

