/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.download;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.download.EnhancedDownloadManager;
import com.aelitis.azureus.core.tag.Tag;
import com.aelitis.azureus.core.tag.TagManager;
import com.aelitis.azureus.core.tag.TagManagerFactory;
import com.aelitis.azureus.core.tag.TagType;
import com.aelitis.azureus.core.tag.TagTypeAdapter;
import com.aelitis.azureus.core.torrent.PlatformTorrentUtils;
import com.aelitis.azureus.util.ExternalStimulusHandler;
import com.aelitis.azureus.util.ExternalStimulusListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.global.GlobalManager;
import org.gudy.azureus2.core3.global.GlobalManagerListener;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.util.Base32;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.HashWrapper;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.core3.util.TimerEventPeriodic;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.disk.DiskManagerChannel;
import org.gudy.azureus2.pluginsimpl.local.PluginCoreUtils;
import org.gudy.azureus2.pluginsimpl.local.disk.DiskManagerChannelImpl;

public class DownloadManagerEnhancer {
    public static final int TICK_PERIOD = 1000;
    private static TagManager tag_manager = TagManagerFactory.getTagManager();
    private static DownloadManagerEnhancer singleton;
    private AzureusCore core;
    private Map<DownloadManager, EnhancedDownloadManager> download_map = new IdentityHashMap<DownloadManager, EnhancedDownloadManager>();
    private Set<HashWrapper> pause_set = new HashSet<HashWrapper>();
    private boolean progressive_enabled;
    private long progressive_active_counter;
    private TimerEventPeriodic pa_timer;

    public static synchronized DownloadManagerEnhancer initialise(AzureusCore core) {
        if (singleton == null) {
            singleton = new DownloadManagerEnhancer(core);
        }
        return singleton;
    }

    public static synchronized DownloadManagerEnhancer getSingleton() {
        return singleton;
    }

    protected DownloadManagerEnhancer(AzureusCore _core) {
        this.core = _core;
        boolean tag_all = this.initAutoTag();
        this.core.getGlobalManager().addListener(new GlobalManagerListener(){

            @Override
            public void downloadManagerAdded(DownloadManager dm) {
                DownloadManagerEnhancer.this.handleAutoTag(dm);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void downloadManagerRemoved(DownloadManager dm) {
                EnhancedDownloadManager edm;
                Map map = DownloadManagerEnhancer.this.download_map;
                synchronized (map) {
                    edm = (EnhancedDownloadManager)DownloadManagerEnhancer.this.download_map.remove(dm);
                }
                if (edm != null) {
                    edm.destroy();
                }
            }

            @Override
            public void destroyInitiated() {
                DownloadManagerEnhancer.this.resume();
            }

            @Override
            public void destroyed() {
            }

            @Override
            public void seedingStatusChanged(boolean seeding_only_mode, boolean b) {
            }
        }, tag_all);
        ExternalStimulusHandler.addListener(new ExternalStimulusListener(){

            @Override
            public boolean receive(String name, Map values) {
                return false;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int query(String name, Map values) {
                if (name.equals("az3.downloadmanager.stream.eta")) {
                    ArrayList edms_copy;
                    Object hash = values.get("hash");
                    byte[] b_hash = null;
                    if (hash instanceof String) {
                        String hash_str = (String)hash;
                        b_hash = hash_str.length() == 32 ? Base32.decode(hash_str) : ByteFormatter.decodeString(hash_str);
                    }
                    if (b_hash != null) {
                        DownloadManagerEnhancer.this.getEnhancedDownload(b_hash);
                    }
                    Map map = DownloadManagerEnhancer.this.download_map;
                    synchronized (map) {
                        edms_copy = new ArrayList(DownloadManagerEnhancer.this.download_map.values());
                    }
                    for (EnhancedDownloadManager edm : edms_copy) {
                        if (b_hash != null) {
                            long eta;
                            byte[] d_hash = edm.getHash();
                            if (d_hash == null || !Arrays.equals(b_hash, d_hash)) continue;
                            if (edm.getDownloadManager().isDownloadComplete(false)) {
                                return 0;
                            }
                            if (!edm.supportsProgressiveMode()) {
                                return Integer.MIN_VALUE;
                            }
                            if (!edm.getProgressiveMode()) {
                                edm.setProgressiveMode(true);
                            }
                            if ((eta = edm.getProgressivePlayETA()) > Integer.MAX_VALUE) {
                                return Integer.MAX_VALUE;
                            }
                            return (int)eta;
                        }
                        if (!edm.getProgressiveMode()) continue;
                        long eta = edm.getProgressivePlayETA();
                        if (eta > Integer.MAX_VALUE) {
                            return Integer.MAX_VALUE;
                        }
                        return (int)eta;
                    }
                }
                return Integer.MIN_VALUE;
            }
        });
        DiskManagerChannelImpl.addListener(new DiskManagerChannelImpl.channelCreateListener(){

            @Override
            public void channelCreated(DiskManagerChannel channel2) {
                try {
                    EnhancedDownloadManager edm = DownloadManagerEnhancer.this.getEnhancedDownload(PluginCoreUtils.unwrap(channel2.getFile().getDownload()));
                    if (edm == null) {
                        return;
                    }
                    if (edm.getDownloadManager().isDownloadComplete(true)) {
                        return;
                    }
                    if (!edm.getProgressiveMode() && edm.supportsProgressiveMode()) {
                        Debug.out("Enabling progressive mode for '" + edm.getName() + "' due to external stream");
                        edm.setProgressiveMode(true);
                    }
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void progressiveActivated() {
        DownloadManagerEnhancer downloadManagerEnhancer = this;
        synchronized (downloadManagerEnhancer) {
            ++this.progressive_active_counter;
            if (this.pa_timer == null) {
                this.pa_timer = SimpleTimer.addPeriodicEvent("DownloadManagerEnhancer:speedChecker", 1000L, new TimerEventPerformer(){
                    private int tick_count;
                    private long last_inactive_marker = 0L;

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void perform(TimerEvent event2) {
                        long current_marker;
                        ++this.tick_count;
                        DownloadManagerEnhancer downloadManagerEnhancer = DownloadManagerEnhancer.this;
                        synchronized (downloadManagerEnhancer) {
                            current_marker = DownloadManagerEnhancer.this.progressive_active_counter;
                            if (this.last_inactive_marker == current_marker) {
                                DownloadManagerEnhancer.this.pa_timer.cancel();
                                DownloadManagerEnhancer.this.pa_timer = null;
                                return;
                            }
                        }
                        List<DownloadManager> downloads = DownloadManagerEnhancer.this.core.getGlobalManager().getDownloadManagers();
                        boolean is_active = false;
                        for (int i = 0; i < downloads.size(); ++i) {
                            DownloadManager download = downloads.get(i);
                            EnhancedDownloadManager edm = DownloadManagerEnhancer.this.getEnhancedDownload(download);
                            if (edm == null || !edm.updateStats(this.tick_count)) continue;
                            is_active = true;
                        }
                        if (!is_active) {
                            this.last_inactive_marker = current_marker;
                        }
                    }
                });
            }
        }
    }

    protected AzureusCore getCore() {
        return this.core;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void pause(DownloadManager dm) {
        TOTorrent torrent = dm.getTorrent();
        if (torrent == null) {
            return;
        }
        try {
            HashWrapper hw = torrent.getHashWrapper();
            Set<HashWrapper> set = this.pause_set;
            synchronized (set) {
                if (this.pause_set.contains(hw)) {
                    return;
                }
                this.pause_set.add(hw);
            }
            dm.pause();
        }
        catch (Throwable e) {
            Debug.out(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resume(DownloadManager dm) {
        TOTorrent torrent = dm.getTorrent();
        if (torrent == null) {
            return;
        }
        try {
            HashWrapper hw = torrent.getHashWrapper();
            Set<HashWrapper> set = this.pause_set;
            synchronized (set) {
                if (!this.pause_set.remove(hw)) {
                    return;
                }
            }
            dm.resume();
        }
        catch (Throwable e) {
            Debug.out(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resume() {
        HashSet<HashWrapper> copy;
        Set<HashWrapper> set = this.pause_set;
        synchronized (set) {
            copy = new HashSet<HashWrapper>(this.pause_set);
            this.pause_set.clear();
        }
        GlobalManager gm = this.core.getGlobalManager();
        for (HashWrapper hw : copy) {
            DownloadManager dm = gm.getDownloadManager(hw);
            if (dm == null) continue;
            dm.resume();
        }
    }

    protected void prepareForProgressiveMode(DownloadManager dm, boolean active) {
        if (active) {
            GlobalManager gm = this.core.getGlobalManager();
            List<DownloadManager> dms = gm.getDownloadManagers();
            for (DownloadManager this_dm : dms) {
                int state;
                if (this_dm == dm || this_dm.isDownloadComplete(false) || (state = this_dm.getState()) != 50 && state != 75) continue;
                this.pause(this_dm);
            }
            if (dm.isPaused()) {
                dm.resume();
            }
        } else {
            this.resume();
        }
    }

    public EnhancedDownloadManager getEnhancedDownload(byte[] hash) {
        DownloadManager dm = this.core.getGlobalManager().getDownloadManager(new HashWrapper(hash));
        if (dm == null) {
            return null;
        }
        return this.getEnhancedDownload(dm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EnhancedDownloadManager getEnhancedDownload(DownloadManager manager) {
        TOTorrent torrent = manager.getTorrent();
        if (torrent == null) {
            return null;
        }
        DownloadManager dm2 = manager.getGlobalManager().getDownloadManager(torrent);
        if (dm2 != manager) {
            return null;
        }
        Map<DownloadManager, EnhancedDownloadManager> map = this.download_map;
        synchronized (map) {
            EnhancedDownloadManager res = this.download_map.get(manager);
            if (res == null) {
                res = new EnhancedDownloadManager(this, manager);
                this.download_map.put(manager, res);
            }
            return res;
        }
    }

    public boolean isProgressiveAvailable() {
        if (this.progressive_enabled) {
            return true;
        }
        PluginInterface ms_pi = this.core.getPluginManager().getPluginInterfaceByID("azupnpav", true);
        if (ms_pi != null) {
            this.progressive_enabled = true;
        }
        return this.progressive_enabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadManager findDownloadManager(String hash) {
        Map<DownloadManager, EnhancedDownloadManager> map = this.download_map;
        synchronized (map) {
            for (DownloadManager dm : this.download_map.keySet()) {
                String thisHash;
                TOTorrent torrent = dm.getTorrent();
                if (!PlatformTorrentUtils.isContent(torrent, true) || !hash.equals(thisHash = PlatformTorrentUtils.getContentHash(torrent))) continue;
                return dm;
            }
        }
        return null;
    }

    private boolean initAutoTag() {
        if (!tag_manager.isEnabled()) {
            return false;
        }
        final String[] tag_ids = new String[]{"tag.type.man.vhdn", "tag.type.man.featcon"};
        final TagType tt = tag_manager.getTagType(3);
        tt.addTagTypeListener(new TagTypeAdapter(){

            @Override
            public void tagRemoved(Tag tag) {
                String name = tag.getTagName(false);
                for (String t : tag_ids) {
                    if (!t.equals(name)) continue;
                    COConfigurationManager.setParameter(name + ".enabled", false);
                }
            }
        }, false);
        for (final String id : tag_ids) {
            COConfigurationManager.addParameterListener(id + ".enabled", new ParameterListener(){

                @Override
                public void parameterChanged(String name) {
                    if (COConfigurationManager.getBooleanParameter(name)) {
                        DownloadManagerEnhancer.this.handleAutoTag(DownloadManagerEnhancer.this.core.getGlobalManager().getDownloadManagers());
                    } else {
                        Tag tag = tt.getTag(id, false);
                        if (tag != null) {
                            tag.removeTag();
                        }
                    }
                }
            });
        }
        boolean run_all = COConfigurationManager.getBooleanParameter("dme.autotag.init_pending", true);
        if (run_all) {
            COConfigurationManager.setParameter("dme.autotag.init_pending", false);
        }
        return run_all;
    }

    private void handleAutoTag(List<DownloadManager> dms) {
        for (DownloadManager dm : dms) {
            this.handleAutoTag(dm);
        }
    }

    private void handleAutoTag(DownloadManager dm) {
        if (!tag_manager.isEnabled()) {
            return;
        }
        try {
            TOTorrent torrent = dm.getTorrent();
            if (torrent != null) {
                boolean is_vhdn = PlatformTorrentUtils.getContentNetworkID(torrent) == 3L;
                String content_type = PlatformTorrentUtils.getContentType(torrent);
                if (content_type != null && !content_type.toLowerCase().contains("vhdn")) {
                    is_vhdn = false;
                }
                if (is_vhdn) {
                    this.handleAutoTag(dm, "tag.type.man.vhdn", "image.sidebar.tag.vhdn");
                }
                if (PlatformTorrentUtils.isFeaturedContent(torrent)) {
                    this.handleAutoTag(dm, "tag.type.man.featcon", "image.sidebar.tag.featcon");
                }
            }
        }
        catch (Throwable e) {
            Debug.out(e);
        }
    }

    private void handleAutoTag(DownloadManager dm, String tag_id, String img_id) {
        if (!tag_manager.isEnabled()) {
            return;
        }
        TagType tt = tag_manager.getTagType(3);
        Tag t = tt.getTag(tag_id, false);
        if (t == null) {
            if (COConfigurationManager.getBooleanParameter(tag_id + ".enabled", true)) {
                try {
                    t = tt.createTag(tag_id, false);
                    t.setImageID(img_id);
                    t.setColor(new int[]{0, 74, 156});
                    t.setPublic(false);
                    t.setCanBePublic(false);
                    tt.addTag(t);
                }
                catch (Throwable e) {
                    Debug.out(e);
                }
            }
        } else if (t.canBePublic()) {
            t.setCanBePublic(false);
        }
        if (t != null && !t.hasTaggable(dm)) {
            t.addTaggable(dm);
        }
    }
}

