/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.download;

import com.aelitis.azureus.core.util.CopyOnWriteList;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.List;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SHA1Simple;
import org.gudy.azureus2.plugins.disk.DiskManagerChannel;
import org.gudy.azureus2.plugins.disk.DiskManagerEvent;
import org.gudy.azureus2.plugins.disk.DiskManagerFileInfo;
import org.gudy.azureus2.plugins.disk.DiskManagerListener;
import org.gudy.azureus2.plugins.disk.DiskManagerRandomReadRequest;
import org.gudy.azureus2.plugins.disk.DiskManagerRequest;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.download.DownloadException;
import org.gudy.azureus2.plugins.utils.PooledByteBuffer;
import org.gudy.azureus2.pluginsimpl.local.utils.PooledByteBufferImpl;

public class DiskManagerFileInfoStream
implements DiskManagerFileInfo {
    private StreamFactory stream_factory;
    private File save_to;
    private byte[] hash;
    private context current_context;
    private Object lock = this;

    public DiskManagerFileInfoStream(StreamFactory _stream_factory, File _save_to) {
        this.stream_factory = _stream_factory;
        this.save_to = _save_to;
        try {
            this.hash = new SHA1Simple().calculateHash(_save_to.getAbsolutePath().getBytes("UTF-8"));
        }
        catch (Throwable e) {
            Debug.out(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isComplete() {
        Object object = this.lock;
        synchronized (object) {
            return this.save_to.exists();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        Object object = this.lock;
        synchronized (object) {
            if (this.current_context != null) {
                this.current_context.destroy(new Exception("Reset"));
            }
            this.save_to.delete();
        }
    }

    @Override
    public void setPriority(boolean b) {
    }

    @Override
    public void setSkipped(boolean b) {
        throw new RuntimeException("Not supported");
    }

    @Override
    public int getNumericPriority() {
        return 0;
    }

    @Override
    public int getNumericPriorty() {
        return 0;
    }

    @Override
    public void setNumericPriority(int priority) {
        throw new RuntimeException("Not supported");
    }

    @Override
    public void setDeleted(boolean b) {
    }

    @Override
    public void setLink(File link_destination) {
        throw new RuntimeException("Not supported");
    }

    @Override
    public File getLink() {
        return null;
    }

    @Override
    public int getAccessMode() {
        return 1;
    }

    @Override
    public long getDownloaded() {
        return this.getLength();
    }

    @Override
    public long getLength() {
        return -1L;
    }

    @Override
    public File getFile() {
        return this.save_to;
    }

    @Override
    public File getFile(boolean follow_link) {
        return this.save_to;
    }

    @Override
    public int getIndex() {
        return 0;
    }

    @Override
    public int getFirstPieceNumber() {
        return 0;
    }

    @Override
    public long getPieceSize() {
        return 32768L;
    }

    @Override
    public int getNumPieces() {
        return -1;
    }

    @Override
    public boolean isPriority() {
        return false;
    }

    @Override
    public boolean isSkipped() {
        return false;
    }

    @Override
    public boolean isDeleted() {
        return false;
    }

    @Override
    public byte[] getDownloadHash() throws DownloadException {
        return this.hash;
    }

    @Override
    public Download getDownload() throws DownloadException {
        throw new DownloadException("Not supported");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DiskManagerChannel createChannel() throws DownloadException {
        try {
            Object object = this.lock;
            synchronized (object) {
                if (this.current_context == null) {
                    this.current_context = new context();
                }
                return this.current_context.createChannel();
            }
        }
        catch (Throwable e) {
            throw new DownloadException("Channel creation failed", e);
        }
    }

    @Override
    public DiskManagerRandomReadRequest createRandomReadRequest(long file_offset, long length, boolean reverse_order, DiskManagerListener listener) throws DownloadException {
        throw new DownloadException("Not supported");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void destroyed(context c) {
        Object object = this.lock;
        synchronized (object) {
            if (this.current_context == c) {
                this.current_context = null;
            }
        }
        this.stream_factory.destroyed(c);
    }

    public static interface StreamFactory {
        public StreamDetails getStream(Object var1) throws IOException;

        public void destroyed(Object var1);

        public static interface StreamDetails {
            public InputStream getStream();

            public boolean hasFailed();
        }
    }

    protected class context {
        private RandomAccessFile raf;
        private StreamFactory.StreamDetails stream_details;
        private boolean stream_got_eof;
        private List<channel> channels = new ArrayList<channel>();
        private List<AESemaphore> waiters = new ArrayList<AESemaphore>();
        private boolean context_destroyed;

        protected context() throws Exception {
            if (DiskManagerFileInfoStream.this.save_to.exists()) {
                this.raf = new RandomAccessFile(DiskManagerFileInfoStream.this.save_to, "r");
                this.stream_got_eof = true;
            } else {
                final File temp_file = new File(DiskManagerFileInfoStream.this.save_to.getAbsolutePath() + "._tmp_");
                this.raf = new RandomAccessFile(temp_file, "rw");
                this.stream_details = DiskManagerFileInfoStream.this.stream_factory.getStream(this);
                final InputStream stream = this.stream_details.getStream();
                new AEThread2("DMS:reader", true){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     * Enabled aggressive block sorting
                     * Enabled unnecessary exception pruning
                     * Enabled aggressive exception aggregation
                     * Converted monitor instructions to comments
                     * Lifted jumps to return sites
                     */
                    @Override
                    public void run() {
                        Object object;
                        int BUFF_SIZE = 131072;
                        byte[] buffer = new byte[131072];
                        try {
                            while (true) {
                                int len;
                                if ((len = stream.read(buffer)) <= 0) {
                                    if (context.this.stream_details.hasFailed()) {
                                        throw new IOException("Stream failed");
                                    }
                                    object = DiskManagerFileInfoStream.this.lock;
                                    // MONITORENTER : object
                                    context.this.stream_got_eof = true;
                                    // MONITOREXIT : object
                                    return;
                                }
                                object = DiskManagerFileInfoStream.this.lock;
                                // MONITORENTER : object
                                context.this.raf.seek(context.this.raf.length());
                                context.this.raf.write(buffer, 0, len);
                                for (AESemaphore waiter : context.this.waiters) {
                                    waiter.release();
                                }
                                // MONITOREXIT : object
                            }
                        }
                        catch (Throwable e) {
                            context.this.destroy(e);
                            return;
                        }
                        finally {
                            try {
                                stream.close();
                            }
                            catch (Throwable e) {}
                            Throwable failed = null;
                            object = DiskManagerFileInfoStream.this.lock;
                        }
                    }
                }.start();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected int read(byte[] buffer, long offset, int length) throws IOException {
            AESemaphore sem;
            Object object = DiskManagerFileInfoStream.this.lock;
            synchronized (object) {
                if (this.raf.length() > offset) {
                    this.raf.seek(offset);
                    return this.raf.read(buffer, 0, length);
                }
                if (this.stream_details == null) {
                    if (this.stream_got_eof) {
                        return -1;
                    }
                    throw new IOException("Premature end of stream (read)");
                }
                sem = new AESemaphore("DMS:block");
                this.waiters.add(sem);
            }
            try {
                sem.reserve(1000L);
            }
            finally {
                object = DiskManagerFileInfoStream.this.lock;
                synchronized (object) {
                    this.waiters.remove(sem);
                }
            }
            return 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected channel createChannel() {
            Object object = DiskManagerFileInfoStream.this.lock;
            synchronized (object) {
                channel c = new channel();
                this.channels.add(c);
                return c;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void removeChannel(channel c) {
            Object object = DiskManagerFileInfoStream.this.lock;
            synchronized (object) {
                this.channels.remove(c);
                if (this.channels.size() == 0 && DiskManagerFileInfoStream.this.save_to.exists()) {
                    this.destroy(null);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void destroy(Throwable error) {
            if (error != null) {
                Debug.out(error);
            }
            Object object = DiskManagerFileInfoStream.this.lock;
            synchronized (object) {
                if (this.context_destroyed) {
                    return;
                }
                this.context_destroyed = true;
                if (this.channels != null) {
                    ArrayList<channel> channels_copy = new ArrayList<channel>(this.channels);
                    for (channel c : channels_copy) {
                        c.destroy();
                    }
                }
                if (this.raf != null) {
                    try {
                        this.raf.close();
                    }
                    catch (Throwable e) {
                        // empty catch block
                    }
                    this.raf = null;
                }
                if (this.stream_details != null) {
                    try {
                        this.stream_details.getStream().close();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    this.stream_details = null;
                }
                if (error != null) {
                    DiskManagerFileInfoStream.this.save_to.delete();
                }
            }
            DiskManagerFileInfoStream.this.destroyed(this);
        }

        static /* synthetic */ StreamFactory.StreamDetails access$202(context x0, StreamFactory.StreamDetails x1) {
            x0.stream_details = x1;
            return x0.stream_details;
        }

        static /* synthetic */ boolean access$400(context x0) {
            return x0.stream_got_eof;
        }

        static /* synthetic */ RandomAccessFile access$502(context x0, RandomAccessFile x1) {
            x0.raf = x1;
            return x0.raf;
        }

        protected class channel
        implements DiskManagerChannel {
            private volatile boolean channel_destroyed;
            private volatile long channel_position;

            protected channel() {
            }

            @Override
            public DiskManagerRequest createRequest() {
                return new request();
            }

            @Override
            public DiskManagerFileInfo getFile() {
                return DiskManagerFileInfoStream.this;
            }

            @Override
            public long getPosition() {
                return this.channel_position;
            }

            @Override
            public boolean isDestroyed() {
                return this.channel_destroyed;
            }

            @Override
            public void destroy() {
                this.channel_destroyed = true;
                context.this.removeChannel(this);
            }

            protected class request
            implements DiskManagerRequest {
                private long offset;
                private long length;
                private long position;
                private int max_read_chunk = 131072;
                private volatile boolean request_cancelled;
                private CopyOnWriteList<DiskManagerListener> listeners = new CopyOnWriteList();

                protected request() {
                }

                @Override
                public void setType(int type) {
                    if (type != 1) {
                        throw new RuntimeException("Not supported");
                    }
                }

                @Override
                public void setOffset(long _offset) {
                    this.offset = _offset;
                }

                @Override
                public void setLength(long _length) {
                    this.length = _length == -1L ? Long.MAX_VALUE : _length;
                }

                @Override
                public void setMaximumReadChunkSize(int size) {
                    if (size > 16384) {
                        this.max_read_chunk = size;
                    }
                }

                @Override
                public long getAvailableBytes() {
                    return this.getRemaining();
                }

                @Override
                public long getRemaining() {
                    return this.length == Long.MAX_VALUE ? this.length : this.offset + this.length - this.position;
                }

                @Override
                public void run() {
                    try {
                        byte[] buffer = new byte[this.max_read_chunk];
                        long rem = this.length;
                        long pos = this.offset;
                        while (rem > 0L) {
                            if (this.request_cancelled) {
                                throw new Exception("Cancelled");
                            }
                            if (channel.this.channel_destroyed) {
                                throw new Exception("Destroyed");
                            }
                            int chunk = (int)Math.min(rem, (long)this.max_read_chunk);
                            int len = context.this.read(buffer, pos, chunk);
                            if (len == -1) {
                                if (this.length != Long.MAX_VALUE) {
                                    throw new Exception("Premature end of stream (complete)");
                                }
                                break;
                            }
                            if (len == 0) {
                                this.sendEvent(new event(pos));
                                continue;
                            }
                            this.sendEvent(new event(new PooledByteBufferImpl(buffer, 0, len), pos, len));
                            rem -= (long)len;
                            pos += (long)len;
                        }
                    }
                    catch (Throwable e) {
                        this.sendEvent(new event(e));
                    }
                }

                @Override
                public void cancel() {
                    this.request_cancelled = true;
                }

                @Override
                public void setUserAgent(String agent) {
                }

                protected void sendEvent(event ev) {
                    for (DiskManagerListener l : this.listeners) {
                        l.eventOccurred(ev);
                    }
                }

                @Override
                public void addListener(DiskManagerListener listener) {
                    this.listeners.add(listener);
                }

                @Override
                public void removeListener(DiskManagerListener listener) {
                    this.listeners.remove(listener);
                }

                protected class event
                implements DiskManagerEvent {
                    private int event_type;
                    private Throwable error;
                    private PooledByteBuffer buffer;
                    private long event_offset;
                    private int event_length;

                    protected event(Throwable _error) {
                        this.event_type = 2;
                        this.error = _error;
                    }

                    protected event(long _offset) {
                        this.event_type = 3;
                        this.event_offset = _offset;
                        channel.this.channel_position = _offset;
                    }

                    protected event(PooledByteBuffer _buffer, long _offset, int _length) {
                        this.event_type = 1;
                        this.buffer = _buffer;
                        this.event_offset = _offset;
                        this.event_length = _length;
                        channel.this.channel_position = _offset + (long)_length - 1L;
                    }

                    @Override
                    public int getType() {
                        return this.event_type;
                    }

                    public DiskManagerRequest getRequest() {
                        return request.this;
                    }

                    @Override
                    public long getOffset() {
                        return this.event_offset;
                    }

                    @Override
                    public int getLength() {
                        return this.event_length;
                    }

                    @Override
                    public PooledByteBuffer getBuffer() {
                        return this.buffer;
                    }

                    @Override
                    public Throwable getFailure() {
                        return this.error;
                    }
                }
            }
        }
    }
}

