/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.diskmanager.cache.impl;

import com.aelitis.azureus.core.diskmanager.cache.CacheFile;
import com.aelitis.azureus.core.diskmanager.cache.CacheFileManagerException;
import com.aelitis.azureus.core.diskmanager.cache.impl.CacheFileManagerImpl;
import com.aelitis.azureus.core.diskmanager.file.FMFile;
import com.aelitis.azureus.core.diskmanager.file.FMFileManagerException;
import java.io.File;
import org.gudy.azureus2.core3.torrent.TOTorrentFile;
import org.gudy.azureus2.core3.util.DirectByteBuffer;

public class CacheFileWithoutCache
implements CacheFile {
    protected final CacheFileManagerImpl manager;
    protected final FMFile file;
    protected final TOTorrentFile torrent_file;
    private long bytes_written;
    private long bytes_read;

    protected CacheFileWithoutCache(CacheFileManagerImpl _manager, FMFile _file, TOTorrentFile _torrent_file) {
        this.manager = _manager;
        this.file = _file;
        this.torrent_file = _torrent_file;
    }

    @Override
    public TOTorrentFile getTorrentFile() {
        return this.torrent_file;
    }

    @Override
    public boolean exists() {
        return this.file.exists();
    }

    @Override
    public void moveFile(File new_file) throws CacheFileManagerException {
        try {
            this.file.moveFile(new_file);
        }
        catch (FMFileManagerException e) {
            this.manager.rethrow(this, e);
        }
    }

    @Override
    public void renameFile(String new_file) throws CacheFileManagerException {
        try {
            this.file.renameFile(new_file);
        }
        catch (FMFileManagerException e) {
            this.manager.rethrow(this, e);
        }
    }

    @Override
    public void setAccessMode(int mode) throws CacheFileManagerException {
        try {
            this.file.setAccessMode(mode == 1 ? 1 : 2);
        }
        catch (FMFileManagerException e) {
            this.manager.rethrow(this, e);
        }
    }

    @Override
    public int getAccessMode() {
        return this.file.getAccessMode() == 1 ? 1 : 2;
    }

    @Override
    public void setStorageType(int type) throws CacheFileManagerException {
        try {
            this.file.setStorageType(CacheFileManagerImpl.convertCacheToFileType(type));
        }
        catch (FMFileManagerException e) {
            this.manager.rethrow(this, e);
        }
    }

    @Override
    public int getStorageType() {
        return CacheFileManagerImpl.convertFileToCacheType(this.file.getStorageType());
    }

    @Override
    public long getLength() throws CacheFileManagerException {
        try {
            return this.file.exists() ? this.file.getLength() : 0L;
        }
        catch (FMFileManagerException e) {
            this.manager.rethrow(this, e);
            return 0L;
        }
    }

    @Override
    public long compareLength(long compare_to) throws CacheFileManagerException {
        return this.getLength() - compare_to;
    }

    @Override
    public void setLength(long length) throws CacheFileManagerException {
        try {
            this.file.setLength(length);
        }
        catch (FMFileManagerException e) {
            this.manager.rethrow(this, e);
        }
    }

    @Override
    public void setPieceComplete(int piece_number, DirectByteBuffer piece_data) throws CacheFileManagerException {
        try {
            this.file.setPieceComplete(piece_number, piece_data);
        }
        catch (FMFileManagerException e) {
            this.manager.rethrow(this, e);
        }
    }

    @Override
    public void read(DirectByteBuffer[] buffers, long position, short policy) throws CacheFileManagerException {
        int read_length = 0;
        for (int i = 0; i < buffers.length; ++i) {
            read_length += buffers[i].remaining((byte)3);
        }
        try {
            this.file.read(buffers, position);
            this.manager.fileBytesRead(read_length);
            this.bytes_read += (long)read_length;
        }
        catch (FMFileManagerException e) {
            this.manager.rethrow(this, e);
        }
    }

    @Override
    public void read(DirectByteBuffer buffer, long position, short policy) throws CacheFileManagerException {
        int read_length = buffer.remaining((byte)3);
        try {
            this.file.read(buffer, position);
            this.manager.fileBytesRead(read_length);
            this.bytes_read += (long)read_length;
        }
        catch (FMFileManagerException e) {
            this.manager.rethrow(this, e);
        }
    }

    @Override
    public void write(DirectByteBuffer buffer, long position) throws CacheFileManagerException {
        int write_length = buffer.remaining((byte)3);
        try {
            this.file.write(buffer, position);
            this.manager.fileBytesWritten(write_length);
            this.bytes_written += (long)write_length;
        }
        catch (FMFileManagerException e) {
            this.manager.rethrow(this, e);
        }
    }

    @Override
    public void write(DirectByteBuffer[] buffers, long position) throws CacheFileManagerException {
        int write_length = 0;
        for (int i = 0; i < buffers.length; ++i) {
            write_length += buffers[i].remaining((byte)3);
        }
        try {
            this.file.write(buffers, position);
            this.manager.fileBytesWritten(write_length);
            this.bytes_written += (long)write_length;
        }
        catch (FMFileManagerException e) {
            this.manager.rethrow(this, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeAndHandoverBuffer(DirectByteBuffer buffer, long position) throws CacheFileManagerException {
        int write_length = buffer.remaining((byte)3);
        boolean write_ok = false;
        try {
            this.file.write(buffer, position);
            this.manager.fileBytesWritten(write_length);
            this.bytes_written += (long)write_length;
            write_ok = true;
        }
        catch (FMFileManagerException e) {
            this.manager.rethrow(this, e);
        }
        finally {
            if (write_ok) {
                buffer.returnToPool();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeAndHandoverBuffers(DirectByteBuffer[] buffers, long position) throws CacheFileManagerException {
        block7: {
            int write_length = 0;
            for (int i = 0; i < buffers.length; ++i) {
                write_length += buffers[i].remaining((byte)3);
            }
            boolean write_ok = false;
            try {
                this.file.write(buffers, position);
                this.manager.fileBytesWritten(write_length);
                this.bytes_written += (long)write_length;
                write_ok = true;
            }
            catch (FMFileManagerException e) {
                this.manager.rethrow(this, e);
            }
            finally {
                if (!write_ok) break block7;
                for (int i = 0; i < buffers.length; ++i) {
                    buffers[i].returnToPool();
                }
            }
        }
    }

    @Override
    public void flushCache() throws CacheFileManagerException {
        try {
            this.file.flush();
        }
        catch (FMFileManagerException e) {
            this.manager.rethrow(this, e);
        }
    }

    @Override
    public void clearCache() throws CacheFileManagerException {
    }

    @Override
    public void close() throws CacheFileManagerException {
        try {
            this.file.close();
        }
        catch (FMFileManagerException e) {
            this.manager.rethrow(this, e);
        }
    }

    @Override
    public boolean isOpen() {
        return this.file.isOpen();
    }

    @Override
    public long getSessionBytesRead() {
        return this.bytes_read;
    }

    @Override
    public long getSessionBytesWritten() {
        return this.bytes_written;
    }

    @Override
    public void delete() throws CacheFileManagerException {
        try {
            this.file.delete();
        }
        catch (FMFileManagerException e) {
            this.manager.rethrow(this, e);
        }
    }
}

