/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.diskmanager.cache.impl;

import com.aelitis.azureus.core.diskmanager.cache.impl.CacheFileWithCache;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DirectByteBuffer;
import org.gudy.azureus2.core3.util.SystemTime;

public class CacheEntry {
    protected static final int CT_DATA_WRITE = 0;
    protected static final int CT_READ_AHEAD = 1;
    protected CacheFileWithCache file;
    protected DirectByteBuffer buffer;
    protected final long offset;
    protected int size;
    protected int buffer_pos;
    protected int buffer_limit;
    protected boolean dirty;
    protected long last_used;
    protected int entry_type;
    protected int usage_count;

    CacheEntry(long offset) {
        this.offset = offset;
    }

    protected CacheEntry(int _entry_type, CacheFileWithCache _file, DirectByteBuffer _buffer, long _offset, int _size) {
        this.entry_type = _entry_type;
        this.file = _file;
        this.buffer = _buffer;
        this.offset = _offset;
        this.size = _size;
        this.buffer_pos = this.buffer.position((byte)3);
        this.buffer_limit = this.buffer.limit((byte)3);
        if (this.size != this.buffer_limit - this.buffer_pos) {
            Debug.out("CacheEntry: initial size incorrect - size =" + this.size + ", pos = " + this.buffer_pos + ", lim = " + this.buffer_limit);
        }
        this.dirty = true;
        this.last_used = SystemTime.getCurrentTime();
    }

    public CacheFileWithCache getFile() {
        return this.file;
    }

    public long getFilePosition() {
        return this.offset;
    }

    public int getLength() {
        return this.size;
    }

    public DirectByteBuffer getBuffer() {
        return this.buffer;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setClean() {
        this.dirty = false;
    }

    protected void resetBufferPosition() {
        this.buffer.position((byte)3, this.buffer_pos);
    }

    protected void used() {
        this.last_used = SystemTime.getCurrentTime();
        ++this.usage_count;
    }

    protected long getLastUsed() {
        return this.last_used;
    }

    protected int getUsageCount() {
        return this.usage_count;
    }

    protected int getType() {
        return this.entry_type;
    }

    protected String getString() {
        return "[" + this.offset + " - " + (this.offset + (long)this.size - 1L) + ":" + this.buffer.position((byte)3) + "/" + this.buffer.limit((byte)3) + "]";
    }
}

