/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.diskmanager.access.impl;

import com.aelitis.azureus.core.diskmanager.access.DiskAccessRequest;
import com.aelitis.azureus.core.diskmanager.access.DiskAccessRequestListener;
import com.aelitis.azureus.core.diskmanager.cache.CacheFile;
import com.aelitis.azureus.core.diskmanager.cache.CacheFileManagerException;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DirectByteBuffer;

public class DiskAccessRequestImpl
implements DiskAccessRequest {
    protected static final short OP_READ = 1;
    protected static final short OP_WRITE = 2;
    protected static final short OP_WRITE_AND_FREE = 3;
    private final CacheFile file;
    private final long offset;
    private final DirectByteBuffer buffer;
    private final DiskAccessRequestListener listener;
    private final short op;
    private final short cache_policy;
    private final int size;
    private volatile boolean cancelled;

    protected DiskAccessRequestImpl(CacheFile _file, long _offset, DirectByteBuffer _buffer, DiskAccessRequestListener _listener, short _op, short _cache_policy) {
        this.file = _file;
        this.offset = _offset;
        this.buffer = _buffer;
        this.listener = _listener;
        this.op = _op;
        this.cache_policy = _cache_policy;
        this.size = this.buffer.remaining((byte)4);
    }

    @Override
    public int getSize() {
        return this.size;
    }

    protected void runRequest() {
        if (this.cancelled) {
            this.listener.requestCancelled(this);
            return;
        }
        try {
            if (this.op == 1) {
                this.file.read(this.buffer, this.offset, this.cache_policy);
            } else if (this.op == 2) {
                this.file.write(this.buffer, this.offset);
            } else {
                this.file.writeAndHandoverBuffer(this.buffer, this.offset);
            }
            this.listener.requestExecuted(this.size);
            this.listener.requestComplete(this);
        }
        catch (Throwable e) {
            this.listener.requestFailed(this, e);
        }
    }

    protected boolean canBeAggregatedWith(DiskAccessRequestImpl other) {
        return this.op == other.getOperation() && this.cache_policy == other.getCachePolicy();
    }

    protected static void runAggregated(DiskAccessRequestImpl base_request, DiskAccessRequestImpl[] requests) {
        DiskAccessRequestImpl request2;
        int i;
        int op = base_request.getOperation();
        CacheFile file = base_request.getFile();
        long offset = base_request.getOffset();
        short cache_policy = base_request.getCachePolicy();
        DirectByteBuffer[] buffers = new DirectByteBuffer[requests.length];
        long current_offset = offset;
        long total_size = 0L;
        for (i = 0; i < buffers.length; ++i) {
            request2 = requests[i];
            if (current_offset != request2.getOffset()) {
                Debug.out("assert failed: requests not contiguous");
            }
            int size = request2.getSize();
            current_offset += (long)size;
            total_size += (long)size;
            buffers[i] = request2.getBuffer();
        }
        try {
            if (op == 1) {
                file.read(buffers, offset, cache_policy);
            } else if (op == 2) {
                file.write(buffers, offset);
            } else {
                file.writeAndHandoverBuffers(buffers, offset);
            }
            base_request.getListener().requestExecuted(total_size);
            for (i = 0; i < requests.length; ++i) {
                request2 = requests[i];
                request2.getListener().requestComplete(request2);
                if (request2 == base_request) continue;
                request2.getListener().requestExecuted(0L);
            }
        }
        catch (CacheFileManagerException e) {
            DiskAccessRequestImpl request3;
            int i2;
            int fail_index = e.getFailIndex();
            for (i2 = 0; i2 < fail_index; ++i2) {
                request3 = requests[i2];
                request3.getListener().requestComplete(request3);
            }
            for (i2 = fail_index; i2 < requests.length; ++i2) {
                request3 = requests[i2];
                request3.getListener().requestFailed(request3, e);
            }
        }
        catch (Throwable e) {
            for (int i3 = 0; i3 < requests.length; ++i3) {
                DiskAccessRequestImpl request4 = requests[i3];
                request4.getListener().requestFailed(request4, e);
            }
        }
    }

    @Override
    public CacheFile getFile() {
        return this.file;
    }

    @Override
    public long getOffset() {
        return this.offset;
    }

    @Override
    public DirectByteBuffer getBuffer() {
        return this.buffer;
    }

    @Override
    public void cancel() {
        this.cancelled = true;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public short getCachePolicy() {
        return this.cache_policy;
    }

    protected int getOperation() {
        return this.op;
    }

    @Override
    public int getPriority() {
        return this.listener.getPriority();
    }

    protected DiskAccessRequestListener getListener() {
        return this.listener;
    }
}

