/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.dht.transport.udp.impl.packethandler;

import com.aelitis.net.udp.uc.PRUDPPacketHandler;
import com.aelitis.net.udp.uc.PRUDPPacketHandlerStats;

public class DHTUDPPacketHandlerStats {
    private long packets_sent;
    private long packets_received;
    private long bytes_sent;
    private long bytes_received;
    private long timeouts;
    private final PRUDPPacketHandlerStats stats;

    protected DHTUDPPacketHandlerStats(PRUDPPacketHandler _handler) {
        this.stats = _handler.getStats();
    }

    protected DHTUDPPacketHandlerStats(DHTUDPPacketHandlerStats _originator, PRUDPPacketHandlerStats _stats) {
        this.packets_sent = _originator.packets_sent;
        this.packets_received = _originator.packets_received;
        this.bytes_sent = _originator.bytes_sent;
        this.bytes_received = _originator.bytes_received;
        this.timeouts = _originator.timeouts;
        this.stats = _stats;
    }

    protected void timeout() {
        ++this.timeouts;
    }

    protected void packetSent(long bytes) {
        ++this.packets_sent;
        this.bytes_sent += bytes;
    }

    protected void packetReceived(long bytes) {
        ++this.packets_received;
        this.bytes_received += bytes;
    }

    public long getPacketsSent() {
        return this.packets_sent;
    }

    public long getPacketsReceived() {
        return this.packets_received;
    }

    public long getRequestsTimedOut() {
        return this.timeouts;
    }

    public long getBytesSent() {
        return this.bytes_sent;
    }

    public long getBytesReceived() {
        return this.bytes_received;
    }

    public long getSendQueueLength() {
        return this.stats.getSendQueueLength();
    }

    public long getReceiveQueueLength() {
        return this.stats.getReceiveQueueLength();
    }

    public DHTUDPPacketHandlerStats snapshot() {
        return new DHTUDPPacketHandlerStats(this, this.stats.snapshot());
    }
}

