/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.dht.transport.udp.impl.packethandler;

import com.aelitis.azureus.core.dht.transport.udp.impl.DHTUDPPacketReply;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTUDPPacketRequest;
import com.aelitis.azureus.core.dht.transport.udp.impl.packethandler.DHTUDPPacketHandlerException;
import com.aelitis.azureus.core.dht.transport.udp.impl.packethandler.DHTUDPPacketHandlerFactory;
import com.aelitis.azureus.core.dht.transport.udp.impl.packethandler.DHTUDPPacketHandlerStats;
import com.aelitis.azureus.core.dht.transport.udp.impl.packethandler.DHTUDPPacketHandlerStub;
import com.aelitis.azureus.core.dht.transport.udp.impl.packethandler.DHTUDPPacketReceiver;
import com.aelitis.azureus.core.dht.transport.udp.impl.packethandler.DHTUDPRequestHandler;
import com.aelitis.azureus.core.util.DNSUtils;
import com.aelitis.azureus.core.util.bloom.BloomFilter;
import com.aelitis.azureus.core.util.bloom.BloomFilterFactory;
import com.aelitis.net.udp.uc.PRUDPPacket;
import com.aelitis.net.udp.uc.PRUDPPacketHandler;
import com.aelitis.net.udp.uc.PRUDPPacketHandlerException;
import com.aelitis.net.udp.uc.PRUDPPacketHandlerRequest;
import com.aelitis.net.udp.uc.PRUDPPacketReceiver;
import com.aelitis.net.udp.uc.PRUDPPacketReply;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.URL;
import org.gudy.azureus2.core3.util.AddressUtils;
import org.gudy.azureus2.core3.util.Base32;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.UrlUtils;

public class DHTUDPPacketHandler
implements DHTUDPPacketHandlerStub {
    private final DHTUDPPacketHandlerFactory factory;
    final int network;
    private final PRUDPPacketHandler packet_handler;
    private final DHTUDPRequestHandler request_handler;
    private final DHTUDPPacketHandlerStats stats;
    private boolean test_network_alive = true;
    private static final int BLOOM_FILTER_SIZE = 10000;
    private static final int BLOOM_ROTATION_PERIOD = 180000;
    private BloomFilter bloom1;
    private BloomFilter bloom2;
    private long last_bloom_rotation_time;
    private boolean destroyed;

    protected DHTUDPPacketHandler(DHTUDPPacketHandlerFactory _factory, int _network, PRUDPPacketHandler _packet_handler, DHTUDPRequestHandler _request_handler) {
        this.factory = _factory;
        this.network = _network;
        this.packet_handler = _packet_handler;
        this.request_handler = _request_handler;
        this.bloom1 = BloomFilterFactory.createAddOnly(10000);
        this.bloom2 = BloomFilterFactory.createAddOnly(10000);
        this.stats = new DHTUDPPacketHandlerStats(this.packet_handler);
    }

    public boolean isDestroyed() {
        return this.destroyed;
    }

    public void testNetworkAlive(boolean alive) {
        this.test_network_alive = alive;
    }

    public DHTUDPRequestHandler getRequestHandler() {
        return this.request_handler;
    }

    public PRUDPPacketHandler getPacketHandler() {
        return this.packet_handler;
    }

    protected int getNetwork() {
        return this.network;
    }

    protected void updateBloom(InetSocketAddress destination_address) {
        if (!destination_address.isUnresolved()) {
            long diff = SystemTime.getCurrentTime() - this.last_bloom_rotation_time;
            if (diff < 0L || diff > 180000L) {
                this.bloom1 = this.bloom2;
                this.bloom2 = BloomFilterFactory.createAddOnly(10000);
                this.last_bloom_rotation_time = SystemTime.getCurrentTime();
            }
            byte[] address_bytes = destination_address.getAddress().getAddress();
            this.bloom1.add(address_bytes);
            this.bloom2.add(address_bytes);
        }
    }

    public void sendAndReceive(DHTUDPPacketRequest request2, InetSocketAddress destination_address, final DHTUDPPacketReceiver receiver, long timeout, int priority) throws DHTUDPPacketHandlerException {
        if (this.destroyed) {
            throw new DHTUDPPacketHandlerException("packet handler is destroyed");
        }
        destination_address = AddressUtils.adjustDHTAddress(destination_address, true);
        try {
            request2.setNetwork(this.network);
            if (this.test_network_alive) {
                if (destination_address.isUnresolved() && destination_address.getHostName().equals("dht6.vuze.com")) {
                    this.tunnelIPv6SeedRequest(request2, destination_address, receiver);
                } else {
                    this.updateBloom(destination_address);
                    this.packet_handler.sendAndReceive(request2, destination_address, new PRUDPPacketReceiver(){

                        @Override
                        public void packetReceived(PRUDPPacketHandlerRequest request2, PRUDPPacket packet, InetSocketAddress from_address) {
                            DHTUDPPacketReply reply = (DHTUDPPacketReply)packet;
                            DHTUDPPacketHandler.this.stats.packetReceived(reply.getSerialisedSize());
                            if (reply.getNetwork() == DHTUDPPacketHandler.this.network) {
                                receiver.packetReceived(reply, from_address, request2.getElapsedTime());
                            } else {
                                Debug.out("Non-matching network reply received: expected=" + DHTUDPPacketHandler.this.network + ", actual=" + reply.getNetwork());
                                receiver.error(new DHTUDPPacketHandlerException(new Exception("Non-matching network reply received")));
                            }
                        }

                        @Override
                        public void error(PRUDPPacketHandlerException e) {
                            receiver.error(new DHTUDPPacketHandlerException(e));
                        }
                    }, timeout, priority);
                }
            } else {
                receiver.error(new DHTUDPPacketHandlerException(new Exception("Test network disabled")));
            }
        }
        catch (PRUDPPacketHandlerException e) {
            throw new DHTUDPPacketHandlerException(e);
        }
        finally {
            this.stats.packetSent(request2.getSerialisedSize());
        }
    }

    public void send(DHTUDPPacketRequest request2, InetSocketAddress destination_address) throws DHTUDPPacketHandlerException {
        if (this.destroyed) {
            throw new DHTUDPPacketHandlerException("packet handler is destroyed");
        }
        destination_address = AddressUtils.adjustDHTAddress(destination_address, true);
        this.updateBloom(destination_address);
        try {
            request2.setNetwork(this.network);
            if (this.test_network_alive) {
                this.packet_handler.send(request2, destination_address);
            }
        }
        catch (PRUDPPacketHandlerException e) {
            throw new DHTUDPPacketHandlerException(e);
        }
        finally {
            this.stats.packetSent(request2.getSerialisedSize());
        }
    }

    @Override
    public void send(DHTUDPPacketReply reply, InetSocketAddress destination_address) throws DHTUDPPacketHandlerException {
        if (this.destroyed) {
            throw new DHTUDPPacketHandlerException("packet handler is destroyed");
        }
        destination_address = AddressUtils.adjustDHTAddress(destination_address, true);
        try {
            reply.setNetwork(this.network);
            if (this.test_network_alive) {
                this.packet_handler.send(reply, destination_address);
            }
        }
        catch (PRUDPPacketHandlerException e) {
            throw new DHTUDPPacketHandlerException(e);
        }
        finally {
            this.stats.packetSent(reply.getSerialisedSize());
        }
    }

    protected void receive(DHTUDPPacketRequest request2) {
        if (this.destroyed) {
            return;
        }
        if (this.test_network_alive) {
            boolean alien;
            request2.setAddress(AddressUtils.adjustDHTAddress(request2.getAddress(), false));
            byte[] bloom_key = request2.getAddress().getAddress().getAddress();
            boolean bl = alien = !this.bloom1.contains(bloom_key);
            if (alien) {
                this.bloom1.add(bloom_key);
                this.bloom2.add(bloom_key);
            }
            this.stats.packetReceived(request2.getSerialisedSize());
            this.request_handler.process(request2, alien);
        }
    }

    public void setDelays(int send_delay, int receive_delay, int queued_request_timeout) {
        this.packet_handler.setDelays(send_delay, receive_delay, queued_request_timeout);
    }

    public void destroy() {
        this.factory.destroy(this);
        this.destroyed = true;
    }

    public DHTUDPPacketHandlerStats getStats() {
        return this.stats;
    }

    private void tunnelIPv6SeedRequest(DHTUDPPacketRequest request2, InetSocketAddress destination_address, DHTUDPPacketReceiver receiver) throws DHTUDPPacketHandlerException {
        if (this.destroyed) {
            throw new DHTUDPPacketHandlerException("packet handler is destroyed");
        }
        if (request2.getAction() != 1028) {
            return;
        }
        try {
            int len;
            long start = SystemTime.getMonotonousTime();
            ByteArrayOutputStream baos_req = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(baos_req);
            request2.serialise(dos);
            dos.close();
            byte[] request_bytes = baos_req.toByteArray();
            String host = "dht6tunnel.vuze.com";
            DNSUtils.DNSUtilsIntf dns_utils = DNSUtils.getSingleton();
            if (dns_utils != null) {
                try {
                    host = dns_utils.getIPV6ByName(host).getHostAddress();
                    host = UrlUtils.convertIPV6Host(host);
                }
                catch (Throwable e) {
                    // empty catch block
                }
            }
            URL url = new URL("http://" + host + "/dht?port=" + this.packet_handler.getPort() + "&request=" + Base32.encode(request_bytes));
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setConnectTimeout(10000);
            connection.setReadTimeout(20000);
            InputStream is = connection.getInputStream();
            ByteArrayOutputStream baos_rep = new ByteArrayOutputStream(1000);
            byte[] buffer = new byte[8192];
            while ((len = is.read(buffer)) > 0) {
                baos_rep.write(buffer, 0, len);
            }
            byte[] reply_bytes = baos_rep.toByteArray();
            if (reply_bytes.length > 0) {
                DHTUDPPacketReply reply = (DHTUDPPacketReply)PRUDPPacketReply.deserialiseReply(this.packet_handler, destination_address, new DataInputStream(new ByteArrayInputStream(reply_bytes)));
                receiver.packetReceived(reply, destination_address, SystemTime.getMonotonousTime() - start);
            }
        }
        catch (Throwable e) {
            throw new DHTUDPPacketHandlerException("Tunnel failed", e);
        }
    }
}

