/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.dht.transport.udp.impl;

import com.aelitis.azureus.core.dht.transport.DHTTransportContact;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTTransportUDPImpl;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTUDPPacketReply;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTUDPPacketRequestQueryStorage;
import com.aelitis.azureus.core.dht.transport.udp.impl.packethandler.DHTUDPPacketNetworkHandler;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;

public class DHTUDPPacketReplyQueryStorage
extends DHTUDPPacketReply {
    private int random_id;
    private int header_length;
    private List<byte[]> response;

    public DHTUDPPacketReplyQueryStorage(DHTTransportUDPImpl transport, DHTUDPPacketRequestQueryStorage request2, DHTTransportContact local_contact, DHTTransportContact remote_contact) {
        super(transport, 1039, request2, local_contact, remote_contact);
    }

    protected DHTUDPPacketReplyQueryStorage(DHTUDPPacketNetworkHandler network_handler, InetSocketAddress originator, DataInputStream is, int trans_id) throws IOException {
        super(network_handler, originator, is, 1039, trans_id);
        int size = is.readShort();
        this.response = new ArrayList<byte[]>(size);
        if (size > 0) {
            this.header_length = is.readByte() & 0xFF;
            byte[] bitmap = new byte[size + 0];
            is.read(bitmap);
            int pos = 0;
            int current = 0;
            for (int i = 0; i < size; ++i) {
                if (i % 8 == 0) {
                    current = bitmap[pos++] & 0xFF;
                }
                if ((current & 0x80) != 0) {
                    byte[] x = new byte[this.header_length];
                    is.read(x);
                    this.response.add(x);
                } else {
                    this.response.add(null);
                }
                current <<= 1;
            }
        }
    }

    @Override
    public void serialise(DataOutputStream os) throws IOException {
        super.serialise(os);
        int size = this.response.size();
        os.writeShort(size);
        if (size > 0) {
            os.writeByte(this.header_length);
            byte[] bitmap = new byte[size + 0];
            int bitmap_pos = 0;
            int current_byte = 0;
            int pos = 0;
            for (byte[] x : this.response) {
                current_byte <<= 1;
                if (x != null) {
                    ++current_byte;
                }
                if (pos % 8 == 7) {
                    bitmap[bitmap_pos++] = (byte)current_byte;
                    current_byte = 0;
                }
                ++pos;
            }
            if (pos % 8 != 0) {
                bitmap[bitmap_pos++] = (byte)(current_byte << 8 - pos % 8);
            }
            os.write(bitmap);
            for (byte[] x : this.response) {
                if (x == null) continue;
                os.write(x);
            }
        }
    }

    protected void setRandomID(int id) {
        this.random_id = id;
    }

    protected int getRandomID() {
        return this.random_id;
    }

    protected void setResponse(int _header_length, List<byte[]> _response) {
        this.header_length = _header_length;
        this.response = _response;
    }

    protected List<byte[]> getResponse() {
        return this.response;
    }
}

