/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.dht.transport.udp.impl;

import com.aelitis.azureus.core.dht.netcoords.DHTNetworkPosition;
import com.aelitis.azureus.core.dht.transport.DHTTransportContact;
import com.aelitis.azureus.core.dht.transport.udp.DHTTransportUDP;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTTransportUDPImpl;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTUDPPacket;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTUDPPacketRequest;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTUDPUtils;
import com.aelitis.azureus.core.dht.transport.udp.impl.packethandler.DHTUDPPacketNetworkHandler;
import com.aelitis.net.udp.uc.PRUDPPacketReply;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import org.gudy.azureus2.core3.util.SystemTime;

public class DHTUDPPacketReply
extends PRUDPPacketReply
implements DHTUDPPacket {
    public static final int DHT_HEADER_SIZE = 26;
    private DHTTransportUDPImpl transport;
    private long connection_id;
    private byte protocol_version;
    private byte vendor_id = (byte)-1;
    private int network;
    private int target_instance_id;
    private byte flags;
    private byte flags2;
    private long skew;
    private DHTNetworkPosition[] network_positions;
    private short processing_time;
    private long request_receive_time;

    public DHTUDPPacketReply(DHTTransportUDPImpl _transport, int _type, DHTUDPPacketRequest _request, DHTTransportContact _local_contact, DHTTransportContact _remote_contact) {
        super(_type, _request.getTransactionId());
        this.transport = _transport;
        this.connection_id = _request.getConnectionId();
        this.protocol_version = _remote_contact.getProtocolVersion();
        if (this.protocol_version > _transport.getProtocolVersion()) {
            this.protocol_version = _transport.getProtocolVersion();
        }
        this.target_instance_id = _local_contact.getInstanceID();
        this.skew = _remote_contact.getClockSkew();
        this.flags = this.transport.getGenericFlags();
        this.flags2 = this.transport.getGenericFlags2();
        this.request_receive_time = _request.getReceiveTime();
    }

    protected DHTUDPPacketReply(DHTUDPPacketNetworkHandler network_handler, InetSocketAddress originator, DataInputStream is, int type, int trans_id) throws IOException {
        super(type, trans_id);
        this.setAddress(originator);
        this.connection_id = is.readLong();
        this.protocol_version = is.readByte();
        if (this.protocol_version >= 14) {
            this.vendor_id = is.readByte();
        }
        if (this.protocol_version >= 9) {
            this.network = is.readInt();
        }
        if (this.protocol_version < (this.network == 1 ? DHTTransportUDP.PROTOCOL_VERSION_MIN_CVS : DHTTransportUDP.PROTOCOL_VERSION_MIN)) {
            throw DHTUDPUtils.INVALID_PROTOCOL_VERSION_EXCEPTION;
        }
        this.transport = network_handler.getTransport(this);
        this.target_instance_id = is.readInt();
        if (this.protocol_version >= 51) {
            this.flags = is.readByte();
        }
        if (this.protocol_version >= 53) {
            this.flags2 = is.readByte();
        }
        if (this.protocol_version >= 54) {
            this.processing_time = is.readShort();
        }
    }

    @Override
    public DHTTransportUDPImpl getTransport() {
        return this.transport;
    }

    protected int getTargetInstanceID() {
        return this.target_instance_id;
    }

    public long getConnectionId() {
        return this.connection_id;
    }

    protected long getClockSkew() {
        return this.skew;
    }

    @Override
    public byte getProtocolVersion() {
        return this.protocol_version;
    }

    protected byte getVendorID() {
        return this.vendor_id;
    }

    public int getNetwork() {
        return this.network;
    }

    @Override
    public byte getGenericFlags() {
        return this.flags;
    }

    @Override
    public byte getGenericFlags2() {
        return this.flags2;
    }

    public void setNetwork(int _network) {
        this.network = _network;
    }

    protected DHTNetworkPosition[] getNetworkPositions() {
        return this.network_positions;
    }

    protected void setNetworkPositions(DHTNetworkPosition[] _network_positions) {
        this.network_positions = _network_positions;
    }

    @Override
    public void serialise(DataOutputStream os) throws IOException {
        super.serialise(os);
        os.writeLong(this.connection_id);
        os.writeByte(this.protocol_version);
        if (this.protocol_version >= 14) {
            os.writeByte(0);
        }
        if (this.protocol_version >= 9) {
            os.writeInt(this.network);
        }
        os.writeInt(this.target_instance_id);
        if (this.protocol_version >= 51) {
            os.writeByte(this.flags);
        }
        if (this.protocol_version >= 53) {
            os.writeByte(this.flags2);
        }
        if (this.protocol_version >= 54) {
            if (this.request_receive_time == 0L) {
                os.writeShort(0);
            } else {
                short processing_time = (short)(SystemTime.getCurrentTime() - this.request_receive_time);
                if (processing_time <= 0) {
                    processing_time = 1;
                }
                os.writeShort(processing_time);
            }
        }
    }

    public long getProcessingTime() {
        return this.processing_time & 0xFFFF;
    }

    @Override
    public String getString() {
        return super.getString() + ",[con=" + this.connection_id + ",prot=" + this.protocol_version + ",ven=" + this.vendor_id + ",net=" + this.network + ",fl=" + this.flags + "/" + this.flags2 + "]";
    }
}

