/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.dht.netcoords.vivaldi.ver1.impl;

import com.aelitis.azureus.core.dht.netcoords.DHTNetworkPosition;
import com.aelitis.azureus.core.dht.netcoords.vivaldi.ver1.Coordinates;
import com.aelitis.azureus.core.dht.netcoords.vivaldi.ver1.VivaldiPosition;
import com.aelitis.azureus.core.dht.netcoords.vivaldi.ver1.impl.HeightCoordinatesImpl;
import java.io.DataOutputStream;
import java.io.IOException;

public class VivaldiPositionImpl
implements VivaldiPosition {
    private static final float cc = 0.25f;
    private static final float ce = 0.5f;
    private static final float initial_error = 10.0f;
    private HeightCoordinatesImpl coordinates;
    private float error;
    private int nbUpdates;

    public VivaldiPositionImpl(HeightCoordinatesImpl coordinates) {
        this.coordinates = coordinates;
        this.error = 10.0f;
    }

    @Override
    public byte getPositionType() {
        return 1;
    }

    @Override
    public Coordinates getCoordinates() {
        return this.coordinates;
    }

    @Override
    public double[] getLocation() {
        Coordinates coords = this.getCoordinates();
        return coords.getCoordinates();
    }

    @Override
    public float getErrorEstimate() {
        return this.error;
    }

    @Override
    public void setErrorEstimate(float error) {
        this.error = error;
    }

    @Override
    public void update(float rtt, Coordinates cj, float ej) {
        if (this.valid(rtt) && this.valid(ej) && cj.isValid()) {
            if (rtt <= 0.0f || rtt > 300000.0f) {
                return;
            }
            if (this.error + ej == 0.0f) {
                return;
            }
            float w = this.error / (ej + this.error);
            float re = rtt - this.coordinates.distance(cj);
            float es = Math.abs(re) / rtt;
            float new_error = es * 0.5f * w + this.error * (1.0f - 0.5f * w);
            float delta = 0.25f * w;
            float scale = delta * re;
            HeightCoordinatesImpl random_error = new HeightCoordinatesImpl((float)Math.random() / 10.0f, (float)Math.random() / 10.0f, 0.0f);
            HeightCoordinatesImpl new_coordinates = (HeightCoordinatesImpl)this.coordinates.add(this.coordinates.sub(cj.add(random_error)).unity().scale(scale));
            if (this.valid(new_error) && new_coordinates.isValid()) {
                this.coordinates = new_coordinates;
                this.error = new_error > 0.1f ? new_error : 0.1f;
            } else {
                this.coordinates = new HeightCoordinatesImpl(0.0f, 0.0f, 0.0f);
                this.error = 10.0f;
            }
            if (!cj.atOrigin()) {
                ++this.nbUpdates;
            }
            if (this.nbUpdates > 5) {
                this.nbUpdates = 0;
                this.update(10.0f, new HeightCoordinatesImpl(0.0f, 0.0f, 0.0f), 50.0f);
            }
        }
    }

    @Override
    public boolean isValid() {
        return !Float.isNaN(this.getErrorEstimate()) && this.getCoordinates().isValid();
    }

    private boolean valid(float f) {
        return !Float.isInfinite(f) && !Float.isNaN(f);
    }

    @Override
    public void update(float rtt, float[] data) {
        this.update(rtt, new HeightCoordinatesImpl(data[0], data[1], data[2]), data[3]);
    }

    @Override
    public float estimateRTT(Coordinates coordinates) {
        return this.coordinates.distance(coordinates);
    }

    @Override
    public float[] toFloatArray() {
        return new float[]{this.coordinates.getX(), this.coordinates.getY(), this.coordinates.getH(), this.error};
    }

    @Override
    public void fromFloatArray(float[] data) {
        this.coordinates = new HeightCoordinatesImpl(data[0], data[1], data[2]);
        this.error = data[3];
    }

    public String toString() {
        return this.coordinates + " : " + this.error;
    }

    public boolean equals(Object arg0) {
        if (arg0 instanceof VivaldiPositionImpl) {
            VivaldiPositionImpl other = (VivaldiPositionImpl)arg0;
            if (other.error != this.error) {
                return false;
            }
            return other.coordinates.equals(this.coordinates);
        }
        return false;
    }

    @Override
    public float estimateRTT(DHTNetworkPosition _other) {
        VivaldiPosition other = (VivaldiPosition)_other;
        Coordinates other_coords = other.getCoordinates();
        if (this.coordinates.atOrigin() || other_coords.atOrigin()) {
            return Float.NaN;
        }
        return this.estimateRTT(other_coords);
    }

    @Override
    public void update(byte[] _other_id, DHTNetworkPosition _other, float rtt) {
        VivaldiPositionImpl other = (VivaldiPositionImpl)_other;
        Coordinates other_coords = other.getCoordinates();
        this.update(rtt, other_coords, other.getErrorEstimate());
    }

    @Override
    public int getSerialisedSize() {
        return 16;
    }

    @Override
    public void serialise(DataOutputStream os) throws IOException {
        float[] data = this.toFloatArray();
        for (int i = 0; i < data.length; ++i) {
            os.writeFloat(data[i]);
        }
    }
}

