/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.dht.netcoords;

import com.aelitis.azureus.core.dht.DHTStorageAdapter;
import com.aelitis.azureus.core.dht.impl.DHTLog;
import com.aelitis.azureus.core.dht.netcoords.DHTNetworkPosition;
import com.aelitis.azureus.core.dht.netcoords.DHTNetworkPositionListener;
import com.aelitis.azureus.core.dht.netcoords.DHTNetworkPositionProvider;
import com.aelitis.azureus.core.dht.netcoords.DHTNetworkPositionProviderInstance;
import com.aelitis.azureus.core.dht.netcoords.DHTNetworkPositionProviderListener;
import com.aelitis.azureus.core.util.CopyOnWriteList;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Iterator;
import org.gudy.azureus2.core3.util.Debug;

public class DHTNetworkPositionManager {
    private static DHTNetworkPositionProvider[] providers = new DHTNetworkPositionProvider[0];
    private static final Object providers_lock = new Object();
    private static DHTStorageAdapter storage_adapter = null;
    private static final CopyOnWriteList<DHTNetworkPositionProviderListener> provider_listeners = new CopyOnWriteList();
    private static volatile CopyOnWriteList<DHTNetworkPositionListener> position_listeners;
    private static final DHTNetworkPosition[] NP_EMPTY_ARRAY;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initialise(DHTStorageAdapter adapter) {
        Object object = providers_lock;
        synchronized (object) {
            if (storage_adapter == null) {
                storage_adapter = adapter;
                for (int i = 0; i < providers.length; ++i) {
                    DHTNetworkPositionProvider provider2 = providers[i];
                    try {
                        DHTNetworkPositionManager.startUp(provider2);
                        continue;
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                    }
                }
            }
        }
    }

    private static void startUp(DHTNetworkPositionProvider provider2) {
        byte[] data = null;
        if (storage_adapter != null) {
            data = storage_adapter.getStorageForKey("NPP:" + provider2.getPositionType());
        }
        if (data == null) {
            data = new byte[]{};
        }
        try {
            provider2.startUp(new DataInputStream(new ByteArrayInputStream(data)));
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
    }

    private static void shutDown(DHTNetworkPositionProvider provider2) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(baos);
            provider2.shutDown(dos);
            dos.flush();
            byte[] data = baos.toByteArray();
            storage_adapter.setStorageForKey("NPP:" + provider2.getPositionType(), data);
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void destroy(DHTStorageAdapter adapter) {
        Object object = providers_lock;
        synchronized (object) {
            if (storage_adapter == adapter) {
                for (int i = 0; i < providers.length; ++i) {
                    DHTNetworkPositionManager.shutDown(providers[i]);
                }
                storage_adapter = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DHTNetworkPositionProviderInstance registerProvider(final DHTNetworkPositionProvider provider2) {
        boolean fire_added = false;
        Object object = providers_lock;
        synchronized (object) {
            boolean found = false;
            DHTNetworkPositionProvider type_found = null;
            for (DHTNetworkPositionProvider p : providers) {
                if (p == provider2) {
                    found = true;
                    break;
                }
                if (p.getPositionType() != provider2.getPositionType()) continue;
                type_found = p;
            }
            if (!found) {
                if (type_found != null) {
                    Debug.out("Registration of " + provider2 + " found previous provider for same position type, removing it");
                    DHTNetworkPositionManager.unregisterProviderSupport(type_found);
                }
                DHTNetworkPositionProvider[] new_providers = new DHTNetworkPositionProvider[providers.length + 1];
                System.arraycopy(providers, 0, new_providers, 0, providers.length);
                new_providers[DHTNetworkPositionManager.providers.length] = provider2;
                providers = new_providers;
                if (storage_adapter != null) {
                    DHTNetworkPositionManager.startUp(provider2);
                }
                fire_added = true;
            }
        }
        if (fire_added) {
            for (DHTNetworkPositionProviderListener l : provider_listeners) {
                try {
                    l.providerAdded(provider2);
                }
                catch (Throwable e) {
                    Debug.out(e);
                }
            }
        }
        return new DHTNetworkPositionProviderInstance(){

            @Override
            public void log(String log) {
                DHTLog.log("NetPos " + provider2.getPositionType() + ": " + log);
            }
        };
    }

    public static void unregisterProvider(DHTNetworkPositionProvider provider2) {
        if (DHTNetworkPositionManager.unregisterProviderSupport(provider2)) {
            for (DHTNetworkPositionProviderListener l : provider_listeners) {
                try {
                    l.providerRemoved(provider2);
                }
                catch (Throwable e) {
                    Debug.out(e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean unregisterProviderSupport(DHTNetworkPositionProvider provider2) {
        boolean removed = false;
        Object object = providers_lock;
        synchronized (object) {
            if (providers.length == 0) {
                return false;
            }
            DHTNetworkPositionProvider[] new_providers = new DHTNetworkPositionProvider[providers.length - 1];
            int pos = 0;
            for (int i = 0; i < providers.length; ++i) {
                if (providers[i] == provider2) {
                    if (storage_adapter == null) continue;
                    DHTNetworkPositionManager.shutDown(provider2);
                    continue;
                }
                new_providers[pos++] = providers[i];
            }
            if (pos == new_providers.length) {
                providers = new_providers;
                removed = true;
            }
        }
        return removed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DHTNetworkPositionProvider getProvider(byte type) {
        Object object = providers_lock;
        synchronized (object) {
            for (int i = 0; i < providers.length; ++i) {
                if (providers[i].getPositionType() != type) continue;
                return providers[i];
            }
        }
        return null;
    }

    public static DHTNetworkPosition[] getLocalPositions() {
        DHTNetworkPositionProvider[] prov = providers;
        ArrayList<DHTNetworkPosition> res = new ArrayList<DHTNetworkPosition>();
        for (int i = 0; i < prov.length; ++i) {
            try {
                DHTNetworkPosition pos = prov[i].getLocalPosition();
                if (pos == null) continue;
                res.add(pos);
                continue;
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
        return res.toArray(new DHTNetworkPosition[res.size()]);
    }

    public static DHTNetworkPosition getBestLocalPosition() {
        DHTNetworkPosition best_position = null;
        DHTNetworkPosition[] positions = DHTNetworkPositionManager.getLocalPositions();
        byte best_provider = 0;
        for (int i = 0; i < positions.length; ++i) {
            DHTNetworkPosition position = positions[i];
            byte type = position.getPositionType();
            if (type <= best_provider) continue;
            best_position = position;
        }
        return best_position;
    }

    public static DHTNetworkPosition[] createPositions(byte[] ID, boolean is_local) {
        DHTNetworkPositionProvider[] prov = providers;
        if (prov.length == 0) {
            return NP_EMPTY_ARRAY;
        }
        DHTNetworkPosition[] res = new DHTNetworkPosition[prov.length];
        int skipped = 0;
        for (int i = 0; i < res.length; ++i) {
            try {
                res[i] = prov[i].create(ID, is_local);
                continue;
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
                ++skipped;
            }
        }
        if (skipped > 0) {
            DHTNetworkPosition[] x = new DHTNetworkPosition[res.length - skipped];
            int pos = 0;
            for (int i = 0; i < res.length; ++i) {
                if (res[i] == null) continue;
                x[pos++] = res[i];
            }
            res = x;
            if (res.length == 0) {
                Debug.out("hmm");
            }
        }
        return res;
    }

    public static float estimateRTT(DHTNetworkPosition[] p1s, DHTNetworkPosition[] p2s) {
        byte best_provider = 0;
        float best_result = Float.NaN;
        block2: for (int i = 0; i < p1s.length; ++i) {
            DHTNetworkPosition p1 = p1s[i];
            byte p1_type = p1.getPositionType();
            for (int j = 0; j < p2s.length; ++j) {
                DHTNetworkPosition p2 = p2s[j];
                if (p1_type != p2.getPositionType()) continue;
                try {
                    float f = p1.estimateRTT(p2);
                    if (Float.isNaN(f) || p1_type <= best_provider) continue block2;
                    best_result = f;
                    best_provider = p1_type;
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
                continue block2;
            }
        }
        return best_result;
    }

    public static void update(DHTNetworkPosition[] local_positions, byte[] remote_id, DHTNetworkPosition[] remote_positions, float rtt) {
        block2: for (int i = 0; i < local_positions.length; ++i) {
            DHTNetworkPosition p1 = local_positions[i];
            for (int j = 0; j < remote_positions.length; ++j) {
                DHTNetworkPosition p2 = remote_positions[j];
                if (p1.getPositionType() != p2.getPositionType()) continue;
                try {
                    p1.update(remote_id, p2, rtt);
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
                continue block2;
            }
        }
    }

    public static byte[] serialisePosition(DHTNetworkPosition pos) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        dos.writeByte(1);
        dos.writeByte(pos.getPositionType());
        pos.serialise(dos);
        dos.close();
        return baos.toByteArray();
    }

    public static DHTNetworkPosition deserialisePosition(InetAddress originator, byte[] bytes) throws IOException {
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        DataInputStream dis = new DataInputStream(bais);
        dis.readByte();
        byte position_type = dis.readByte();
        return DHTNetworkPositionManager.deserialise(originator, position_type, dis);
    }

    public static DHTNetworkPosition deserialise(InetAddress originator, byte position_type, DataInputStream is) throws IOException {
        DHTNetworkPositionProvider[] prov = providers;
        is.mark(512);
        for (int i = 0; i < prov.length; ++i) {
            if (prov[i].getPositionType() != position_type) continue;
            DHTNetworkPositionProvider provider2 = prov[i];
            try {
                DHTNetworkPosition np = provider2.deserialisePosition(is);
                CopyOnWriteList<DHTNetworkPositionListener> listeners = position_listeners;
                if (listeners != null) {
                    Iterator<DHTNetworkPositionListener> it = listeners.iterator();
                    while (it.hasNext()) {
                        try {
                            it.next().positionFound(provider2, originator, np);
                        }
                        catch (Throwable e) {
                            Debug.printStackTrace(e);
                        }
                    }
                }
                return np;
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
                is.reset();
                break;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addPositionListener(DHTNetworkPositionListener listener) {
        Class<DHTNetworkPositionManager> clazz = DHTNetworkPositionManager.class;
        synchronized (DHTNetworkPositionManager.class) {
            if (position_listeners == null) {
                position_listeners = new CopyOnWriteList();
            }
            position_listeners.add(listener);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removePositionListener(DHTNetworkPositionListener listener) {
        Class<DHTNetworkPositionManager> clazz = DHTNetworkPositionManager.class;
        synchronized (DHTNetworkPositionManager.class) {
            if (position_listeners != null) {
                position_listeners.remove(listener);
                if (position_listeners.size() == 0) {
                    position_listeners = null;
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static void addProviderListener(DHTNetworkPositionProviderListener listener) {
        provider_listeners.add(listener);
    }

    public static void removeProviderListener(DHTNetworkPositionProviderListener listener) {
        provider_listeners.remove(listener);
    }

    static {
        NP_EMPTY_ARRAY = new DHTNetworkPosition[0];
    }
}

