/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.devices.impl;

import com.aelitis.azureus.core.devices.TranscodeActionVetoException;
import com.aelitis.azureus.core.devices.TranscodeAnalysisListener;
import com.aelitis.azureus.core.devices.TranscodeException;
import com.aelitis.azureus.core.devices.TranscodeFile;
import com.aelitis.azureus.core.devices.TranscodeJob;
import com.aelitis.azureus.core.devices.TranscodeProfile;
import com.aelitis.azureus.core.devices.TranscodeProvider;
import com.aelitis.azureus.core.devices.TranscodeProviderAdapter;
import com.aelitis.azureus.core.devices.TranscodeProviderAnalysis;
import com.aelitis.azureus.core.devices.TranscodeProviderJob;
import com.aelitis.azureus.core.devices.TranscodeQueue;
import com.aelitis.azureus.core.devices.TranscodeQueueActionListener;
import com.aelitis.azureus.core.devices.TranscodeQueueListener;
import com.aelitis.azureus.core.devices.TranscodeTarget;
import com.aelitis.azureus.core.devices.impl.DeviceImpl;
import com.aelitis.azureus.core.devices.impl.TranscodeFileImpl;
import com.aelitis.azureus.core.devices.impl.TranscodeJobImpl;
import com.aelitis.azureus.core.devices.impl.TranscodeManagerImpl;
import com.aelitis.azureus.core.devices.impl.TranscodePipe;
import com.aelitis.azureus.core.devices.impl.TranscodePipeStreamSource2;
import com.aelitis.azureus.core.download.DiskManagerFileInfoURL;
import com.aelitis.azureus.core.util.CopyOnWriteList;
import com.aelitis.azureus.core.util.average.Average;
import com.aelitis.azureus.core.util.average.AverageFactory;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfo;
import org.gudy.azureus2.core3.disk.DiskManagerPiece;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentFile;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.AsyncDispatcher;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DelayedEvent;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.IndentWriter;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.disk.DiskManager;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.ipc.IPCInterface;
import org.gudy.azureus2.plugins.utils.DelayedTask;
import org.gudy.azureus2.pluginsimpl.local.PluginCoreUtils;
import org.gudy.azureus2.pluginsimpl.local.PluginInitializer;
import org.gudy.azureus2.pluginsimpl.local.utils.UtilitiesImpl;

public class TranscodeQueueImpl
implements TranscodeQueue {
    private static final String CONFIG_FILE = "xcodejobs.config";
    private static final Object KEY_XCODE_ERROR = new Object();
    private TranscodeManagerImpl manager;
    private List<TranscodeJobImpl> queue = new ArrayList<TranscodeJobImpl>();
    private AESemaphore queue_sem = new AESemaphore("XcodeQ");
    private AEThread2 queue_thread;
    private volatile TranscodeJobImpl current_job;
    private AsyncDispatcher anaylsis_dispatcher = new AsyncDispatcher();
    private CopyOnWriteList<TranscodeQueueListener> listeners = new CopyOnWriteList();
    private CopyOnWriteList<TranscodeQueueActionListener> action_listeners = new CopyOnWriteList();
    private volatile boolean paused;
    private volatile int max_bytes_per_sec;
    private volatile boolean config_dirty;

    protected TranscodeQueueImpl(TranscodeManagerImpl _manager) {
        this.manager = _manager;
    }

    protected void initialise() {
        this.loadConfig();
        COConfigurationManager.addAndFireParameterListeners(new String[]{"xcode.queue.paused", "xcode.queue.maxbps"}, new ParameterListener(){

            @Override
            public void parameterChanged(String name) {
                TranscodeQueueImpl.this.paused = COConfigurationManager.getBooleanParameter("xcode.queue.paused", false);
                TranscodeQueueImpl.this.max_bytes_per_sec = COConfigurationManager.getIntParameter("xcode.queue.maxbps", 0);
            }
        });
        DelayedTask delayed_task = UtilitiesImpl.addDelayedTask("TranscodeQueue:schedule", new Runnable(){

            @Override
            public void run() {
                TranscodeQueueImpl.this.schedule();
            }
        });
        delayed_task.queue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean process(final TranscodeJobImpl job) {
        TranscodePipe pipe = null;
        this.current_job = job;
        DeviceImpl device = job.getDevice();
        device.setTranscoding(true);
        try {
            TranscodeProviderAnalysis provider_analysis;
            boolean xcode_required;
            job.starts();
            TranscodeProvider provider2 = job.getProfile().getProvider();
            final TranscodeException[] error = new TranscodeException[]{null};
            TranscodeProfile profile = job.getProfile();
            final TranscodeFileImpl transcode_file = job.getTranscodeFile();
            if (provider2 == null) {
                xcode_required = false;
                provider_analysis = null;
            } else {
                int tt_req;
                provider_analysis = this.analyse(job);
                xcode_required = provider_analysis.getBooleanProperty(1);
                if (job.isStream()) {
                    tt_req = 3;
                } else {
                    tt_req = job.getTranscodeRequirement();
                    if (device instanceof TranscodeTarget && provider_analysis.getLongProperty(4) == 0L && ((TranscodeTarget)((Object)device)).isAudioCompatible(transcode_file)) {
                        tt_req = 1;
                    }
                }
                if (tt_req == 1) {
                    xcode_required = false;
                } else if (tt_req == 3) {
                    xcode_required = true;
                    provider_analysis.setBooleanProperty(5, true);
                }
            }
            if (xcode_required) {
                final AESemaphore xcode_sem = new AESemaphore("xcode:proc");
                final TranscodeProviderJob[] provider_job = new TranscodeProviderJob[]{null};
                TranscodeProviderAdapter xcode_adapter = new TranscodeProviderAdapter(){
                    private boolean resolution_updated;
                    private final int ETA_AVERAGE_SIZE = 10;
                    private int last_eta;
                    private int eta_samples;
                    private Average eta_average = AverageFactory.MovingAverage(10);
                    private int last_percent;
                    private long initial_file_downloaded = job.getFile().getDownloaded();
                    private long file_size = job.getFile().getLength();

                    @Override
                    public void updateProgress(int percent, int eta_secs, int new_width, int new_height) {
                        this.last_eta = eta_secs;
                        this.last_percent = percent;
                        TranscodeProviderJob prov_job = provider_job[0];
                        if (prov_job == null) {
                            return;
                        }
                        int job_state = job.getState();
                        if (job_state == 4 || job_state == 7) {
                            prov_job.cancel();
                        } else if (TranscodeQueueImpl.this.paused || job_state == 2) {
                            prov_job.pause();
                        } else {
                            if (job_state == 1) {
                                prov_job.resume();
                            }
                            job.updateProgress(percent, eta_secs);
                            prov_job.setMaxBytesPerSecond(TranscodeQueueImpl.this.max_bytes_per_sec);
                            if (!this.resolution_updated && new_width > 0 && new_height > 0) {
                                transcode_file.setResolution(new_width, new_height);
                                this.resolution_updated = true;
                            }
                        }
                    }

                    @Override
                    public void streamStats(long connect_rate, long write_speed) {
                        if (Constants.isOSX && job.getEnableAutoRetry() && job.canUseDirectInput() && job.getAutoRetryCount() == 0) {
                            if (connect_rate > 5L && this.last_percent < 100) {
                                long eta = (long)this.eta_average.update(this.last_eta);
                                ++this.eta_samples;
                                if (this.eta_samples >= 10) {
                                    double over_write;
                                    long total_time = eta * 100L / (long)(100 - this.last_percent);
                                    long total_write = total_time * write_speed;
                                    org.gudy.azureus2.plugins.disk.DiskManagerFileInfo file = job.getFile();
                                    long length = file.getLength();
                                    if (length > 0L && (over_write = (double)total_write / (double)length) > 5.0) {
                                        this.failed(new TranscodeException("Overwrite limit exceeded, abandoning transcode"));
                                        provider_job[0].cancel();
                                    }
                                }
                            } else {
                                this.eta_samples = 0;
                            }
                        }
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void failed(TranscodeException e) {
                        try {
                            if (error[0] == null) {
                                error[0] = e;
                            }
                            if (e.isRetryDisabled()) {
                                job.setEnableAutoRetry(false);
                            }
                        }
                        finally {
                            xcode_sem.release();
                        }
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void complete() {
                        block20: {
                            try {
                                long contiguous_downloaded;
                                long current_downloaded;
                                block21: {
                                    current_downloaded = job.getFile().getDownloaded();
                                    if (this.file_size <= 0L || this.initial_file_downloaded >= this.file_size || current_downloaded >= this.file_size || error[0] != null) break block20;
                                    contiguous_downloaded = 0L;
                                    try {
                                        org.gudy.azureus2.plugins.disk.DiskManagerFileInfo _file_info = job.getFile();
                                        Download download = _file_info.getDownload();
                                        DiskManagerFileInfo file_info = PluginCoreUtils.unwrap(_file_info);
                                        TOTorrentFile torrent_file = file_info.getTorrentFile();
                                        TOTorrent torrent = torrent_file.getTorrent();
                                        TOTorrentFile[] torrent_files = torrent.getFiles();
                                        long byte_start = 0L;
                                        for (TOTorrentFile tf : torrent_files) {
                                            if (tf == torrent_file) break;
                                            byte_start += tf.getLength();
                                        }
                                        DiskManager dm = download.getDiskManager();
                                        if (dm == null) {
                                            throw new Exception("Download stopped");
                                        }
                                        DiskManagerPiece[] pieces = PluginCoreUtils.unwrap(dm).getPieces();
                                        long piece_size = torrent.getPieceLength();
                                        int first_piece_index = (int)(byte_start / piece_size);
                                        int first_piece_offset = (int)(byte_start % piece_size);
                                        int last_piece_index = torrent_file.getLastPieceNumber();
                                        DiskManagerPiece first_piece = pieces[first_piece_index];
                                        if (!first_piece.isDone()) {
                                            boolean[] blocks = first_piece.getWritten();
                                            if (blocks == null) {
                                                if (first_piece.isDone()) {
                                                    contiguous_downloaded = first_piece.getLength() - first_piece_offset;
                                                }
                                            } else {
                                                int piece_offset = 0;
                                                for (int j = 0; j < blocks.length && blocks[j]; ++j) {
                                                    int block_size = first_piece.getBlockSize(j);
                                                    piece_offset += block_size;
                                                    if (contiguous_downloaded == 0L) {
                                                        if (piece_offset <= first_piece_offset) continue;
                                                        contiguous_downloaded = piece_offset - first_piece_offset;
                                                        continue;
                                                    }
                                                    contiguous_downloaded += (long)block_size;
                                                }
                                            }
                                            break block21;
                                        }
                                        contiguous_downloaded = first_piece.getLength() - first_piece_offset;
                                        for (int i = first_piece_index + 1; i <= last_piece_index; ++i) {
                                            DiskManagerPiece piece = pieces[i];
                                            if (piece.isDone()) {
                                                contiguous_downloaded += (long)piece.getLength();
                                                continue;
                                            }
                                            boolean[] blocks = piece.getWritten();
                                            if (blocks == null) {
                                                if (piece.isDone()) {
                                                    contiguous_downloaded += (long)piece.getLength();
                                                }
                                            } else {
                                                for (int j = 0; j < blocks.length && blocks[j]; ++j) {
                                                    contiguous_downloaded += (long)piece.getBlockSize(j);
                                                }
                                            }
                                            break;
                                        }
                                    }
                                    catch (Throwable e) {
                                        // empty catch block
                                    }
                                }
                                if (contiguous_downloaded < this.file_size && (current_downloaded = job.getFile().getDownloaded()) < this.file_size) {
                                    Debug.out("Premature transcode termination: init=" + this.initial_file_downloaded + ", curr=" + current_downloaded + ", len=" + this.file_size);
                                    error[0] = new TranscodeException("Transcode terminated prematurely");
                                }
                            }
                            finally {
                                xcode_sem.release();
                            }
                        }
                    }
                };
                boolean direct_input = job.useDirectInput();
                if (job.isStream()) {
                    pipe = new TranscodePipeStreamSource2(new TranscodePipeStreamSource2.streamListener(){

                        @Override
                        public void gotStream(InputStream is) {
                            job.setStream(is);
                        }
                    });
                    provider_job[0] = provider2.transcode(xcode_adapter, provider_analysis, direct_input, job.getFile(), profile, new URL("tcp://127.0.0.1:" + pipe.getPort()));
                } else {
                    File output_file = transcode_file.getCacheFile();
                    provider_job[0] = provider2.transcode(xcode_adapter, provider_analysis, direct_input, job.getFile(), profile, output_file.toURI().toURL());
                }
                provider_job[0].setMaxBytesPerSecond(this.max_bytes_per_sec);
                TranscodeQueueListener listener = new TranscodeQueueListener(){

                    @Override
                    public void jobAdded(TranscodeJob job2) {
                    }

                    @Override
                    public void jobChanged(TranscodeJob changed_job) {
                        if (changed_job == job) {
                            int state = job.getState();
                            if (state == 2) {
                                provider_job[0].pause();
                            } else if (state == 1) {
                                provider_job[0].resume();
                            } else if (state == 4 || state == 6) {
                                provider_job[0].cancel();
                            }
                        }
                    }

                    @Override
                    public void jobRemoved(TranscodeJob removed_job) {
                        if (removed_job == job) {
                            provider_job[0].cancel();
                        }
                    }
                };
                try {
                    this.addListener(listener);
                    xcode_sem.reserve();
                }
                finally {
                    this.removeListener(listener);
                }
                if (error[0] != null) {
                    throw error[0];
                }
            } else {
                org.gudy.azureus2.plugins.disk.DiskManagerFileInfo source = job.getFile();
                transcode_file.setTranscodeRequired(false);
                if (job.isStream()) {
                    PluginInterface av_pi = PluginInitializer.getDefaultInterface().getPluginManager().getPluginInterfaceByID("azupnpav");
                    if (av_pi == null) {
                        throw new TranscodeException("Media Server plugin not found");
                    }
                    IPCInterface av_ipc = av_pi.getIPC();
                    String url_str = (String)av_ipc.invoke("getContentURL", new Object[]{source});
                    if (url_str == null || url_str.length() == 0) {
                        File source_file = source.getFile();
                        if (!source_file.exists()) throw new TranscodeException("No UPnPAV URL and file doesn't exist");
                        job.setStream(new BufferedInputStream(new FileInputStream(source_file)));
                    } else {
                        URL source_url = new URL(url_str);
                        job.setStream(source_url.openConnection().getInputStream());
                    }
                } else {
                    boolean url_input_source = source instanceof DiskManagerFileInfoURL;
                    if (device.getAlwaysCacheFiles() || url_input_source) {
                        long length;
                        InputStream is;
                        PluginInterface av_pi = PluginInitializer.getDefaultInterface().getPluginManager().getPluginInterfaceByID("azupnpav");
                        if (av_pi == null) {
                            throw new TranscodeException("Media Server plugin not found");
                        }
                        IPCInterface av_ipc = av_pi.getIPC();
                        String url_str = (String)av_ipc.invoke("getContentURL", new Object[]{source});
                        if (url_str == null || url_str.length() == 0) {
                            File source_file;
                            if (url_input_source) {
                                ((DiskManagerFileInfoURL)source).download();
                            }
                            if (!(source_file = source.getFile()).exists()) throw new TranscodeException("No UPnPAV URL and file doesn't exist");
                            is = new BufferedInputStream(new FileInputStream(source_file));
                            length = source_file.length();
                        } else {
                            URL source_url = new URL(url_str);
                            URLConnection connection = source_url.openConnection();
                            is = source_url.openConnection().getInputStream();
                            String s = connection.getHeaderField("content-length");
                            length = s != null ? Long.parseLong(s) : -1L;
                        }
                        FileOutputStream os = null;
                        final boolean[] cancel_copy = new boolean[]{false};
                        TranscodeQueueListener copy_listener = new TranscodeQueueListener(){

                            @Override
                            public void jobAdded(TranscodeJob job2) {
                            }

                            @Override
                            public void jobChanged(TranscodeJob changed_job) {
                                int state;
                                if (changed_job == job && (state = job.getState()) != 2 && state != 1 && (state == 4 || state == 6)) {
                                    cancel_copy[0] = true;
                                }
                            }

                            @Override
                            public void jobRemoved(TranscodeJob removed_job) {
                                if (removed_job == job) {
                                    cancel_copy[0] = true;
                                }
                            }
                        };
                        try {
                            this.addListener(copy_listener);
                            os = new FileOutputStream(transcode_file.getCacheFile());
                            long total_copied = 0L;
                            byte[] buffer = new byte[131072];
                            while (true) {
                                if (cancel_copy[0]) {
                                    throw new TranscodeException("Copy cancelled");
                                }
                                int len = is.read(buffer);
                                if (len <= 0) {
                                    break;
                                }
                                ((OutputStream)os).write(buffer, 0, len);
                                total_copied += (long)len;
                                if (length > 0L) {
                                    job.updateProgress((int)(total_copied * 100L / length), -1);
                                }
                                total_copied += (long)len;
                            }
                        }
                        finally {
                            try {
                                is.close();
                            }
                            catch (Throwable e) {
                                Debug.out(e);
                            }
                            try {
                                if (os != null) {
                                    ((OutputStream)os).close();
                                }
                            }
                            catch (Throwable e) {
                                Debug.out(e);
                            }
                            this.removeListener(copy_listener);
                        }
                    }
                }
            }
            job.complete();
            boolean bl = true;
            return bl;
        }
        catch (Throwable e) {
            job.failed(e);
            e.printStackTrace();
            if (!job.isStream() && job.getEnableAutoRetry() && job.getAutoRetryCount() == 0 && job.canUseDirectInput() && !job.useDirectInput()) {
                this.log("Auto-retrying transcode with direct input");
                job.setUseDirectInput();
                job.setAutoRetry(true);
                this.queue_sem.release();
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (pipe != null) {
                pipe.destroy();
            }
            device.setTranscoding(false);
            this.current_job = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void schedule() {
        TranscodeQueueImpl transcodeQueueImpl = this;
        synchronized (transcodeQueueImpl) {
            if (this.queue.size() > 0 && this.queue_thread == null) {
                this.queue_thread = new AEThread2("XcodeQ", true){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            while (true) {
                                TranscodeQueueImpl.this.checkJobStatus();
                                boolean got = TranscodeQueueImpl.this.queue_sem.reserve(30000L);
                                TranscodeJobImpl job = null;
                                TranscodeQueueImpl transcodeQueueImpl = TranscodeQueueImpl.this;
                                synchronized (transcodeQueueImpl) {
                                    block14: {
                                        if (got || TranscodeQueueImpl.this.queue.size() != 0) break block14;
                                        TranscodeQueueImpl.this.queue_thread = null;
                                        return;
                                    }
                                    for (TranscodeJobImpl j : TranscodeQueueImpl.this.queue) {
                                        int state = j.getState();
                                        if (state == 5 && j.isAutoRetry()) {
                                            j.setAutoRetry(false);
                                            j.reset();
                                            job = j;
                                            break;
                                        }
                                        if (state == 2) {
                                            job = j;
                                            continue;
                                        }
                                        if (state != 0 || job != null || j.getDownloadETA() != 0L) continue;
                                        job = j;
                                    }
                                }
                                TranscodeQueueImpl.this.checkJobStatus();
                                if (job == null || !TranscodeQueueImpl.this.process(job)) continue;
                                try {
                                    TranscodeQueueImpl.this.remove(job, true);
                                }
                                catch (TranscodeActionVetoException e) {
                                    Debug.out(e);
                                }
                            }
                        }
                        finally {
                            TranscodeQueueImpl.this.checkJobStatus();
                        }
                    }
                };
                this.queue_thread.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateStatus(int tick_count) {
        int queue_size;
        TranscodeQueueImpl transcodeQueueImpl = this;
        synchronized (transcodeQueueImpl) {
            queue_size = this.queue.size();
        }
        if (queue_size > 0) {
            TranscodeJobImpl[] jobs;
            for (TranscodeJobImpl job : jobs = this.getJobs()) {
                job.updateStatus();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkJobStatus() {
        HashSet<DeviceImpl> devices = new HashSet<DeviceImpl>(Arrays.asList(this.manager.getManager().getDevices()));
        TranscodeQueueImpl transcodeQueueImpl = this;
        synchronized (transcodeQueueImpl) {
            for (TranscodeJobImpl j : this.queue) {
                if (j.getState() != 5) continue;
                DeviceImpl device = j.getDevice();
                device.setError(KEY_XCODE_ERROR, MessageText.getString("device.error.xcodefail"));
                devices.remove(device);
            }
        }
        for (DeviceImpl device : devices) {
            device.setError(KEY_XCODE_ERROR, null);
        }
    }

    @Override
    public TranscodeJobImpl add(TranscodeTarget target, TranscodeProfile profile, org.gudy.azureus2.plugins.disk.DiskManagerFileInfo file, boolean add_stopped) throws TranscodeException {
        return this.add(target, profile, file, add_stopped, false, -1);
    }

    @Override
    public TranscodeJobImpl add(TranscodeTarget target, TranscodeProfile profile, org.gudy.azureus2.plugins.disk.DiskManagerFileInfo file, int transcode_requirement, boolean add_stopped) throws TranscodeException {
        return this.add(target, profile, file, add_stopped, false, transcode_requirement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TranscodeJobImpl add(TranscodeTarget target, TranscodeProfile profile, org.gudy.azureus2.plugins.disk.DiskManagerFileInfo file, boolean add_stopped, boolean stream, int transcode_requirement) throws TranscodeException {
        TranscodeFileImpl existing_tf = ((DeviceImpl)target.getDevice()).lookupFile(profile, file);
        if (existing_tf != null) {
            ArrayList<TranscodeJobImpl> to_remove = new ArrayList<TranscodeJobImpl>();
            TranscodeQueueImpl transcodeQueueImpl = this;
            synchronized (transcodeQueueImpl) {
                for (TranscodeJobImpl job : this.queue) {
                    if (job.getTarget() != target || !job.getTranscodeFile().equals(existing_tf)) continue;
                    to_remove.add(job);
                }
            }
            for (TranscodeJobImpl job : to_remove) {
                job.removeForce();
            }
            if (!stream) {
                existing_tf.delete(true);
            }
        }
        TranscodeJobImpl job = new TranscodeJobImpl(this, target, profile, file, add_stopped, transcode_requirement, stream);
        try {
            Iterator<TranscodeQueueListener> i$ = this;
            synchronized (i$) {
                this.queue.add(job);
                this.queue_sem.release();
                this.configDirty();
            }
            for (TranscodeQueueListener listener : this.listeners) {
                try {
                    listener.jobAdded(job);
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            }
        }
        finally {
            this.schedule();
        }
        return job;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void remove(TranscodeJobImpl job, boolean force) throws TranscodeActionVetoException {
        TranscodeQueueImpl transcodeQueueImpl = this;
        synchronized (transcodeQueueImpl) {
            if (!this.queue.contains(job)) {
                return;
            }
        }
        if (!force) {
            for (TranscodeQueueActionListener l : this.action_listeners) {
                try {
                    l.jobWillBeActioned(job, 1);
                }
                catch (TranscodeActionVetoException e) {
                    throw e;
                }
                catch (Throwable e) {
                    Debug.out(e);
                }
            }
        }
        Iterator<TranscodeQueueListener> i$ = this;
        synchronized (i$) {
            if (!this.queue.remove(job)) {
                return;
            }
        }
        this.configDirty();
        job.destroy();
        for (TranscodeQueueListener listener : this.listeners) {
            try {
                listener.jobRemoved(job);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
        this.checkJobStatus();
        this.schedule();
    }

    protected void jobChanged(TranscodeJob job, boolean schedule, boolean persistable) {
        for (TranscodeQueueListener listener : this.listeners) {
            try {
                listener.jobChanged(job);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
        if (persistable) {
            this.configDirty();
        }
        if (schedule) {
            this.queue_sem.release();
            this.schedule();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getIndex(TranscodeJobImpl job) {
        TranscodeQueueImpl transcodeQueueImpl = this;
        synchronized (transcodeQueueImpl) {
            return this.queue.indexOf(job) + 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TranscodeJobImpl[] getJobs() {
        TranscodeQueueImpl transcodeQueueImpl = this;
        synchronized (transcodeQueueImpl) {
            return this.queue.toArray(new TranscodeJobImpl[this.queue.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getJobCount() {
        TranscodeQueueImpl transcodeQueueImpl = this;
        synchronized (transcodeQueueImpl) {
            return this.queue.size();
        }
    }

    @Override
    public TranscodeJob getCurrentJob() {
        return this.current_job;
    }

    @Override
    public boolean isTranscoding() {
        return this.current_job != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TranscodeJobImpl getJob(TranscodeFile for_file) {
        TranscodeQueueImpl transcodeQueueImpl = this;
        synchronized (transcodeQueueImpl) {
            for (TranscodeJobImpl job : this.queue) {
                if (!job.getTranscodeFile().equals(for_file)) continue;
                return job;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveUp(TranscodeJobImpl job) {
        TranscodeJobImpl[] updated;
        TranscodeQueueImpl transcodeQueueImpl = this;
        synchronized (transcodeQueueImpl) {
            int index = this.queue.indexOf(job);
            if (index <= 0 || this.queue.size() == 1) {
                return;
            }
            this.queue.remove(job);
            this.queue.add(index - 1, job);
            updated = this.getJobs();
        }
        for (TranscodeJobImpl j : updated) {
            this.jobChanged(j, false, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveDown(TranscodeJobImpl job) {
        TranscodeJobImpl[] updated;
        TranscodeQueueImpl transcodeQueueImpl = this;
        synchronized (transcodeQueueImpl) {
            int index = this.queue.indexOf(job);
            if (index < 0 || index == this.queue.size() - 1) {
                return;
            }
            this.queue.remove(job);
            this.queue.add(index + 1, job);
            updated = this.getJobs();
        }
        for (TranscodeJobImpl j : updated) {
            this.jobChanged(j, false, true);
        }
    }

    @Override
    public void pause() {
        if (!this.paused && this.paused) {
            COConfigurationManager.setParameter("xcode.paused", true);
        }
    }

    @Override
    public boolean isPaused() {
        return this.paused;
    }

    @Override
    public void resume() {
        if (this.paused) {
            COConfigurationManager.setParameter("xcode.queue.paused", false);
        }
    }

    @Override
    public long getMaxBytesPerSecond() {
        return this.max_bytes_per_sec;
    }

    @Override
    public void setMaxBytesPerSecond(long max) {
        COConfigurationManager.setParameter("xcode.queue.maxbps", max);
    }

    protected TranscodeTarget lookupTarget(String target_id) throws TranscodeException {
        return this.manager.lookupTarget(target_id);
    }

    protected TranscodeProfile lookupProfile(String profile_id) throws TranscodeException {
        TranscodeProfile profile = this.manager.getProfileFromUID(profile_id);
        if (profile == null) {
            throw new TranscodeException("Transcode profile with id '" + profile_id + "' not found");
        }
        return profile;
    }

    protected org.gudy.azureus2.plugins.disk.DiskManagerFileInfo lookupFile(byte[] hash, int index) throws TranscodeException {
        return this.manager.lookupFile(hash, index);
    }

    protected void analyse(final TranscodeJobImpl job, final TranscodeAnalysisListener listener) throws TranscodeException {
        this.anaylsis_dispatcher.dispatch(new AERunnable(){

            @Override
            public void runSupport() {
                try {
                    TranscodeProviderAnalysis analysis = TranscodeQueueImpl.this.analyse(job);
                    listener.analysisComplete(job, analysis);
                }
                catch (TranscodeException e) {
                    listener.analysisFailed(job, e);
                }
                catch (Throwable e) {
                    listener.analysisFailed(job, new TranscodeException("Analysis failed", e));
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TranscodeProviderAnalysis analyse(final TranscodeJobImpl job) throws TranscodeException {
        TranscodeProvider provider2 = job.getProfile().getProvider();
        if (provider2 == null) {
            throw new TranscodeException("Transcode provider not available");
        }
        final TranscodeException[] error = new TranscodeException[]{null};
        TranscodeProfile profile = job.getProfile();
        final AESemaphore analysis_sem = new AESemaphore("analysis:proc");
        final boolean was_stopped = job.getState() == 6;
        TranscodeProviderAdapter analysis_adapter = new TranscodeProviderAdapter(){

            @Override
            public void updateProgress(int percent, int eta_secs, int width, int height) {
            }

            @Override
            public void streamStats(long connect_rate, long write_speed) {
            }

            @Override
            public void failed(TranscodeException e) {
                error[0] = e;
                analysis_sem.release();
            }

            @Override
            public void complete() {
                analysis_sem.release();
            }
        };
        final TranscodeProviderAnalysis provider_analysis = provider2.analyse(analysis_adapter, job.getFile(), profile);
        TranscodeQueueListener analysis_q_listener = new TranscodeQueueListener(){

            @Override
            public void jobAdded(TranscodeJob job2) {
            }

            @Override
            public void jobChanged(TranscodeJob changed_job) {
                if (changed_job == job) {
                    int state = job.getState();
                    if (state == 4) {
                        provider_analysis.cancel();
                    } else if (state == 6 && !was_stopped) {
                        provider_analysis.cancel();
                    }
                }
            }

            @Override
            public void jobRemoved(TranscodeJob removed_job) {
                if (removed_job == job) {
                    provider_analysis.cancel();
                }
            }
        };
        try {
            this.addListener(analysis_q_listener);
            analysis_sem.reserve();
        }
        finally {
            this.removeListener(analysis_q_listener);
        }
        if (error[0] != null) {
            throw error[0];
        }
        TranscodeFileImpl transcode_file = job.getTranscodeFile();
        transcode_file.update(provider_analysis);
        return provider_analysis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void configDirty() {
        TranscodeQueueImpl transcodeQueueImpl = this;
        synchronized (transcodeQueueImpl) {
            if (this.config_dirty) {
                return;
            }
            this.config_dirty = true;
            new DelayedEvent("TranscodeQueue:save", 5000L, new AERunnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void runSupport() {
                    TranscodeQueueImpl transcodeQueueImpl = TranscodeQueueImpl.this;
                    synchronized (transcodeQueueImpl) {
                        if (!TranscodeQueueImpl.this.config_dirty) {
                            return;
                        }
                        TranscodeQueueImpl.this.saveConfig();
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadConfig() {
        if (!FileUtil.resilientConfigFileExists(CONFIG_FILE)) {
            return;
        }
        this.log("Loading configuration");
        try {
            TranscodeQueueImpl transcodeQueueImpl = this;
            synchronized (transcodeQueueImpl) {
                Map map = FileUtil.readResilientConfigFile(CONFIG_FILE);
                List l_jobs = (List)map.get("jobs");
                if (l_jobs != null) {
                    for (Map m : l_jobs) {
                        try {
                            TranscodeJobImpl job = new TranscodeJobImpl(this, m);
                            this.queue.add(job);
                            this.queue_sem.release();
                        }
                        catch (Throwable e) {
                            this.log("Failed to restore job: " + m, e);
                        }
                    }
                }
            }
        }
        catch (Throwable e) {
            this.log("Configuration load failed", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveConfig() {
        TranscodeQueueImpl transcodeQueueImpl = this;
        synchronized (transcodeQueueImpl) {
            this.config_dirty = false;
            if (this.queue.size() == 0) {
                FileUtil.deleteResilientConfigFile(CONFIG_FILE);
            } else {
                HashMap map = new HashMap();
                ArrayList<Map<String, Object>> l_jobs = new ArrayList<Map<String, Object>>();
                map.put("jobs", l_jobs);
                for (TranscodeJobImpl job : this.queue) {
                    if (job.isStream()) continue;
                    try {
                        l_jobs.add(job.toMap());
                    }
                    catch (Throwable e) {
                        this.log("Failed to save job", e);
                    }
                }
                FileUtil.writeResilientConfigFile(CONFIG_FILE, map);
            }
        }
    }

    protected void close() {
        if (this.config_dirty) {
            this.saveConfig();
        }
    }

    @Override
    public void addListener(TranscodeQueueListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    @Override
    public void removeListener(TranscodeQueueListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void addActionListener(TranscodeQueueActionListener listener) {
        this.action_listeners.add(listener);
    }

    @Override
    public void removeActionListener(TranscodeQueueActionListener listener) {
        this.action_listeners.remove(listener);
    }

    protected void log(String str) {
        this.manager.log("Queue: " + str);
    }

    protected void log(String str, Throwable e) {
        this.manager.log("Queue: " + str, e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generate(IndentWriter writer) {
        writer.println("Transcode Queue: paused=" + this.paused + ",max_bps=" + this.max_bytes_per_sec);
        try {
            TranscodeJobImpl[] jobs;
            writer.indent();
            for (TranscodeJobImpl job : jobs = this.getJobs()) {
                job.generate(writer);
            }
        }
        finally {
            writer.exdent();
        }
    }
}

