/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.devices.impl;

import com.aelitis.azureus.core.devices.impl.TranscodePipe;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.net.Socket;
import java.util.HashMap;
import java.util.StringTokenizer;

public class TranscodePipeFileSource
extends TranscodePipe {
    private static final String NL = "\r\n";
    private File source_file;
    private RandomAccessFile raf;
    private int raf_count;

    protected TranscodePipeFileSource(File _source_file, TranscodePipe.errorListener _error_listener) throws IOException {
        super(_error_listener);
        this.source_file = _source_file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void handleSocket(Socket socket) {
        TranscodePipeFileSource transcodePipeFileSource = this;
        synchronized (transcodePipeFileSource) {
            if (this.destroyed) {
                try {
                    socket.close();
                }
                catch (Throwable e) {
                    // empty catch block
                }
                return;
            }
            this.sockets.add(socket);
        }
        try {
            String command = null;
            HashMap<String, String> headers = new HashMap<String, String>();
            InputStream is = socket.getInputStream();
            OutputStream os = socket.getOutputStream();
            while (true) {
                String line = "";
                while (!line.endsWith(NL)) {
                    byte[] buffer = new byte[1];
                    if (is.read(buffer) <= 0) {
                        throw new IOException("unexpected end of stream");
                    }
                    line = line + new String(buffer);
                }
                if ((line = line.trim()).length() == 0) break;
                if (command == null) {
                    command = line;
                    continue;
                }
                int pos = line.indexOf(58);
                if (pos == -1) {
                    return;
                }
                String lhs = line.substring(0, pos).trim().toLowerCase();
                String rhs = line.substring(pos + 1).trim();
                headers.put(lhs, rhs);
            }
            boolean head = false;
            if (command == null) {
                throw new IOException("no method supplied");
            }
            if (!command.startsWith("GET ")) {
                if (command.startsWith("HEAD ")) {
                    head = true;
                } else {
                    throw new IOException("unsupported method '" + command + "'");
                }
            }
            long file_length = this.source_file.length();
            if (head) {
                this.write(os, "HTTP/1.1 200 OK\r\n");
                this.write(os, "Server: Azureus Media Server 1.0\r\n");
                this.write(os, "Accept-Ranges: bytes\r\n");
                this.write(os, "Content-Length: " + file_length + NL);
                this.write(os, "Content-Range: 0-" + (file_length - 1L) + "/" + file_length + NL);
                os.flush();
            } else {
                String ranges = (String)headers.get("range");
                long request_start = 0L;
                long request_length = 0L;
                boolean request_ok = false;
                if (ranges == null) {
                    this.write(os, "HTTP/1.1 200 OK\r\n");
                    this.write(os, "Server: Azureus Media Server 1.0\r\n");
                    this.write(os, "Connection: close\r\n");
                    this.write(os, "Accept-Ranges: bytes\r\n");
                    this.write(os, "Content-Range: 0-" + (file_length - 1L) + "/" + file_length + NL);
                    this.write(os, "Content-Length: " + file_length + NL + NL);
                    request_length = file_length;
                    request_ok = true;
                } else {
                    long start;
                    if (!(ranges = ranges.toLowerCase()).startsWith("bytes=")) {
                        throw new IOException("invalid range: " + ranges);
                    }
                    StringTokenizer tok = new StringTokenizer(ranges = ranges.substring(6), ",");
                    if (tok.countTokens() != 1) {
                        throw new IOException("invalid range - only single supported: " + ranges);
                    }
                    String range = tok.nextToken();
                    int pos = range.indexOf(45);
                    long end = pos < range.length() - 1 ? Long.parseLong(range.substring(pos + 1)) : file_length - 1L;
                    if (pos > 0) {
                        start = Long.parseLong(range.substring(0, pos));
                    } else {
                        start = file_length - end;
                        end = file_length - 1L;
                    }
                    request_length = end - start + 1L;
                    if (request_length < 0L) {
                        this.write(os, "HTTP/1.1 416 Requested Range Not Satisfiable\r\n\r\n");
                    } else {
                        request_start = start;
                        this.write(os, "HTTP/1.1 206 Partial content\r\n");
                        this.write(os, "Server: Azureus Media Server 1.0\r\n");
                        this.write(os, "Connection: close\r\n");
                        this.write(os, "Content-Range: bytes " + start + "-" + end + "/" + file_length + NL);
                        this.write(os, "Content-Length: " + request_length + NL + NL);
                        request_ok = true;
                    }
                }
                os.flush();
                if (request_ok) {
                    this.handleRAF(os, request_start, request_length);
                }
            }
            TranscodePipeFileSource transcodePipeFileSource2 = this;
            synchronized (transcodePipeFileSource2) {
                if (this.destroyed) {
                    try {
                        socket.close();
                    }
                    catch (Throwable e) {
                        // empty catch block
                    }
                    try {
                        is.close();
                    }
                    catch (Throwable e) {
                        // empty catch block
                    }
                    this.sockets.remove(socket);
                    return;
                }
            }
        }
        catch (Throwable e) {
            try {
                socket.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            TranscodePipeFileSource transcodePipeFileSource3 = this;
            synchronized (transcodePipeFileSource3) {
                this.sockets.remove(socket);
            }
        }
    }

    protected void write(OutputStream os, String str) throws IOException {
        os.write(str.getBytes());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected RandomAccessFile reserveRAF() throws IOException {
        TranscodePipeFileSource transcodePipeFileSource = this;
        synchronized (transcodePipeFileSource) {
            if (this.destroyed) {
                throw new IOException("destroyed");
            }
            if (this.raf == null) {
                this.raf = new RandomAccessFile(this.source_file, "r");
            }
            ++this.raf_count;
            return this.raf;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void releaseRAF(RandomAccessFile _raf) {
        TranscodePipeFileSource transcodePipeFileSource = this;
        synchronized (transcodePipeFileSource) {
            --this.raf_count;
            if (this.raf_count == 0) {
                try {
                    this.raf.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                this.raf = null;
            }
        }
    }

    @Override
    protected boolean destroy() {
        if (super.destroy()) {
            if (this.raf != null) {
                try {
                    this.raf.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                this.raf = null;
            }
            return true;
        }
        return false;
    }
}

