/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.devices.impl;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.devices.DeviceMediaRenderer;
import com.aelitis.azureus.core.devices.TranscodeException;
import com.aelitis.azureus.core.devices.TranscodeManager;
import com.aelitis.azureus.core.devices.TranscodeManagerListener;
import com.aelitis.azureus.core.devices.TranscodeProfile;
import com.aelitis.azureus.core.devices.TranscodeProvider;
import com.aelitis.azureus.core.devices.TranscodeTarget;
import com.aelitis.azureus.core.devices.impl.DeviceImpl;
import com.aelitis.azureus.core.devices.impl.DeviceManagerImpl;
import com.aelitis.azureus.core.devices.impl.TranscodeProviderVuze;
import com.aelitis.azureus.core.devices.impl.TranscodeQueueImpl;
import com.aelitis.azureus.core.tag.Tag;
import com.aelitis.azureus.core.tag.TagDownload;
import com.aelitis.azureus.core.tag.TagFeatureListener;
import com.aelitis.azureus.core.tag.TagFeatureTranscode;
import com.aelitis.azureus.core.tag.TagListener;
import com.aelitis.azureus.core.tag.TagManager;
import com.aelitis.azureus.core.tag.TagManagerFactory;
import com.aelitis.azureus.core.tag.TagType;
import com.aelitis.azureus.core.tag.Taggable;
import com.aelitis.azureus.core.util.CopyOnWriteList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gudy.azureus2.core3.category.Category;
import org.gudy.azureus2.core3.category.CategoryListener;
import org.gudy.azureus2.core3.category.CategoryManager;
import org.gudy.azureus2.core3.category.CategoryManagerListener;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.global.GlobalManagerAdapter;
import org.gudy.azureus2.core3.global.GlobalManagerListener;
import org.gudy.azureus2.core3.util.AEDiagnostics;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DelayedEvent;
import org.gudy.azureus2.core3.util.IndentWriter;
import org.gudy.azureus2.plugins.PluginEvent;
import org.gudy.azureus2.plugins.PluginEventListener;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.PluginListener;
import org.gudy.azureus2.plugins.disk.DiskManagerFileInfo;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.torrent.TorrentAttribute;
import org.gudy.azureus2.pluginsimpl.local.PluginCoreUtils;
import org.gudy.azureus2.pluginsimpl.local.PluginInitializer;

public class TranscodeManagerImpl
implements TranscodeManager {
    private DeviceManagerImpl device_manager;
    private AzureusCore azureus_core;
    private volatile TranscodeProviderVuze vuzexcode_provider;
    private CopyOnWriteList<TranscodeManagerListener> listeners = new CopyOnWriteList();
    private TranscodeQueueImpl queue = new TranscodeQueueImpl(this);
    private AESemaphore init_sem = new AESemaphore("TM:init");
    private boolean hooked_categories;
    private Map<Category, Object[]> category_map = new HashMap<Category, Object[]>();
    private CategoryListener category_listener;
    private GlobalManagerListener category_dl_listener;
    private TorrentAttribute category_ta;
    private boolean hooked_tags;
    private Map<Tag, Object[]> tag_map = new HashMap<Tag, Object[]>();
    private TagListener tag_listener;
    private TorrentAttribute tag_ta;

    protected TranscodeManagerImpl(DeviceManagerImpl _dm) {
        this.device_manager = _dm;
        this.azureus_core = AzureusCoreFactory.getSingleton();
        PluginInterface default_pi = PluginInitializer.getDefaultInterface();
        this.category_ta = default_pi.getTorrentManager().getPluginAttribute("xcode.cat.done");
        this.tag_ta = default_pi.getTorrentManager().getPluginAttribute("xcode.tag.done");
        final AESemaphore plugin_sem = new AESemaphore("TM:plugin");
        default_pi.addListener(new PluginListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void initializationComplete() {
                try {
                    PluginInterface[] plugins;
                    PluginInterface default_pi = PluginInitializer.getDefaultInterface();
                    default_pi.addEventListener(new PluginEventListener(){

                        @Override
                        public void handleEvent(PluginEvent ev) {
                            int type = ev.getType();
                            if (type == 8) {
                                TranscodeManagerImpl.this.pluginAdded((PluginInterface)ev.getValue());
                            }
                            if (type == 9) {
                                TranscodeManagerImpl.this.pluginRemoved((PluginInterface)ev.getValue());
                            }
                        }
                    });
                    for (PluginInterface pi : plugins = default_pi.getPluginManager().getPlugins()) {
                        if (!pi.getPluginState().isOperational()) continue;
                        TranscodeManagerImpl.this.pluginAdded(pi);
                    }
                }
                finally {
                    plugin_sem.releaseForever();
                }
            }

            @Override
            public void closedownInitiated() {
                plugin_sem.releaseForever();
                TranscodeManagerImpl.this.init_sem.releaseForever();
            }

            @Override
            public void closedownComplete() {
            }
        });
        if (!plugin_sem.reserve(30000L)) {
            Debug.out("Timeout waiting for init");
            AEDiagnostics.dumpThreads();
        }
    }

    protected void initialise() {
        this.queue.initialise();
        this.init_sem.releaseForever();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void pluginAdded(PluginInterface pi) {
        block13: {
            TranscodeProviderVuze provider2;
            boolean updated;
            block14: {
                if (pi.getPluginState().isBuiltIn()) {
                    return;
                }
                String plugin_id = pi.getPluginID();
                if (!plugin_id.equals("vuzexcode")) break block13;
                boolean added = false;
                updated = false;
                provider2 = null;
                TranscodeManagerImpl transcodeManagerImpl = this;
                synchronized (transcodeManagerImpl) {
                    if (this.vuzexcode_provider == null) {
                        this.vuzexcode_provider = new TranscodeProviderVuze(this, pi);
                        added = true;
                    } else if (pi != this.vuzexcode_provider.getPluginInterface()) {
                        this.vuzexcode_provider.update(pi);
                        updated = true;
                    }
                    provider2 = this.vuzexcode_provider;
                }
                if (!added) break block14;
                for (TranscodeManagerListener listener : this.listeners) {
                    try {
                        listener.providerAdded(provider2);
                    }
                    catch (Throwable e) {
                        Debug.out(e);
                    }
                }
                break block13;
            }
            if (!updated) break block13;
            for (TranscodeManagerListener listener : this.listeners) {
                try {
                    listener.providerUpdated(provider2);
                }
                catch (Throwable e) {
                    Debug.out(e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void pluginRemoved(PluginInterface pi) {
        String plugin_id = pi.getPluginID();
        if (plugin_id.equals("vuzexcode")) {
            TranscodeProviderVuze provider2 = null;
            TranscodeManagerImpl transcodeManagerImpl = this;
            synchronized (transcodeManagerImpl) {
                if (this.vuzexcode_provider != null) {
                    provider2 = this.vuzexcode_provider;
                    this.vuzexcode_provider.destroy();
                    this.vuzexcode_provider = null;
                }
            }
            if (provider2 != null) {
                for (TranscodeManagerListener listener : this.listeners) {
                    try {
                        listener.providerRemoved(provider2);
                    }
                    catch (Throwable e) {
                        Debug.out(e);
                    }
                }
            }
        }
    }

    protected void updateStatus(int tick_count) {
        if (this.queue != null) {
            this.queue.updateStatus(tick_count);
            if (!this.hooked_categories) {
                this.hooked_categories = true;
                CategoryManager.addCategoryManagerListener(new CategoryManagerListener(){

                    @Override
                    public void categoryAdded(Category category) {
                    }

                    @Override
                    public void categoryRemoved(Category category) {
                    }

                    @Override
                    public void categoryChanged(Category category) {
                        TranscodeManagerImpl.this.checkCategories();
                    }
                });
                this.checkCategories();
            }
            if (!this.hooked_tags) {
                this.hooked_tags = true;
                TagManagerFactory.getTagManager().addTagFeatureListener(8, new TagFeatureListener(){

                    @Override
                    public void tagFeatureChanged(Tag tag, int feature) {
                        TranscodeManagerImpl.this.checkTags();
                    }
                });
                this.checkTags();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkCategories() {
        Category[] cats = CategoryManager.getCategories();
        HashMap<Category, Object[]> active_map = new HashMap<Category, Object[]>();
        for (Category cat : cats) {
            String target = cat.getStringAttribute("at_att");
            if (target == null) continue;
            String device_id = null;
            if (target.endsWith("/blank")) {
                device_id = target.substring(0, target.length() - 6);
            }
            DeviceMediaRenderer target_dmr = null;
            TranscodeProfile target_profile = null;
            block4: for (DeviceImpl device : this.device_manager.getDevices()) {
                TranscodeProfile[] profs;
                if (!(device instanceof DeviceMediaRenderer)) continue;
                DeviceMediaRenderer dmr = (DeviceMediaRenderer)((Object)device);
                if (device_id != null) {
                    if (!device.getID().equals(device_id)) continue;
                    target_dmr = dmr;
                    target_profile = device.getBlankProfile();
                    break;
                }
                for (TranscodeProfile prof : profs = device.getTranscodeProfiles()) {
                    if (!prof.getUID().equals(target)) continue;
                    target_dmr = dmr;
                    target_profile = prof;
                    continue block4;
                }
            }
            if (target_dmr == null) continue;
            active_map.put(cat, new Object[]{target_dmr, target_profile});
        }
        HashMap to_process = new HashMap();
        Map<Category, Object[]> len$ = this.category_map;
        synchronized (len$) {
            if (this.category_listener == null) {
                this.category_listener = new CategoryListener(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void downloadManagerAdded(Category cat, DownloadManager manager) {
                        Object[] details;
                        Map map = TranscodeManagerImpl.this.category_map;
                        synchronized (map) {
                            details = (Object[])TranscodeManagerImpl.this.category_map.get(cat);
                        }
                        if (details != null) {
                            TranscodeManagerImpl.this.processCategory(cat, details, manager);
                        }
                    }

                    @Override
                    public void downloadManagerRemoved(Category cat, DownloadManager removed) {
                    }
                };
            }
            Iterator<Category> it = this.category_map.keySet().iterator();
            while (it.hasNext()) {
                Category c = it.next();
                if (active_map.containsKey(c)) continue;
                c.removeCategoryListener(this.category_listener);
                it.remove();
            }
            for (final Category c : active_map.keySet()) {
                if (this.category_map.containsKey(c)) continue;
                to_process.put(c, active_map.get(c));
                c.addCategoryListener(this.category_listener);
                this.category_map.put(c, (Object[])active_map.get(c));
                if (c.getType() != 2 || this.category_dl_listener != null) continue;
                this.category_dl_listener = new GlobalManagerAdapter(){

                    @Override
                    public void downloadManagerAdded(final DownloadManager dm) {
                        new DelayedEvent("TM:cat-check", 10000L, new AERunnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void runSupport() {
                                Category dm_c = dm.getDownloadState().getCategory();
                                if (dm_c == null || dm_c == c) {
                                    Object[] details;
                                    Map map = TranscodeManagerImpl.this.category_map;
                                    synchronized (map) {
                                        details = (Object[])TranscodeManagerImpl.this.category_map.get(c);
                                    }
                                    if (details != null) {
                                        TranscodeManagerImpl.this.processCategory(c, details, dm);
                                    }
                                }
                            }
                        });
                    }

                    @Override
                    public void downloadManagerRemoved(DownloadManager dm) {
                    }
                };
                this.azureus_core.getGlobalManager().addListener(this.category_dl_listener, false);
            }
        }
        if (to_process.size() > 0) {
            List<DownloadManager> downloads = this.azureus_core.getGlobalManager().getDownloadManagers();
            for (Map.Entry entry : to_process.entrySet()) {
                Category c;
                c = (Category)entry.getKey();
                Object[] details = (Object[])entry.getValue();
                List<DownloadManager> list = c.getDownloadManagers(downloads);
                for (DownloadManager dm : list) {
                    this.processCategory(c, details, dm);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processCategory(Category cat, Object[] details, DownloadManager dm) {
        Download download = PluginCoreUtils.wrap(dm);
        if (download == null) {
            return;
        }
        if (download.getFlag(16L)) {
            return;
        }
        String str = download.getAttribute(this.category_ta);
        String cat_name = cat.getName();
        if (cat.getType() == 2) {
            cat_name = "<none>";
        }
        String cat_tag = cat_name + ";";
        if (str != null && str.contains(cat_tag)) {
            return;
        }
        try {
            DeviceMediaRenderer device = (DeviceMediaRenderer)details[0];
            TranscodeProfile profile = (TranscodeProfile)details[1];
            this.log("Category " + cat_name + " - adding " + download.getName() + " to " + device.getName() + "/" + profile.getName());
            DiskManagerFileInfo[] dm_files = download.getDiskManagerFileInfo();
            int num_added = 0;
            for (DiskManagerFileInfo dm_file : dm_files) {
                if (num_added > 64) break;
                if (dm_files.length != 1 && dm_file.getLength() < 131072L) continue;
                try {
                    this.queue.add(device, profile, dm_file, false);
                    ++num_added;
                }
                catch (Throwable e) {
                    this.log("    add failed", e);
                }
            }
            download.setAttribute(this.category_ta, str == null ? cat_tag : str + cat_tag);
        }
        catch (Throwable throwable) {
            download.setAttribute(this.category_ta, str == null ? cat_tag : str + cat_tag);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkTags() {
        TagManager tm = TagManagerFactory.getTagManager();
        HashMap<Tag, Object[]> active_map = new HashMap<Tag, Object[]>();
        for (TagType tagType : tm.getTagTypes()) {
            if (!tagType.hasTagTypeFeature(8L)) continue;
            for (Tag tag : tagType.getTags()) {
                String[] target_details;
                TagFeatureTranscode tfx = (TagFeatureTranscode)((Object)tag);
                if (!tfx.supportsTagTranscode() || (target_details = tfx.getTagTranscodeTarget()) == null) continue;
                String target = target_details[0];
                String device_id = null;
                if (target.endsWith("/blank")) {
                    device_id = target.substring(0, target.length() - 6);
                }
                DeviceMediaRenderer target_dmr = null;
                TranscodeProfile target_profile = null;
                block5: for (DeviceImpl device : this.device_manager.getDevices()) {
                    TranscodeProfile[] profs;
                    if (!(device instanceof DeviceMediaRenderer)) continue;
                    DeviceMediaRenderer dmr = (DeviceMediaRenderer)((Object)device);
                    if (device_id != null) {
                        if (!device.getID().equals(device_id)) continue;
                        target_dmr = dmr;
                        target_profile = device.getBlankProfile();
                        break;
                    }
                    for (TranscodeProfile prof : profs = device.getTranscodeProfiles()) {
                        if (!prof.getUID().equals(target)) continue;
                        target_dmr = dmr;
                        target_profile = prof;
                        continue block5;
                    }
                }
                if (target_dmr == null) continue;
                active_map.put(tag, new Object[]{target_dmr, target_profile});
            }
        }
        HashMap to_process = new HashMap();
        Map<Tag, Object[]> map = this.tag_map;
        synchronized (map) {
            if (this.tag_listener == null) {
                this.tag_listener = new TagListener(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void taggableAdded(Tag tag, Taggable tagged) {
                        Object[] details;
                        Map map = TranscodeManagerImpl.this.tag_map;
                        synchronized (map) {
                            details = (Object[])TranscodeManagerImpl.this.tag_map.get(tag);
                        }
                        if (details != null) {
                            TranscodeManagerImpl.this.processTag(tag, details, (DownloadManager)tagged);
                        }
                    }

                    @Override
                    public void taggableSync(Tag tag) {
                    }

                    @Override
                    public void taggableRemoved(Tag tag, Taggable tagged) {
                    }
                };
            }
            Iterator<Tag> it = this.tag_map.keySet().iterator();
            while (it.hasNext()) {
                Tag t = it.next();
                if (active_map.containsKey(t)) continue;
                t.removeTagListener(this.tag_listener);
                it.remove();
            }
            for (Tag tag : active_map.keySet()) {
                if (this.tag_map.containsKey(tag)) continue;
                to_process.put(tag, active_map.get(tag));
                tag.addTagListener(this.tag_listener, false);
                this.tag_map.put(tag, (Object[])active_map.get(tag));
            }
        }
        if (to_process.size() > 0) {
            for (Map.Entry entry : to_process.entrySet()) {
                Tag tag;
                tag = (Tag)entry.getKey();
                Object[] details = (Object[])entry.getValue();
                Set<DownloadManager> list = ((TagDownload)tag).getTaggedDownloads();
                for (DownloadManager dm : list) {
                    this.processTag(tag, details, dm);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processTag(Tag tag, Object[] details, DownloadManager dm) {
        Download download = PluginCoreUtils.wrap(dm);
        if (download == null) {
            return;
        }
        if (download.getFlag(16L)) {
            return;
        }
        String str = download.getAttribute(this.tag_ta);
        String tag_name = tag.getTagName(true);
        String tag_tag = tag.getTagType().getTagType() + "." + tag.getTagID() + ";";
        if (str != null && str.contains(tag_tag)) {
            return;
        }
        try {
            DeviceMediaRenderer device = (DeviceMediaRenderer)details[0];
            TranscodeProfile profile = (TranscodeProfile)details[1];
            this.log("Tag " + tag_name + " - adding " + download.getName() + " to " + device.getName() + "/" + profile.getName());
            DiskManagerFileInfo[] dm_files = download.getDiskManagerFileInfo();
            int num_added = 0;
            for (DiskManagerFileInfo dm_file : dm_files) {
                if (num_added > 64) break;
                if (dm_files.length != 1 && dm_file.getLength() < 131072L) continue;
                try {
                    this.queue.add(device, profile, dm_file, false);
                    ++num_added;
                }
                catch (Throwable e) {
                    this.log("    add failed", e);
                }
            }
            download.setAttribute(this.tag_ta, str == null ? tag_tag : str + tag_tag);
        }
        catch (Throwable throwable) {
            download.setAttribute(this.tag_ta, str == null ? tag_tag : str + tag_tag);
            throw throwable;
        }
    }

    @Override
    public TranscodeProvider[] getProviders() {
        TranscodeProviderVuze vp = this.vuzexcode_provider;
        if (vp == null) {
            return new TranscodeProvider[0];
        }
        return new TranscodeProvider[]{vp};
    }

    protected TranscodeProvider getProvider(int p_id) throws TranscodeException {
        TranscodeProviderVuze vp = this.vuzexcode_provider;
        if (p_id == 1 && vp != null) {
            return vp;
        }
        throw new TranscodeException("Transcode provider not registered");
    }

    protected TranscodeProfile getProfileFromUID(String uid) {
        for (TranscodeProvider provider2 : this.getProviders()) {
            TranscodeProfile profile = provider2.getProfile(uid);
            if (profile == null) continue;
            return profile;
        }
        return null;
    }

    @Override
    public TranscodeQueueImpl getQueue() {
        if (!this.init_sem.reserve(30000L)) {
            Debug.out("Timeout waiting for init");
            AEDiagnostics.dumpThreads();
        }
        return this.queue;
    }

    protected DeviceManagerImpl getManager() {
        return this.device_manager;
    }

    protected TranscodeTarget lookupTarget(String target_id) throws TranscodeException {
        DeviceImpl device = this.device_manager.getDevice(target_id);
        if (device instanceof TranscodeTarget) {
            return (TranscodeTarget)((Object)device);
        }
        throw new TranscodeException("Transcode target with id " + target_id + " not found");
    }

    protected DiskManagerFileInfo lookupFile(byte[] hash, int index) throws TranscodeException {
        try {
            Download download = PluginInitializer.getDefaultInterface().getDownloadManager().getDownload(hash);
            if (download == null) {
                throw new TranscodeException("Download with hash " + ByteFormatter.encodeString(hash) + " not found");
            }
            return download.getDiskManagerFileInfo()[index];
        }
        catch (Throwable e) {
            throw new TranscodeException("Download with hash " + ByteFormatter.encodeString(hash) + " not found", e);
        }
    }

    protected void close() {
        this.queue.close();
    }

    @Override
    public void addListener(TranscodeManagerListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(TranscodeManagerListener listener) {
        this.listeners.remove(listener);
    }

    protected void log(String str) {
        this.device_manager.log("Trans: " + str);
    }

    protected void log(String str, Throwable e) {
        this.device_manager.log("Trans: " + str, e);
    }

    public void generate(IndentWriter writer) {
        writer.println("Transcode Manager: vuze provider=" + this.vuzexcode_provider);
        this.queue.generate(writer);
    }
}

