/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.devices.impl;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.AzureusCoreRunningListener;
import com.aelitis.azureus.core.devices.impl.DeviceManagerImpl;
import com.aelitis.azureus.core.devices.impl.DeviceiTunes;
import org.gudy.azureus2.plugins.PluginEvent;
import org.gudy.azureus2.plugins.PluginEventListener;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.PluginListener;
import org.gudy.azureus2.plugins.PluginManager;

public class DeviceiTunesManager {
    private DeviceManagerImpl device_manager;
    private DeviceiTunes itunes_device;

    protected DeviceiTunesManager(DeviceManagerImpl _dm) {
        this.device_manager = _dm;
        AzureusCoreFactory.addCoreRunningListener(new AzureusCoreRunningListener(){

            @Override
            public void azureusCoreRunning(AzureusCore core) {
                DeviceiTunesManager.this.init(core);
            }
        });
    }

    private void init(AzureusCore azureus_core) {
        final PluginManager pm = azureus_core.getPluginManager();
        final PluginInterface default_pi = pm.getDefaultPluginInterface();
        default_pi.addListener(new PluginListener(){

            @Override
            public void initializationComplete() {
                PluginInterface[] plugins;
                default_pi.addEventListener(new PluginEventListener(){

                    @Override
                    public void handleEvent(PluginEvent ev) {
                        int type = ev.getType();
                        if (type == 8) {
                            DeviceiTunesManager.this.pluginAdded((PluginInterface)ev.getValue());
                        }
                        if (type == 9) {
                            DeviceiTunesManager.this.pluginRemoved((PluginInterface)ev.getValue());
                        }
                    }
                });
                for (PluginInterface pi : plugins = pm.getPlugins()) {
                    if (!pi.getPluginState().isOperational()) continue;
                    DeviceiTunesManager.this.pluginAdded(pi);
                }
            }

            @Override
            public void closedownInitiated() {
            }

            @Override
            public void closedownComplete() {
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void pluginAdded(PluginInterface pi) {
        if (pi.getPluginState().isBuiltIn()) {
            return;
        }
        String plugin_id = pi.getPluginID();
        if (plugin_id.equals("azitunes")) {
            DeviceiTunes new_device;
            DeviceiTunesManager deviceiTunesManager = this;
            synchronized (deviceiTunesManager) {
                if (this.itunes_device != null) {
                    return;
                }
                this.itunes_device = new_device = new DeviceiTunes(this.device_manager, pi);
            }
            this.device_manager.addDevice(new_device, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void pluginRemoved(PluginInterface pi) {
        String plugin_id = pi.getPluginID();
        if (plugin_id.equals("azitunes")) {
            DeviceiTunes existing_device;
            DeviceiTunesManager deviceiTunesManager = this;
            synchronized (deviceiTunesManager) {
                if (this.itunes_device == null) {
                    return;
                }
                existing_device = this.itunes_device;
                this.itunes_device = null;
            }
            existing_device.remove();
        }
    }
}

