/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.devices.impl;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.AzureusCoreLifecycleAdapter;
import com.aelitis.azureus.core.AzureusCoreRunningListener;
import com.aelitis.azureus.core.devices.Device;
import com.aelitis.azureus.core.devices.DeviceManager;
import com.aelitis.azureus.core.devices.DeviceManagerDiscoveryListener;
import com.aelitis.azureus.core.devices.DeviceManagerException;
import com.aelitis.azureus.core.devices.DeviceManagerListener;
import com.aelitis.azureus.core.devices.DeviceMediaRenderer;
import com.aelitis.azureus.core.devices.DeviceOfflineDownloaderManager;
import com.aelitis.azureus.core.devices.DeviceSearchListener;
import com.aelitis.azureus.core.devices.DeviceTemplate;
import com.aelitis.azureus.core.devices.TranscodeManager;
import com.aelitis.azureus.core.devices.TranscodeProfile;
import com.aelitis.azureus.core.devices.TranscodeProvider;
import com.aelitis.azureus.core.devices.impl.DeviceDriveManager;
import com.aelitis.azureus.core.devices.impl.DeviceImpl;
import com.aelitis.azureus.core.devices.impl.DeviceManagerRSSFeed;
import com.aelitis.azureus.core.devices.impl.DeviceManagerUPnPImpl;
import com.aelitis.azureus.core.devices.impl.DeviceMediaRendererImpl;
import com.aelitis.azureus.core.devices.impl.DeviceMediaRendererManual;
import com.aelitis.azureus.core.devices.impl.DeviceMediaRendererTemplateImpl;
import com.aelitis.azureus.core.devices.impl.DeviceOfflineDownloaderImpl;
import com.aelitis.azureus.core.devices.impl.DeviceTivoManager;
import com.aelitis.azureus.core.devices.impl.DeviceUPnPImpl;
import com.aelitis.azureus.core.devices.impl.DeviceiTunesManager;
import com.aelitis.azureus.core.devices.impl.TranscodeFileImpl;
import com.aelitis.azureus.core.devices.impl.TranscodeManagerImpl;
import com.aelitis.azureus.core.messenger.config.PlatformDevicesMessenger;
import com.aelitis.azureus.core.util.CopyOnWriteList;
import com.aelitis.azureus.core.vuzefile.VuzeFile;
import com.aelitis.azureus.core.vuzefile.VuzeFileComponent;
import com.aelitis.azureus.core.vuzefile.VuzeFileHandler;
import com.aelitis.azureus.core.vuzefile.VuzeFileProcessor;
import com.aelitis.net.upnp.UPnPDevice;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.logging.LogAlert;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.AEDiagnostics;
import org.gudy.azureus2.core3.util.AEDiagnosticsEvidenceGenerator;
import org.gudy.azureus2.core3.util.AEDiagnosticsLogger;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.AsyncDispatcher;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DelayedEvent;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.IndentWriter;
import org.gudy.azureus2.core3.util.ListenerManager;
import org.gudy.azureus2.core3.util.ListenerManagerDispatcher;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.platform.PlatformManagerFactory;
import org.gudy.azureus2.plugins.disk.DiskManagerFileInfo;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.ipc.IPCInterface;
import org.gudy.azureus2.plugins.torrent.TorrentAttribute;
import org.gudy.azureus2.plugins.tracker.web.TrackerWebPageRequest;
import org.gudy.azureus2.plugins.ui.UIManager;
import org.gudy.azureus2.plugins.utils.PowerManagementListener;
import org.gudy.azureus2.plugins.utils.StaticUtilities;
import org.gudy.azureus2.pluginsimpl.local.PluginInitializer;

public class DeviceManagerImpl
implements DeviceManager,
DeviceOfflineDownloaderManager,
PowerManagementListener,
AEDiagnosticsEvidenceGenerator {
    private static final String LOGGER_NAME = "Devices";
    private static final String CONFIG_FILE = "devices.config";
    private static final String AUTO_SEARCH_CONFIG_KEY = "devices.config.auto_search";
    private static final int AUTO_HIDE_OLD_DAYS_DEFAULT = 31;
    private static final String AUTO_HIDE_OLD_CONFIG_KEY = "devices.config.auto_hide_old";
    private static final String RSS_ENABLE_CONFIG_KEY = "devices.config.rss_enable";
    private static final String OD_ENABLED_CONFIG_KEY = "devices.config.od.enabled";
    private static final String OD_IS_AUTO_CONFIG_KEY = "devices.config.od.auto";
    private static final String OD_INCLUDE_PRIVATE_CONFIG_KEY = "devices.config.od.inc_priv";
    private static final String TRANSCODE_DIR_DEFAULT = "transcodes";
    private static final String CONFIG_DEFAULT_WORK_DIR = "devices.config.def_work_dir";
    private static final String CONFIG_DISABLE_SLEEP = "devices.config.disable_sleep";
    protected static final int DEVICE_UPDATE_PERIOD = 5000;
    protected static final int DEVICE_AUTO_HIDE_CHECK_PERIOD = 120000;
    protected static final int DEVICE_AUTO_HIDE_CHECK_TICKS = 24;
    private static boolean pre_initialised;
    private static DeviceManagerImpl singleton;
    private AzureusCore azureus_core;
    private TorrentAttribute od_manual_ta;
    private List<DeviceImpl> device_list = new ArrayList<DeviceImpl>();
    private Map<String, DeviceImpl> device_map = new HashMap<String, DeviceImpl>();
    private DeviceTivoManager tivo_manager;
    private DeviceManagerUPnPImpl upnp_manager;
    private DeviceDriveManager drive_manager;
    private Set<Device> disable_events = Collections.synchronizedSet(new HashSet());
    private static final int LT_DEVICE_ADDED = 1;
    private static final int LT_DEVICE_CHANGED = 2;
    private static final int LT_DEVICE_ATTENTION = 3;
    private static final int LT_DEVICE_REMOVED = 4;
    private static final int LT_INITIALIZED = 5;
    private ListenerManager<DeviceManagerListener> listeners = ListenerManager.createAsyncManager("DM:ld", new ListenerManagerDispatcher<DeviceManagerListener>(){

        @Override
        public void dispatch(DeviceManagerListener listener, int type, Object value) {
            DeviceImpl device = (DeviceImpl)value;
            switch (type) {
                case 1: {
                    listener.deviceAdded(device);
                    break;
                }
                case 2: {
                    if (!this.deviceAdded(device)) break;
                    device.fireChanged();
                    listener.deviceChanged(device);
                    break;
                }
                case 3: {
                    if (!this.deviceAdded(device)) break;
                    listener.deviceAttentionRequest(device);
                    break;
                }
                case 4: {
                    listener.deviceRemoved(device);
                    break;
                }
                case 5: {
                    listener.deviceManagerLoaded();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean deviceAdded(Device device) {
            DeviceManagerImpl deviceManagerImpl = DeviceManagerImpl.this;
            synchronized (deviceManagerImpl) {
                return DeviceManagerImpl.this.device_list.contains(device);
            }
        }
    });
    private boolean auto_search;
    private int auto_hide_old_days = 31;
    private DeviceManagerRSSFeed rss_publisher;
    private boolean od_enabled;
    private boolean od_is_auto;
    private boolean od_include_private;
    private boolean closing;
    private boolean config_unclean;
    private boolean config_dirty;
    private int explicit_search;
    private volatile TranscodeManagerImpl transcode_manager;
    private CopyOnWriteList<DeviceManagerDiscoveryListener> discovery_listeners = new CopyOnWriteList();
    private int getMimeType_fails;
    private Object logger_lock = new Object();
    private AEDiagnosticsLogger logger;
    private AsyncDispatcher async_dispatcher = new AsyncDispatcher(10000);
    private AESemaphore init_sem = new AESemaphore("dm:init");
    private volatile boolean initialized = false;
    private Object lsn_lock = new Object();
    private String local_service_name;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void preInitialise() {
        Class<DeviceManagerImpl> clazz = DeviceManagerImpl.class;
        synchronized (DeviceManagerImpl.class) {
            if (pre_initialised) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
            pre_initialised = true;
            // ** MonitorExit[var0] (shouldn't be in output)
            VuzeFileHandler.getSingleton().addProcessor(new VuzeFileProcessor(){

                @Override
                public void process(VuzeFile[] files, int expected_types) {
                    for (int i = 0; i < files.length; ++i) {
                        VuzeFile vf = files[i];
                        VuzeFileComponent[] comps = vf.getComponents();
                        for (int j = 0; j < comps.length; ++j) {
                            VuzeFileComponent comp2 = comps[j];
                            int type = comp2.getType();
                            if (type != 512) continue;
                            try {
                                ((DeviceManagerImpl)DeviceManagerImpl.getSingleton()).importVuzeFile(comp2.getContent(), (expected_types & 0x200) == 0);
                                comp2.setProcessed();
                                continue;
                            }
                            catch (Throwable e) {
                                Debug.printStackTrace(e);
                            }
                        }
                    }
                }
            });
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DeviceManager getSingleton() {
        Class<DeviceManagerImpl> clazz = DeviceManagerImpl.class;
        synchronized (DeviceManagerImpl.class) {
            if (singleton == null) {
                singleton = new DeviceManagerImpl();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return singleton;
        }
    }

    protected DeviceManagerImpl() {
        AEDiagnostics.addEvidenceGenerator(this);
        AzureusCoreFactory.addCoreRunningListener(new AzureusCoreRunningListener(){

            @Override
            public void azureusCoreRunning(AzureusCore core) {
                DeviceManagerImpl.this.initWithCore(core);
            }
        });
    }

    private TranscodeManager ensureInitialised(boolean partial) {
        AzureusCore core = AzureusCoreFactory.getSingleton();
        if (core.isStarted()) {
            this.initWithCore(core);
        } else if (core.isInitThread()) {
            Debug.out("This is bad");
            this.initWithCore(core);
        }
        if (partial) {
            long start = SystemTime.getMonotonousTime();
            while (!this.init_sem.reserve(250L) && this.transcode_manager == null) {
                if (SystemTime.getMonotonousTime() - start < 30000L) continue;
                Debug.out("Timeout waiting for init");
                AEDiagnostics.dumpThreads();
                break;
            }
        } else if (!this.init_sem.reserve(30000L)) {
            Debug.out("Timeout waiting for init");
            AEDiagnostics.dumpThreads();
        }
        return this.transcode_manager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initWithCore(AzureusCore core) {
        DeviceManagerImpl deviceManagerImpl = this;
        synchronized (deviceManagerImpl) {
            if (this.azureus_core != null) {
                return;
            }
            this.azureus_core = core;
        }
        try {
            this.od_manual_ta = PluginInitializer.getDefaultInterface().getTorrentManager().getPluginAttribute("device.manager.od.ta.manual");
            this.rss_publisher = new DeviceManagerRSSFeed(this);
            COConfigurationManager.addAndFireParameterListeners(new String[]{AUTO_SEARCH_CONFIG_KEY, AUTO_HIDE_OLD_CONFIG_KEY}, new ParameterListener(){

                @Override
                public void parameterChanged(String name) {
                    DeviceManagerImpl.this.auto_search = COConfigurationManager.getBooleanParameter(DeviceManagerImpl.AUTO_SEARCH_CONFIG_KEY, true);
                    DeviceManagerImpl.this.auto_hide_old_days = COConfigurationManager.getIntParameter(DeviceManagerImpl.AUTO_HIDE_OLD_CONFIG_KEY, 31);
                }
            });
            COConfigurationManager.addAndFireParameterListeners(new String[]{OD_ENABLED_CONFIG_KEY, OD_IS_AUTO_CONFIG_KEY, OD_INCLUDE_PRIVATE_CONFIG_KEY}, new ParameterListener(){

                @Override
                public void parameterChanged(String name) {
                    boolean new_od_enabled = COConfigurationManager.getBooleanParameter(DeviceManagerImpl.OD_ENABLED_CONFIG_KEY, true);
                    boolean new_od_is_auto = COConfigurationManager.getBooleanParameter(DeviceManagerImpl.OD_IS_AUTO_CONFIG_KEY, true);
                    boolean new_od_include_private_priv = COConfigurationManager.getBooleanParameter(DeviceManagerImpl.OD_INCLUDE_PRIVATE_CONFIG_KEY, false);
                    if (new_od_enabled != DeviceManagerImpl.this.od_enabled || new_od_is_auto != DeviceManagerImpl.this.od_is_auto || new_od_include_private_priv != DeviceManagerImpl.this.od_include_private) {
                        DeviceManagerImpl.this.od_enabled = new_od_enabled;
                        DeviceManagerImpl.this.od_is_auto = new_od_is_auto;
                        DeviceManagerImpl.this.od_include_private = new_od_include_private_priv;
                        DeviceManagerImpl.this.manageOD();
                    }
                }
            });
            this.tivo_manager = new DeviceTivoManager(this);
            this.upnp_manager = new DeviceManagerUPnPImpl(this);
            this.loadConfig();
            new DeviceiTunesManager(this);
            this.drive_manager = new DeviceDriveManager(this);
            this.transcode_manager = new TranscodeManagerImpl(this);
            this.transcode_manager.initialise();
            core.addLifecycleListener(new AzureusCoreLifecycleAdapter(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void stopping(AzureusCore core) {
                    DeviceManagerImpl deviceManagerImpl = DeviceManagerImpl.this;
                    synchronized (deviceManagerImpl) {
                        DeviceImpl[] devices;
                        if (DeviceManagerImpl.this.config_dirty || DeviceManagerImpl.this.config_unclean) {
                            DeviceManagerImpl.this.saveConfig();
                        }
                        DeviceManagerImpl.this.closing = true;
                        DeviceManagerImpl.this.transcode_manager.close();
                        for (DeviceImpl device : devices = DeviceManagerImpl.this.getDevices()) {
                            device.close();
                        }
                    }
                }
            });
            this.upnp_manager.initialise();
            SimpleTimer.addPeriodicEvent("DeviceManager:update", 5000L, new TimerEventPerformer(){
                private int tick_count = 0;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void perform(TimerEvent event2) {
                    ArrayList copy;
                    ++this.tick_count;
                    DeviceManagerImpl.this.transcode_manager.updateStatus(this.tick_count);
                    DeviceManagerImpl deviceManagerImpl = DeviceManagerImpl.this;
                    synchronized (deviceManagerImpl) {
                        if (DeviceManagerImpl.this.device_list.size() == 0) {
                            return;
                        }
                        copy = new ArrayList(DeviceManagerImpl.this.device_list);
                    }
                    for (DeviceImpl device : copy) {
                        device.updateStatus(this.tick_count);
                    }
                    if (DeviceManagerImpl.this.auto_hide_old_days > 0 && this.tick_count % 24 == 0) {
                        long now = SystemTime.getCurrentTime();
                        int num_hidden = 0;
                        for (DeviceImpl device : copy) {
                            DeviceMediaRenderer rend;
                            int type;
                            if (!device.isLivenessDetectable() || device.isTagged() || (type = device.getType()) != 2 && (type != 3 || (rend = (DeviceMediaRenderer)((Object)device)).getRendererSpecies() != 6)) continue;
                            long age = now - device.getLastSeen();
                            if (age > (long)(DeviceManagerImpl.this.auto_hide_old_days * 24 * 60 * 60) * 1000L) {
                                if (device.isHidden()) continue;
                                DeviceManagerImpl.this.log("Auto-hiding '" + device.getName() + "'");
                                device.setHidden(true);
                                device.setAutoHidden(true);
                                ++num_hidden;
                                continue;
                            }
                            if (!device.isHidden() || !device.isAutoHidden()) continue;
                            DeviceManagerImpl.this.log("Auto-showing '" + device.getName() + "'");
                            device.setAutoHidden(false);
                            device.setHidden(false);
                        }
                        if (num_hidden > 0) {
                            Logger.log(new LogAlert(true, 0, MessageText.getString("device.autohide.alert", new String[]{String.valueOf(num_hidden), String.valueOf(DeviceManagerImpl.this.auto_hide_old_days)})));
                        }
                    }
                }
            });
            this.initialized = true;
            this.listeners.dispatch(5, null);
            core.addPowerManagementListener(this);
        }
        finally {
            this.init_sem.releaseForever();
        }
    }

    protected void manageOD() {
        DeviceImpl[] devices;
        for (DeviceImpl device : devices = this.getDevices()) {
            if (device.getType() != 5) continue;
            ((DeviceOfflineDownloaderImpl)device).checkConfig();
        }
    }

    protected void UPnPManagerStarted() {
        DeviceImpl[] devices;
        this.tivo_manager.startUp();
        for (DeviceImpl device : devices = this.getDevices()) {
            if (!(device instanceof DeviceUPnPImpl)) continue;
            ((DeviceUPnPImpl)device).UPnPInitialised();
        }
    }

    protected AzureusCore getAzureusCore() {
        return this.azureus_core;
    }

    protected DeviceManagerUPnPImpl getUPnPManager() {
        return this.upnp_manager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getLocalServiceName() {
        Object object = this.lsn_lock;
        synchronized (object) {
            if (this.local_service_name == null) {
                try {
                    this.local_service_name = (String)this.getUPnPManager().getUPnPAVIPC().invoke("getServiceName", new Object[0]);
                }
                catch (Throwable e) {
                    // empty catch block
                }
                if (this.local_service_name == null) {
                    this.local_service_name = Constants.APP_NAME;
                    try {
                        String cn = PlatformManagerFactory.getPlatformManager().getComputerName();
                        if (cn != null && cn.length() > 0) {
                            this.local_service_name = this.local_service_name + " on " + cn;
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
            return this.local_service_name;
        }
    }

    @Override
    public boolean isTiVoEnabled() {
        return this.tivo_manager.isEnabled();
    }

    @Override
    public void setTiVoEnabled(boolean enabled) {
        this.tivo_manager.setEnabled(enabled);
    }

    public TranscodeProvider[] getProviders() {
        TranscodeManager tm = this.ensureInitialised(true);
        if (tm == null) {
            return new TranscodeProvider[0];
        }
        return tm.getProviders();
    }

    @Override
    public DeviceTemplate[] getDeviceTemplates(int device_type) {
        if (this.transcode_manager == null || device_type != 3) {
            return new DeviceTemplate[0];
        }
        TranscodeProvider[] providers = this.transcode_manager.getProviders();
        ArrayList<DeviceMediaRendererTemplateImpl> result = new ArrayList<DeviceMediaRendererTemplateImpl>();
        for (TranscodeProvider provider2 : providers) {
            TranscodeProfile[] profiles = provider2.getProfiles();
            HashMap<String, DeviceMediaRendererTemplateImpl> class_map = new HashMap<String, DeviceMediaRendererTemplateImpl>();
            for (TranscodeProfile profile : profiles) {
                String classification = profile.getDeviceClassification();
                if (classification.startsWith("apple.")) {
                    classification = "apple.";
                }
                boolean auto = classification.equals("sony.PS3") || classification.equals("microsoft.XBox") || classification.equals("apple.") || classification.equals("nintendo.Wii") || classification.equals("browser.generic");
                DeviceMediaRendererTemplateImpl temp = (DeviceMediaRendererTemplateImpl)class_map.get(classification);
                if (temp == null) {
                    temp = new DeviceMediaRendererTemplateImpl(this, classification, auto);
                    class_map.put(classification, temp);
                    result.add(temp);
                }
                temp.addProfile(profile);
            }
        }
        return result.toArray(new DeviceTemplate[result.size()]);
    }

    @Override
    public DeviceManager.DeviceManufacturer[] getDeviceManufacturers(int device_type) {
        DeviceTemplate[] templates = this.getDeviceTemplates(device_type);
        HashMap<String, DeviceManufacturerImpl> map = new HashMap<String, DeviceManufacturerImpl>();
        for (DeviceTemplate template : templates) {
            if (template.getType() != device_type) continue;
            String man_str = template.getManufacturer();
            DeviceManufacturerImpl man = (DeviceManufacturerImpl)map.get(man_str);
            if (man == null) {
                man = new DeviceManufacturerImpl(man_str);
                map.put(man_str, man);
            }
            man.addTemplate(template);
        }
        return map.values().toArray(new DeviceManager.DeviceManufacturer[map.size()]);
    }

    @Override
    public Device addVirtualDevice(int type, String uid, String classification, String name) throws DeviceManagerException {
        return this.createDevice(type, uid, classification, name, true);
    }

    @Override
    public Device addInetDevice(int type, String uid, String classification, String name, InetAddress address) throws DeviceManagerException {
        Device device = this.createDevice(type, uid, classification, name, false);
        device.setAddress(address);
        return device;
    }

    protected Device createDevice(int device_type, String uid, String classification, String name, boolean manual) throws DeviceManagerException {
        if (device_type == 3) {
            DeviceImpl res = manual ? new DeviceMediaRendererManual(this, uid, classification, true, name) : new DeviceMediaRendererImpl(this, uid, classification, true, name);
            res = this.addDevice(res);
            return res;
        }
        throw new DeviceManagerException("Can't manually create this device type");
    }

    @Override
    public void search(final int millis, final DeviceSearchListener listener) {
        new AEThread2("DM:search", true){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                DeviceManagerImpl deviceManagerImpl = DeviceManagerImpl.this;
                synchronized (deviceManagerImpl) {
                    DeviceManagerImpl.this.explicit_search++;
                }
                DeviceManagerImpl.this.tivo_manager.search();
                DeviceManagerImpl.this.drive_manager.search();
                AESemaphore sem = new AESemaphore("DM:search");
                DeviceManagerListener dm_listener = new DeviceManagerListener(){

                    @Override
                    public void deviceAdded(Device device) {
                        listener.deviceFound(device);
                    }

                    @Override
                    public void deviceChanged(Device device) {
                    }

                    @Override
                    public void deviceAttentionRequest(Device device) {
                    }

                    @Override
                    public void deviceRemoved(Device device) {
                    }

                    @Override
                    public void deviceManagerLoaded() {
                    }
                };
                try {
                    DeviceManagerImpl.this.addListener(dm_listener);
                    DeviceManagerImpl.this.upnp_manager.search();
                    sem.reserve(millis);
                }
                finally {
                    DeviceManagerImpl deviceManagerImpl2 = DeviceManagerImpl.this;
                    synchronized (deviceManagerImpl2) {
                        DeviceManagerImpl.this.explicit_search--;
                    }
                    DeviceManagerImpl.this.removeListener(dm_listener);
                    listener.complete();
                }
            }
        }.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DeviceImpl getDevice(String id) {
        DeviceManagerImpl deviceManagerImpl = this;
        synchronized (deviceManagerImpl) {
            return this.device_map.get(id);
        }
    }

    protected DeviceImpl addDevice(DeviceImpl device) {
        return this.addDevice(device, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DeviceImpl addDevice(DeviceImpl device, boolean is_alive) {
        DeviceImpl existing = null;
        DeviceManagerImpl deviceManagerImpl = this;
        synchronized (deviceManagerImpl) {
            DeviceMediaRenderer renderer;
            existing = this.device_map.get(device.getID());
            if (existing != null) {
                existing.updateFrom(device, is_alive);
            } else if (device.getType() == 3 && (renderer = (DeviceMediaRenderer)((Object)device)).getRendererSpecies() == 2 && !renderer.isManual()) {
                for (DeviceImpl d : this.device_list) {
                    DeviceMediaRenderer r;
                    if (d.getType() != 3 || (r = (DeviceMediaRenderer)((Object)d)).getRendererSpecies() != 2 || !r.isManual()) continue;
                    existing = d;
                    this.log("Merging " + device.getString() + " -> " + existing.getString());
                    String secondary_id = device.getID();
                    existing.setSecondaryID(secondary_id);
                    existing.updateFrom(device, is_alive);
                }
            }
            if (existing == null) {
                this.device_list.add(device);
                this.device_map.put(device.getID(), device);
            }
        }
        if (existing != null) {
            this.applyUpdates(existing);
            return existing;
        }
        try {
            this.disable_events.add(device);
            device.initialise();
            if (is_alive) {
                device.alive();
            }
            this.applyUpdates(device);
        }
        finally {
            this.disable_events.remove(device);
        }
        this.deviceAdded(device);
        this.configDirty();
        return device;
    }

    protected void applyUpdates(DeviceImpl device) {
        UPnPDevice upnp_device;
        DeviceMediaRenderer renderer;
        if (device.getType() == 3 && (renderer = (DeviceMediaRenderer)((Object)device)) instanceof DeviceUPnPImpl && (upnp_device = ((DeviceUPnPImpl)((Object)renderer)).getUPnPDevice()) != null) {
            String model_number;
            String lc_manufacturer = this.getOptionalLC(upnp_device.getManufacturer());
            String lc_model = this.getOptionalLC(upnp_device.getModelName());
            String lc_fname = this.getOptionalLC(upnp_device.getFriendlyName());
            if (lc_manufacturer.startsWith("samsung")) {
                device.setPersistentStringProperty("tt_rend_class", "samsung.generic");
                TranscodeProfile[] profiles = device.getTranscodeProfiles();
                if (profiles.length == 0) {
                    device.setTranscodeRequirement(1);
                } else {
                    device.setTranscodeRequirement(2);
                }
            } else if (lc_manufacturer.startsWith("western digital")) {
                device.setPersistentStringProperty("tt_rend_class", "western.digital.generic");
                TranscodeProfile[] profiles = device.getTranscodeProfiles();
                if (profiles.length == 0) {
                    device.setTranscodeRequirement(1);
                } else {
                    device.setTranscodeRequirement(2);
                }
            } else if (lc_manufacturer.startsWith("sony") && lc_fname.startsWith("bravia")) {
                device.setPersistentStringProperty("tt_rend_class", "sony.bravia");
            } else if (lc_model.equals("windows media player") && (model_number = upnp_device.getModelNumber()) != null) {
                try {
                    int num = Integer.parseInt(model_number);
                    if (num >= 12) {
                        device.setPersistentStringProperty("tt_rend_class", "ms_wmp.generic");
                        TranscodeProfile[] profiles = device.getTranscodeProfiles();
                        if (profiles.length == 0) {
                            device.setTranscodeRequirement(1);
                        } else {
                            device.setTranscodeRequirement(2);
                        }
                    }
                }
                catch (Throwable e) {
                    // empty catch block
                }
            }
        }
    }

    private String getOptionalLC(String str) {
        if (str == null) {
            return "";
        }
        return str.toLowerCase().trim();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeDevice(DeviceImpl device) {
        DeviceManagerImpl deviceManagerImpl = this;
        synchronized (deviceManagerImpl) {
            DeviceImpl existing = this.device_map.remove(device.getID());
            if (existing == null) {
                return;
            }
            this.device_list.remove(device);
            String secondary_id = device.getSecondaryID();
            if (secondary_id != null) {
                this.device_map.remove(secondary_id);
            }
        }
        device.destroy();
        this.deviceRemoved(device);
        this.configDirty();
    }

    @Override
    public boolean isBusy(int device_type) {
        DeviceImpl[] devices;
        if ((device_type == 0 || device_type == 3) && this.getTranscodeManager().getQueue().isTranscoding()) {
            return true;
        }
        for (DeviceImpl device : devices = this.getDevices()) {
            if (!device.isBusy() || device_type != 0 && device_type != device.getType()) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DeviceImpl[] getDevices() {
        DeviceManagerImpl deviceManagerImpl = this;
        synchronized (deviceManagerImpl) {
            return this.device_list.toArray(new DeviceImpl[this.device_list.size()]);
        }
    }

    @Override
    public boolean getAutoSearch() {
        return this.auto_search;
    }

    @Override
    public void setAutoSearch(boolean auto) {
        COConfigurationManager.setParameter(AUTO_SEARCH_CONFIG_KEY, auto);
    }

    @Override
    public int getAutoHideOldDevicesDays() {
        return COConfigurationManager.getIntParameter(AUTO_HIDE_OLD_CONFIG_KEY, 31);
    }

    @Override
    public void setAutoHideOldDevicesDays(int days) {
        COConfigurationManager.setParameter(AUTO_HIDE_OLD_CONFIG_KEY, days);
    }

    @Override
    public boolean isRSSPublishEnabled() {
        return COConfigurationManager.getBooleanParameter(RSS_ENABLE_CONFIG_KEY, false);
    }

    @Override
    public void setRSSPublishEnabled(boolean enabled) {
        COConfigurationManager.setParameter(RSS_ENABLE_CONFIG_KEY, enabled);
    }

    @Override
    public String getRSSLink() {
        return this.rss_publisher.getFeedURL();
    }

    @Override
    public DeviceOfflineDownloaderManager getOfflineDownlaoderManager() {
        return this;
    }

    @Override
    public boolean isOfflineDownloadingEnabled() {
        return this.od_enabled;
    }

    @Override
    public void setOfflineDownloadingEnabled(boolean enabled) {
        COConfigurationManager.setParameter(OD_ENABLED_CONFIG_KEY, enabled);
    }

    @Override
    public boolean getOfflineDownloadingIsAuto() {
        return this.od_is_auto;
    }

    @Override
    public void setOfflineDownloadingIsAuto(boolean auto) {
        COConfigurationManager.setParameter(OD_IS_AUTO_CONFIG_KEY, auto);
    }

    @Override
    public boolean getOfflineDownloadingIncludePrivate() {
        return this.od_include_private;
    }

    @Override
    public void setOfflineDownloadingIncludePrivate(boolean include) {
        COConfigurationManager.setParameter(OD_INCLUDE_PRIVATE_CONFIG_KEY, include);
    }

    @Override
    public boolean isManualDownload(Download download) {
        return download.getBooleanAttribute(this.od_manual_ta);
    }

    @Override
    public void addManualDownloads(Download[] downloads) {
        for (Download d : downloads) {
            d.setBooleanAttribute(this.od_manual_ta, true);
        }
        this.manageOD();
    }

    @Override
    public void removeManualDownloads(Download[] downloads) {
        for (Download d : downloads) {
            d.setBooleanAttribute(this.od_manual_ta, false);
        }
        this.manageOD();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isExplicitSearch() {
        DeviceManagerImpl deviceManagerImpl = this;
        synchronized (deviceManagerImpl) {
            return this.explicit_search > 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isClosing() {
        DeviceManagerImpl deviceManagerImpl = this;
        synchronized (deviceManagerImpl) {
            return this.closing;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadConfig() {
        if (!FileUtil.resilientConfigFileExists(CONFIG_FILE)) {
            return;
        }
        this.log("Loading configuration");
        DeviceManagerImpl deviceManagerImpl = this;
        synchronized (deviceManagerImpl) {
            Map map = FileUtil.readResilientConfigFile(CONFIG_FILE);
            List l_devices = (List)map.get("devices");
            if (l_devices != null) {
                for (int i = 0; i < l_devices.size(); ++i) {
                    Map m = (Map)l_devices.get(i);
                    try {
                        DeviceImpl device = DeviceImpl.importFromBEncodedMapStatic(this, m);
                        this.device_list.add(device);
                        this.device_map.put(device.getID(), device);
                        String secondary_id = device.getSecondaryID();
                        if (secondary_id != null) {
                            this.device_map.put(secondary_id, device);
                        }
                        device.initialise();
                        this.log("    loaded " + device.getString());
                        continue;
                    }
                    catch (Throwable e) {
                        this.log("Failed to import subscription from " + m, e);
                    }
                }
            }
        }
    }

    protected void configDirty(DeviceImpl device, boolean save_changes) {
        this.deviceChanged(device, save_changes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void configDirty() {
        DeviceManagerImpl deviceManagerImpl = this;
        synchronized (deviceManagerImpl) {
            if (this.config_dirty) {
                return;
            }
            this.config_dirty = true;
            new DelayedEvent("Subscriptions:save", 5000L, new AERunnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void runSupport() {
                    DeviceManagerImpl deviceManagerImpl = DeviceManagerImpl.this;
                    synchronized (deviceManagerImpl) {
                        if (!DeviceManagerImpl.this.config_dirty) {
                            return;
                        }
                        DeviceManagerImpl.this.saveConfig();
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveConfig() {
        this.log("Saving configuration");
        DeviceManagerImpl deviceManagerImpl = this;
        synchronized (deviceManagerImpl) {
            if (this.closing) {
                return;
            }
            this.config_dirty = false;
            this.config_unclean = false;
            if (this.device_list.size() == 0) {
                FileUtil.deleteResilientConfigFile(CONFIG_FILE);
            } else {
                HashMap map = new HashMap();
                ArrayList l_devices = new ArrayList();
                map.put("devices", l_devices);
                for (DeviceImpl device : this.device_list) {
                    try {
                        HashMap d = new HashMap();
                        device.exportToBEncodedMap(d, false);
                        l_devices.add(d);
                    }
                    catch (Throwable e) {
                        this.log("Failed to save device " + device.getString(), e);
                    }
                }
                FileUtil.writeResilientConfigFile(CONFIG_FILE, map);
            }
        }
    }

    protected void deviceAdded(DeviceImpl device) {
        this.configDirty();
        try {
            PlatformDevicesMessenger.qosFoundDevice(device);
        }
        catch (Throwable e) {
            Debug.out(e);
        }
        this.listeners.dispatch(1, device);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deviceChanged(DeviceImpl device, boolean save_changes) {
        if (save_changes) {
            this.configDirty();
        } else {
            DeviceManagerImpl deviceManagerImpl = this;
            synchronized (deviceManagerImpl) {
                this.config_unclean = true;
            }
        }
        if (!this.disable_events.contains(device)) {
            this.listeners.dispatch(2, device);
        }
    }

    protected void deviceRemoved(DeviceImpl device) {
        this.configDirty();
        this.listeners.dispatch(4, device);
    }

    protected void requestAttention(DeviceImpl device) {
        this.listeners.dispatch(3, device);
    }

    protected URL getStreamURL(TranscodeFileImpl file, String host) {
        IPCInterface ipc = this.upnp_manager.getUPnPAVIPC();
        if (ipc != null) {
            try {
                DiskManagerFileInfo f = file.getTargetFile();
                String str = (String)ipc.invoke("getContentURL", new Object[]{f});
                if (str != null && str.length() > 0) {
                    if (host != null) {
                        str = str.replace("127.0.0.1", host);
                    }
                    return new URL(str);
                }
            }
            catch (Throwable e) {
                // empty catch block
            }
        }
        return null;
    }

    protected String getMimeType(TranscodeFileImpl file) {
        if (this.getMimeType_fails > 5) {
            return null;
        }
        IPCInterface ipc = this.upnp_manager.getUPnPAVIPC();
        if (ipc != null) {
            try {
                DiskManagerFileInfo f = file.getTargetFile();
                String[] strs = (String[])ipc.invoke("getMimeTypes", new Object[]{f});
                if (strs != null && strs.length > 0) {
                    return strs[0];
                }
            }
            catch (Throwable e) {
                ++this.getMimeType_fails;
                e.printStackTrace();
            }
        }
        return null;
    }

    @Override
    public File getDefaultWorkingDirectory() {
        return this.getDefaultWorkingDirectory(false);
    }

    public File getDefaultWorkingDirectory(boolean persist) {
        File f;
        String def = COConfigurationManager.getStringParameter(CONFIG_DEFAULT_WORK_DIR, "").trim();
        if (def.length() == 0) {
            String def_dir = COConfigurationManager.getStringParameter("Default save path");
            def = def_dir + File.separator + TRANSCODE_DIR_DEFAULT;
        }
        if (!(f = new File(def)).exists()) {
            String parent;
            if (f.getName().equals(TRANSCODE_DIR_DEFAULT) && ((parent = f.getParentFile().getName()).equals("Azureus Downloads") || parent.equals("Vuze Downloads"))) {
                String def_dir = COConfigurationManager.getStringParameter("Default save path");
                f = new File(def_dir, TRANSCODE_DIR_DEFAULT);
            }
            if (persist) {
                f.mkdirs();
            }
        }
        return f;
    }

    @Override
    public void setDefaultWorkingDirectory(File dir) {
        File existing = this.getDefaultWorkingDirectory(false);
        if (!existing.getAbsolutePath().equals(dir.getAbsolutePath())) {
            DeviceImpl[] devices;
            for (DeviceImpl device : devices = this.getDevices()) {
                device.resetWorkingDirectory();
            }
        }
        COConfigurationManager.setParameter(CONFIG_DEFAULT_WORK_DIR, dir.getAbsolutePath());
    }

    @Override
    public boolean getDisableSleep() {
        return COConfigurationManager.getBooleanParameter(CONFIG_DISABLE_SLEEP, true);
    }

    @Override
    public void setDisableSleep(boolean b) {
        COConfigurationManager.setParameter(CONFIG_DISABLE_SLEEP, b);
    }

    @Override
    public TranscodeManagerImpl getTranscodeManager() {
        if (this.transcode_manager == null) {
            this.ensureInitialised(false);
        }
        return this.transcode_manager;
    }

    @Override
    public DeviceManager.UnassociatedDevice[] getUnassociatedDevices() {
        return this.upnp_manager.getUnassociatedDevices();
    }

    @Override
    public String getPowerName() {
        return "Transcode";
    }

    @Override
    public boolean requestPowerStateChange(int new_state, Object data) {
        return !this.getDisableSleep() || !this.getTranscodeManager().getQueue().isTranscoding();
    }

    @Override
    public void informPowerStateChange(int new_state, Object data) {
    }

    @Override
    public void addListener(DeviceManagerListener listener) {
        this.listeners.addListener(listener);
        if (this.initialized) {
            this.listeners.dispatch(listener, 5, null);
        }
    }

    protected boolean browseReceived(TrackerWebPageRequest request2, Map<String, Object> browser_args) {
        for (DeviceManagerDiscoveryListener l : this.discovery_listeners) {
            try {
                if (!l.browseReceived(request2, browser_args)) continue;
                return true;
            }
            catch (Throwable e) {
                Debug.out(e);
            }
        }
        return false;
    }

    protected VuzeFile exportVuzeFile(DeviceImpl device) throws IOException {
        VuzeFile vf = VuzeFileHandler.getSingleton().create();
        HashMap map = new HashMap();
        HashMap device_map = new HashMap();
        map.put("device", device_map);
        device.exportToBEncodedMap(device_map, true);
        vf.addComponent(512, map);
        return vf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void importVuzeFile(Map map, boolean warn_user) {
        Map m = (Map)map.get("device");
        try {
            UIManager ui_manager;
            DeviceImpl existing;
            DeviceImpl device = DeviceImpl.importFromBEncodedMapStatic(this, m);
            DeviceManagerImpl deviceManagerImpl = this;
            synchronized (deviceManagerImpl) {
                existing = this.device_map.get(device.getID());
            }
            if (existing == null) {
                if (warn_user) {
                    ui_manager = StaticUtilities.getUIManager(120000L);
                    String details = MessageText.getString("device.import.desc", new String[]{device.getName()});
                    long res = ui_manager.showMessageBox("device.import.title", "!" + details + "!", 12L);
                    if (res != 4L) {
                        return;
                    }
                }
                this.addDevice(device, false);
            } else if (warn_user) {
                ui_manager = StaticUtilities.getUIManager(120000L);
                String details = MessageText.getString("device.import.dup.desc", new String[]{existing.getName()});
                ui_manager.showMessageBox("device.import.dup.title", "!" + details + "!", 1L);
            }
        }
        catch (Throwable e) {
            Debug.out(e);
        }
    }

    @Override
    public void addDiscoveryListener(DeviceManagerDiscoveryListener listener) {
        this.discovery_listeners.add(listener);
    }

    @Override
    public void removeDiscoveryListener(DeviceManagerDiscoveryListener listener) {
        this.discovery_listeners.remove(listener);
    }

    @Override
    public void removeListener(DeviceManagerListener listener) {
        this.listeners.removeListener(listener);
    }

    @Override
    public Device findDevice(UPnPDevice upnpDevice) {
        DeviceImpl[] devices;
        for (DeviceImpl device : devices = this.getDevices()) {
            DeviceUPnPImpl deviceUPnP;
            UPnPDevice uPnPDevice2;
            if (!(device instanceof DeviceUPnPImpl) || !upnpDevice.equals(uPnPDevice2 = (deviceUPnP = (DeviceUPnPImpl)device).getUPnPDevice())) continue;
            return device;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AEDiagnosticsLogger getLogger() {
        Object object = this.logger_lock;
        synchronized (object) {
            if (this.logger == null) {
                this.logger = AEDiagnostics.getLogger(LOGGER_NAME);
            }
            return this.logger;
        }
    }

    public void log(String s, Throwable e) {
        AEDiagnosticsLogger diag_logger = this.getLogger();
        diag_logger.log(s);
        diag_logger.log(e);
    }

    public void log(String s) {
        AEDiagnosticsLogger diag_logger = this.getLogger();
        diag_logger.log(s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void generate(IndentWriter writer) {
        writer.println(LOGGER_NAME);
        try {
            DeviceImpl[] devices;
            writer.indent();
            for (DeviceImpl device : devices = this.getDevices()) {
                device.generate(writer);
            }
            if (this.transcode_manager != null) {
                this.transcode_manager.generate(writer);
            }
        }
        finally {
            writer.exdent();
        }
    }

    protected static class DeviceManufacturerImpl
    implements DeviceManager.DeviceManufacturer {
        private String name;
        private List<DeviceTemplate> templates = new ArrayList<DeviceTemplate>();

        protected DeviceManufacturerImpl(String _name) {
            this.name = _name;
        }

        protected void addTemplate(DeviceTemplate t) {
            this.templates.add(t);
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public DeviceTemplate[] getDeviceTemplates() {
            return this.templates.toArray(new DeviceTemplate[this.templates.size()]);
        }
    }
}

