/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.devices.impl;

import com.aelitis.azureus.core.devices.DeviceContentDirectory;
import com.aelitis.azureus.core.devices.impl.DeviceImpl;
import com.aelitis.azureus.core.devices.impl.DeviceManagerImpl;
import com.aelitis.azureus.core.devices.impl.DeviceUPnPImpl;
import com.aelitis.net.upnp.UPnPDevice;
import com.aelitis.net.upnp.UPnPService;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.util.Debug;

public class DeviceContentDirectoryImpl
extends DeviceUPnPImpl
implements DeviceContentDirectory {
    private UPnPService upnp_service;

    protected DeviceContentDirectoryImpl(DeviceManagerImpl _manager, UPnPDevice _device, UPnPService _service) {
        super(_manager, _device, 2);
        this.upnp_service = _service;
    }

    protected DeviceContentDirectoryImpl(DeviceManagerImpl _manager, Map _map) throws IOException {
        super(_manager, _map);
    }

    @Override
    protected boolean updateFrom(DeviceImpl _other, boolean _is_alive) {
        if (!super.updateFrom(_other, _is_alive)) {
            return false;
        }
        if (!(_other instanceof DeviceContentDirectoryImpl)) {
            Debug.out("Inconsistent");
            return false;
        }
        DeviceContentDirectoryImpl other = (DeviceContentDirectoryImpl)_other;
        if (other.upnp_service != null) {
            this.upnp_service = other.upnp_service;
        }
        return true;
    }

    @Override
    public List<URL> getControlURLs() {
        if (this.upnp_service != null) {
            try {
                return this.upnp_service.getControlURLs();
            }
            catch (Throwable e) {
                Debug.out(e);
            }
        }
        return null;
    }

    @Override
    public void setPreferredControlURL(URL url) {
        if (this.upnp_service != null) {
            this.upnp_service.setPreferredControlURL(url);
        }
    }
}

