/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.activities;

import com.aelitis.azureus.activities.VuzeActivitiesEntry;
import com.aelitis.azureus.activities.VuzeActivitiesListener;
import com.aelitis.azureus.activities.VuzeActivitiesLoadedListener;
import com.aelitis.azureus.activities.VuzeActivitiesManager;
import com.aelitis.azureus.core.util.AZ3Functions;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.ui.swt.UserAlerts;

public class LocalActivityManager {
    private static List<VuzeActivitiesEntry> pending = new ArrayList<VuzeActivitiesEntry>(1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addLocalActivity(String uid, String icon_id, String name, String[] actions, Class<? extends AZ3Functions.provider.LocalActivityCallback> callback, Map<String, String> callback_data) {
        VuzeActivitiesEntry entry = new VuzeActivitiesEntry(SystemTime.getCurrentTime(), name, "LOCAL_NEWS_ITEM");
        entry.setID(uid);
        entry.setIconIDRaw(icon_id);
        entry.setActions(actions);
        entry.setCallback(callback, callback_data);
        Class<LocalActivityManager> clazz = LocalActivityManager.class;
        synchronized (LocalActivityManager.class) {
            if (pending != null) {
                pending.add(entry);
            } else {
                VuzeActivitiesManager.addEntries(new VuzeActivitiesEntry[]{entry});
            }
            // ** MonitorExit[var7_7] (shouldn't be in output)
            return;
        }
    }

    static {
        VuzeActivitiesManager.addListener(new VuzeActivitiesLoadedListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void vuzeActivitiesLoaded() {
                Class<LocalActivityManager> clazz = LocalActivityManager.class;
                synchronized (LocalActivityManager.class) {
                    for (VuzeActivitiesEntry entry : pending) {
                        VuzeActivitiesManager.addEntries(new VuzeActivitiesEntry[]{entry});
                    }
                    pending = null;
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
            }
        });
        VuzeActivitiesManager.addListener(new VuzeActivitiesListener(){

            @Override
            public void vuzeNewsEntryChanged(VuzeActivitiesEntry entry) {
            }

            @Override
            public void vuzeNewsEntriesRemoved(VuzeActivitiesEntry[] entries) {
            }

            @Override
            public void vuzeNewsEntriesAdded(VuzeActivitiesEntry[] entries) {
                UserAlerts ua;
                boolean local_added = false;
                for (VuzeActivitiesEntry entry : entries) {
                    if (!entry.getTypeID().equals("LOCAL_NEWS_ITEM")) continue;
                    local_added = true;
                }
                if (local_added && (ua = UserAlerts.getSingleton()) != null) {
                    ua.notificationAdded();
                }
            }
        });
    }

    public static interface LocalActivityCallback
    extends AZ3Functions.provider.LocalActivityCallback {
    }
}

