/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.dex2jar.ir.expr;

import com.googlecode.dex2jar.ir.LabelAndLocalMapper;
import com.googlecode.dex2jar.ir.Util;
import com.googlecode.dex2jar.ir.expr.Value;

public class InvokeExpr
extends Value.EnExpr {
    public String[] args;
    public String name;
    public String owner;
    public String ret;

    @Override
    protected void releaseMemory() {
        this.args = null;
        this.ret = null;
        this.owner = null;
        this.name = null;
        super.releaseMemory();
    }

    public InvokeExpr(Value.VT type, Value[] args, String ownerType, String methodName, String[] argmentTypes, String returnType) {
        super(type, args);
        this.ret = returnType;
        this.name = methodName;
        this.owner = ownerType;
        this.args = argmentTypes;
    }

    @Override
    public Value clone() {
        return new InvokeExpr(this.vt, this.cloneOps(), this.owner, this.name, this.args, this.ret);
    }

    @Override
    public Value clone(LabelAndLocalMapper mapper) {
        return new InvokeExpr(this.vt, this.cloneOps(mapper), this.owner, this.name, this.args, this.ret);
    }

    @Override
    public String toString0() {
        int i;
        StringBuilder sb = new StringBuilder();
        if (this.vt == Value.VT.INVOKE_NEW) {
            sb.append("new ").append(Util.toShortClassName(this.owner)).append('(');
        } else {
            sb.append(this.vt == Value.VT.INVOKE_STATIC ? Util.toShortClassName(this.owner) : this.ops[0]).append('.').append(this.name).append('(');
        }
        boolean first = true;
        int n = i = this.vt == Value.VT.INVOKE_STATIC || this.vt == Value.VT.INVOKE_NEW ? 0 : 1;
        while (i < this.ops.length) {
            if (first) {
                first = false;
            } else {
                sb.append(',');
            }
            sb.append(this.ops[i]);
            ++i;
        }
        sb.append(')');
        return sb.toString();
    }
}

