require "lootFilter/global"

--[[
If you edit this script while the game is running, tap V twice to reload it.
Tapping V once will disable loot filters.
Loot filter script is active by default.

You can find out more about LUA here
https://www.tutorialspoint.com/lua/
HOW TO ADD YOUR OWN FILTER? 
https://www.tutorialspoint.com/lua/lua_functions.htm
You need to create a function.
If an item is supposed to be hidden, the function has to return "true".
"false" will cause the item to be visible.
Example of a function:

function hideWhiteEquipment(data)
    if data.textColor == COLOR_WHITE and isEquipment(data) == true then
		return true
	else
		return false
	end
end

We are checking if text color is white and if it's something we can equip 
I've created the function isEquipment above,
feel free to create your own helping functions when you learn more about LUA
and share your loot filters on the "loot-filter-scripts" channel on Discord!


So you got a function. Now how to make it work?
You have to add it to filterList array in myLootFilter function (bottom of the file)

As you can see, the main loot filter function has the following parameters:
lootFilter(displayedName,textColor,itemType)
so if you pass "data" to it in myLootFilter function, you can access these variables by writing
data.displayedName / data.textColor / data.itemType
You can check the values they can take in lootFilter/global.lua

Different functions in filterList should be separated by a comma.
We should pass data to the function.
So the thing we should add to the filterList to make our new function work would be
hideWhiteEquipment(data)

Be careful about hiding more items that you want.
For example, if you wanted to hide all white items but wanted to see the scrolls, you'd have to check if the color is white and return "false" if the item is a scroll.
Hiding ALL white items would be a bad idea, as you'd never see gold/scrolls/books etc. 
That's why I'm checking if the item can be equipped - that way I don't have to worry about books/scrolls/potions...

I've created three loot filters that are disabled by default.
To enable them, uncomment the two lines in myLootFilter (comment = --)
You can also force the filter to always show certain items by name - to do so, just add their names to exception array below. (Names lowercase, separated by comma)
#important!!!
Global.lua is loaded when tchernobog starts so if you want to add your own stuff, best to do it in lootFilter.lua (here)
    --]]
---------------ADD YOUR OWN LOOT FILTERS BELOW THIS LINE-----------------------------

--WHEN SHARING THEM ON DISCORD, DON'T SHARE THE WHOLE FILE (NO NEED), JUST YOUR LOOT FUNCTION AND filterList

function myLootFilter(data)
---------------add your functions to the array here!---------------
--list with exception of items
	local exception = {"tower shield", "horned helm", "havoc harness"}
--list with filters
	local filterList = {
	--hideGoldBelow(data,2500),       -- hides gold piles with less than X pieces
	--hideEquipment(data,COLOR_WHITE),-- hides white items
	--hideEquipment(data,COLOR_BLUE)  -- hides magic items
	}
--list with renaming functions
	renameList = {
	--renamePotionToDrink(data)
	}
--list with recoloring functions
	recolorList = {
	--recolorPotionsToGold(data)      
	}
---------------end of functions array, don't touch the rest!---------------
	return handleEverything(data,filterList,exception,renameList,recolorList)
end