------------------------DONT TOUCH---------------------
TRUE = 1
FALSE = 0

--possible data.textColor values
COLOR_WHITE = 0 
COLOR_RED = 2
COLOR_BLUE = 3
COLOR_GOLD = 4
COLOR_GREY = 5
COLOR_YELLOW = 6
COLOR_ORANGE = 7
COLOR_GREEN = 8

--possible data.itemType values
ITEM_MISC = 0   --quest items
ITEM_POTION = 1 -- potions and elixirs
ITEM_SCROLL = 2 -- scrolls
ITEM_BOOK = 3	-- books
ITEM_GOLD = 4   -- gold
ITEM_FING = 5   -- rings etc.
ITEM_NECK = 6   -- amulets etc.
ITEM_HEAD = 7   -- helmets
ITEM_BODY = 8   -- armors
ITEM_SHIELD = 9 -- shields
ITEM_WP_1H = 10  -- one-handed weapons
ITEM_WP_2H = 11  -- two-handed weapons
ITEM_WAIST = 12 -- belts
ITEM_WP_OFFHAND = 13  -- offhand weapons
ITEM_CRAFTINGMAT = 14  -- crafting materials
ITEM_RECIPE = 15  -- recipes

CLASS_WARRIOR = 0
CLASS_ROGUE = 1
CLASS_SORCERER = 2
CLASS_BARBARIAN = 3
CLASS_NECROMANCER = 4
CLASS_ASSASSIN = 5

function printMsg(data)
     if type(data) == "string" then
	     printMessage(data)
	else
	    --printMessage("wrong data for printMsg function - input wasn't a string!")
		printMessage(tostring(data))
	end
end

function printDebug(data,v)
	file = io.open("debug.txt", "a")
	file:write("NAME: "..data.displayedName.." COLOR: "..data.textColor.." ITEMTYPE: "..data.itemType.." -> "..v, "\n")
end

function printDebugRaw(v)
	file = io.open("debug.txt", "a")
	file:write(v, "\n")
end

function lootFilter(displayedName,textColor,itemType,isIdentified,playerClass,playerLevel)
	local isGood,v1,v2,v3 = pcall(myLootFilter,{displayedName=displayedName:lower(),textColor=textColor,itemType=itemType,isIdentified=isIdentified,playerClass=playerClass,playerLevel=playerLevel})
    if isGood == true then
		if v1 ~= nil and v2 ~= nil and v3 ~= nil then
		    if type(v1) == "string" and type(v2) == "number" and type(v3) == "number" then
				if v2 >= 0 and v2 <= 8 then
				    return v1,v2,v3
				else
					printMsg("Color must be between 0 and 8.")
				end
			else
				--printMsg(type(v1).." "..type(v2).." "..type(v3))
				printMsg("Your loot filter returned bad values! It should return <new displayed name>,<new color><show or not>")	
			end
		else
		    printMsg("One or more of the values returned by your lootFilter were empty!!!")	
		end
	else
		printMsg(ret)
		return -1
	end
	return TRUE
end

function isGold(data)
	return data.itemType == ITEM_GOLD
end

function isEquipment(data)
	return data.itemType >= ITEM_FING and data.itemType <= ITEM_WP_OFFHAND
end

function hideEquipment(data,color)
    return data.textColor == color and isEquipment(data) == true
end

function hideGoldBelow(data,howmuch)
	if isGold(data) == true then
		howMuchGold = tonumber(string.match(string.match(data.displayedName,"%d+ gold pieces"),"%d+"))
		if howMuchGold >= howmuch then
			return false
		else
			return true
		end
	end
	return false
end

function renamePotionToDrink(data)
	out = data.displayedName:gsub("potion","drink")
	return out
end

function recolorPotionsToGold(data)
	if data.itemType == ITEM_POTION then
		return COLOR_GOLD
	else
		return data.textColor
	end
end

	


function isException(arr, val)
    for i=1, #arr do
        if arr[i] == val then
            return TRUE
        end
    end
    return FALSE
end

function filter(arr)
	for i=1, #arr do
		if arr[i] == true then
			return FALSE
		end
	end
	return TRUE
end

function getNew(val,arr)
    for i=1, #arr do
        if arr[i] ~= val then
            return arr[i]
        end
    end
    return val
end

function handleEverything(data,filterList,exception,renames,recolors)
	local newName = getNew(data.displayedName,renames)
	local newColor = getNew(data.textColor,recolors)
	if data.itemType == -1 then
		return data.displayedName,data.textColor,TRUE
	end
	if isException(exception,data.displayedName) == TRUE then
		return newName,newColor,TRUE
	end
	return newName,newColor,filter(filterList)
end