<?xml version="1.0" encoding="ISO-8859-1"?>
<!DOCTYPE xsl:stylesheet [ 
    <!ENTITY nbsp "&#160;">   <!-- white space in XSL -->
    <!ENTITY raquo "&#187;">   <!-- >> -->
    ]> 
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="xml" omit-xml-declaration="yes" indent="yes"
    doctype-system="http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd"
    doctype-public="-//W3C//DTD XHTML 1.0 Transitional//EN" />

<xsl:param name="ThumbnailPageStartItem" select="'default'"/>

<xsl:template match="/">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
<xsl:if test="/Doc/TitleBarText[string(.)]">
	<title><xsl:value-of select="Doc/TitleBarText"/></title>
</xsl:if>
<link href="{/Doc/ThumbnailPages/Page[$ThumbnailPageStartItem]/ThumbnailPagePathPrefix}css/stylesheet.css" rel="stylesheet" type="text/css" />
</head>
<body>
<table width="100%"  border="0" cellspacing="0" cellpadding="0">
  <tr>
    <td align="center" valign="middle">
    	<table width="760" border="0" cellspacing="0" cellpadding="0">
        <tr>
          <td align="center" valign="middle">
          	<div id="wrapper">
              <xsl:if test="/Doc/IncludeHeader = 1">
						  <xsl:if test="/Doc/Header/UseImage = 1">
						  	<div id="logohead"><img src="{/Doc/ThumbnailPages/Page[$ThumbnailPageStartItem]/ThumbnailPagePathPrefix}{/Doc/Header/ImagePath}"/></div>
						  </xsl:if>
						  </xsl:if>
              <xsl:if test="/Doc/TitleBarText[string(.)]">
              <div id="pagehead">
              	<h1><xsl:value-of select="Doc/TitleBarText"/></h1>
							</div>
							</xsl:if>
		          		          
		          <xsl:if test="/Doc/IncludeHeader = 1">
		          <xsl:if test="/Doc/Header/UseInfo = 1">
						  	<div id="subhead">
						  		<xsl:if test="/Doc/Header/Text[string(.)] or /Doc/Header/Author[string(.)] or /Doc/Header/Date[string(.)]">
						    		<div class="left">
						    			<xsl:if test="/Doc/Header/Text[string(.)]">
						    				<xsl:value-of select="Doc/Header/Text"/>
						    				<xsl:if test="/Doc/Header/Author[string(.)] or /Doc/Header/Date[string(.)]">
						    				&nbsp;|&nbsp;
						    				</xsl:if>
						    			</xsl:if>
						    			<xsl:if test="/Doc/Header/Author[string(.)]">
						    				<xsl:value-of select="Doc/Header/Author"/>
						    				<xsl:if test="/Doc/Header/Date[string(.)]">
						    				&nbsp;|&nbsp;
						    				</xsl:if>
						    			</xsl:if>
						    			<xsl:if test="/Doc/Header/Date[string(.)]">
						    				<xsl:value-of select="Doc/Header/Date"/>
						    			</xsl:if>
						    		</div>
						    	</xsl:if>
						    	<xsl:if test="/Doc/Header/Email[string(.)]">
						    		<div class="right"><a href="mailto:{/Doc/Header/Email}"><xsl:value-of select="Doc/Header/Email"/></a></div>
						    	</xsl:if>
						    	<div class="clearer">&nbsp;</div>
						  	</div>
						  </xsl:if>
						  </xsl:if>
              
              <div id="mainbox">
	              <table width="100%">
									<caption>Thumbnail Image Table</caption>
									<tr align="center" valign="top">
	                	<td class="thumbtable">
	                		<table  border="0" cellspacing="0" cellpadding="0">
	                    	<xsl:for-each select="Doc/ThumbnailPages/Page[$ThumbnailPageStartItem]/Row">
	                    	<tr>
	                    		<xsl:for-each select="Column">
	                      	<td align="center" valign="middle">
	                      	<div class="thumbcontainer">
	                      		<a href="{/Doc/ThumbnailPages/Page[$ThumbnailPageStartItem]/ThumbnailPagePathPrefix}{ImagePagePath}"><img src="{/Doc/ThumbnailPages/Page[$ThumbnailPageStartItem]/ThumbnailPagePathPrefix}{ThumbnailPath}" border="0" width="{ThumbnailWidth}" height="{ThumbnailHeight}"/></a>
	                        	<xsl:if test="ThumbnailTags[node()]">
	                        	<div class="thumbmeta">
	                        		<xsl:if test="ThumbnailTags/FileName/Value[string(.)]">
											  		  	<strong><xsl:value-of select="ThumbnailTags/FileName/Value"/></strong><br/>
											  		  </xsl:if>
											  		  <xsl:if test="ThumbnailTags/Date/Value[string(.)]">
											  		  	Date:&nbsp;<xsl:value-of select="ThumbnailTags/Date/Value"/><br/>
															</xsl:if>
	    												<xsl:if test="ThumbnailTags/Rating">
											        	<xsl:if test="ThumbnailTags/Rating/Value = 0">
											        		<img src="{/Doc/ThumbnailPages/Page[$ThumbnailPageStartItem]/ThumbnailPagePathPrefix}resources/graf_star_zero.gif"/>
											        	</xsl:if>
											        	<xsl:if test="ThumbnailTags/Rating/Value = 1">
											        		<img src="{/Doc/ThumbnailPages/Page[$ThumbnailPageStartItem]/ThumbnailPagePathPrefix}resources/graf_star_one.gif"/>
											        	</xsl:if>
											        	<xsl:if test="ThumbnailTags/Rating/Value = 2">
											        		<img src="{/Doc/ThumbnailPages/Page[$ThumbnailPageStartItem]/ThumbnailPagePathPrefix}resources/graf_star_two.gif"/>
											        	</xsl:if>
											        	<xsl:if test="ThumbnailTags/Rating/Value = 3">
											        		<img src="{/Doc/ThumbnailPages/Page[$ThumbnailPageStartItem]/ThumbnailPagePathPrefix}resources/graf_star_three.gif"/>
											        	</xsl:if>
											        	<xsl:if test="ThumbnailTags/Rating/Value = 4">
											        		<img src="{/Doc/ThumbnailPages/Page[$ThumbnailPageStartItem]/ThumbnailPagePathPrefix}resources/graf_star_four.gif"/>
											        	</xsl:if>
											        	<xsl:if test="ThumbnailTags/Rating/Value = 5">
											        		<img src="{/Doc/ThumbnailPages/Page[$ThumbnailPageStartItem]/ThumbnailPagePathPrefix}resources/graf_star_five.gif"/>
											        	</xsl:if>
										        		<br/>
											        </xsl:if>
											  		  <xsl:for-each select="ThumbnailTags/Tag">
										        		<xsl:value-of select="Name"/>:&nbsp;<xsl:value-of select="Value"/><br/>
										        	</xsl:for-each>
	                          </div>
	                        	</xsl:if>
	                        </div>
	                        </td>
	                        </xsl:for-each>
	                      </tr>
	                    	</xsl:for-each>
	                    </table>
	                  </td>
	                </tr>
	              </table>
            	</div>
			  
							<div class="paginate"> <xsl:value-of select="/Doc/Translations/Pages"/>:&nbsp;&nbsp;&nbsp;&nbsp; 
						  <xsl:for-each select="Doc/ThumbnailPages/Page">
						  	<xsl:if test="CurrentThumbnailPageNumber = $ThumbnailPageStartItem">
						  		<span class="this-page"><xsl:value-of select="CurrentThumbnailPageNumber"/></span>
						  	</xsl:if>
						  	<xsl:if test="CurrentThumbnailPageNumber != $ThumbnailPageStartItem">
						  		<a href="{/Doc/ThumbnailPages/Page[$ThumbnailPageStartItem]/ThumbnailPagePathPrefix}{ThumbnailPagePath}"><xsl:value-of select="CurrentThumbnailPageNumber"/></a>
						  	</xsl:if>
						  </xsl:for-each>
						  </div>
          		
          		<xsl:if test="/Doc/IncludeFooter = 1">
		          <xsl:if test="/Doc/Footer/UseInfo = 1">
						  	<div id="subfoot">
						  		<xsl:if test="/Doc/Footer/Text[string(.)] or /Doc/Footer/Author[string(.)] or /Doc/Footer/Date[string(.)]">
						    		<div class="left">
						    			<xsl:if test="/Doc/Footer/Text[string(.)]">
						    				<xsl:value-of select="Doc/Footer/Text"/>
						    				<xsl:if test="/Doc/Footer/Author[string(.)] or /Doc/Footer/Date[string(.)]">
						    				&nbsp;|&nbsp;
						    				</xsl:if>
						    			</xsl:if>
						    			<xsl:if test="/Doc/Footer/Author[string(.)]">
						    				<xsl:value-of select="Doc/Footer/Author"/>
						    				<xsl:if test="/Doc/Footer/Date[string(.)]">
						    				&nbsp;|&nbsp;
						    				</xsl:if>
						    			</xsl:if>
						    			<xsl:if test="/Doc/Footer/Date[string(.)]">
						    				<xsl:value-of select="Doc/Footer/Date"/>
						    			</xsl:if>
						    		</div>
						    	</xsl:if>
						    	<xsl:if test="/Doc/Footer/Email[string(.)]">
						    		<div class="right"><a href="mailto:{/Doc/Footer/Email}"><xsl:value-of select="Doc/Footer/Email"/></a></div>
						    	</xsl:if>
						    	<div class="clearer">&nbsp;</div>
						  	</div>
						  </xsl:if>
						  			        
			        <xsl:if test="/Doc/Footer/UseImage = 1">
						  	<div id="logofoot"><img src="{/Doc/ThumbnailPages/Page[$ThumbnailPageStartItem]/ThumbnailPagePathPrefix}{/Doc/Footer/ImagePath}"/></div>
						  </xsl:if>
						  </xsl:if>
              
		  			</div>
		  		</td>
        </tr>
      </table>
		</td>
  </tr>
</table>
</body>
</html>

</xsl:template>
</xsl:stylesheet>