<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="text" encoding="iso-8859-1"/>
<xsl:template match="/">

/* CSS
--------------------------------------------------*/
body {
	background: #<xsl:value-of select="Doc/Colors/BackgroundColor/ColorValue"/>;
	color: #000000;
	font-family: Verdana, Helvetica, sans-serif;
	font-size: 10pt;
	margin: 0;
	padding: 0;
}

body,h1,h2,h3,h4,h5,h6,p,form,fieldset {
	margin: 0;
	padding: 0;
	font-family: Verdana, Helvetica, sans-serif;
}

/* Links
--------------------------------------------------*/
a {
	text-decoration: underline;
	color: #000000;
}

a:hover {
	text-decoration: none;
	color: #000000;
}

a img {
	border: none;
}

/* IDs
--------------------------------------------------*/
#wrapper {
	background: transparent;
	padding: 0;
	margin: 0 auto;
	text-align: center;
}

#logohead {
	background: #<xsl:value-of select="Doc/Colors/InnerPageColor/ColorValue"/>;
	text-align: left;
	padding: 10px;
}

#logofoot {
	background: #<xsl:value-of select="Doc/Colors/InnerPageColor/ColorValue"/>;
	text-align: left;
	padding: 10px;
}

#pagehead {
	background: #<xsl:value-of select="Doc/Colors/TitleBackground/ColorValue"/>;
	color: #<xsl:value-of select="Doc/Fonts/TitleFont/ColorValue"/>;
	padding: 10px 7px 10px 7px;
	border: 7px solid #<xsl:value-of select="Doc/Colors/InnerPageColor/ColorValue"/>;
	text-align: left;
}

#pagehead p {
	line-height: 13pt;
}

#subhead {
	background: #<xsl:value-of select="Doc/Colors/HeaderColor/ColorValue"/>;
	color: #<xsl:value-of select="Doc/Fonts/HeaderFont/ColorValue"/>;
	font-size: <xsl:value-of select="Doc/Fonts/HeaderFont/Size"/>pt;
	font-family: &quot;<xsl:value-of select="Doc/Fonts/HeaderFont/Family"/>&quot;, Times, serif;
	padding: 7px;
	border: 7px solid #<xsl:value-of select="Doc/Colors/InnerPageColor/ColorValue"/>;
	text-align: left;
	margin: 7px 0;
}

#subhead a {
	color: #<xsl:value-of select="Doc/Fonts/HeaderFont/ColorValue"/>;
	text-decoration: none;
}

#subhead a:hover {
	color: #<xsl:value-of select="Doc/Fonts/HeaderFont/ColorValue"/>;
	text-decoration: underline;
}

#subfoot {
	background: #<xsl:value-of select="Doc/Colors/FooterColor/ColorValue"/>;
	color: #<xsl:value-of select="Doc/Fonts/FooterFont/ColorValue"/>;
	font-size: <xsl:value-of select="Doc/Fonts/FooterFont/Size"/>pt;
	font-family: &quot;<xsl:value-of select="Doc/Fonts/FooterFont/Family"/>&quot;, Times, serif;
	padding: 7px;
	border: 7px solid #<xsl:value-of select="Doc/Colors/InnerPageColor/ColorValue"/>;
	text-align: left;
	margin: 7px 0;
}

#subfoot a {
	color: #<xsl:value-of select="Doc/Fonts/FooterFont/ColorValue"/>;
	text-decoration: none;
}

#subfoot a:hover {
	color: #<xsl:value-of select="Doc/Fonts/FooterFont/ColorValue"/>;
	text-decoration: underline;
}

#mainbox {
	background: #<xsl:value-of select="Doc/Colors/InnerPageColor/ColorValue"/>;
	color: #000000;
	padding: 7px;
	border: 7px solid #<xsl:value-of select="Doc/Colors/InnerPageColor/ColorValue"/>;
	margin: 7px 0;
}

#pagefoot {
	background: transparent;
	color: #000000;
	margin-top: -20px;
	margin-bottom: 10px;
	font-size: 9pt;
}

#pagefoot strong, #pagehead strong {
	font-size: 11pt;
}

#mainimage {
	margin: 0;
	padding: 0;
	text-align: center;
}

#mainimage img {
	margin-bottom: 10px;
	background: #<xsl:value-of select="Doc/Colors/InnerPageColor/ColorValue"/>;
	padding: 0;
}

#altmainimage {
	padding: 10px 0 10px 0;
	margin: 0 0 10px 0;
	width: 740px;
	overflow: auto;
	text-align: center;
}

/* Classes
--------------------------------------------------*/
.low {
	display: none;
}

.smalltext {
	font-size: 8pt;
}

.clearer {
	clear: both;
	line-height: 0;
}

.left {
	float: left;
	clear: right;
	background: transparent;
}

.right {
	float: right;
	background: transparent;
}

.center {
	text-align: center;
	margin: 0 auto;
}

.sep {
	line-height: 0px;
	height: 1px;
	border: none;
	background: #a2c0df;
	color: #a2c0df;
	margin: 0;
	padding: 0;
}

.seppad {
	line-height: 0px;
	height: 1px;
	border: none;
	background: #a2c0df;
	color: #a2c0df;
	margin: 10px 0 10px 0;
	padding: 0;
}

.metatitle {
	margin-bottom: 10px;
}

.metatitle1 {
	font-size: <xsl:value-of select="Doc/Fonts/FilenameFont/Size"/>pt;
	font-weight: bold;
	margin: 0;
	padding: 0;
	font-family: &quot;<xsl:value-of select="Doc/Fonts/FilenameFont/Family"/>&quot;, Helvetica, sans-serif;
	color: #<xsl:value-of select="Doc/Fonts/FilenameFont/ColorValue"/>;
	float: left;
	margin-right: 8px;
}

.metatitle1 a {
	text-decoration: none;
}

.metatitle1 a:hover {
	color: #7ba9c4;
}

.metatitle2 {
	color: #<xsl:value-of select="Doc/Fonts/DateFont/ColorValue"/>;
	font-family: &quot;<xsl:value-of select="Doc/Fonts/DateFont/Family"/>&quot;, Helvetica, sans-serif;	
	font-size: <xsl:value-of select="Doc/Fonts/DateFont/Size"/>pt;
	font-style: italic;
	margin-left: 2px;
	margin-top: 0.5em;
	float: left;
}

.metatitle3 {
	float: right;
}

.metatitle4 {
	float: left;
}

.metaitem {
	margin-bottom: 4px;
}

.thumbcontainer {                                         
	padding: 5px;                                           
	height: auto;                                           
	display: table-cell;                                    
}                                                         

.thumbmeta {
	background: #<xsl:value-of select="Doc/Colors/ThumbnailColor/ColorValue"/>;
	color: #<xsl:value-of select="Doc/Fonts/ThumbnailFont/ColorValue"/>;
	font-family: &quot;<xsl:value-of select="Doc/Fonts/ThumbnailFont/Family"/>&quot;, Helvetica, sans-serif;	
	font-size: <xsl:value-of select="Doc/Fonts/ThumbnailFont/Size"/>pt;
	margin-top: 5px;
	text-align: left;
	line-height: 12pt;
	padding-left: 10px;
}

.metabox {
	background: #<xsl:value-of select="Doc/Colors/ImageColor/ColorValue"/>;
	color: #<xsl:value-of select="Doc/Fonts/ImageFont/ColorValue"/>;
	font-family: &quot;<xsl:value-of select="Doc/Fonts/ImageFont/Family"/>&quot;, Helvetica, sans-serif;	
	font-size: <xsl:value-of select="Doc/Fonts/ImageFont/Size"/>pt;
	padding: 7px;
	text-align: left;
	line-height: 12pt;
	margin: 0 auto;
	height: 1px;
}

html > body .metabox {
	height: auto;
}

.paginate {
	color: #<xsl:value-of select="Doc/Fonts/PaginationFont/ColorValue"/>;
	font-family: &quot;<xsl:value-of select="Doc/Fonts/PaginationFont/Family"/>&quot;, Helvetica, sans-serif;
	font-size: <xsl:value-of select="Doc/Fonts/PaginationFont/Size"/>pt;
  padding: 11px 7px 11px 7px;
	margin: 0px;
	text-align: center;
	background: #<xsl:value-of select="Doc/Colors/PaginateBackgroundColor/ColorValue"/>;
	border: 7px solid #<xsl:value-of select="Doc/Colors/InnerPageColor/ColorValue"/>;
}

.paginate a {
	padding: 2px 6px;
	border: solid 1px #<xsl:value-of select="Doc/Colors/PaginateBorderColor/ColorValue"/>;
	background: #<xsl:value-of select="Doc/Colors/InnerPageColor/ColorValue"/>;
	color: #<xsl:value-of select="Doc/Colors/PaginateOtherPageTextColor/ColorValue"/>;
	text-decoration: none;
}

.paginate .this-page {
	padding: 2px 6px;
	border-color: #999999;
	font-weight: bold;
	font-size: <xsl:value-of select="Doc/Fonts/PaginationFont/Size"/>pt;
	color: #<xsl:value-of select="Doc/Fonts/PaginationFont/ColorValue"/>;
	vertical-align: top;
	background: transparent;
}

.paginate a:hover {
	color: #<xsl:value-of select="Doc/Colors/PaginateHoverTextColor/ColorValue"/>;
	background: #<xsl:value-of select="Doc/Colors/PaginateHoverBackgroundColor/ColorValue"/>;
	border-color: #<xsl:value-of select="Doc/Colors/PaginateHoverBorderColor/ColorValue"/>;
	text-decoration: none;
}

.imagenav .left, .imagenav .right {
	padding: 6px 0;
}

.imagenav {
	color: #<xsl:value-of select="Doc/Fonts/NavigationFont/ColorValue"/>;
	margin-bottom: 10px;
	font-size: <xsl:value-of select="Doc/Fonts/NavigationFont/Size"/>pt;
	text-align: center;
	font-family: &quot;<xsl:value-of select="Doc/Fonts/NavigationFont/Family"/>&quot;, Helvetica, sans-serif;	
}

.imagenav a {
	color: #<xsl:value-of select="Doc/Fonts/NavigationFont/ColorValue"/>;
	padding: 3px 6px;
	border: solid 1px #<xsl:value-of select="Doc/Colors/NavigationBordersColor/ColorValue"/>;
	background: #<xsl:value-of select="Doc/Colors/NavigationBackgroundColor/ColorValue"/>;
	text-decoration: none;
}

.imagenav a:hover {
	color: #<xsl:value-of select="Doc/Fonts/NavigationFont/ColorValue"/>;
	background: #<xsl:value-of select="Doc/Colors/NavigationHoverBackgroundColor/ColorValue"/>;
	border-color: #<xsl:value-of select="Doc/Colors/NavigationHoverBorderColor/ColorValue"/>;
	text-decoration: none;
}

.imagenav .this-page {
	padding: 3px 6px;
	border: solid 1px #<xsl:value-of select="Doc/Colors/NavigationBordersColor/ColorValue"/>;
	background: #<xsl:value-of select="Doc/Colors/InnerPageColor/ColorValue"/>;
	text-decoration: none;
}

.headimage {
	position: relative;
	top: -8px;
	left: -6px;
}

html > body .headimage {
	position: relative;
	top: -12px;
	left: -8px;
}

.slide {
	background: #ffeec5;
	padding: 7px;
	margin-right: 10px;
}

.nav {
	background: #ffeec5;
	padding: 7px;
}

/* Headings
--------------------------------------------------*/
h1 {
	font-size: <xsl:value-of select="Doc/Fonts/TitleFont/Size"/>pt;
	color: #<xsl:value-of select="Doc/Fonts/TitleFont/ColorValue"/>;
	text-align: left;
	font-weight: normal;
	font-family: &quot;<xsl:value-of select="Doc/Fonts/TitleFont/Family"/>&quot;, Times, serif;
}

/* Images
--------------------------------------------------*/
/* Tables
--------------------------------------------------*/
caption {
	display: none;
}

table{
	margin: 0;
	padding: 0;
	border: 0;
}

td {
	padding: 0;
	margin: 0;
}

td.thumbtable {
	text-align: center;
	padding: 5px;
}

</xsl:template>
</xsl:stylesheet>