<?xml version="1.0" encoding="ISO-8859-1"?>
<!DOCTYPE xsl:stylesheet [ 
    <!ENTITY nbsp "&#160;">   <!-- white space in XSL -->
    <!ENTITY raquo "&#187;">   <!-- >> -->
    ]> 
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="xml" omit-xml-declaration="yes" indent="yes"
    doctype-system="http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd"
    doctype-public="-//W3C//DTD XHTML 1.0 Transitional//EN" />
    
<xsl:param name="ImagePageStartItem" select="'default'"/>

<xsl:template match="/">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
<xsl:if test="/Doc/TitleBarText[string(.)]">
	<title><xsl:value-of select="Doc/TitleBarText"/></title>
</xsl:if>
<link href="{/Doc/ImagePages/Page[$ImagePageStartItem]/ImagePagePathPrefix}css/stylesheet.css" rel="stylesheet" type="text/css" />
<script language="JavaScript1.1">
		var playing = 0
		var timeoutID = 0
		var slideShowNextLink = "<xsl:value-of select="/Doc/ImagePages/Page[$ImagePageStartItem]/ImagePagePathPrefix"/><xsl:value-of select="/Doc/ImagePages/Page[$ImagePageStartItem]/NextSlideshowImagePagePath"/>"
		var slideShowDelay = <xsl:value-of select="/Doc/SlideshowDelay"/>

		// Browser detection	
		var agt = navigator.userAgent.toLowerCase();
		var is_ie = (agt.indexOf("msie") != -1);

		if (location.href.indexOf("?") != -1) {
			urlQuery = location.href.split("?")
			playing = parseInt(urlQuery[1])
		}
		
		if (playing == 1) {
			startSlideShow()
		}
	
		function slideShow() {
			window.location.href = slideShowNextLink + "?" + "1"
			timeoutID = setInterval("slideShow()", slideShowDelay);
		}

		function startSlideShow() {
			clearTimeout(timeoutID)
			timeoutID = setInterval("slideShow()", slideShowDelay);
		}

		function stopSlideShow() {
			clearTimeout(timeoutID)
			if (is_ie) {
				fakeTimeoutID = setInterval("redirectDelay()", 0);
			}
			else {
				redirectDelay();
			}
		}
		
		function redirectDelay() {
			tempArray = window.location.href.split("?")
			window.location.href = tempArray[0]
		}
</script>
</head>
<body>

<div id="wrapper">
<div id="content">
	<xsl:if test="/Doc/IncludeHeader = 1">
  <xsl:if test="/Doc/Header/UseImage = 1">
  	<div id="logohead" class="left"><img src="{/Doc/ImagePages/Page[$ImagePageStartItem]/ImagePagePathPrefix}{/Doc/Header/ImagePath}"/></div>
  </xsl:if>
  
  <xsl:if test="/Doc/Header/UseInfo = 1">
  	<div id="pagehead" class="right">
  		<xsl:if test="/Doc/Header/Text[string(.)]">
    		<p><strong><xsl:value-of select="Doc/Header/Text"/></strong></p>
  		</xsl:if>
  		<xsl:if test="/Doc/Header/Author[string(.)]">
    		<p><xsl:value-of select="Doc/Header/Author"/></p>
    	</xsl:if>
    	<xsl:if test="/Doc/Header/Date[string(.)]">
    		<p><xsl:value-of select="Doc/Header/Date"/></p>
    	</xsl:if>
			<xsl:if test="/Doc/Header/Email[string(.)]">
    		<p><a href="mailto:{/Doc/Header/Email}"><xsl:value-of select="Doc/Header/Email"/></a></p>
    	</xsl:if>
  	</div>
  </xsl:if>
  </xsl:if>
  
  <div class="clearer">&nbsp;</div>
  <div id="pageband">&nbsp;</div>
  
  <div id="subhead">
		<div class="left">
			<xsl:if test="/Doc/ImagePages/Page[$ImagePageStartItem]/ImageTags/FileName/Value[string(.)] or /Doc/ImagePages/Page[$ImagePageStartItem]/ImageTags/Rating">
			<h1>
			<xsl:if test="/Doc/ImagePages/Page[$ImagePageStartItem]/ImageTags/FileName/Value[string(.)]">
				<xsl:value-of select="/Doc/ImagePages/Page[$ImagePageStartItem]/ImageTags/FileName/Value"/>&nbsp;
			</xsl:if>
			<xsl:if test="/Doc/ImagePages/Page[$ImagePageStartItem]/ImageTags/Rating">
				<xsl:if test="/Doc/ImagePages/Page[$ImagePageStartItem]/ImageTags/Rating/Value = 0">
      		<img src="{/Doc/ImagePages/Page[$ImagePageStartItem]/ImagePagePathPrefix}resources/graf_star_zero.gif"/>
      	</xsl:if>
      	<xsl:if test="/Doc/ImagePages/Page[$ImagePageStartItem]/ImageTags/Rating/Value = 1">
      		<img src="{/Doc/ImagePages/Page[$ImagePageStartItem]/ImagePagePathPrefix}resources/graf_star_one.gif"/>
      	</xsl:if>
      	<xsl:if test="/Doc/ImagePages/Page[$ImagePageStartItem]/ImageTags/Rating/Value = 2">
      		<img src="{/Doc/ImagePages/Page[$ImagePageStartItem]/ImagePagePathPrefix}resources/graf_star_two.gif"/>
      	</xsl:if>
      	<xsl:if test="/Doc/ImagePages/Page[$ImagePageStartItem]/ImageTags/Rating/Value = 3">
      		<img src="{/Doc/ImagePages/Page[$ImagePageStartItem]/ImagePagePathPrefix}resources/graf_star_three.gif"/>
      	</xsl:if>
      	<xsl:if test="/Doc/ImagePages/Page[$ImagePageStartItem]/ImageTags/Rating/Value = 4">
      		<img src="{/Doc/ImagePages/Page[$ImagePageStartItem]/ImagePagePathPrefix}resources/graf_star_four.gif"/>
      	</xsl:if>
      	<xsl:if test="/Doc/ImagePages/Page[$ImagePageStartItem]/ImageTags/Rating/Value = 5">
      		<img src="{/Doc/ImagePages/Page[$ImagePageStartItem]/ImagePagePathPrefix}resources/graf_star_five.gif"/>
      	</xsl:if>
			</xsl:if>
			</h1>
			</xsl:if>
			<xsl:if test="/Doc/ImagePages/Page[$ImagePageStartItem]/ImageTags/Date/Value[string(.)]">
				<div class="smalltext"><xsl:value-of select="/Doc/ImagePages/Page[$ImagePageStartItem]/ImageTags/Date/Value"/></div>
				<br/>
			</xsl:if>
		</div>
	</div>
	
 	<div class="imagenav right">
 			<strong><xsl:value-of select="/Doc/Translations/Slideshow"/>:</strong>&nbsp;<a href="javascript:void(0)" name="slideShowControl" onclick="startSlideShow()"><xsl:value-of select="/Doc/Translations/Start"/></a>&nbsp;|&nbsp;<a href="javascript:void(0)" name="slideShowControl" onclick="stopSlideShow()"><xsl:value-of select="/Doc/Translations/Stop"/></a>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
 			<xsl:if test="/Doc/ImagePages/Page[$ImagePageStartItem]/PreviousImagePagePath[string(.)]">
				<strong>Navigation:</strong>&nbsp;<a href="{/Doc/ImagePages/Page[$ImagePageStartItem]/ImagePagePathPrefix}{/Doc/ImagePages/Page[$ImagePageStartItem]/PreviousImagePagePath}"><xsl:value-of select="/Doc/Translations/Previous"/></a>&nbsp;|&nbsp;
			</xsl:if>
			<xsl:if test="/Doc/ImagePages/Page[$ImagePageStartItem]/PreviousImagePagePath[.='']">
				<strong>Navigation:</strong>&nbsp;<xsl:value-of select="/Doc/Translations/Previous"/>&nbsp;|&nbsp;
			</xsl:if>
			<a href="{/Doc/ImagePages/Page[$ImagePageStartItem]/ImagePagePathPrefix}{/Doc/HomeFileName}"><xsl:value-of select="/Doc/Translations/Home"/></a>&nbsp;|&nbsp;
			<xsl:if test="/Doc/ImagePages/Page[$ImagePageStartItem]/NextImagePagePath[string(.)]">
				<a href="{/Doc/ImagePages/Page[$ImagePageStartItem]/ImagePagePathPrefix}{/Doc/ImagePages/Page[$ImagePageStartItem]/NextImagePagePath}"><xsl:value-of select="/Doc/Translations/Next"/></a>
 			</xsl:if>
 			<xsl:if test="/Doc/ImagePages/Page[$ImagePageStartItem]/NextImagePagePath[.='']">
 				<xsl:value-of select="/Doc/Translations/Next"/>
 			</xsl:if>
 	</div>
 	<div class="clearer">&nbsp;</div>
 	
  <div id="mainimage">
  	<xsl:if test="/Doc/ImagePages/Page[$ImagePageStartItem]/FullSizeImagePath[string(.)]">
  		<a href="{/Doc/ImagePages/Page[$ImagePageStartItem]/ImagePagePathPrefix}{/Doc/ImagePages/Page[$ImagePageStartItem]/FullSizeImagePath}"><img src="{/Doc/ImagePages/Page[$ImagePageStartItem]/ImagePagePathPrefix}{/Doc/ImagePages/Page[$ImagePageStartItem]/ImagePath}" width="{/Doc/ImagePages/Page[$ImagePageStartItem]/ImageWidth}" height="{/Doc/ImagePages/Page[$ImagePageStartItem]/ImageHeight}"/></a>
  	</xsl:if>
  	<xsl:if test="/Doc/ImagePages/Page[$ImagePageStartItem]/FullSizeImagePath[.='']">
  		<img src="{/Doc/ImagePages/Page[$ImagePageStartItem]/ImagePagePathPrefix}{/Doc/ImagePages/Page[$ImagePageStartItem]/ImagePath}" width="{/Doc/ImagePages/Page[$ImagePageStartItem]/ImageWidth}" height="{/Doc/ImagePages/Page[$ImagePageStartItem]/ImageHeight}"/>
  	</xsl:if>
	</div>
	
	<xsl:if test="/Doc/ImagePages/Page[$ImagePageStartItem]/ImageTags/Tag and /Doc/ImagePages/Page[$ImagePageStartItem]/ImageTags/Tag/Value[string(.)]">
		<div class="metabox">
		<table>
			<xsl:for-each select="Doc/ImagePages/Page[$ImagePageStartItem]/ImageTags/Tag">
			<xsl:if test="Value[string(.)]">
				<tr><td width="70%"><div class="metaitem"><strong><xsl:value-of select="Name"/></strong></div></td><td><div class="metaitem"><xsl:value-of select="Value"/></div></td></tr>
			</xsl:if>
			</xsl:for-each>
		</table>
		</div>
	</xsl:if>
	
	<xsl:if test="/Doc/IncludeFooter = 1">
	<xsl:if test="/Doc/Footer/UseInfo = 1">	
  	<div id="pagefoot">
  		<xsl:if test="/Doc/Footer/Text[string(.)] or /Doc/Footer/Author[string(.)] or /Doc/Footer/Date[string(.)]">
    		<div class="left">
    			<xsl:if test="/Doc/Footer/Text[string(.)]">
    				<xsl:value-of select="Doc/Footer/Text"/>
    				<xsl:if test="/Doc/Footer/Author[string(.)] or /Doc/Footer/Date[string(.)]"> &raquo; </xsl:if>
    			</xsl:if>
    			<xsl:if test="/Doc/Footer/Author[string(.)]">
    				<xsl:value-of select="Doc/Footer/Author"/>
    				<xsl:if test="/Doc/Footer/Date[string(.)]"> &raquo; </xsl:if>
    			</xsl:if>
    			<xsl:if test="/Doc/Footer/Date[string(.)]">
    				<xsl:value-of select="Doc/Footer/Date"/>
    			</xsl:if>
    		</div>
    	</xsl:if>
    	<xsl:if test="/Doc/Footer/Email[string(.)]">
    		<div class="right"><a href="mailto:{/Doc/Footer/Email}"><xsl:value-of select="Doc/Footer/Email"/></a></div>
    	</xsl:if>
    	<div class="clearer">&nbsp;</div>
  	</div>
  </xsl:if>
  
  <xsl:if test="/Doc/Footer/UseImage = 1">
  	<div id="logofooter" class="center"><img src="{/Doc/ImagePages/Page[$ImagePageStartItem]/ImagePagePathPrefix}{/Doc/Footer/ImagePath}"/></div>
  </xsl:if>
  </xsl:if>

</div>
</div>
</body>
</html>

</xsl:template>
</xsl:stylesheet>